/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.file;

import com.silverpeas.scheduler.Job;
import com.silverpeas.scheduler.JobExecutionContext;
import com.silverpeas.scheduler.Scheduler;
import com.silverpeas.scheduler.SchedulerException;
import com.silverpeas.scheduler.trigger.JobTrigger;
import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.util.ResourceLocator;
import java.io.File;
import java.text.ParseException;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.silverpeas.file.ImageCache;

@Named
public class ResizedImageCacheCleaner
extends Job {
    private static final String CRON_PROPERTY = "image.cleaner.cron";
    @Inject
    private Scheduler scheduler;

    @PostConstruct
    public void scheduleFrequently() throws SchedulerException, ParseException {
        String cron;
        ResourceLocator settings = new ResourceLocator("org.silverpeas.lookAndFeel.generalLook", "");
        if (this.scheduler.isJobScheduled(this.getName())) {
            this.scheduler.unscheduleJob(this.getName());
        }
        if (StringUtil.isDefined(cron = settings.getString(CRON_PROPERTY))) {
            this.scheduler.scheduleJob(this, JobTrigger.triggerAt(cron));
        }
    }

    public ResizedImageCacheCleaner() {
        super(ResizedImageCacheCleaner.class.getSimpleName());
    }

    @Override
    public void execute(JobExecutionContext context) throws Exception {
        List<String> originalImagePaths = ImageCache.getAllImageEntries();
        for (String originalImagePath : originalImagePaths) {
            File originalImage = new File(originalImagePath);
            if (originalImage.exists()) continue;
            ImageCache.removeImages(originalImagePath);
        }
    }
}

