/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.media.video.ffmpeg;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.exec.CommandLine;
import org.silverpeas.exec.ExternalExecution;
import org.silverpeas.exec.ExternalExecutionException;
import org.silverpeas.media.video.VideoThumbnailExtractorException;
import org.silverpeas.media.video.ffmpeg.FFmpegToolManager;

public class FFmpegUtil
extends ExternalExecution {
    public static boolean isActivated() {
        return FFmpegToolManager.isActivated();
    }

    static CommandLine buildFFmpegThumbnailExtractorCommandLine(File inputFile, File outputFile, int seconds) {
        HashMap<String, File> files = new HashMap<String, File>(2);
        files.put("inputFile", inputFile);
        files.put("outputFile", outputFile);
        CommandLine commandLine = new CommandLine("ffmpeg");
        commandLine.addArgument("-ss", false);
        commandLine.addArgument(Integer.toString(seconds), false);
        commandLine.addArgument("-i", false);
        commandLine.addArgument("${inputFile}", false);
        commandLine.addArgument("-vframes", false);
        commandLine.addArgument("1", false);
        commandLine.addArgument("-vf", false);
        commandLine.addArgument("scale=600:-1", false);
        commandLine.addArgument("${outputFile}", false);
        commandLine.setSubstitutionMap(files);
        return commandLine;
    }

    public static List<String> extractVideoThumbnail(File videoFile, File outputFile, int time) {
        SilverTrace.debug("VideoTool", "FFmpegUtil.extractVideoThumbnail", "extract video thumbnail at " + time);
        CommandLine cmd = FFmpegUtil.buildFFmpegThumbnailExtractorCommandLine(videoFile, outputFile, time);
        try {
            return FFmpegUtil.exec(cmd);
        }
        catch (ExternalExecutionException e) {
            throw new VideoThumbnailExtractorException(e);
        }
    }
}

