/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.password.rule;

import com.silverpeas.util.StringUtil;
import java.util.regex.Pattern;
import org.silverpeas.password.constant.PasswordRuleType;
import org.silverpeas.password.rule.AbstractPasswordRule;

public class SequentialForbiddenPasswordRule
extends AbstractPasswordRule {
    private boolean value = settings.getBoolean(this.getType().getSettingKey(), false);

    public SequentialForbiddenPasswordRule() {
        super(PasswordRuleType.SEQUENTIAL_FORBIDDEN);
    }

    public Boolean getValue() {
        return this.value;
    }

    @Override
    public boolean check(String password) {
        return StringUtil.isDefined(password) && !Pattern.compile("([\\S\\s])\\1").matcher(password).find();
    }

    @Override
    public String random() {
        return "";
    }
}

