/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.persistence.model;

import com.silverpeas.util.AssertArgument;
import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.UserDetail;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Transient;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.silverpeas.persistence.model.Entity;
import org.silverpeas.persistence.repository.OperationContext;

public abstract class AbstractEntity<ENTITY extends Entity<ENTITY, IDENTIFIER_TYPE>, IDENTIFIER_TYPE>
implements Cloneable,
Entity<ENTITY, IDENTIFIER_TYPE> {
    @Transient
    private UserDetail createdByUser;
    @Transient
    private UserDetail lastUpdatedByUser;

    protected abstract ENTITY setId(String var1);

    @Override
    public String getComponentInstanceId() {
        throw new NotImplementedException();
    }

    protected abstract ENTITY setVersion(Long var1);

    protected void performBeforePersist() {
        OperationContext.getFromCache().applyToPersistOperation(this);
        AssertArgument.assertDefined(this.getCreatedBy(), "createdBy attribute of entity " + this.getClass().getName() + " must exists on insert");
        AssertArgument.assertDefined(this.getLastUpdatedBy(), "lastUpdateBy attribute of entity " + this.getClass().getName() + " must exists on insert");
        Timestamp timestamp = new Timestamp(new Date().getTime());
        this.setCreateDate(timestamp);
        this.setLastUpdateDate(timestamp);
    }

    protected void performBeforeUpdate() {
        OperationContext.getFromCache().applyToUpdateOperation(this);
        AssertArgument.assertDefined(this.getLastUpdatedBy(), "lastUpdatedBy attribute of entity " + this.getClass().getName() + " must exists on update");
        this.setLastUpdateDate(new Timestamp(new Date().getTime()));
    }

    public abstract ENTITY setCreatedBy(String var1);

    protected abstract ENTITY setCreateDate(Date var1);

    public abstract ENTITY setLastUpdatedBy(String var1);

    protected abstract ENTITY setLastUpdateDate(Date var1);

    @Override
    public UserDetail getCreator() {
        if (StringUtil.isDefined(this.getCreatedBy())) {
            if (this.createdByUser == null || !this.getCreatedBy().equals(this.createdByUser.getId())) {
                this.createdByUser = UserDetail.getById(this.getCreatedBy());
            }
        } else {
            this.createdByUser = null;
        }
        return this.createdByUser;
    }

    @Override
    public ENTITY setCreator(UserDetail creator) {
        this.createdByUser = creator;
        return this.setCreatedBy(this.createdByUser != null ? this.createdByUser.getId() : null);
    }

    @Override
    public UserDetail getLastUpdater() {
        if (StringUtil.isDefined(this.getLastUpdatedBy())) {
            if (this.lastUpdatedByUser == null || !this.getLastUpdatedBy().equals(this.lastUpdatedByUser.getId())) {
                this.lastUpdatedByUser = UserDetail.getById(this.getLastUpdatedBy());
            }
        } else {
            this.lastUpdatedByUser = this.getCreator();
        }
        return this.lastUpdatedByUser;
    }

    @Override
    public ENTITY setLastUpdater(UserDetail updater) {
        this.lastUpdatedByUser = updater;
        return this.setLastUpdatedBy(this.lastUpdatedByUser != null ? this.lastUpdatedByUser.getId() : null);
    }

    @Override
    public boolean isPersisted() {
        return this.getId() != null;
    }

    @Override
    public boolean hasBeenModified() {
        return this.isPersisted() && this.getVersion() > 0L;
    }

    public final int hashCode() {
        HashCodeBuilder hash = new HashCodeBuilder();
        hash.append(this.getId() != null ? this.getId() : Integer.valueOf(super.hashCode()));
        return hash.toHashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (super.equals(obj)) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Entity other = (Entity)obj;
        if (this.getId() != null && other.getId() != null) {
            EqualsBuilder matcher = new EqualsBuilder();
            matcher.append((Object)this.getId(), (Object)other.getId());
            return matcher.isEquals();
        }
        return false;
    }

    public ENTITY clone() {
        AbstractEntity entity;
        try {
            entity = (AbstractEntity)super.clone();
            entity.setId(null);
            entity.setCreator(null);
            entity.setCreatedBy(null);
            entity.setCreateDate(null);
            entity.setLastUpdater(null);
            entity.setLastUpdatedBy(null);
            entity.setLastUpdateDate(null);
            entity.setVersion(0L);
        }
        catch (CloneNotSupportedException e) {
            entity = null;
        }
        return (ENTITY)entity;
    }
}

