/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.search.indexEngine.model;

import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.spell.LuceneDictionary;
import org.apache.lucene.search.spell.SpellChecker;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

public class DidYouMeanIndexer {
    public static final String SUFFIX_SPELLING_INDEX_PATH = "Spell";

    private DidYouMeanIndexer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void createSpellIndex(String field, String originalIndexDirectory, String spellIndexDirectory) {
        block8: {
            if (!(StringUtil.isDefined(field) && StringUtil.isDefined(originalIndexDirectory) && StringUtil.isDefined(spellIndexDirectory))) {
                SilverTrace.error("indexEngine", DidYouMeanIndexer.class.toString(), "root.EX_INVALID_ARG");
                return;
            }
            IndexReader indexReader = null;
            try {
                File file = new File(spellIndexDirectory);
                FSDirectory directory = FSDirectory.open((File)file);
                indexReader = IndexReader.open((Directory)FSDirectory.open((File)new File(originalIndexDirectory)));
                LuceneDictionary dictionary = new LuceneDictionary(indexReader, field);
                SpellChecker spellChecker = new SpellChecker((Directory)directory);
                IndexWriterConfig config = new IndexWriterConfig(Version.LUCENE_36, (Analyzer)new StandardAnalyzer(Version.LUCENE_36));
                spellChecker.indexDictionary((Dictionary)dictionary, config, true);
                spellChecker.close();
                IOUtils.closeQuietly((Closeable)indexReader);
            }
            catch (CorruptIndexException e) {
                SilverTrace.error("indexEngine", DidYouMeanIndexer.class.toString(), "root.EX_INDEX_FAILED", e);
            }
            catch (IOException e2) {
                SilverTrace.error("indexEngine", DidYouMeanIndexer.class.toString(), "root.EX_LOAD_IO_EXCEPTION", e2);
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(indexReader);
            }
        }
    }

    public static void createSpellIndex(String field, String originalIndexDirectory) {
        DidYouMeanIndexer.createSpellIndex(field, originalIndexDirectory, originalIndexDirectory + SUFFIX_SPELLING_INDEX_PATH);
    }

    public static boolean clearSpellIndex(String pathSpellChecker) {
        boolean isCleared = false;
        try {
            SpellChecker spell;
            File file = new File(pathSpellChecker);
            if (file != null && file.exists() && (spell = new SpellChecker((Directory)FSDirectory.open((File)file))) != null) {
                spell.clearIndex();
                isCleared = true;
            }
        }
        catch (IOException e) {
            SilverTrace.error("indexEngine", DidYouMeanIndexer.class.toString(), "root.EX_LOAD_IO_EXCEPTION", e);
        }
        return isCleared;
    }

    public static void clearSpellIndex(String[] paths) {
        for (String path : paths) {
            DidYouMeanIndexer.clearSpellIndex(path);
        }
    }

    public static void createSpellIndexForAllLanguage(String field, String originalIndexDirectory) {
        for (String language : I18NHelper.getAllSupportedLanguages()) {
            if (!language.equalsIgnoreCase("fr")) {
                field = field + "_" + language;
            }
            DidYouMeanIndexer.createSpellIndex(field, originalIndexDirectory, originalIndexDirectory + SUFFIX_SPELLING_INDEX_PATH);
        }
    }
}

