/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.viewer;

import com.silverpeas.annotation.Service;
import com.silverpeas.converter.DocumentFormat;
import com.silverpeas.converter.DocumentFormatConverterFactory;
import com.silverpeas.converter.option.FilterOption;
import com.silverpeas.util.FileUtil;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.silverpeas.viewer.AbstractViewerService;
import org.silverpeas.viewer.DocumentView;
import org.silverpeas.viewer.JsonPdfToolManager;
import org.silverpeas.viewer.PreviewService;
import org.silverpeas.viewer.ViewService;
import org.silverpeas.viewer.ViewerContext;
import org.silverpeas.viewer.ViewerSettings;
import org.silverpeas.viewer.exception.ViewerException;
import org.silverpeas.viewer.flexpaper.TemporaryFlexPaperView;
import org.silverpeas.viewer.util.DocumentInfo;
import org.silverpeas.viewer.util.JsonPdfUtil;
import org.silverpeas.viewer.util.SwfUtil;

@Service
public class DefaultViewService
extends AbstractViewerService
implements ViewService {
    private static final String PROCESS_NAME = "VIEW";
    @Inject
    private PreviewService previewService;

    @Override
    public boolean isViewable(File file) {
        String fileName = file.getPath();
        return SwfUtil.isPdfToSwfActivated() && file.exists() && (FileUtil.isPdf(fileName) || FileUtil.isOpenOfficeCompatible(fileName));
    }

    @Override
    public DocumentView getDocumentView(final ViewerContext viewerContext) {
        return this.process(PROCESS_NAME, new AbstractViewerService.ViewerTreatment<DocumentView>(){

            @Override
            public DocumentView execute() {
                File pdfFile;
                if (!DefaultViewService.this.isViewable(viewerContext.getOriginalSourceFile())) {
                    throw new ViewerException("IT IS NOT POSSIBLE GETTING DOCUMENT VIEW");
                }
                if (FileUtil.isOpenOfficeCompatible(viewerContext.getOriginalSourceFile().getName())) {
                    pdfFile = DefaultViewService.this.toPdf(viewerContext.getOriginalSourceFile(), DefaultViewService.this.generateTmpFile(viewerContext, "pdf"));
                } else {
                    pdfFile = DefaultViewService.this.generateTmpFile(viewerContext, "pdf");
                    try {
                        FileUtils.copyFile((File)viewerContext.getOriginalSourceFile(), (File)pdfFile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                DocumentView documentView = DefaultViewService.this.toSwf(viewerContext.getOriginalFileName(), pdfFile);
                FileUtils.deleteQuietly((File)pdfFile);
                return documentView;
            }

            @Override
            public DocumentView performAfterSuccess(DocumentView result) {
                if (ViewerSettings.isSilentConversionEnabled() && viewerContext.isProcessingCache() && DefaultViewService.this.previewService.isPreviewable(viewerContext.getOriginalSourceFile())) {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            DefaultViewService.this.previewService.getPreview(viewerContext.clone());
                        }
                    });
                    thread.start();
                }
                return super.performAfterSuccess(result);
            }
        }).execute(viewerContext);
    }

    private File toPdf(File source, File destination) {
        DocumentFormatConverterFactory.getFactory().getToPDFConverter().convert(source, destination, DocumentFormat.pdf, new FilterOption[0]);
        return destination;
    }

    private DocumentView toSwf(String originalFileName, File pdfSource) {
        DocumentInfo info = SwfUtil.getPdfDocumentInfo(pdfSource);
        File swfFile = this.changeFileExtension(pdfSource, "swf");
        swfFile.getParentFile().mkdirs();
        boolean jsonConversion = JsonPdfToolManager.isActivated();
        boolean splitMode = ViewerSettings.isSplitStrategyEnabled();
        if (!splitMode) {
            try {
                SwfUtil.fromPdfToSwf(pdfSource, swfFile, false);
                jsonConversion = false;
            }
            catch (Exception e) {
                e.printStackTrace();
                splitMode = true;
            }
        }
        if (splitMode) {
            swfFile = new File(swfFile.getParentFile(), "page.swf");
            SwfUtil.fromPdfToSwf(pdfSource, swfFile, true);
            if (jsonConversion) {
                try {
                    JsonPdfUtil.convert(pdfSource, swfFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    jsonConversion = false;
                }
            }
        }
        TemporaryFlexPaperView documentView = new TemporaryFlexPaperView(originalFileName, swfFile, info);
        documentView.markDocumentSplit(splitMode);
        documentView.markSearchDataComputed(jsonConversion);
        return documentView;
    }
}

