/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.wysiwyg.control;

import com.silverpeas.util.ForeignPK;
import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import com.stratelia.webactiv.util.WAPrimaryKey;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.search.indexEngine.model.FullIndexEntry;
import org.silverpeas.wysiwyg.WysiwygException;
import org.silverpeas.wysiwyg.control.WysiwygContentTransformer;
import org.silverpeas.wysiwyg.control.WysiwygManager;

public class WysiwygController {
    public static final String WYSIWYG_CONTEXT = WysiwygManager.WYSIWYG_CONTEXT;
    public static final String WYSIWYG_IMAGES = "Images";
    public static final String WYSIWYG_WEBSITES = "webSites";
    private static WysiwygController instance = new WysiwygController();
    @Inject
    private WysiwygManager wysiwygManager;

    protected WysiwygManager getManager() {
        if (this.wysiwygManager == null) {
            this.wysiwygManager = new WysiwygManager();
        }
        return this.wysiwygManager;
    }

    public static WysiwygController getInstance() {
        return instance;
    }

    protected WysiwygController() {
    }

    public static List<SimpleDocument> getImages(String id, String componentId) {
        return WysiwygController.getInstance().getManager().getImages(id, componentId);
    }

    public static String getWebsiteRepository() {
        return WysiwygController.getInstance().getManager().getWebsiteRepository();
    }

    public static String[][] getWebsiteImages(String path, String componentId) throws WysiwygException {
        return WysiwygController.getInstance().getManager().getWebsiteImages(path, componentId);
    }

    public static String[][] getWebsitePages(String path, String componentId) throws WysiwygException {
        return WysiwygController.getInstance().getManager().getWebsitePages(path, componentId);
    }

    public static String getOldWysiwygFileName(String objectId) {
        return WysiwygController.getInstance().getManager().getOldWysiwygFileName(objectId);
    }

    public static String getWysiwygFileName(String objectId, String currentLanguage) {
        return WysiwygController.getInstance().getManager().getWysiwygFileName(objectId, currentLanguage);
    }

    public static String getImagesFileName(String objectId) {
        return WysiwygController.getInstance().getManager().getImagesFileName(objectId);
    }

    public static void deleteFileAndAttachment(String componentId, String id) {
        WysiwygController.getInstance().getManager().deleteFileAndAttachment(componentId, id);
    }

    public static void deleteFile(String componentId, String objectId, String language) {
        WysiwygController.getInstance().getManager().deleteFile(componentId, objectId, language);
    }

    public static void createFileAndAttachment(String textHtml, WAPrimaryKey foreignKey, String context, String userId, String contentLanguage) {
        WysiwygController.getInstance().getManager().createFileAndAttachment(textHtml, foreignKey, context, userId, contentLanguage);
    }

    public static void createFileAndAttachment(String textHtml, WAPrimaryKey foreignKey, String userId, String contentLanguage) {
        WysiwygController.getInstance().getManager().createFileAndAttachment(textHtml, foreignKey, userId, contentLanguage);
    }

    public static void createUnindexedFileAndAttachment(String textHtml, WAPrimaryKey foreignKey, String userId, String contentLanguage) {
        WysiwygController.getInstance().getManager().createUnindexedFileAndAttachment(textHtml, foreignKey, userId, contentLanguage);
    }

    public static void addToIndex(FullIndexEntry indexEntry, ForeignPK pk, String language) {
        WysiwygController.getInstance().getManager().addToIndex(indexEntry, pk, language);
    }

    public static void updateFileAndAttachment(String textHtml, String componentId, String objectId, String userId, String language) {
        WysiwygController.getInstance().getManager().updateFileAndAttachment(textHtml, componentId, objectId, userId, language);
    }

    public static void updateFileAndAttachment(String textHtml, String componentId, String objectId, String userId, String language, boolean indexIt) {
        WysiwygController.getInstance().getManager().updateFileAndAttachment(textHtml, componentId, objectId, userId, language, indexIt);
    }

    public static void save(String textHtml, String componentId, String objectId, String userId, String language, boolean indexIt) {
        WysiwygController.getInstance().getManager().save(textHtml, componentId, objectId, userId, language, indexIt);
    }

    public static void deleteWysiwygAttachments(String componentId, String objectId) {
        WysiwygController.getInstance().getManager().deleteWysiwygAttachments(componentId, objectId);
    }

    public static void deleteWysiwygAttachmentsOnly(String spaceId, String componentId, String objectId) throws WysiwygException {
        WysiwygController.getInstance().getManager().deleteWysiwygAttachmentsOnly(spaceId, componentId, objectId);
    }

    public static String load(String componentId, String objectId, String language) {
        return WysiwygController.getInstance().getManager().load(componentId, objectId, language);
    }

    public static String loadForReadOnly(String componentId, String objectId, String language) {
        String wysiwygContent = WysiwygController.getInstance().getManager().load(componentId, objectId, language);
        return WysiwygContentTransformer.on(wysiwygContent).modifyImageUrlAccordingToHtmlSizeDirective().transform();
    }

    public static List<String> getEmbeddedAttachmentIds(String content) {
        return WysiwygController.getInstance().getManager().getEmbeddedAttachmentIds(content);
    }

    public static String loadFileWebsite(String path, String fileName) throws WysiwygException {
        return WysiwygController.getInstance().getManager().loadFileWebsite(path, fileName);
    }

    public static boolean haveGotWysiwygToDisplay(String componentId, String objectId, String language) {
        return WysiwygController.getInstance().getManager().haveGotWysiwygToDisplay(componentId, objectId, language);
    }

    public static boolean haveGotWysiwyg(String componentId, String objectId, String language) {
        return WysiwygController.getInstance().getManager().haveGotWysiwyg(componentId, objectId, language);
    }

    public static void updateWebsite(String cheminFichier, String nomFichier, String contenuFichier) throws WysiwygException {
        WysiwygController.getInstance().getManager().updateWebsite(cheminFichier, nomFichier, contenuFichier);
    }

    public static Map<String, String> copy(String oldComponentId, String oldObjectId, String componentId, String objectId, String userId) {
        return WysiwygController.getInstance().getManager().copy(oldComponentId, oldObjectId, componentId, objectId, userId);
    }

    public static void move(String fromComponentId, String fromObjectId, String componentId, String objectId) {
        WysiwygController.getInstance().getManager().move(fromComponentId, fromObjectId, componentId, objectId);
    }

    public static void wysiwygPlaceHaveChanged(String oldComponentId, String oldObjectId, String newComponentId, String newObjectId) {
        WysiwygController.getInstance().getManager().wysiwygPlaceHaveChanged(oldComponentId, oldObjectId, newComponentId, newObjectId);
    }

    public static String getWysiwygPath(String componentId, String objectId, String language) {
        return WysiwygController.getInstance().getManager().getWysiwygPath(componentId, objectId, language);
    }

    public static String getWysiwygPath(String componentId, String objectId) {
        return WysiwygController.getInstance().getManager().getWysiwygPath(componentId, objectId);
    }

    public static List<ComponentInstLight> getGalleries() {
        return WysiwygController.getInstance().getManager().getGalleries();
    }

    public static List<ComponentInstLight> getStorageFile() {
        return WysiwygController.getInstance().getManager().getStorageFile();
    }

    public static void indexEmbeddedLinkedFiles(FullIndexEntry indexEntry, List<String> embeddedAttachmentIds) {
        WysiwygController.getInstance().getManager().indexEmbeddedLinkedFiles(indexEntry, embeddedAttachmentIds);
    }

    public static String createPath(String componentId, String context) {
        return WysiwygController.getInstance().getManager().createPath(componentId, context);
    }
}

