/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.kmelia.control.ejb;

import com.silverpeas.SilverpeasContent;
import com.silverpeas.admin.components.PasteDetail;
import com.silverpeas.comment.service.CommentService;
import com.silverpeas.comment.service.CommentServiceFactory;
import com.silverpeas.component.kmelia.KmeliaCopyDetail;
import com.silverpeas.form.DataRecord;
import com.silverpeas.form.FormException;
import com.silverpeas.form.RecordSet;
import com.silverpeas.form.RecordTemplate;
import com.silverpeas.form.importExport.XMLField;
import com.silverpeas.form.record.GenericRecordSet;
import com.silverpeas.formTemplate.dao.ModelDAO;
import com.silverpeas.kmelia.notification.KmeliaDefermentPublicationUserNotification;
import com.silverpeas.kmelia.notification.KmeliaDocumentSubscriptionPublicationUserNotification;
import com.silverpeas.kmelia.notification.KmeliaModificationPublicationUserNotification;
import com.silverpeas.kmelia.notification.KmeliaNoMoreValidatorPublicationUserNotification;
import com.silverpeas.kmelia.notification.KmeliaNotifyPublicationUserNotification;
import com.silverpeas.kmelia.notification.KmeliaPendingValidationPublicationUserNotification;
import com.silverpeas.kmelia.notification.KmeliaSubscriptionPublicationUserNotification;
import com.silverpeas.kmelia.notification.KmeliaSupervisorPublicationUserNotification;
import com.silverpeas.kmelia.notification.KmeliaTopicUserNotification;
import com.silverpeas.kmelia.notification.KmeliaValidationPublicationUserNotification;
import com.silverpeas.notification.builder.UserNotificationBuilder;
import com.silverpeas.notification.builder.helper.UserNotificationHelper;
import com.silverpeas.pdc.PdcServiceFactory;
import com.silverpeas.pdc.ejb.PdcBm;
import com.silverpeas.pdc.model.PdcClassification;
import com.silverpeas.pdc.service.PdcClassificationService;
import com.silverpeas.pdcSubscription.util.PdcSubscriptionUtil;
import com.silverpeas.publicationTemplate.PublicationTemplate;
import com.silverpeas.publicationTemplate.PublicationTemplateException;
import com.silverpeas.publicationTemplate.PublicationTemplateManager;
import com.silverpeas.subscribe.Subscription;
import com.silverpeas.subscribe.SubscriptionService;
import com.silverpeas.subscribe.SubscriptionServiceProvider;
import com.silverpeas.subscribe.SubscriptionSubscriber;
import com.silverpeas.subscribe.service.NodeSubscription;
import com.silverpeas.subscribe.service.NodeSubscriptionResource;
import com.silverpeas.subscribe.service.UserSubscriptionSubscriber;
import com.silverpeas.subscribe.util.SubscriptionList;
import com.silverpeas.thumbnail.ThumbnailException;
import com.silverpeas.thumbnail.control.ThumbnailController;
import com.silverpeas.thumbnail.model.ThumbnailDetail;
import com.silverpeas.thumbnail.service.ThumbnailServiceFactory;
import com.silverpeas.util.ArrayUtil;
import com.silverpeas.util.CollectionUtil;
import com.silverpeas.util.FileUtil;
import com.silverpeas.util.ForeignPK;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.silverpeas.notificationManager.NotificationMetaData;
import com.stratelia.silverpeas.notificationManager.constant.NotifAction;
import com.stratelia.silverpeas.pdc.control.PdcBmImpl;
import com.stratelia.silverpeas.pdc.model.ClassifyPosition;
import com.stratelia.silverpeas.pdc.model.PdcException;
import com.stratelia.silverpeas.silverpeasinitialize.CallBackManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.SilverpeasRole;
import com.stratelia.webactiv.beans.admin.AdminController;
import com.stratelia.webactiv.beans.admin.ObjectType;
import com.stratelia.webactiv.beans.admin.ProfileInst;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.calendar.backbone.TodoBackboneAccess;
import com.stratelia.webactiv.calendar.backbone.TodoDetail;
import com.stratelia.webactiv.calendar.model.Attendee;
import com.stratelia.webactiv.kmelia.KmeliaContentManager;
import com.stratelia.webactiv.kmelia.KmeliaSecurity;
import com.stratelia.webactiv.kmelia.PublicationImport;
import com.stratelia.webactiv.kmelia.control.ejb.KmeliaBm;
import com.stratelia.webactiv.kmelia.control.ejb.KmeliaHelper;
import com.stratelia.webactiv.kmelia.control.ejb.KmeliaNodeSimulationElementLister;
import com.stratelia.webactiv.kmelia.control.ejb.KmeliaPublicationSimulationElementLister;
import com.stratelia.webactiv.kmelia.control.ejb.KmeliaServiceContext;
import com.stratelia.webactiv.kmelia.control.ejb.KmeliaUserTreeViewFilter;
import com.stratelia.webactiv.kmelia.control.ejb.KmeliaValidation;
import com.stratelia.webactiv.kmelia.model.KmaxRuntimeException;
import com.stratelia.webactiv.kmelia.model.KmeliaPublication;
import com.stratelia.webactiv.kmelia.model.KmeliaRuntimeException;
import com.stratelia.webactiv.kmelia.model.TopicComparator;
import com.stratelia.webactiv.kmelia.model.TopicDetail;
import com.stratelia.webactiv.util.ActionType;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.WAPrimaryKey;
import com.stratelia.webactiv.util.annotation.Action;
import com.stratelia.webactiv.util.annotation.SourcePK;
import com.stratelia.webactiv.util.annotation.TargetPK;
import com.stratelia.webactiv.util.coordinates.control.CoordinatesBm;
import com.stratelia.webactiv.util.coordinates.model.Coordinate;
import com.stratelia.webactiv.util.coordinates.model.CoordinatePK;
import com.stratelia.webactiv.util.coordinates.model.CoordinatePoint;
import com.stratelia.webactiv.util.node.control.NodeBm;
import com.stratelia.webactiv.util.node.model.NodeDetail;
import com.stratelia.webactiv.util.node.model.NodePK;
import com.stratelia.webactiv.util.publication.control.PublicationBm;
import com.stratelia.webactiv.util.publication.model.Alias;
import com.stratelia.webactiv.util.publication.model.CompletePublication;
import com.stratelia.webactiv.util.publication.model.PublicationDetail;
import com.stratelia.webactiv.util.publication.model.PublicationPK;
import com.stratelia.webactiv.util.publication.model.ValidationStep;
import com.stratelia.webactiv.util.statistic.control.StatisticBm;
import com.stratelia.webactiv.util.statistic.model.HistoryObjectDetail;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.interceptor.Interceptors;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.EntityReference;
import org.silverpeas.attachment.AttachmentException;
import org.silverpeas.attachment.AttachmentServiceFactory;
import org.silverpeas.attachment.model.DocumentType;
import org.silverpeas.attachment.model.HistorisedDocument;
import org.silverpeas.attachment.model.SimpleAttachment;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.model.SimpleDocumentPK;
import org.silverpeas.attachment.util.SimpleDocumentList;
import org.silverpeas.component.kmelia.KmeliaPublicationHelper;
import org.silverpeas.core.admin.OrganisationController;
import org.silverpeas.core.admin.OrganisationControllerFactory;
import org.silverpeas.dateReminder.persistent.service.DateReminderServiceFactory;
import org.silverpeas.dateReminder.persistent.service.PersistentDateReminderService;
import org.silverpeas.process.annotation.SimulationActionProcess;
import org.silverpeas.process.annotation.SimulationActionProcessAnnotationEJBInterceptor;
import org.silverpeas.publication.dateReminder.PublicationNoteReference;
import org.silverpeas.upload.UploadedFile;
import org.silverpeas.wysiwyg.WysiwygException;
import org.silverpeas.wysiwyg.control.WysiwygController;

@Stateless(name="Kmelia", description="Stateless session bean to manage Kmelia and Kmax.")
@TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
public class KmeliaBmEJB
implements KmeliaBm {
    private static final String MESSAGES_PATH = "org.silverpeas.kmelia.multilang.kmeliaBundle";
    private static final String SETTINGS_PATH = "org.silverpeas.kmelia.settings.kmeliaSettings";
    private static final ResourceLocator settings = new ResourceLocator("org.silverpeas.kmelia.settings.kmeliaSettings", "");
    @EJB
    private NodeBm nodeBm;
    @EJB
    private PublicationBm publicationBm;
    @EJB
    private StatisticBm statisticBm;
    @EJB
    private PdcBm pdcBm;
    @EJB
    private CoordinatesBm coordinatesBm;
    private CommentService commentService = null;
    private PersistentDateReminderService dateReminderService = null;

    private int getNbPublicationsOnRoot(String componentId) {
        String parameterValue = OrganisationControllerFactory.getOrganisationController().getComponentParameterValue(componentId, "nbPubliOnRoot");
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.getNbPublicationsOnRoot()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("parameterValue=" + parameterValue));
        if (StringUtil.isDefined((String)parameterValue)) {
            return Integer.parseInt(parameterValue);
        }
        if (KmeliaHelper.isToolbox(componentId)) {
            return 0;
        }
        ResourceLocator theSettings = this.getComponentSettings();
        return Integer.parseInt(theSettings.getString("HomeNbPublications"));
    }

    private boolean isDraftModeUsed(String componentId) {
        return "yes".equals(OrganisationControllerFactory.getOrganisationController().getComponentParameterValue(componentId, "draft"));
    }

    public SubscriptionService getSubscribeBm() {
        return SubscriptionServiceProvider.getSubscribeService();
    }

    @Override
    public TopicDetail goTo(NodePK pk, String userId, boolean isTreeStructureUsed, String userProfile, boolean isRightsOnTopicsUsed) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.goTo()", (String)"root.MSG_GEN_ENTER_METHOD");
        ArrayList<NodeDetail> newPath = new ArrayList<NodeDetail>();
        NodeDetail nodeDetail = null;
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.goTo()", (String)"root.MSG_GEN_PARAM_VALUE", (String)"nodeBm.getDetail(pk) BEGIN");
        try {
            nodeDetail = this.nodeBm.getDetail(pk);
            if (isRightsOnTopicsUsed) {
                OrganisationController orga = OrganisationControllerFactory.getOrganisationController();
                if (nodeDetail.haveRights() && !orga.isObjectAvailable(nodeDetail.getRightsDependsOn(), ObjectType.NODE, pk.getInstanceId(), userId)) {
                    nodeDetail.setUserRole("noRights");
                }
                List<NodeDetail> availableChildren = this.getAllowedSubfolders(nodeDetail, userId);
                nodeDetail.setChildrenDetails(availableChildren);
            }
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.goTo()", 4, "kmelia.EX_IMPOSSIBLE_DACCEDER_AU_THEME", e);
        }
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.goTo()", (String)"root.MSG_GEN_PARAM_VALUE", (String)"nodeBm.getDetail(pk) END");
        List<KmeliaPublication> pubDetails = this.getPublicationsOfFolder(pk, userProfile, userId, isTreeStructureUsed, isRightsOnTopicsUsed);
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.goTo()", (String)"root.MSG_GEN_PARAM_VALUE", (String)"GetPath BEGIN");
        if (pk.isRoot()) {
            newPath.add(nodeDetail);
        } else {
            newPath = this.getPathFromAToZ(nodeDetail);
        }
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.goTo()", (String)"root.MSG_GEN_PARAM_VALUE", (String)"GetPath END");
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.goTo()", (String)"root.MSG_GEN_EXIT_METHOD");
        return new TopicDetail(newPath, nodeDetail, pubDetails);
    }

    @Override
    public List<KmeliaPublication> getPublicationsOfFolder(NodePK pk, String userProfile, String userId, boolean isTreeStructureUsed, boolean isRightsOnTopicsUsed) {
        Collection pubDetails = null;
        if (pk.isTrash()) {
            pubDetails = this.getPublicationsInBasket(pk, userProfile, userId);
        } else {
            if (pk.isRoot()) {
                SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.goTo()", (String)"root.MSG_GEN_PARAM_VALUE", (String)"publicationBm.getUnavailablePublicationsByPublisherId(pubPK, currentUser.getId()) BEGIN");
                try {
                    int nbPublisOnRoot = this.getNbPublicationsOnRoot(pk.getInstanceId());
                    if (nbPublisOnRoot != 0 && isTreeStructureUsed && !KmeliaHelper.isToolbox(pk.getInstanceId())) {
                        return this.getLatestPublications(pk.getInstanceId(), nbPublisOnRoot, isRightsOnTopicsUsed, userId);
                    }
                    pubDetails = this.publicationBm.getDetailsByFatherPK(pk, "P.pubUpdateDate desc", false);
                }
                catch (Exception e) {
                    throw new KmeliaRuntimeException("KmeliaBmEJB.getPublicationsOfFolder()", 4, "kmelia.EX_IMPOSSIBLE_DAVOIR_LES_DERNIERES_PUBLICATIONS", e);
                }
            }
            SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.getPublicationsOfFolder()", (String)"root.MSG_GEN_PARAM_VALUE", (String)"publicationBm.getDetailsByFatherPK(pk) BEGIN");
            try {
                pubDetails = this.publicationBm.getDetailsByFatherPK(pk, "P.pubUpdateDate DESC, P.pubId DESC", false);
            }
            catch (Exception e) {
                throw new KmeliaRuntimeException("KmeliaBmEJB.getPublicationsOfFolder()", 4, "kmelia.EX_IMPOSSIBLE_DAVOIR_LA_LISTE_DES_PUBLICATIONS", e);
            }
            SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.getPublicationsOfFolder()", (String)"root.MSG_GEN_PARAM_VALUE", (String)"publicationBm.getDetailsByFatherPK(pk) END");
        }
        return this.pubDetails2userPubs(pubDetails);
    }

    @Override
    public List<KmeliaPublication> getLatestPublications(String instanceId, int nbPublisOnRoot, boolean isRightsOnTopicsUsed, String userId) {
        PublicationPK pubPK = new PublicationPK("unknown", instanceId);
        Collection pubDetails = this.publicationBm.getDetailsByBeginDateDescAndStatusAndNotLinkedToFatherId(pubPK, "Valid", nbPublisOnRoot, "1");
        if (isRightsOnTopicsUsed) {
            ArrayList<PublicationDetail> filteredList = new ArrayList<PublicationDetail>();
            KmeliaSecurity security = new KmeliaSecurity();
            for (PublicationDetail pubDetail : pubDetails) {
                if (!security.isObjectAvailable(instanceId, userId, pubDetail.getPK().getId(), "Publication")) continue;
                filteredList.add(pubDetail);
            }
            pubDetails.clear();
            pubDetails.addAll(filteredList);
        }
        return this.pubDetails2userPubs(pubDetails);
    }

    @Override
    public List<NodeDetail> getAllowedSubfolders(NodeDetail folder, String userId) {
        OrganisationController orga = OrganisationControllerFactory.getOrganisationController();
        NodePK pk = folder.getNodePK();
        List children = (List)folder.getChildrenDetails();
        ArrayList<NodeDetail> availableChildren = new ArrayList<NodeDetail>();
        for (NodeDetail child : children) {
            NodePK childId = child.getNodePK();
            if (childId.isTrash() || childId.isUnclassed() || !child.haveRights()) {
                availableChildren.add(child);
                continue;
            }
            int rightsDependsOn = child.getRightsDependsOn();
            boolean nodeAvailable = orga.isObjectAvailable(rightsDependsOn, ObjectType.NODE, pk.getInstanceId(), userId);
            if (nodeAvailable) {
                availableChildren.add(child);
                continue;
            }
            Iterator descendants = this.nodeBm.getDescendantDetails(child).iterator();
            boolean childAllowed = false;
            while (!childAllowed && descendants.hasNext()) {
                NodeDetail descendant = (NodeDetail)descendants.next();
                if (descendant.getRightsDependsOn() == rightsDependsOn || !orga.isObjectAvailable(descendant.getRightsDependsOn(), ObjectType.NODE, pk.getInstanceId(), userId)) continue;
                childAllowed = true;
                if (availableChildren.contains(child)) continue;
                availableChildren.add(child);
            }
        }
        return availableChildren;
    }

    private Collection<NodeDetail> getPathFromAToZ(NodeDetail nd) {
        ArrayList<NodeDetail> newPath = new ArrayList<NodeDetail>();
        try {
            List pathInReverse = (List)this.nodeBm.getPath(nd.getNodePK());
            for (int i = pathInReverse.size() - 1; i >= 0; --i) {
                newPath.add((NodeDetail)pathInReverse.get(i));
            }
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.getPathFromAToZ()", 4, "kmelia.EX_IMPOSSIBLE_DAVOIR_LE_CHEMIN_COURANT", e);
        }
        return newPath;
    }

    @Override
    public NodePK addToTopic(NodePK fatherPK, NodeDetail subTopic) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.addToTopic()", (String)"root.MSG_GEN_ENTER_METHOD");
        NodePK theNodePK = null;
        try {
            NodeDetail fatherDetail = this.nodeBm.getHeader(fatherPK);
            theNodePK = this.nodeBm.createNode(subTopic, fatherDetail);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.addToTopic()", 4, "kmelia.EX_IMPOSSIBLE_DE_CREER_LE_THEME", e);
        }
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.addToTopic()", (String)"root.MSG_GEN_EXIT_METHOD");
        return theNodePK;
    }

    @Override
    public NodePK addSubTopic(NodePK fatherPK, NodeDetail subTopic, String alertType) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.addSubTopic()", (String)"root.MSG_GEN_ENTER_METHOD");
        String creationDate = DateUtil.today2SQLDate();
        subTopic.setCreationDate(creationDate);
        subTopic.setStatus("Invisible");
        NodePK pk = this.addToTopic(fatherPK, subTopic);
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.addSubTopic()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("pk = " + pk.toString()));
        if (!"-1".equals(pk.getId())) {
            this.topicCreationAlert(pk, fatherPK, alertType);
        }
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.addSubTopic()", (String)"root.MSG_GEN_EXIT_METHOD");
        return pk;
    }

    private void topicCreationAlert(NodePK nodePK, NodePK fatherPK, String alertType) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.topicCreationAlert()", (String)"root.MSG_GEN_ENTER_METHOD");
        UserNotificationHelper.buildAndSend((UserNotificationBuilder)new KmeliaTopicUserNotification(nodePK, fatherPK, alertType));
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.topicCreationAlert()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("AlertType alert = " + alertType));
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.topicCreationAlert()", (String)"root.MSG_GEN_EXIT_METHOD");
    }

    @Override
    public NodePK updateTopic(NodeDetail topic, String alertType) {
        try {
            NodeDetail oldNode = this.nodeBm.getHeader(topic.getNodePK());
            int order = oldNode.getOrder();
            topic.setOrder(order);
            this.nodeBm.setDetail(topic);
            if (this.isRightsOnTopicsEnabled(topic.getNodePK().getInstanceId()) && oldNode.getRightsDependsOn() != topic.getRightsDependsOn()) {
                if (!topic.haveRights()) {
                    NodeDetail father = this.nodeBm.getHeader(oldNode.getFatherPK());
                    topic.setRightsDependsOn(father.getRightsDependsOn());
                    AdminController admin = new AdminController(null);
                    List profiles = admin.getProfilesByObject(topic.getNodePK().getId(), ObjectType.NODE.getCode(), topic.getNodePK().getInstanceId());
                    if (profiles != null) {
                        for (ProfileInst profile : profiles) {
                            if (profile == null) continue;
                            admin.deleteProfileInst(profile.getId());
                        }
                    }
                } else {
                    topic.setRightsDependsOnMe();
                }
                this.nodeBm.updateRightsDependency(topic);
            }
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.updateTopic()", 4, "kmelia.EX_IMPOSSIBLE_DE_MODIFIER_THEME", e);
        }
        this.topicCreationAlert(topic.getNodePK(), null, alertType);
        return topic.getNodePK();
    }

    @Override
    public NodeDetail getSubTopicDetail(NodePK pk) {
        NodeDetail subTopic = null;
        try {
            subTopic = this.nodeBm.getDetail(pk);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.getSubTopicDetail()", 4, "kmelia.EX_IMPOSSIBLE_DACCEDER_AU_THEME", e);
        }
        return subTopic;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void deleteTopic(NodePK pkToDelete) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.deleteTopic()", (String)"root.MSG_GEN_ENTER_METHOD");
        try {
            Collection nodesToDelete = this.nodeBm.getDescendantPKs(pkToDelete);
            nodesToDelete.add(pkToDelete);
            SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.deleteTopic()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("nodesToDelete = " + nodesToDelete));
            Iterator itNode = nodesToDelete.iterator();
            ArrayList<Alias> aliases = new ArrayList<Alias>();
            while (itNode.hasNext()) {
                NodePK oneNodeToDelete = (NodePK)itNode.next();
                Collection pubsToCheck = this.publicationBm.getPubPKsInFatherPK(oneNodeToDelete);
                for (PublicationPK onePubToCheck : pubsToCheck) {
                    if (onePubToCheck.getInstanceId().equals(oneNodeToDelete.getInstanceId())) {
                        Collection pubFathers = this.publicationBm.getAllFatherPK(onePubToCheck);
                        if (pubFathers.size() >= 2) {
                            this.publicationBm.removeFather(onePubToCheck, oneNodeToDelete);
                            SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.deleteTopic()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("RemoveFather(pubId, fatherId) with  pubId = " + onePubToCheck.getId() + ", fatherId = " + oneNodeToDelete));
                            continue;
                        }
                        this.sendPublicationToBasket(onePubToCheck);
                        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.deleteTopic()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("RemoveAllFather(pubId) with pubId = " + onePubToCheck.getId()));
                        continue;
                    }
                    aliases.clear();
                    aliases.add(new Alias(oneNodeToDelete.getId(), oneNodeToDelete.getInstanceId()));
                    this.publicationBm.removeAlias(onePubToCheck, aliases);
                }
            }
            this.removeSubscriptionsByTopic(nodesToDelete);
            this.nodeBm.removeNode(pkToDelete);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.deleteTopic()", 4, "kmelia.EX_IMPOSSIBLE_DE_SUPPRIMER_THEME", e);
        }
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.deleteTopic()", (String)"root.MSG_GEN_EXIT_METHOD");
    }

    @Override
    public void changeSubTopicsOrder(String way, NodePK subTopicPK, NodePK fatherPK) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.changeSubTopicsOrder()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("way = " + way + ", subTopicPK = " + subTopicPK.toString()));
        List subTopics = null;
        try {
            subTopics = (List)this.nodeBm.getChildrenDetails(fatherPK);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.changeSubTopicsOrder()", 4, "kmelia.EX_IMPOSSIBLE_DE_LISTER_THEMES", e);
        }
        if (subTopics != null && !subTopics.isEmpty()) {
            int indexOfTopic;
            if (fatherPK.isRoot() && !KmeliaHelper.isToolbox(subTopicPK.getInstanceId())) {
                indexOfTopic = this.getIndexOfNode("1", subTopics);
                subTopics.remove(indexOfTopic);
                indexOfTopic = this.getIndexOfNode("2", subTopics);
                subTopics.remove(indexOfTopic);
            }
            indexOfTopic = this.getIndexOfNode(subTopicPK.getId(), subTopics);
            NodeDetail node2move = (NodeDetail)subTopics.get(indexOfTopic);
            subTopics.remove(indexOfTopic);
            if (way.equals("up")) {
                subTopics.add(indexOfTopic - 1, node2move);
            } else {
                subTopics.add(indexOfTopic + 1, node2move);
            }
            for (int i = 0; i < subTopics.size(); ++i) {
                NodeDetail nodeDetail = (NodeDetail)subTopics.get(i);
                SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.changeSubTopicsOrder()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("updating Node : nodeId = " + nodeDetail.getNodePK().getId() + ", order = " + i));
                try {
                    nodeDetail.setOrder(i);
                    this.nodeBm.setDetail(nodeDetail);
                    continue;
                }
                catch (Exception e) {
                    throw new KmeliaRuntimeException("KmeliaBmEJB.changeSubTopicsOrder()", 4, "kmelia.EX_IMPOSSIBLE_DE_MODIFIER_THEME", e);
                }
            }
        }
    }

    private int getIndexOfNode(String nodeId, List<NodeDetail> nodes) {
        SilverTrace.debug((String)"kmelia", (String)"KmeliaBmEJB.getIndexOfNode()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("nodeId = " + nodeId));
        int index = 0;
        if (nodes != null) {
            for (NodeDetail node : nodes) {
                if (nodeId.equals(node.getNodePK().getId())) {
                    SilverTrace.debug((String)"kmelia", (String)"KmeliaBmEJB.getIndexOfNode()", (String)"root.MSG_GEN_EXIT_METHOD", (String)("index = " + index));
                    return index;
                }
                ++index;
            }
        }
        SilverTrace.debug((String)"kmelia", (String)"KmeliaBmEJB.getIndexOfNode()", (String)"root.MSG_GEN_EXIT_METHOD", (String)("index = " + index));
        return index;
    }

    @Override
    public void changeTopicStatus(String newStatus, NodePK nodePK, boolean recursiveChanges) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.changeTopicStatus()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("newStatus = " + newStatus + ", nodePK = " + nodePK.toString() + ", recursiveChanges = " + recursiveChanges));
        try {
            if (!recursiveChanges) {
                NodeDetail nodeDetail = this.nodeBm.getHeader(nodePK);
                this.changeTopicStatus(newStatus, nodeDetail);
            } else {
                ArrayList subTree = this.nodeBm.getSubTree(nodePK);
                Iterator i$ = subTree.iterator();
                while (i$.hasNext()) {
                    NodeDetail aSubTree;
                    NodeDetail nodeDetail = aSubTree = (NodeDetail)i$.next();
                    this.changeTopicStatus(newStatus, nodeDetail);
                }
            }
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.changeTopicStatus()", 4, "kmelia.EX_IMPOSSIBLE_DE_MODIFIER_THEME", e);
        }
    }

    @Override
    public void sortSubTopics(NodePK fatherPK) {
        this.sortSubTopics(fatherPK, false, null);
    }

    @Override
    public void sortSubTopics(NodePK fatherPK, boolean recursive, String[] criteria) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.sortSubTopics()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("fatherPK = " + fatherPK.toString()));
        List subTopics = null;
        try {
            subTopics = (List)this.nodeBm.getChildrenDetails(fatherPK);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.sortSubTopics()", 4, "kmelia.EX_IMPOSSIBLE_DE_LISTER_THEMES", e);
        }
        if (subTopics != null && subTopics.size() > 0) {
            Collections.sort(subTopics, new TopicComparator(criteria));
            for (int i = 0; i < subTopics.size(); ++i) {
                NodeDetail nodeDetail = (NodeDetail)subTopics.get(i);
                SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.sortSubTopics()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("updating Node : nodeId = " + nodeDetail.getNodePK().getId() + ", order = " + i));
                try {
                    nodeDetail.setOrder(i);
                    this.nodeBm.setDetail(nodeDetail);
                }
                catch (Exception e) {
                    throw new KmeliaRuntimeException("KmeliaBmEJB.sortSubTopics()", 4, "kmelia.EX_IMPOSSIBLE_DE_MODIFIER_THEME", e);
                }
                if (!recursive) continue;
                this.sortSubTopics(nodeDetail.getNodePK(), true, criteria);
            }
        }
    }

    private void changeTopicStatus(String newStatus, NodeDetail topic) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.changeTopicStatus()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("newStatus = " + newStatus + ", nodePK = " + topic.getNodePK().toString()));
        try {
            topic.setStatus(newStatus);
            this.nodeBm.setDetail(topic);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.changeTopicStatus()", 4, "kmelia.EX_IMPOSSIBLE_DE_MODIFIER_THEME", e);
        }
    }

    @Override
    public List<NodeDetail> getTreeview(NodePK nodePK, String profile, boolean coWritingEnable, boolean draftVisibleWithCoWriting, String userId, boolean displayNb, boolean isRightsOnTopicsUsed) {
        String instanceId = nodePK.getInstanceId();
        ArrayList allowedTree = this.nodeBm.getSubTree(nodePK);
        if (profile == null) {
            profile = this.getProfile(userId, nodePK);
        }
        KmeliaUserTreeViewFilter.from(userId, instanceId, nodePK, profile, isRightsOnTopicsUsed).setBestUserRoleAndFilter(allowedTree);
        if (displayNb) {
            boolean checkVisibility = false;
            StringBuilder statusSubQuery = new StringBuilder();
            if (profile.equals("user")) {
                checkVisibility = true;
                statusSubQuery.append(" AND sb_publication_publi.pubStatus = 'Valid' ");
            } else if (profile.equals("writer")) {
                statusSubQuery.append(" AND (");
                if (coWritingEnable && draftVisibleWithCoWriting) {
                    statusSubQuery.append("sb_publication_publi.pubStatus = 'Valid' OR ").append("sb_publication_publi.pubStatus = 'Draft' OR ").append("sb_publication_publi.pubStatus = 'Unvalidate' ");
                } else {
                    checkVisibility = true;
                    statusSubQuery.append("sb_publication_publi.pubStatus = 'Valid' OR ").append("(sb_publication_publi.pubStatus = 'Draft' AND ").append("sb_publication_publi.pubUpdaterId = '").append(userId).append("') OR (sb_publication_publi.pubStatus = 'Unvalidate' AND ").append("sb_publication_publi.pubUpdaterId = '").append(userId).append("') ");
                }
                statusSubQuery.append("OR (sb_publication_publi.pubStatus = 'ToValidate' ").append("AND sb_publication_publi.pubUpdaterId = '").append(userId).append("') ");
                statusSubQuery.append("OR sb_publication_publi.pubUpdaterId = '").append(userId).append("')");
            } else {
                statusSubQuery.append(" AND (");
                if (coWritingEnable && draftVisibleWithCoWriting) {
                    statusSubQuery.append("sb_publication_publi.pubStatus IN ('Valid','ToValidate','Draft') ");
                } else {
                    if (profile.equals("publisher")) {
                        checkVisibility = true;
                    }
                    statusSubQuery.append("sb_publication_publi.pubStatus IN ('Valid','ToValidate') OR (sb_publication_publi.pubStatus = 'Draft' AND sb_publication_publi.pubUpdaterId = '").append(userId).append("') ");
                }
                statusSubQuery.append("OR sb_publication_publi.pubUpdaterId = '").append(userId).append("')");
            }
            Map numbers = this.publicationBm.getDistributionTree(nodePK.getInstanceId(), statusSubQuery.toString(), checkVisibility);
            NodePK trashPk = new NodePK("1", nodePK.getInstanceId());
            int nbPubsInTrash = this.getPublicationsInBasket(trashPk, profile, userId).size();
            numbers.put("1", nbPubsInTrash);
            this.decorateWithNumberOfPublications(allowedTree, (Map<String, Integer>)numbers);
        }
        return allowedTree;
    }

    private void decorateWithNumberOfPublications(List<NodeDetail> nodes, Map<String, Integer> numbers) {
        for (NodeDetail node : nodes) {
            this.decorateWithNumberOfPublications(node, numbers);
        }
    }

    private int decorateWithNumberOfPublications(NodeDetail node, Map<String, Integer> numbers) {
        Integer nb = numbers.get(node.getNodePK().getId());
        for (NodeDetail child : node.getChildrenDetails()) {
            nb = nb + this.decorateWithNumberOfPublications(child, numbers);
        }
        node.setNbObjects(nb.intValue());
        return nb;
    }

    private Collection<PublicationDetail> getPublicationsInBasket(NodePK pk, String userProfile, String userId) {
        String currentUserId = userId;
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.getPublicationsInBasket()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("pk = " + pk.toString() + ", userProfile = " + userProfile + ", userId = " + currentUserId));
        try {
            if (SilverpeasRole.admin.isInRole(new String[]{userProfile})) {
                currentUserId = null;
            }
            Collection pubDetails = this.publicationBm.getDetailsByFatherPK(pk, null, false, currentUserId);
            SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.getPublicationsInBasket()", (String)"root.MSG_GEN_EXIT_METHOD", (String)("nbPublis = " + pubDetails.size()));
            return pubDetails;
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.getPublicationsInBasket()", 4, "kmelia.EX_IMPOSSIBLE_DAVOIR_LE_CONTENU_DE_LA_CORBEILLE", e);
        }
    }

    @Override
    public Collection<Collection<NodeDetail>> getSubscriptionList(String userId, String componentId) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.getSubscriptionList()", (String)"root.MSG_GEN_ENTER_METHOD");
        try {
            SubscriptionList list = this.getSubscribeBm().getBySubscriberAndComponent((SubscriptionSubscriber)UserSubscriptionSubscriber.from((String)userId), componentId);
            ArrayList<Collection<NodeDetail>> detailedList = new ArrayList<Collection<NodeDetail>>();
            for (Subscription subscription : list) {
                Collection path = this.nodeBm.getPath((NodePK)subscription.getResource().getPK());
                detailedList.add(path);
            }
            SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.getSubscriptionList()", (String)"root.MSG_GEN_EXIT_METHOD");
            return detailedList;
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.getSubscriptionList()", 4, "kmelia.EX_IMPOSSIBLE_DOBTENIR_LES_ABONNEMENTS", e);
        }
    }

    @Override
    public void removeSubscriptionToCurrentUser(NodePK topicPK, String userId) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.removeSubscriptionToCurrentUser()", (String)"root.MSG_GEN_ENTER_METHOD");
        try {
            this.getSubscribeBm().unsubscribe((Subscription)new NodeSubscription(userId, topicPK));
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.removeSubscriptionToCurrentUser()", 4, "kmelia.EX_IMPOSSIBLE_DE_SUPPRIMER_ABONNEMENT", e);
        }
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.removeSubscriptionToCurrentUser()", (String)"root.MSG_GEN_EXIT_METHOD");
    }

    private void removeSubscriptionsByTopic(Collection<NodePK> topicPKsToDelete) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.removeSubscriptionsByTopic()", (String)"root.MSG_GEN_ENTER_METHOD");
        try {
            ArrayList<NodeSubscriptionResource> subscriptionResourcesToDelete = new ArrayList<NodeSubscriptionResource>();
            for (NodePK topicPK : topicPKsToDelete) {
                subscriptionResourcesToDelete.add(NodeSubscriptionResource.from((NodePK)topicPK));
            }
            this.getSubscribeBm().unsubscribeByResources(subscriptionResourcesToDelete);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.removeSubscriptionsByTopic()", 4, "kmelia.EX_IMPOSSIBLE_DE_SUPPRIMER_LES_ABONNEMENTS", e);
        }
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.removeSubscriptionsByTopic()", (String)"root.MSG_GEN_EXIT_METHOD");
    }

    @Override
    public void addSubscription(NodePK topicPK, String userId) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.addSubscription()", (String)"root.MSG_GEN_ENTER_METHOD");
        this.getSubscribeBm().subscribe((Subscription)new NodeSubscription(userId, topicPK));
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.addSubscription()", (String)"root.MSG_GEN_EXIT_METHOD");
    }

    @Override
    public boolean checkSubscription(NodePK topicPK, String userId) {
        return !this.getSubscribeBm().existsSubscription((Subscription)new NodeSubscription(userId, topicPK));
    }

    private List<KmeliaPublication> pubDetails2userPubs(Collection<PublicationDetail> pubDetails) {
        ArrayList<KmeliaPublication> publications = new ArrayList<KmeliaPublication>();
        int i = -1;
        for (PublicationDetail publicationDetail : pubDetails) {
            publications.add(KmeliaPublication.aKmeliaPublicationFromDetail(publicationDetail, i++));
        }
        return publications;
    }

    @Override
    public PublicationDetail getPublicationDetail(PublicationPK pubPK) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.getPublicationDetail()", (String)"root.MSG_GEN_ENTER_METHOD");
        try {
            SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.getPublicationDetail()", (String)"root.MSG_GEN_EXIT_METHOD");
            return this.publicationBm.getDetail(pubPK);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.getPublicationDetail()", 4, "kmelia.EX_IMPOSSIBLE_DOBTENIR_LA_PUBLICATION", e);
        }
    }

    @Override
    public Collection<Collection<NodeDetail>> getPathList(PublicationPK pubPK) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.getPathList()", (String)"root.MSG_GEN_ENTER_METHOD");
        Collection fatherPKs = null;
        try {
            fatherPKs = this.publicationBm.getAllFatherPK(pubPK);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.getPathList()", 4, "kmelia.EX_IMPOSSIBLE_DOBTENIR_LES_EMPLACEMENTS_DE_LA_PUBLICATION", e);
        }
        try {
            ArrayList<Collection<NodeDetail>> pathList = new ArrayList<Collection<NodeDetail>>();
            if (fatherPKs != null) {
                for (NodePK pk : fatherPKs) {
                    Collection path = this.nodeBm.getAnotherPath(pk);
                    pathList.add(path);
                }
            }
            SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.getPathList()", (String)"root.MSG_GEN_EXIT_METHOD");
            return pathList;
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.getPathList()", 4, "kmelia.EX_IMPOSSIBLE_DOBTENIR_LES_EMPLACEMENTS_DE_LA_PUBLICATION", e);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public String createPublicationIntoTopic(PublicationDetail pubDetail, NodePK fatherPK) {
        PdcClassificationService classifier = PdcServiceFactory.getFactory().getPdcClassificationService();
        PdcClassification predefinedClassification = classifier.findAPreDefinedClassification(fatherPK.getId(), fatherPK.getInstanceId());
        return this.createPublicationIntoTopic(pubDetail, fatherPK, predefinedClassification);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public String createPublicationIntoTopic(PublicationDetail pubDetail, NodePK fatherPK, PdcClassification classification) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.createPublicationIntoTopic()", (String)"root.MSG_GEN_ENTER_METHOD");
        String pubId = null;
        try {
            pubId = this.createPublicationIntoTopicWithoutNotifications(pubDetail, fatherPK, classification);
            this.createTodosForPublication(pubDetail, true);
            this.sendAlertToSupervisors(fatherPK, pubDetail);
            this.sendSubscriptionsNotification(pubDetail, NotifAction.CREATE, false);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.createPublicationIntoTopic()", 4, "kmelia.EX_IMPOSSIBLE_DE_CREER_LA_PUBLICATION", e);
        }
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.createPublicationIntoTopic()", (String)"root.MSG_GEN_EXIT_METHOD");
        return pubId;
    }

    private String createPublicationIntoTopicWithoutNotifications(PublicationDetail pubDetail, NodePK fatherPK, PdcClassification classification) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.createPublicationIntoTopic()", (String)"root.MSG_GEN_ENTER_METHOD");
        PublicationPK pubPK = null;
        try {
            pubDetail = this.changePublicationStatusOnCreation(pubDetail, fatherPK);
            pubPK = this.publicationBm.createPublication(pubDetail);
            pubDetail.getPK().setId(pubPK.getId());
            this.createSilverContent(pubDetail, pubDetail.getCreatorId());
            this.addPublicationToTopicWithoutNotifications(pubPK, fatherPK, true);
            if (!classification.isEmpty()) {
                PdcClassificationService service = PdcServiceFactory.getFactory().getPdcClassificationService();
                classification.ofContent(pubPK.getId());
                service.classifyContent((SilverpeasContent)pubDetail, classification, false);
            }
            KmeliaServiceContext.createdIntoRequestContext(pubDetail);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.createPublicationIntoTopic()", 4, "kmelia.EX_IMPOSSIBLE_DE_CREER_LA_PUBLICATION", e);
        }
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.createPublicationIntoTopic()", (String)"root.MSG_GEN_EXIT_METHOD");
        return pubPK.getId();
    }

    private String getProfile(String userId, NodePK nodePK) {
        NodeDetail topic;
        OrganisationController orgCtrl = OrganisationControllerFactory.getOrganisationController();
        String profile = this.isRightsOnTopicsEnabled(nodePK.getInstanceId()) ? ((topic = this.nodeBm.getHeader(nodePK)).haveRights() ? KmeliaHelper.getProfile(orgCtrl.getUserProfiles(userId, nodePK.getInstanceId(), topic.getRightsDependsOn(), ObjectType.NODE)) : KmeliaHelper.getProfile(orgCtrl.getUserProfiles(userId, nodePK.getInstanceId()))) : KmeliaHelper.getProfile(orgCtrl.getUserProfiles(userId, nodePK.getInstanceId()));
        return profile;
    }

    private String getProfileOnPublication(String userId, PublicationPK pubPK) {
        List fathers = (List)this.getPublicationFathers(pubPK);
        NodePK nodePK = new NodePK("unknown", pubPK.getInstanceId());
        if (fathers != null && !fathers.isEmpty()) {
            nodePK = (NodePK)fathers.get(0);
        }
        return this.getProfile(userId, nodePK);
    }

    private PublicationDetail changePublicationStatusOnCreation(PublicationDetail pubDetail, NodePK nodePK) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.changePublicationStatusOnCreation()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("status = " + pubDetail.getStatus()));
        String status = pubDetail.getStatus();
        if (!StringUtil.isDefined((String)status)) {
            status = "ToValidate";
            boolean draftModeUsed = this.isDraftModeUsed(pubDetail.getPK().getInstanceId());
            if (draftModeUsed) {
                status = "Draft";
            } else {
                String profile = this.getProfile(pubDetail.getCreatorId(), nodePK);
                if (SilverpeasRole.publisher.isInRole(new String[]{profile}) || SilverpeasRole.admin.isInRole(new String[]{profile})) {
                    status = "Valid";
                }
            }
        }
        pubDetail.setStatus(status);
        KmeliaHelper.checkIndex(pubDetail);
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.changePublicationStatusOnCreation()", (String)"root.MSG_GEN_EXIT_METHOD", (String)("status = " + pubDetail.getStatus() + ", indexOperation = " + pubDetail.getIndexOperation()));
        return pubDetail;
    }

    private boolean changePublicationStatusOnMove(PublicationDetail pub, NodePK to) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.changePublicationStatusOnMove()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("status = " + pub.getStatus()));
        String oldStatus = pub.getStatus();
        String status = pub.getStatus();
        if (!status.equals("Draft")) {
            status = "ToValidate";
            String profile = this.getProfile(pub.getUpdaterId(), to);
            if (SilverpeasRole.publisher.isInRole(new String[]{profile}) || SilverpeasRole.admin.isInRole(new String[]{profile})) {
                status = "Valid";
            }
        }
        pub.setStatus(status);
        KmeliaHelper.checkIndex(pub);
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.changePublicationStatusOnMove()", (String)"root.MSG_GEN_EXIT_METHOD", (String)("status = " + pub.getStatus() + ", indexOperation = " + pub.getIndexOperation()));
        return !oldStatus.equals(status);
    }

    private boolean changePublicationStatusOnUpdate(PublicationDetail pubDetail) {
        String oldStatus;
        String newStatus = oldStatus = pubDetail.getStatus();
        List fathers = (List)this.getPublicationFathers(pubDetail.getPK());
        if (pubDetail.isStatusMustBeChecked() && !pubDetail.isDraft() && !pubDetail.isClone()) {
            String profile;
            NodePK nodePK = new NodePK("unknown", pubDetail.getPK().getInstanceId());
            if (fathers != null && !fathers.isEmpty()) {
                nodePK = (NodePK)fathers.get(0);
            }
            if (SilverpeasRole.writer.isInRole(new String[]{profile = this.getProfile(pubDetail.getUpdaterId(), nodePK)})) {
                newStatus = "ToValidate";
            }
            pubDetail.setStatus(newStatus);
        }
        KmeliaHelper.checkIndex(pubDetail);
        if (fathers == null || fathers.isEmpty() || fathers.size() == 1 && ((NodePK)fathers.get(0)).isTrash()) {
            pubDetail.setIndexOperation(-1);
        }
        return !oldStatus.equalsIgnoreCase(newStatus);
    }

    @Override
    public void updatePublication(PublicationDetail pubDetail) {
        this.updatePublication(pubDetail, 0, false);
    }

    @Override
    public void updatePublication(PublicationDetail pubDetail, boolean forceUpdateDate) {
        this.updatePublication(pubDetail, 0, forceUpdateDate);
    }

    private void updatePublication(PublicationDetail pubDetail, int updateScope, boolean forceUpdateDate) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.updatePublication()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("updateScope = " + updateScope));
        try {
            boolean isNewsManage;
            boolean isClone = pubDetail.isClone();
            SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.updatePublication()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("This publication is clone ? " + isClone));
            PublicationDetail old = this.getPublicationDetail(pubDetail.getPK());
            if (StringUtil.isDefined((String)old.getTargetValidatorId()) && !StringUtil.isDefined((String)pubDetail.getTargetValidatorId())) {
                pubDetail.setTargetValidatorId(old.getTargetValidatorId());
            }
            boolean isPublicationInBasket = this.isPublicationInBasket(pubDetail.getPK());
            if (isClone) {
                this.publicationBm.setDetail(pubDetail, forceUpdateDate);
                this.performValidatorChanges(old, pubDetail);
            } else {
                boolean statusChanged = this.changePublicationStatusOnUpdate(pubDetail);
                this.publicationBm.setDetail(pubDetail, forceUpdateDate);
                if (!isPublicationInBasket) {
                    if (statusChanged) {
                        this.createTodosForPublication(pubDetail, false);
                    } else {
                        this.performValidatorChanges(old, pubDetail);
                    }
                    this.updateSilverContentVisibility(pubDetail);
                    String profile = KmeliaHelper.getProfile(OrganisationControllerFactory.getOrganisationController().getUserProfiles(pubDetail.getUpdaterId(), pubDetail.getPK().getInstanceId()));
                    if ("supervisor".equals(profile)) {
                        this.sendModificationAlert(updateScope, pubDetail.getPK());
                    }
                    boolean visibilityPeriodUpdated = this.isVisibilityPeriodUpdated(pubDetail, old);
                    if (statusChanged || visibilityPeriodUpdated) {
                        if (KmeliaHelper.isIndexable(pubDetail)) {
                            this.indexExternalElementsOfPublication(pubDetail);
                        } else {
                            this.unIndexExternalElementsOfPublication(pubDetail.getPK());
                        }
                    }
                }
            }
            if (!(isPublicationInBasket || KmeliaServiceContext.hasPublicationBeenCreatedFromRequestContext(pubDetail) || KmeliaServiceContext.hasPublicationBeenUpdatedFromRequestContext(pubDetail))) {
                this.sendSubscriptionsNotification(pubDetail, NotifAction.UPDATE, false);
            }
            if (isNewsManage = StringUtil.getBooleanValue((String)OrganisationControllerFactory.getOrganisationController().getComponentParameterValue(pubDetail.getPK().getInstanceId(), "isNewsManage"))) {
                CallBackManager callBackManager = CallBackManager.get();
                callBackManager.invoke(21, Integer.parseInt(pubDetail.getId()), pubDetail.getInstanceId(), (Object)pubDetail);
            }
            KmeliaServiceContext.updatedIntoRequestContext(pubDetail);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.updatePublication()", 4, "kmelia.EX_IMPOSSIBLE_DE_MODIFIER_LA_PUBLICATION", e);
        }
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.updatePublication()", (String)"root.MSG_GEN_EXIT_METHOD");
    }

    private void performValidatorChanges(PublicationDetail previousPublication, PublicationDetail currentPublication) {
        if (currentPublication.isValidationRequired() && currentPublication.getTargetValidatorIds() != null) {
            List<String> oldValidatorIds = Arrays.asList(previousPublication.getTargetValidatorIds());
            List<String> newValidatorIds = Arrays.asList(currentPublication.getTargetValidatorIds());
            ArrayList<String> toRemoveToDo = new ArrayList<String>(oldValidatorIds);
            ArrayList<String> toAlert = new ArrayList<String>(newValidatorIds);
            toRemoveToDo.removeAll(newValidatorIds);
            toAlert.removeAll(oldValidatorIds);
            this.removeTodoForPublication(currentPublication.getPK(), toRemoveToDo);
            this.addTodoAndSendNotificationToValidators(currentPublication, toAlert);
        }
    }

    private boolean isVisibilityPeriodUpdated(PublicationDetail pubDetail, PublicationDetail old) {
        boolean beginVisibilityPeriodUpdated = pubDetail.getBeginDate() != null && old.getBeginDate() == null || pubDetail.getBeginDate() == null && old.getBeginDate() != null || pubDetail.getBeginDate() != null && old.getBeginDate() != null && !pubDetail.getBeginDate().equals(old.getBeginDate());
        boolean endVisibilityPeriodUpdated = pubDetail.getEndDate() != null && old.getEndDate() == null || pubDetail.getEndDate() == null && old.getEndDate() != null || pubDetail.getEndDate() != null && old.getEndDate() != null && !pubDetail.getEndDate().equals(old.getEndDate());
        return beginVisibilityPeriodUpdated || endVisibilityPeriodUpdated;
    }

    @Override
    @Interceptors(value={SimulationActionProcessAnnotationEJBInterceptor.class})
    @SimulationActionProcess(elementLister=KmeliaPublicationSimulationElementLister.class)
    @Action(value=ActionType.MOVE)
    public void movePublication(@SourcePK PublicationPK pubPK, @TargetPK NodePK to, String userId) {
        PublicationDetail pub = this.getPublicationDetail(pubPK);
        if (pub != null) {
            if (pubPK.getInstanceId().equals(to.getInstanceId())) {
                this.movePublicationInSameApplication(pub, to, userId);
            } else {
                this.movePublicationInAnotherApplication(pub, to, userId);
            }
        }
    }

    @Override
    @Interceptors(value={SimulationActionProcessAnnotationEJBInterceptor.class})
    @SimulationActionProcess(elementLister=KmeliaPublicationSimulationElementLister.class)
    @Action(value=ActionType.MOVE)
    public void movePublicationInSameApplication(@SourcePK PublicationPK pubPK, @TargetPK NodePK from, NodePK to, String userId) {
        PublicationDetail pub = this.getPublicationDetail(pubPK);
        String profile = this.getUserTopicProfile(from, userId);
        boolean cutAllowed = KmeliaPublicationHelper.isCanBeCut(from.getComponentName(), userId, profile, pub.getCreator());
        String profileInTarget = this.getUserTopicProfile(to, userId);
        boolean pasteAllowed = KmeliaPublicationHelper.isCreationAllowed(to, profileInTarget);
        if (cutAllowed && pasteAllowed) {
            this.movePublicationInSameApplication(pub, to, userId);
        }
    }

    private void movePublicationInSameApplication(PublicationDetail pub, NodePK to, String userId) {
        if (to.isTrash()) {
            this.sendPublicationToBasket(pub.getPK());
        } else {
            this.publicationBm.removeAllFather(pub.getPK());
            this.publicationBm.addFather(pub.getPK(), to);
            this.processPublicationAfterMove(pub, to, userId);
        }
    }

    @Override
    @Interceptors(value={SimulationActionProcessAnnotationEJBInterceptor.class})
    @SimulationActionProcess(elementLister=KmeliaPublicationSimulationElementLister.class)
    @Action(value=ActionType.MOVE)
    public void movePublicationInAnotherApplication(@SourcePK PublicationDetail pub, @TargetPK NodePK to, String userId) {
        try {
            ForeignPK fromForeignPK = new ForeignPK((WAPrimaryKey)pub.getPK());
            String fromComponentId = pub.getInstanceId();
            ForeignPK toPubliForeignPK = new ForeignPK(pub.getId(), (WAPrimaryKey)to);
            this.unIndexExternalElementsOfPublication(pub.getPK());
            ThumbnailController.moveThumbnail((ForeignPK)fromForeignPK, (ForeignPK)toPubliForeignPK);
            try {
                SimpleDocumentList documents = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKeyAndType((WAPrimaryKey)fromForeignPK, DocumentType.image, null);
                documents.addAll(AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKeyAndType((WAPrimaryKey)fromForeignPK, DocumentType.wysiwyg, null));
                for (SimpleDocument doc : documents) {
                    AttachmentServiceFactory.getAttachmentService().moveDocument(doc, toPubliForeignPK);
                }
            }
            catch (AttachmentException e) {
                SilverTrace.error((String)"kmelia", (String)"KmeliaBmEJB.movePublicationInAnotherApplication()", (String)"root.MSG_GEN_PARAM_VALUE", (String)"kmelia.CANT_MOVE_ATTACHMENTS", (Throwable)e);
            }
            WysiwygController.wysiwygPlaceHaveChanged((String)fromForeignPK.getInstanceId(), (String)pub.getPK().getId(), (String)to.getInstanceId(), (String)pub.getPK().getId());
            SimpleDocumentList docs = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKeyAndType((WAPrimaryKey)fromForeignPK, DocumentType.attachment, null);
            for (SimpleDocument doc : docs) {
                AttachmentServiceFactory.getAttachmentService().moveDocument(doc, toPubliForeignPK);
            }
            String infoId = pub.getInfoId();
            if (infoId != null && !"0".equals(infoId)) {
                PublicationTemplateManager templateManager = PublicationTemplateManager.getInstance();
                GenericRecordSet toRecordSet = templateManager.addDynamicPublicationTemplate(to.getInstanceId() + ":" + pub.getInfoId(), pub.getInfoId() + ".xml");
                RecordTemplate toRecordTemplate = toRecordSet.getRecordTemplate();
                PublicationTemplate pubTemplateFrom = templateManager.getPublicationTemplate(fromComponentId + ":" + pub.getInfoId());
                RecordSet set = pubTemplateFrom.getRecordSet();
                set.move(fromForeignPK, toPubliForeignPK, toRecordTemplate);
            }
            this.getCommentService().moveComments(PublicationDetail.getResourceType(), (WAPrimaryKey)fromForeignPK, (WAPrimaryKey)toPubliForeignPK);
            PdcBmImpl pdcBmImpl = new PdcBmImpl();
            int fromSilverObjectId = this.getSilverObjectId(pub.getPK());
            List positions = pdcBmImpl.getPositions(fromSilverObjectId, fromComponentId);
            this.deleteSilverContent(pub.getPK());
            this.statisticBm.moveStat(toPubliForeignPK, 1, "Publication");
            this.publicationBm.movePublication(pub.getPK(), to, false);
            pub.getPK().setComponentName(to.getInstanceId());
            this.processPublicationAfterMove(pub, to, userId);
            if (KmeliaHelper.isIndexable(pub)) {
                this.indexPublication(pub);
            }
            int toSilverObjectId = this.getSilverObjectId(pub.getPK());
            pdcBmImpl.addPositions(positions, toSilverObjectId, to.getInstanceId());
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.movePublication()", 4, "kmelia.EX_CANT_MOVE_PUBLICATION_INTO_ANOTHER_APP", e);
        }
    }

    private void processPublicationAfterMove(PublicationDetail pub, NodePK to, String userId) {
        pub.setUpdaterId(userId);
        boolean statusChanged = this.changePublicationStatusOnMove(pub, to);
        this.publicationBm.setDetail(pub, statusChanged);
        this.updateSilverContentVisibility(pub);
        if (statusChanged) {
            this.createTodosForPublication(pub, false);
            if (KmeliaHelper.isIndexable(pub)) {
                this.indexExternalElementsOfPublication(pub);
            } else {
                this.unIndexExternalElementsOfPublication(pub.getPK());
            }
        }
        this.sendSubscriptionsNotification(pub, NotifAction.PUBLISHED, false);
    }

    @Override
    public void externalElementsOfPublicationHaveChanged(PublicationPK pubPK, String userId, int action) {
        if (pubPK != null && StringUtil.isDefined((String)pubPK.getInstanceId()) && (pubPK.getInstanceId().startsWith("kmelia") || pubPK.getInstanceId().startsWith("toolbox") || pubPK.getInstanceId().startsWith("kmax"))) {
            PublicationDetail pubDetail = null;
            boolean isPublicationInBasketBeforeUpdate = false;
            try {
                isPublicationInBasketBeforeUpdate = this.isPublicationInBasket(pubPK);
                pubDetail = this.getPublicationDetail(pubPK);
            }
            catch (Exception e) {
                SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.externalElementsOfPublicationHaveChanged", (String)"kmelia.EX_IMPOSSIBLE_DOBTENIR_LA_PUBLICATION", (String)("pubPK = " + pubPK.toString()), (Throwable)e);
            }
            if (pubDetail == null || StringUtil.isDefined((String)pubPK.getInstanceId()) && !pubDetail.getInstanceId().equals(pubPK.getInstanceId())) {
                return;
            }
            if (pubDetail.isClone()) {
                pubDetail.setIndexOperation(-1);
            }
            if (StringUtil.isDefined((String)userId)) {
                pubDetail.setUpdaterId(userId);
            }
            if (!StringUtil.isDefined((String)userId)) {
                this.updatePublication(pubDetail, 1, false);
            } else {
                String profile = this.getProfileOnPublication(userId, pubDetail.getPK());
                if ("supervisor".equals(profile) || SilverpeasRole.publisher.isInRole(new String[]{profile}) || SilverpeasRole.admin.isInRole(new String[]{profile}) || SilverpeasRole.writer.isInRole(new String[]{profile})) {
                    this.updatePublication(pubDetail, 1, false);
                } else {
                    SilverTrace.warn((String)"kmelia", (String)"KmeliaBmEJB.externalElementsOfPublicationHaveChanged", (String)"kmelia.PROBLEM_DETECTED", (String)("user " + userId + " is not allowed to update publication " + pubDetail.getPK()));
                }
            }
            if (KmeliaHelper.isIndexable(pubDetail) && !isPublicationInBasketBeforeUpdate) {
                this.publicationBm.createIndex(pubDetail);
            }
            this.indexExternalElementsOfPublication(pubDetail);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void deletePublication(PublicationPK pubPK) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.deletePublication()", (String)"root.MSG_GEN_ENTER_METHOD");
        try {
            this.removeXMLContentOfPublication(pubPK);
            this.deleteAllReadingControlsByPublication(pubPK);
            this.publicationBm.removeAllFather(pubPK);
            this.publicationBm.removePublication(pubPK);
            this.deleteSilverContent(pubPK);
            this.removeExternalElementsOfPublications(pubPK);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.deletePublication()", 4, "kmelia.EX_IMPOSSIBLE_DE_SUPPRIMER_LA_PUBLICATION", e);
        }
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.deletePublication()", (String)"root.MSG_GEN_EXIT_METHOD");
    }

    @Override
    public void sendPublicationToBasket(PublicationPK pubPK, boolean kmaxMode) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.sendPublicationToBasket()", (String)"root.MSG_GEN_ENTER_METHOD");
        try {
            if (kmaxMode) {
                CoordinatePK coordinatePK = new CoordinatePK("unknown", pubPK.getSpaceId(), pubPK.getComponentName());
                Collection fatherPKs = this.publicationBm.getAllFatherPK(pubPK);
                Iterator it = fatherPKs.iterator();
                ArrayList<String> coordinates = new ArrayList<String>();
                SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.sendPublicationToBasket()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("fatherPKs" + fatherPKs));
                while (it.hasNext()) {
                    String coordinateId = ((NodePK)it.next()).getId();
                    coordinates.add(coordinateId);
                }
                if (coordinates.size() > 0) {
                    this.coordinatesBm.deleteCoordinates(coordinatePK, coordinates);
                }
            }
            this.publicationBm.removeAllFather(pubPK);
            this.publicationBm.addFather(pubPK, new NodePK("1", (WAPrimaryKey)pubPK));
            this.removeAllTodosForPublication(pubPK);
            this.updateSilverContentVisibility(pubPK, false);
            this.unIndexExternalElementsOfPublication(pubPK);
            boolean isNewsManage = StringUtil.getBooleanValue((String)OrganisationControllerFactory.getOrganisationController().getComponentParameterValue(pubPK.getInstanceId(), "isNewsManage"));
            if (isNewsManage) {
                CallBackManager callBackManager = CallBackManager.get();
                callBackManager.invoke(22, Integer.parseInt(pubPK.getId()), pubPK.getInstanceId(), (Object)"");
            }
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.sendPublicationToBasket()", 4, "kmelia.EX_IMPOSSIBLE_DENVOYER_LA_PUBLICATION_A_LA_CORBEILLE", e);
        }
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.sendPublicationToBasket()", (String)"root.MSG_GEN_EXIT_METHOD");
    }

    @Override
    public void sendPublicationToBasket(PublicationPK pubPK) {
        this.sendPublicationToBasket(pubPK, KmeliaHelper.isKmax(pubPK.getInstanceId()));
    }

    @Override
    public void addPublicationToTopic(PublicationPK pubPK, NodePK fatherPK, boolean isACreation) {
        this.addPublicationToTopicWithoutNotifications(pubPK, fatherPK, isACreation);
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.addPublicationToTopic()", (String)"root.MSG_GEN_ENTER_METHOD");
        PublicationDetail pubDetail = this.getPublicationDetail(pubPK);
        this.sendSubscriptionsNotification(pubDetail, NotifAction.CREATE, false);
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.addPublicationToTopic()", (String)"root.MSG_GEN_EXIT_METHOD");
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void addPublicationToTopicWithoutNotifications(PublicationPK pubPK, NodePK fatherPK, boolean isACreation) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.addPublicationToTopic()", (String)"root.MSG_GEN_ENTER_METHOD");
        PublicationDetail pubDetail = this.getPublicationDetail(pubPK);
        if (!isACreation) {
            try {
                Collection fathers = this.publicationBm.getAllFatherPK(pubPK);
                if (this.isPublicationInBasket(pubPK, fathers)) {
                    this.publicationBm.removeFather(pubPK, new NodePK("1", (WAPrimaryKey)fatherPK));
                    if ("Valid".equalsIgnoreCase(pubDetail.getStatus())) {
                        this.publicationBm.createIndex(pubPK);
                        this.indexExternalElementsOfPublication(pubDetail);
                        this.updateSilverContentVisibility(pubDetail);
                    } else if ("ToValidate".equalsIgnoreCase(pubDetail.getStatus())) {
                        this.createTodosForPublication(pubDetail, true);
                    }
                } else if (fathers.isEmpty()) {
                    pubDetail.setEndDate(null);
                    this.publicationBm.setDetail(pubDetail);
                    this.updateSilverContentVisibility(pubDetail);
                }
            }
            catch (Exception e) {
                throw new KmeliaRuntimeException("KmeliaBmEJB.addPublicationToTopic()", 4, "kmelia.EX_IMPOSSIBLE_DE_PLACER_LA_PUBLICATION_DANS_LE_THEME", e);
            }
        }
        try {
            this.publicationBm.addFather(pubPK, fatherPK);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.addPublicationToTopic()", 4, "kmelia.EX_IMPOSSIBLE_DE_PLACER_LA_PUBLICATION_DANS_LE_THEME", e);
        }
    }

    private boolean isPublicationInBasket(PublicationPK pubPK) {
        return this.isPublicationInBasket(pubPK, null);
    }

    private boolean isPublicationInBasket(PublicationPK pubPK, Collection<NodePK> fathers) {
        NodePK pk;
        Iterator iterator;
        if (fathers == null) {
            fathers = this.publicationBm.getAllFatherPK(pubPK);
        }
        return fathers.size() == 1 && (iterator = fathers.iterator()).hasNext() && (pk = (NodePK)iterator.next()).isTrash();
    }

    private NodePK sendSubscriptionsNotification(PublicationDetail pubDetail, NotifAction action, boolean sendOnlyToAliases) {
        NodePK oneFather = null;
        if (!pubDetail.haveGotClone() && pubDetail.isValid() && pubDetail.isVisible()) {
            Collection<NodePK> fathers = this.getPublicationFathers(pubDetail.getPK());
            if (!sendOnlyToAliases) {
                Iterator<NodePK> i$ = fathers.iterator();
                while (i$.hasNext()) {
                    NodePK father;
                    oneFather = father = i$.next();
                    this.sendSubscriptionsNotification(father, pubDetail, action);
                }
            }
            List aliases = (List)this.getAlias(pubDetail.getPK());
            for (Alias alias : aliases) {
                NodePK aliasNodePk = new NodePK(alias.getId(), alias.getInstanceId());
                if ((!sendOnlyToAliases || alias.getDate() == null) && fathers.contains(aliasNodePk)) continue;
                pubDetail.setAlias(true);
                this.sendSubscriptionsNotification((NodePK)alias, pubDetail, action);
            }
            try {
                int silverObjectId = this.getSilverObjectId(pubDetail.getPK());
                List positions = this.pdcBm.getPositions(silverObjectId, pubDetail.getPK().getInstanceId());
                PdcSubscriptionUtil pdc = new PdcSubscriptionUtil();
                if (positions != null) {
                    for (ClassifyPosition position : positions) {
                        pdc.checkSubscriptions(position.getValues(), pubDetail.getPK().getInstanceId(), silverObjectId);
                    }
                }
            }
            catch (RemoteException e) {
                SilverTrace.error((String)"kmelia", (String)"KmeliaBmEJB.sendSubscriptionsNotification", (String)"kmelia.CANT_SEND_PDC_SUBSCRIPTIONS", (Throwable)e);
            }
        }
        return oneFather;
    }

    private void sendSubscriptionsNotification(NodePK fatherPK, PublicationDetail pubDetail, NotifAction action) {
        try {
            UserNotificationHelper.buildAndSend((UserNotificationBuilder)new KmeliaSubscriptionPublicationUserNotification(fatherPK, pubDetail, action));
        }
        catch (Exception e) {
            SilverTrace.warn((String)"kmelia", (String)"KmeliaBmEJB.sendSubscriptionsNotification()", (String)"kmelia.EX_IMPOSSIBLE_DALERTER_LES_UTILISATEURS", (String)("fatherId = " + fatherPK.getId() + ", pubId = " + pubDetail.getPK().getId()), (Throwable)e);
        }
    }

    @Override
    public void deletePublicationFromTopic(PublicationPK pubPK, NodePK fatherPK) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.deletePublicationFromTopic()", (String)"root.MSG_GEN_ENTER_METHOD");
        try {
            Collection pubFathers = this.publicationBm.getAllFatherPK(pubPK);
            if (pubFathers.size() >= 2) {
                this.publicationBm.removeFather(pubPK, fatherPK);
            } else {
                this.sendPublicationToBasket(pubPK);
            }
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.deletePublicationFromTopic()", 4, "kmelia.EX_IMPOSSIBLE_DE_SUPPRIMER_LA_PUBLICATION_DE_CE_THEME", e);
        }
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.deletePublicationFromTopic()", (String)"root.MSG_GEN_EXIT_METHOD");
    }

    @Override
    public void deletePublicationFromAllTopics(PublicationPK pubPK) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.deletePublicationFromAllTopics()", (String)"root.MSG_GEN_ENTER_METHOD");
        try {
            this.publicationBm.removeAllFather(pubPK);
            this.sendPublicationToBasket(pubPK);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.deletePublicationFromAllTopics()", 4, "kmelia.EX_IMPOSSIBLE_DE_SUPPRIMER_LA_PUBLICATION_DE_CE_THEME", e);
        }
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.deletePublicationFromAllTopics()", (String)"root.MSG_GEN_EXIT_METHOD");
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void addInfoLinks(PublicationPK pubPK, List<ForeignPK> links) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.addInfoLinks()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("pubId = " + pubPK.getId() + ", pubIds = " + links.toString()));
        try {
            this.publicationBm.addLinks(pubPK, links);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.addInfoLinks()", 4, "kmelia.EX_IMPOSSIBLE_DE_MODIFIER_LE_CONTENU_DU_MODELE", e);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void deleteInfoLinks(PublicationPK pubPK, List<ForeignPK> links) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.deleteInfoLinks()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("pubId = " + pubPK.getId() + ", pubIds = " + links.toString()));
        try {
            this.publicationBm.deleteInfoLinks(pubPK, links);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.deleteInfoLinks()", 4, "kmelia.EX_IMPOSSIBLE_DE_MODIFIER_LE_CONTENU_DU_MODELE", e);
        }
    }

    @Override
    public CompletePublication getCompletePublication(PublicationPK pubPK) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.getCompletePublication()", (String)"root.MSG_GEN_ENTER_METHOD");
        CompletePublication completePublication = null;
        try {
            completePublication = this.publicationBm.getCompletePublication(pubPK);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.getCompletePublication()", 4, "kmelia.EX_IMPOSSIBLE_DOBTENIR_LA_PUBLICATION", e);
        }
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.getCompletePublication()", (String)"root.MSG_GEN_EXIT_METHOD");
        return completePublication;
    }

    @Override
    public KmeliaPublication getPublication(PublicationPK pubPK) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.getPublication()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("pubPK = " + pubPK.toString()));
        return KmeliaPublication.aKmeliaPublicationWithPk(pubPK);
    }

    @Override
    public TopicDetail getPublicationFather(PublicationPK pubPK, boolean isTreeStructureUsed, String userId, boolean isRightsOnTopicsUsed) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.getPublicationFather()", (String)"root.MSG_GEN_ENTER_METHOD");
        NodePK fatherPK = this.getPublicationFatherPK(pubPK, isTreeStructureUsed, userId, isRightsOnTopicsUsed);
        String profile = KmeliaHelper.getProfile(OrganisationControllerFactory.getOrganisationController().getUserProfiles(userId, pubPK.getInstanceId()));
        TopicDetail fatherDetail = this.goTo(fatherPK, userId, isTreeStructureUsed, profile, isRightsOnTopicsUsed);
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.getPublicationFather()", (String)"root.MSG_GEN_EXIT_METHOD");
        return fatherDetail;
    }

    @Override
    public NodePK getPublicationFatherPK(PublicationPK pubPK, boolean isTreeStructureUsed, String userId, boolean isRightsOnTopicsUsed) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.getPublicationFatherId()", (String)"root.MSG_GEN_ENTER_METHOD");
        Collection<NodePK> fathers = this.getPublicationFathers(pubPK);
        NodePK fatherPK = new NodePK("0", (WAPrimaryKey)pubPK);
        if (fathers != null) {
            Iterator<NodePK> it = fathers.iterator();
            if (!isRightsOnTopicsUsed) {
                if (it.hasNext()) {
                    fatherPK = it.next();
                }
            } else {
                NodeDetail allowedFather = null;
                while (allowedFather == null && it.hasNext()) {
                    fatherPK = it.next();
                    NodeDetail father = this.getNodeHeader(fatherPK);
                    if (father.haveRights() && !OrganisationControllerFactory.getOrganisationController().isObjectAvailable(father.getRightsDependsOn(), ObjectType.NODE, fatherPK.getInstanceId(), userId)) continue;
                    allowedFather = father;
                }
                if (allowedFather != null) {
                    fatherPK = allowedFather.getNodePK();
                }
            }
        }
        return fatherPK;
    }

    @Override
    public Collection<NodePK> getPublicationFathers(PublicationPK pubPK) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.getPublicationFathers()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("pubPK = " + pubPK.toString()));
        try {
            Collection fathers = this.publicationBm.getAllFatherPK(pubPK);
            if (CollectionUtil.isEmpty((Collection)fathers)) {
                SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.getPublicationFathers()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("Following publication have got no fathers : pubPK = " + pubPK.toString()));
                boolean alwaysVisibleModeActivated = StringUtil.getBooleanValue((String)OrganisationControllerFactory.getOrganisationController().getComponentParameterValue(pubPK.getInstanceId(), "publicationAlwaysVisible"));
                if (alwaysVisibleModeActivated) {
                    SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.getPublicationFathers()", (String)"root.MSG_GEN_PARAM_VALUE", (String)"Getting the publication");
                    PublicationDetail publi = this.publicationBm.getDetail(pubPK);
                    if (publi != null) {
                        boolean isClone = publi.isClone();
                        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.getPublicationFathers()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("This publication is clone ? " + isClone));
                        if (isClone) {
                            fathers = this.publicationBm.getAllFatherPK(publi.getClonePK());
                            SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.getPublicationFathers()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("Main publication's fathers fetched. # of fathers = " + fathers.size()));
                        }
                    }
                }
            }
            return fathers;
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.getPublicationFathers()", 4, "kmelia.EX_IMPOSSIBLE_DOBTENIR_UN_PERE_DE_LA_PUBLICATION", e);
        }
    }

    @Override
    public Collection<PublicationDetail> getPublicationDetails(List<ForeignPK> links) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.getPublicationDetails()", (String)"root.MSG_GEN_ENTER_METHOD");
        Collection publications = null;
        ArrayList<PublicationPK> publicationPKs = new ArrayList<PublicationPK>();
        for (ForeignPK link : links) {
            PublicationPK pubPK = new PublicationPK(link.getId(), link.getInstanceId());
            publicationPKs.add(pubPK);
        }
        try {
            publications = this.publicationBm.getPublications(publicationPKs);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.getPublicationDetails()", 4, "kmelia.EX_IMPOSSIBLE_DOBTENIR_LES_PUBLICATIONS", e);
        }
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.getPublicationDetails()", (String)"root.MSG_GEN_EXIT_METHOD");
        return publications;
    }

    @Override
    public Collection<KmeliaPublication> getPublications(List<ForeignPK> links, String userId, boolean isRightsOnTopicsUsed) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.getPublications()", (String)"root.MSG_GEN_ENTER_METHOD");
        ArrayList<ForeignPK> allowedPublicationIds = new ArrayList<ForeignPK>(links);
        if (isRightsOnTopicsUsed) {
            KmeliaSecurity security = new KmeliaSecurity();
            allowedPublicationIds.clear();
            for (ForeignPK link : links) {
                if (!security.isObjectAvailable(link.getInstanceId(), userId, link.getId(), "Publication")) continue;
                allowedPublicationIds.add(link);
            }
        }
        Collection<PublicationDetail> publications = this.getPublicationDetails(allowedPublicationIds);
        return this.pubDetails2userPubs(publications);
    }

    @Override
    public List<KmeliaPublication> getLinkedPublications(KmeliaPublication publication, String userId) {
        KmeliaSecurity security = new KmeliaSecurity();
        List allLinkIds = publication.getCompleteDetail().getLinkList();
        ArrayList<KmeliaPublication> authorizedLinks = new ArrayList<KmeliaPublication>(allLinkIds.size());
        for (ForeignPK linkId : allLinkIds) {
            if (!security.isAccessAuthorized(linkId.getInstanceId(), userId, linkId.getId())) continue;
            PublicationPK pubPk = new PublicationPK(linkId.getId(), linkId.getInstanceId());
            authorizedLinks.add(KmeliaPublication.aKmeliaPublicationWithPk(pubPk));
        }
        return authorizedLinks;
    }

    @Override
    public List<KmeliaPublication> getLinkedPublications(KmeliaPublication publication) {
        List allLinkIds = publication.getCompleteDetail().getLinkList();
        ArrayList<KmeliaPublication> linkedPublications = new ArrayList<KmeliaPublication>(allLinkIds.size());
        for (ForeignPK linkId : allLinkIds) {
            PublicationPK pubPk = new PublicationPK(linkId.getId(), linkId.getInstanceId());
            linkedPublications.add(KmeliaPublication.aKmeliaPublicationWithPk(pubPk));
        }
        return linkedPublications;
    }

    @Override
    public List<KmeliaPublication> getPublicationsToValidate(String componentId, String userId) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.getPublicationsToValidate()", (String)"root.MSG_GEN_ENTER_METHOD");
        ArrayList<PublicationDetail> publications = new ArrayList<PublicationDetail>();
        PublicationPK pubPK = new PublicationPK("useless", componentId);
        try {
            Collection temp = this.publicationBm.getPublicationsByStatus("ToValidate", pubPK);
            for (PublicationDetail publi : temp) {
                boolean isClone;
                boolean bl = isClone = publi.isValidationRequired() && !"-1".equals(publi.getCloneId());
                if (isClone) {
                    if (!this.isUserCanValidatePublication(publi.getPK(), userId)) continue;
                    try {
                        PublicationDetail original = this.getPublicationDetail(new PublicationPK(publi.getCloneId(), (WAPrimaryKey)publi.getPK()));
                        publications.add(original);
                    }
                    catch (Exception e) {
                        SilverTrace.warn((String)"kmelia", (String)"KmeliaBmEJB.getPublicationsToValidate()", (String)"kmelia.ORIGINAL_PUBLICATION_OF_CLONE_NOT_FOUND", (String)("cloneId = " + publi.getId() + ", originalId=" + publi.getCloneId()));
                    }
                    continue;
                }
                if (!this.isUserCanValidatePublication(publi.getPK(), userId)) continue;
                publications.add(publi);
            }
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.getPublicationsToValidate()", 4, "kmelia.EX_IMPOSSIBLE_DOBTENIR_LES_PUBLICATIONS_A_VALIDER", e);
        }
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.getPublicationsToValidate()", (String)"root.MSG_GEN_EXIT_METHOD");
        return this.pubDetails2userPubs(publications);
    }

    private void sendValidationNotification(NodePK fatherPK, PublicationDetail pubDetail, String refusalMotive, String userIdWhoRefuse) {
        try {
            UserNotificationHelper.buildAndSend((UserNotificationBuilder)new KmeliaValidationPublicationUserNotification(fatherPK, pubDetail, refusalMotive, userIdWhoRefuse));
        }
        catch (Exception e) {
            SilverTrace.warn((String)"kmelia", (String)"KmeliaBmEJB.sendValidationNotification()", (String)"kmelia.EX_IMPOSSIBLE_DALERTER_LES_UTILISATEURS", (String)("fatherId = " + fatherPK.getId() + ", pubPK = " + pubDetail.getPK()), (Throwable)e);
        }
    }

    private void sendAlertToSupervisors(NodePK fatherPK, PublicationDetail pubDetail) {
        if (pubDetail.isValid()) {
            try {
                UserNotificationHelper.buildAndSend((UserNotificationBuilder)new KmeliaSupervisorPublicationUserNotification(fatherPK, pubDetail));
            }
            catch (Exception e) {
                SilverTrace.warn((String)"kmelia", (String)"KmeliaBmEJB.alertSupervisors()", (String)"kmelia.EX_IMPOSSIBLE_DALERTER_LES_UTILISATEURS", (String)("fatherId = " + fatherPK.getId() + ", pubPK = " + pubDetail.getPK()), (Throwable)e);
            }
        }
    }

    private void sendNoMoreValidatorNotification(NodePK fatherPK, PublicationDetail pubDetail) {
        if (pubDetail.isValidationRequired() || pubDetail.isValid()) {
            try {
                UserNotificationHelper.buildAndSend((UserNotificationBuilder)new KmeliaNoMoreValidatorPublicationUserNotification(fatherPK, pubDetail));
            }
            catch (Exception e) {
                SilverTrace.warn((String)"kmelia", (String)"KmeliaBmEJB.sendNoMoreValidatorNotification()", (String)"kmelia.EX_IMPOSSIBLE_DALERTER_LES_UTILISATEURS", (String)("fatherId = " + fatherPK.getId() + ", pubPK = " + pubDetail.getPK()), (Throwable)e);
            }
        }
    }

    private int getValidationType(String instanceId) {
        String sParam = OrganisationControllerFactory.getOrganisationController().getComponentParameterValue(instanceId, "targetValidation");
        if (StringUtil.isDefined((String)sParam)) {
            return Integer.parseInt(sParam);
        }
        return 0;
    }

    private boolean isTargetedValidationEnabled(String componentId) {
        int value = this.getValidationType(componentId);
        return value == 2 || value == 1;
    }

    private List<String> getValidatorIds(PublicationDetail publi) {
        ArrayList<String> allValidators = new ArrayList<String>();
        if (StringUtil.isDefined((String)publi.getTargetValidatorId())) {
            StringTokenizer tokenizer = new StringTokenizer(publi.getTargetValidatorId(), ",");
            while (tokenizer.hasMoreTokens()) {
                allValidators.add(tokenizer.nextToken());
            }
        }
        return allValidators;
    }

    @Override
    public List<String> getAllValidators(PublicationPK pubPK) {
        SilverTrace.debug((String)"kmelia", (String)"KmeliaBmEJB.getAllValidators", (String)"root.MSG_GEN_ENTER_METHOD", (String)("pubId = " + pubPK.getId()));
        List<Object> allValidators = new ArrayList();
        if (this.isTargetedValidationEnabled(pubPK.getInstanceId())) {
            PublicationDetail publi = this.publicationBm.getDetail(pubPK);
            allValidators = this.getValidatorIds(publi);
        }
        if (allValidators.isEmpty()) {
            ArrayList<String> roles = new ArrayList<String>(2);
            roles.add(SilverpeasRole.admin.name());
            roles.add(SilverpeasRole.publisher.name());
            if (KmeliaHelper.isKmax(pubPK.getInstanceId())) {
                allValidators.addAll(Arrays.asList(OrganisationControllerFactory.getOrganisationController().getUsersIdsByRoleNames(pubPK.getInstanceId(), roles)));
            } else {
                List nodePKs = (List)this.getPublicationFathers(pubPK);
                boolean oneNodeIsPublic = false;
                for (int n = 0; !oneNodeIsPublic && nodePKs != null && n < nodePKs.size(); ++n) {
                    NodePK nodePK = (NodePK)nodePKs.get(n);
                    NodeDetail node = this.getNodeHeader(nodePK);
                    if (node == null) continue;
                    SilverTrace.debug((String)"kmelia", (String)"KmeliaBmEJB.getAllValidators", (String)"root.MSG_GEN_PARAM_VALUE", (String)("nodePK = " + nodePK.toString()));
                    if (!node.haveRights()) {
                        allValidators.addAll(Arrays.asList(OrganisationControllerFactory.getOrganisationController().getUsersIdsByRoleNames(pubPK.getInstanceId(), roles)));
                        oneNodeIsPublic = true;
                        continue;
                    }
                    allValidators.addAll(Arrays.asList(OrganisationControllerFactory.getOrganisationController().getUsersIdsByRoleNames(pubPK.getInstanceId(), Integer.toString(node.getRightsDependsOn()), ObjectType.NODE, roles)));
                }
            }
        }
        SilverTrace.debug((String)"kmelia", (String)"KmeliaBmEJB.getAllValidators", (String)"root.MSG_GEN_EXIT_METHOD", (String)("pubId = " + pubPK.getId() + ", allValidators = " + allValidators.toString()));
        return allValidators;
    }

    @Override
    public void setValidators(PublicationPK pubPK, String userIds) {
        PublicationDetail publication = this.getPublicationDetail(pubPK);
        Object[] validatorIds = StringUtil.split((String)userIds, (char)',');
        if (!ArrayUtil.isEmpty((Object[])validatorIds)) {
            publication.setTargetValidatorId(userIds);
            publication.setStatusMustBeChecked(false);
            publication.setIndexOperation(-1);
            this.publicationBm.setDetail(publication);
            if (publication.isValidationRequired()) {
                this.sendValidationAlert(publication, (String[])validatorIds);
            }
        }
    }

    private boolean isValidationComplete(PublicationPK pubPK, List<String> allValidators) {
        List steps = this.publicationBm.getValidationSteps(pubPK);
        ArrayList<String> stepUserIds = new ArrayList<String>();
        for (ValidationStep step : steps) {
            stepUserIds.add(step.getUserId());
        }
        boolean validationOK = true;
        for (int i = 0; validationOK && i < allValidators.size(); ++i) {
            String validatorId = allValidators.get(i);
            validationOK = stepUserIds.contains(validatorId);
        }
        return validationOK;
    }

    @Override
    public boolean validatePublication(PublicationPK pubPK, String userId, boolean force, boolean hasUserNoMoreValidationRight) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.validatePublication()", (String)"root.MSG_GEN_ENTER_METHOD");
        boolean validationComplete = false;
        try {
            int validationType;
            PublicationDetail currentPubDetail;
            CompletePublication currentPub = this.publicationBm.getCompletePublication(pubPK);
            PublicationDetail currentPubOrCloneDetail = currentPubDetail = currentPub.getPublicationDetail();
            boolean validationOnClone = currentPubDetail.haveGotClone();
            PublicationPK validatedPK = pubPK;
            if (validationOnClone) {
                validatedPK = currentPubDetail.getClonePK();
                currentPubOrCloneDetail = this.getPublicationDetail(validatedPK);
            }
            if (!hasUserNoMoreValidationRight && !this.isUserCanValidatePublication(validatedPK, userId)) {
                SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.validatePublication()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("user " + userId + " is not allowed to validate publication " + pubPK.toString()));
                return false;
            }
            String validatorUserId = userId;
            Date validationDate = new Date();
            if (force) {
                validationComplete = true;
            } else if (!hasUserNoMoreValidationRight) {
                validationType = this.getValidationType(pubPK.getInstanceId());
                if (validationType == 0 || validationType == 1) {
                    validationComplete = true;
                } else {
                    PublicationDetail publi;
                    if (validationType == 2 && !StringUtil.isDefined((String)(publi = this.publicationBm.getDetail(validatedPK)).getTargetValidatorId())) {
                        validationComplete = true;
                    }
                    if (!validationComplete) {
                        List<String> allValidators = this.getAllValidators(validatedPK);
                        if (allValidators.size() == 1) {
                            validationComplete = true;
                        } else if (allValidators.size() > 1) {
                            this.removeTodoForPublication(validatedPK, userId);
                            if (validationOnClone) {
                                this.removeTodoForPublication(pubPK, userId);
                            }
                            ValidationStep validation = new ValidationStep(validatedPK, userId, "Valid");
                            this.publicationBm.addValidationStep(validation);
                            validationComplete = this.isValidationComplete(validatedPK, allValidators);
                        }
                    }
                }
            } else {
                Collection<NodePK> fatherPks;
                validationType = this.getValidationType(pubPK.getInstanceId());
                boolean alertPublicationOwnerThereIsNoMoreValidator = false;
                switch (validationType) {
                    case 0: 
                    case 1: {
                        alertPublicationOwnerThereIsNoMoreValidator = true;
                        break;
                    }
                    default: {
                        List<String> allValidators = this.getAllValidators(validatedPK);
                        if (allValidators.isEmpty()) {
                            alertPublicationOwnerThereIsNoMoreValidator = true;
                            break;
                        }
                        validationComplete = this.isValidationComplete(validatedPK, allValidators);
                        if (validationComplete) {
                            validationDate = new Date(0L);
                            for (ValidationStep validationStep : this.publicationBm.getValidationSteps(validatedPK)) {
                                String validationStepUserId = validationStep.getUserId();
                                if (validationStepUserId.equals(userId) || validationStep.getValidationDate().compareTo(validationDate) <= 0) continue;
                                validationDate = validationStep.getValidationDate();
                                validatorUserId = validationStepUserId;
                            }
                            break;
                        }
                        if (validationType != 2 || !StringUtil.isNotDefined((String)currentPubOrCloneDetail.getTargetValidatorId())) break;
                        alertPublicationOwnerThereIsNoMoreValidator = true;
                    }
                }
                if (alertPublicationOwnerThereIsNoMoreValidator && !(fatherPks = this.getPublicationFathers(currentPubDetail.getPK())).isEmpty()) {
                    this.sendNoMoreValidatorNotification(fatherPks.iterator().next(), currentPubDetail);
                }
            }
            if (validationComplete) {
                this.removeAllTodosForPublication(validatedPK);
                if (validationOnClone) {
                    this.removeAllTodosForPublication(pubPK);
                }
                if (currentPubDetail.haveGotClone()) {
                    currentPubDetail = this.mergeClone(currentPub, validatorUserId, validationDate);
                } else if (currentPubDetail.isValidationRequired()) {
                    currentPubDetail.setValidatorId(validatorUserId);
                    currentPubDetail.setValidateDate(validationDate);
                    currentPubDetail.setStatus("Valid");
                }
                KmeliaHelper.checkIndex(currentPubDetail);
                this.publicationBm.setDetail(currentPubDetail);
                this.updateSilverContentVisibility(currentPubDetail);
                this.indexExternalElementsOfPublication(currentPubDetail);
                NodePK oneFather = this.sendSubscriptionsNotification(currentPubDetail, NotifAction.PUBLISHED, false);
                this.sendValidationNotification(oneFather, currentPubDetail, null, validatorUserId);
                this.sendAlertToSupervisors(oneFather, currentPubDetail);
            }
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.validatePublication()", 4, "kmelia.EX_IMPOSSIBLE_DE_VALIDER_LA_PUBLICATION", e);
        }
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.validatePublication()", (String)"root.MSG_GEN_EXIT_METHOD", (String)("validationComplete = " + validationComplete));
        return validationComplete;
    }

    private PublicationDetail getClone(PublicationDetail refPub) {
        PublicationDetail clone = new PublicationDetail();
        if (refPub.getAuthor() != null) {
            clone.setAuthor(refPub.getAuthor());
        }
        if (refPub.getBeginDate() != null) {
            clone.setBeginDate(new Date(refPub.getBeginDate().getTime()));
        }
        if (refPub.getBeginHour() != null) {
            clone.setBeginHour(refPub.getBeginHour());
        }
        if (refPub.getContent() != null) {
            clone.setContent(refPub.getContent());
        }
        clone.setCreationDate(new Date(refPub.getCreationDate().getTime()));
        clone.setCreatorId(refPub.getCreatorId());
        if (refPub.getDescription() != null) {
            clone.setDescription(refPub.getDescription());
        }
        if (refPub.getEndDate() != null) {
            clone.setEndDate(new Date(refPub.getEndDate().getTime()));
        }
        if (refPub.getEndHour() != null) {
            clone.setEndHour(refPub.getEndHour());
        }
        clone.setImportance(refPub.getImportance());
        if (refPub.getInfoId() != null) {
            clone.setInfoId(refPub.getInfoId());
        }
        if (refPub.getKeywords() != null) {
            clone.setKeywords(refPub.getKeywords());
        }
        if (refPub.getName() != null) {
            clone.setName(refPub.getName());
        }
        clone.setPk(new PublicationPK(refPub.getPK().getId(), refPub.getPK().getInstanceId()));
        if (refPub.getStatus() != null) {
            clone.setStatus(refPub.getStatus());
        }
        if (refPub.getTargetValidatorId() != null) {
            clone.setTargetValidatorId(refPub.getTargetValidatorId());
        }
        if (refPub.getCloneId() != null) {
            clone.setCloneId(refPub.getCloneId());
        }
        if (refPub.getUpdateDate() != null) {
            clone.setUpdateDate(new Date(refPub.getUpdateDate().getTime()));
        }
        if (refPub.getUpdaterId() != null) {
            clone.setUpdaterId(refPub.getUpdaterId());
        }
        if (refPub.getValidateDate() != null) {
            clone.setValidateDate(new Date(refPub.getValidateDate().getTime()));
        }
        if (refPub.getValidatorId() != null) {
            clone.setValidatorId(refPub.getValidatorId());
        }
        if (refPub.getVersion() != null) {
            clone.setVersion(refPub.getVersion());
        }
        return clone;
    }

    private PublicationDetail mergeClone(CompletePublication currentPub, String validatorUserId, Date validationDate) throws FormException, PublicationTemplateException, AttachmentException {
        PublicationDetail currentPubDetail = currentPub.getPublicationDetail();
        String memInfoId = currentPubDetail.getInfoId();
        PublicationPK pubPK = currentPubDetail.getPK();
        String cloneId = currentPubDetail.getCloneId();
        if (!"-1".equals(cloneId)) {
            boolean cloneWysiwyg;
            PublicationPK tempPK = new PublicationPK(cloneId, (WAPrimaryKey)pubPK);
            CompletePublication tempPubli = this.publicationBm.getCompletePublication(tempPK);
            PublicationDetail tempPubliDetail = tempPubli.getPublicationDetail();
            currentPubDetail = this.getClone(tempPubliDetail);
            currentPubDetail.setPk(pubPK);
            if (validatorUserId != null) {
                currentPubDetail.setValidatorId(validatorUserId);
                currentPubDetail.setValidateDate(validationDate != null ? validationDate : new Date());
            }
            currentPubDetail.setStatus("Valid");
            currentPubDetail.setCloneId("-1");
            currentPubDetail.setCloneStatus(null);
            ForeignPK pkFrom = new ForeignPK(pubPK.getId(), pubPK.getInstanceId());
            ForeignPK pkTo = new ForeignPK(cloneId, tempPK.getInstanceId());
            Map attachmentIds = AttachmentServiceFactory.getAttachmentService().mergeDocuments(pkFrom, pkTo, DocumentType.attachment);
            String infoId = tempPubli.getPublicationDetail().getInfoId();
            if (infoId != null && !"0".equals(infoId) && !StringUtil.isInteger((String)infoId)) {
                String xmlFormShortName = infoId;
                PublicationTemplateManager publicationTemplateManager = PublicationTemplateManager.getInstance();
                PublicationTemplate pubTemplate = publicationTemplateManager.getPublicationTemplate(tempPK.getInstanceId() + ":" + xmlFormShortName);
                RecordSet set = pubTemplate.getRecordSet();
                if (memInfoId != null && !"0".equals(memInfoId)) {
                    set.merge(cloneId, pubPK.getInstanceId(), pubPK.getId(), pubPK.getInstanceId(), attachmentIds);
                } else {
                    publicationTemplateManager.addDynamicPublicationTemplate(tempPK.getInstanceId() + ":" + xmlFormShortName, xmlFormShortName + ".xml");
                    set.clone(cloneId, pubPK.getInstanceId(), pubPK.getId(), pubPK.getInstanceId(), attachmentIds);
                }
            }
            if (cloneWysiwyg = WysiwygController.haveGotWysiwyg((String)tempPK.getInstanceId(), (String)cloneId, (String)tempPubli.getPublicationDetail().getLanguage())) {
                try {
                    WysiwygController.deleteWysiwygAttachmentsOnly((String)pubPK.getInstanceId(), (String)pubPK.getId());
                }
                catch (WysiwygException e) {
                    Logger.getLogger(this.getClass().getSimpleName()).log(Level.SEVERE, e.getMessage(), e);
                }
                WysiwygController.copy((String)tempPK.getInstanceId(), (String)cloneId, (String)pubPK.getInstanceId(), (String)pubPK.getId(), (String)tempPubli.getPublicationDetail().getUpdaterId());
            }
            this.deletePublication(tempPK);
        }
        return currentPubDetail;
    }

    @Override
    public void unvalidatePublication(PublicationPK pubPK, String userId, String refusalMotive, int validationType) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.unvalidatePublication()", (String)"root.MSG_GEN_ENTER_METHOD");
        try {
            switch (validationType) {
                case 2: 
                case 3: {
                    this.publicationBm.removeValidationSteps(pubPK);
                    break;
                }
            }
            PublicationDetail currentPubDetail = this.publicationBm.getDetail(pubPK);
            if (currentPubDetail.haveGotClone()) {
                String cloneId = currentPubDetail.getCloneId();
                PublicationPK tempPK = new PublicationPK(cloneId, (WAPrimaryKey)pubPK);
                PublicationDetail clone = this.publicationBm.getDetail(tempPK);
                clone.setStatus("UnValidate");
                clone.setIndexOperation(-1);
                this.publicationBm.setDetail(clone);
                currentPubDetail.setCloneStatus("Unvalidate");
                currentPubDetail.setUpdateDateMustBeSet(false);
                this.publicationBm.setDetail(currentPubDetail);
                List fathers = (List)this.getPublicationFathers(pubPK);
                NodePK oneFather = null;
                if (fathers != null && fathers.size() > 0) {
                    oneFather = (NodePK)fathers.get(0);
                }
                this.sendValidationNotification(oneFather, clone, refusalMotive, userId);
                this.removeAllTodosForPublication(clone.getPK());
            } else {
                currentPubDetail.setStatus("UnValidate");
                KmeliaHelper.checkIndex(currentPubDetail);
                this.publicationBm.setDetail(currentPubDetail);
                this.updateSilverContentVisibility(currentPubDetail);
                List fathers = (List)this.getPublicationFathers(pubPK);
                NodePK oneFather = null;
                if (fathers != null && !fathers.isEmpty()) {
                    oneFather = (NodePK)fathers.get(0);
                }
                this.sendValidationNotification(oneFather, currentPubDetail, refusalMotive, userId);
                this.removeAllTodosForPublication(currentPubDetail.getPK());
            }
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.unvalidatePublication()", 4, "kmelia.EX_IMPOSSIBLE_DE_REFUSER_LA_PUBLICATION", e);
        }
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.unvalidatePublication()", (String)"root.MSG_GEN_EXIT_METHOD");
    }

    @Override
    public void suspendPublication(PublicationPK pubPK, String defermentMotive, String userId) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.suspendPublication()", (String)"root.MSG_GEN_ENTER_METHOD");
        try {
            PublicationDetail currentPubDetail = this.publicationBm.getDetail(pubPK);
            currentPubDetail.setStatus("ToValidate");
            KmeliaHelper.checkIndex(currentPubDetail);
            this.publicationBm.setDetail(currentPubDetail);
            this.updateSilverContentVisibility(currentPubDetail);
            this.unIndexExternalElementsOfPublication(currentPubDetail.getPK());
            this.sendDefermentNotification(currentPubDetail, defermentMotive, userId);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.unvalidatePublication()", 4, "kmelia.EX_IMPOSSIBLE_DE_REFUSER_LA_PUBLICATION", e);
        }
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.suspendPublication()", (String)"root.MSG_GEN_EXIT_METHOD");
    }

    private void sendDefermentNotification(PublicationDetail pubDetail, String defermentMotive, String senderId) {
        try {
            UserNotificationHelper.buildAndSend((UserNotificationBuilder)new KmeliaDefermentPublicationUserNotification(pubDetail, defermentMotive));
        }
        catch (Exception e) {
            SilverTrace.warn((String)"kmelia", (String)"KmeliaBmEJB.sendDefermentNotification()", (String)"kmelia.EX_IMPOSSIBLE_DALERTER_LES_UTILISATEURS", (String)("pubPK = " + pubDetail.getPK()), (Throwable)e);
        }
    }

    @Override
    public void draftOutPublication(PublicationPK pubPK, NodePK topicPK, String userProfile) {
        PublicationDetail pubDetail = this.draftOutPublicationWithoutNotifications(pubPK, topicPK, userProfile);
        this.indexExternalElementsOfPublication(pubDetail);
        this.sendTodosAndNotificationsOnDraftOut(pubDetail, topicPK, userProfile);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public PublicationDetail draftOutPublicationWithoutNotifications(PublicationPK pubPK, NodePK topicPK, String userProfile) {
        return this.draftOutPublication(pubPK, topicPK, userProfile, false, true);
    }

    @Override
    public PublicationDetail draftOutPublication(PublicationPK pubPK, NodePK topicPK, String userProfile, boolean forceUpdateDate) {
        return this.draftOutPublication(pubPK, topicPK, userProfile, forceUpdateDate, false);
    }

    private PublicationDetail draftOutPublication(PublicationPK pubPK, NodePK topicPK, String userProfile, boolean forceUpdateDate, boolean inTransaction) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.draftOutPublication()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("pubId = " + pubPK.getId()));
        try {
            PublicationDetail changedPublication = null;
            CompletePublication currentPub = this.publicationBm.getCompletePublication(pubPK);
            PublicationDetail pubDetail = currentPub.getPublicationDetail();
            SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.draftOutPublication()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("actual status = " + pubDetail.getStatus()));
            if (userProfile.equals("publisher") || userProfile.equals("admin")) {
                if (pubDetail.haveGotClone()) {
                    pubDetail = this.mergeClone(currentPub, null, null);
                }
                pubDetail.setStatus("Valid");
                changedPublication = pubDetail;
            } else if (pubDetail.haveGotClone()) {
                PublicationDetail clone = this.publicationBm.getDetail(pubDetail.getClonePK());
                clone.setStatus("ToValidate");
                clone.setIndexOperation(-1);
                clone.setUpdateDateMustBeSet(false);
                this.publicationBm.setDetail(clone);
                changedPublication = clone;
                pubDetail.setCloneStatus("ToValidate");
            } else {
                pubDetail.setStatus("ToValidate");
                changedPublication = pubDetail;
            }
            KmeliaHelper.checkIndex(pubDetail);
            this.publicationBm.setDetail(pubDetail, forceUpdateDate);
            if (!KmeliaHelper.isKmax(pubDetail.getInstanceId())) {
                this.updateSilverContentVisibility(pubDetail);
            }
            SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.draftOutPublication()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("new status = " + pubDetail.getStatus()));
            if (!inTransaction) {
                this.indexExternalElementsOfPublication(changedPublication);
                this.sendTodosAndNotificationsOnDraftOut(changedPublication, topicPK, userProfile);
            }
            return changedPublication;
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.draftOutPublication()", 4, "kmelia.EX_IMPOSSIBLE_DE_MODIFIER_LA_PUBLICATION", e);
        }
    }

    private void sendTodosAndNotificationsOnDraftOut(PublicationDetail pubDetail, NodePK topicPK, String userProfile) {
        if (SilverpeasRole.writer.isInRole(new String[]{userProfile})) {
            this.createTodosForPublication(pubDetail, true);
        }
        if (!KmeliaHelper.isKmax(pubDetail.getInstanceId())) {
            this.sendSubscriptionsNotification(pubDetail, NotifAction.PUBLISHED, false);
            if (topicPK != null) {
                this.sendAlertToSupervisors(topicPK, pubDetail);
            }
        }
    }

    @Override
    public void draftInPublication(PublicationPK pubPK) {
        this.draftInPublication(pubPK, null);
    }

    @Override
    public void draftInPublication(PublicationPK pubPK, String userId) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.draftInPublication()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("pubPK = " + pubPK.toString()));
        try {
            PublicationDetail pubDetail = this.publicationBm.getDetail(pubPK);
            SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.draftInPublication()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("actual status = " + pubDetail.getStatus()));
            if (pubDetail.isRefused() || pubDetail.isValid()) {
                pubDetail.setStatus("Draft");
                pubDetail.setUpdaterId(userId);
                KmeliaHelper.checkIndex(pubDetail);
                this.publicationBm.setDetail(pubDetail);
                this.updateSilverContentVisibility(pubDetail);
                this.unIndexExternalElementsOfPublication(pubDetail.getPK());
                this.removeAllTodosForPublication(pubPK);
                boolean isNewsManage = StringUtil.getBooleanValue((String)OrganisationControllerFactory.getOrganisationController().getComponentParameterValue(pubDetail.getPK().getInstanceId(), "isNewsManage"));
                if (isNewsManage) {
                    CallBackManager callBackManager = CallBackManager.get();
                    callBackManager.invoke(22, Integer.parseInt(pubDetail.getId()), pubDetail.getInstanceId(), (Object)pubDetail);
                }
            }
            SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.draftInPublication()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("new status = " + pubDetail.getStatus()));
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.draftInPublication()", 4, "kmelia.EX_IMPOSSIBLE_DE_MODIFIER_LA_PUBLICATION", e);
        }
    }

    @Override
    public NotificationMetaData getAlertNotificationMetaData(PublicationPK pubPK, NodePK topicPK, String senderName) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.getAlertNotificationMetaData()", (String)"root.MSG_GEN_ENTER_METHOD");
        PublicationDetail pubDetail = this.getPublicationDetail(pubPK);
        pubDetail.setAlias(this.isAlias(pubDetail, topicPK));
        NotificationMetaData notifMetaData = UserNotificationHelper.build((UserNotificationBuilder)new KmeliaNotifyPublicationUserNotification(topicPK, pubDetail, senderName));
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.getAlertNotificationMetaData()", (String)"root.MSG_GEN_EXIT_METHOD");
        return notifMetaData;
    }

    public boolean isAlias(PublicationDetail pubDetail, NodePK nodePK) {
        boolean result = false;
        Collection<Alias> aliases = this.getAlias(pubDetail.getPK());
        for (Alias alias : aliases) {
            if (alias.getInstanceId().equals(pubDetail.getInstanceId()) || !nodePK.equals((Object)alias)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public NotificationMetaData getAlertNotificationMetaData(PublicationPK pubPK, SimpleDocumentPK documentPk, NodePK topicPK, String senderName) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.getAlertNotificationMetaData(document)", (String)"root.MSG_GEN_ENTER_METHOD");
        PublicationDetail pubDetail = this.getPublicationDetail(pubPK);
        SimpleDocument document = AttachmentServiceFactory.getAttachmentService().searchDocumentById(documentPk, null);
        SimpleDocument version = document.getLastPublicVersion();
        if (version == null) {
            version = document.getVersionMaster();
        }
        NotificationMetaData notifMetaData = UserNotificationHelper.build((UserNotificationBuilder)new KmeliaDocumentSubscriptionPublicationUserNotification(topicPK, pubDetail, version, senderName));
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.getAlertNotificationMetaData(document)", (String)"root.MSG_GEN_EXIT_METHOD");
        return notifMetaData;
    }

    @Override
    public void deleteAllReadingControlsByPublication(PublicationPK pubPK) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.deleteAllReadingControlsByPublication()", (String)"root.MSG_GEN_ENTER_METHOD");
        try {
            this.statisticBm.deleteStats(new ForeignPK(pubPK.getId(), pubPK.getInstanceId()), "Publication");
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.deleteAllReadingControlsByPublication()", 4, "kmelia.EX_IMPOSSIBLE_DE_SUPPRIMER_LES_CONTROLES_DE_LECTURE", e);
        }
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.deleteAllReadingControlsByPublication()", (String)"root.MSG_GEN_EXIT_METHOD");
    }

    @Override
    public List<HistoryObjectDetail> getLastAccess(PublicationPK pk, NodePK nodePK, String excludedUserId) {
        Collection allAccess = this.statisticBm.getHistoryByAction(new ForeignPK((WAPrimaryKey)pk), 1, "Publication");
        List<String> userIds = this.getUserIdsOfFolder(nodePK);
        ArrayList<String> readerIds = new ArrayList<String>();
        ArrayList<HistoryObjectDetail> lastAccess = new ArrayList<HistoryObjectDetail>();
        for (HistoryObjectDetail access : allAccess) {
            String readerId = access.getUserId();
            if (StringUtil.isDefined((String)excludedUserId) && excludedUserId.equals(readerId) || userIds != null && !userIds.contains(readerId) || readerIds.contains(readerId)) continue;
            readerIds.add(readerId);
            if (UserDetail.getById((String)readerId).isAnonymous()) continue;
            lastAccess.add(access);
        }
        return lastAccess;
    }

    @Override
    public List<String> getUserIdsOfFolder(NodePK pk) {
        if (!this.isRightsOnTopicsEnabled(pk.getInstanceId())) {
            return null;
        }
        NodeDetail node = this.getNodeHeader(pk);
        if (node != null && node.haveRights()) {
            int rightsDependsOn = node.getRightsDependsOn();
            ArrayList<String> profileNames = new ArrayList<String>(4);
            profileNames.add("admin");
            profileNames.add("publisher");
            profileNames.add("writer");
            profileNames.add("user");
            String[] userIds = OrganisationControllerFactory.getOrganisationController().getUsersIdsByRoleNames(pk.getInstanceId(), Integer.toString(rightsDependsOn), ObjectType.NODE, profileNames);
            return Arrays.asList(userIds);
        }
        return null;
    }

    @Override
    public void indexKmelia(String componentId) {
        this.indexTopics(new NodePK("useless", componentId));
        this.indexPublications(new PublicationPK("useless", componentId));
    }

    private void indexPublications(PublicationPK pubPK) {
        Collection pubs = null;
        try {
            pubs = this.publicationBm.getAllPublications(pubPK);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.indexPublications()", 4, "kmelia.EX_IMPOSSIBLE_DINDEXER_LES_PUBLICATIONS", e);
        }
        if (pubs != null) {
            for (PublicationDetail pub : pubs) {
                try {
                    NodePK nodePK;
                    pubPK = pub.getPK();
                    if (pub.getStatus() == null || !pub.isValid()) continue;
                    List pubFathers = (List)this.publicationBm.getAllFatherPK(pubPK);
                    if (pubFathers.size() >= 2) {
                        this.indexPublication(pub);
                        continue;
                    }
                    if (pubFathers.size() != 1 || (nodePK = (NodePK)pubFathers.get(0)).isTrash()) continue;
                    this.indexPublication(pub);
                }
                catch (Exception e) {
                    throw new KmeliaRuntimeException("KmeliaBmEJB.indexPublications()", 4, "kmelia.EX_IMPOSSIBLE_DINDEXER_LA_PUBLICATION", "pubPK = " + pubPK.toString(), e);
                }
            }
        }
    }

    private void indexPublication(PublicationDetail pub) {
        this.publicationBm.createIndex(pub.getPK());
        this.indexExternalElementsOfPublication(pub);
    }

    private void indexTopics(NodePK nodePK) {
        try {
            Collection nodes = this.nodeBm.getAllNodes(nodePK);
            if (nodes != null) {
                for (NodeDetail node : nodes) {
                    if (node.getNodePK().isRoot() || node.getNodePK().isTrash() || node.getNodePK().getId().equals("2")) continue;
                    this.nodeBm.createIndex(node);
                }
            }
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.indexTopics()", 4, "kmelia.EX_IMPOSSIBLE_DINDEXER_LES_THEMES", e);
        }
    }

    private void createTodosForPublication(PublicationDetail pubDetail, boolean creation) {
        if (!creation) {
            this.removeAllTodosForPublication(pubDetail.getPK());
        }
        if (pubDetail.isValidationRequired() || "ToValidate".equalsIgnoreCase(pubDetail.getCloneStatus())) {
            int validationType = this.getValidationType(pubDetail.getPK().getInstanceId());
            if (validationType == 2 || validationType == 3) {
                this.publicationBm.removeValidationSteps(pubDetail.getPK());
            }
            List<String> validators = this.getAllValidators(pubDetail.getPK());
            this.addTodoAndSendNotificationToValidators(pubDetail, validators);
        }
    }

    private void addTodoAndSendNotificationToValidators(PublicationDetail pub, List<String> validators) {
        if (validators != null && !validators.isEmpty()) {
            String[] users = validators.toArray(new String[validators.size()]);
            this.addTodo(pub, users);
            this.sendValidationAlert(pub, users);
        }
    }

    private String addTodo(PublicationDetail pubDetail, String[] users) {
        ResourceLocator message = new ResourceLocator("com.stratelia.webactiv.kmelia.multilang.kmeliaBundle", "fr");
        TodoDetail todo = new TodoDetail();
        todo.setId(pubDetail.getPK().getId());
        todo.setSpaceId(pubDetail.getPK().getSpace());
        todo.setComponentId(pubDetail.getPK().getComponentName());
        todo.setName(message.getString("ToValidateShort") + " : " + pubDetail.getName());
        ArrayList<Attendee> attendees = new ArrayList<Attendee>();
        for (String user : users) {
            if (user == null) continue;
            attendees.add(new Attendee(user));
        }
        todo.setAttendees(new ArrayList(attendees));
        if (StringUtil.isDefined((String)pubDetail.getUpdaterId())) {
            todo.setDelegatorId(pubDetail.getUpdaterId());
        } else {
            todo.setDelegatorId(pubDetail.getCreatorId());
        }
        todo.setExternalId(pubDetail.getPK().getId());
        TodoBackboneAccess todoBBA = new TodoBackboneAccess();
        return todoBBA.addEntry(todo);
    }

    private void removeAllTodosForPublication(PublicationPK pubPK) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.removeAllTodosForPublication()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("Enter pubPK =" + pubPK.toString()));
        TodoBackboneAccess todoBBA = new TodoBackboneAccess();
        todoBBA.removeEntriesFromExternal("useless", pubPK.getInstanceId(), pubPK.getId());
    }

    private void removeTodoForPublication(PublicationPK pubPK, List<String> userIds) {
        if (userIds != null) {
            for (String userId : userIds) {
                this.removeTodoForPublication(pubPK, userId);
            }
        }
    }

    private void removeTodoForPublication(PublicationPK pubPK, String userId) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.removeTodoForPublication()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("Enter pubPK =" + pubPK.toString()));
        TodoBackboneAccess todoBBA = new TodoBackboneAccess();
        todoBBA.removeAttendeeToEntryFromExternal(pubPK.getInstanceId(), pubPK.getId(), userId);
    }

    private void sendValidationAlert(PublicationDetail pubDetail, String[] users) {
        UserNotificationHelper.buildAndSend((UserNotificationBuilder)new KmeliaPendingValidationPublicationUserNotification(pubDetail, users));
    }

    private void sendModificationAlert(int modificationScope, PublicationDetail pubDetail) {
        UserNotificationHelper.buildAndSend((UserNotificationBuilder)new KmeliaModificationPublicationUserNotification(pubDetail, modificationScope));
    }

    @Override
    public void sendModificationAlert(int modificationScope, PublicationPK pubPK) {
        this.sendModificationAlert(modificationScope, this.getPublicationDetail(pubPK));
    }

    @Override
    public int getSilverObjectId(PublicationPK pubPK) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.getSilverObjectId()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("pubId = " + pubPK.getId()));
        int silverObjectId = -1;
        try {
            silverObjectId = this.getKmeliaContentManager().getSilverObjectId(pubPK.getId(), pubPK.getInstanceId());
            if (silverObjectId == -1) {
                PublicationDetail pubDetail = this.getPublicationDetail(pubPK);
                silverObjectId = this.createSilverContent(pubDetail, pubDetail.getCreatorId());
            }
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.getSilverObjectId()", 4, "kmelia.EX_IMPOSSIBLE_DOBTENIR_LE_SILVEROBJECTID", e);
        }
        return silverObjectId;
    }

    private int createSilverContent(PublicationDetail pubDetail, String creatorId) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.createSilverContent()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("pubId = " + pubDetail.getPK().getId()));
        Connection con = null;
        try {
            con = this.getConnection();
            int n = this.getKmeliaContentManager().createSilverContent(con, pubDetail, creatorId);
            return n;
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.createSilverContent()", 4, "kmelia.EX_IMPOSSIBLE_DOBTENIR_LE_SILVEROBJECTID", e);
        }
        finally {
            this.freeConnection(con);
        }
    }

    @Override
    public void deleteSilverContent(PublicationPK pubPK) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaBmEJB.deleteSilverContent()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("pubId = " + pubPK.getId()));
        Connection con = this.getConnection();
        try {
            this.getKmeliaContentManager().deleteSilverContent(con, pubPK);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.deleteSilverContent()", 4, "kmelia.EX_IMPOSSIBLE_DOBTENIR_LE_SILVEROBJECTID", e);
        }
        finally {
            this.freeConnection(con);
        }
    }

    private void updateSilverContentVisibility(PublicationDetail pubDetail) {
        try {
            this.getKmeliaContentManager().updateSilverContentVisibility(pubDetail);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.updateSilverContentVisibility()", 4, "kmelia.EX_IMPOSSIBLE_DOBTENIR_LE_SILVEROBJECTID", e);
        }
    }

    private void updateSilverContentVisibility(PublicationPK pubPK, boolean isVisible) {
        PublicationDetail pubDetail = this.getPublicationDetail(pubPK);
        try {
            this.getKmeliaContentManager().updateSilverContentVisibility(pubDetail, isVisible);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.updateSilverContentVisibility()", 4, "kmelia.EX_IMPOSSIBLE_DOBTENIR_LE_SILVEROBJECTID", e);
        }
    }

    private KmeliaContentManager getKmeliaContentManager() {
        return new KmeliaContentManager();
    }

    private void indexExternalElementsOfPublication(PublicationDetail pubDetail) {
        if (KmeliaHelper.isIndexable(pubDetail)) {
            try {
                AttachmentServiceFactory.getAttachmentService().indexAllDocuments((WAPrimaryKey)pubDetail.getPK(), pubDetail.getBeginDate(), pubDetail.getEndDate());
            }
            catch (Exception e) {
                SilverTrace.error((String)"kmelia", (String)"KmeliaBmEJB.indexExternalElementsOfPublication", (String)"Indexing versioning documents failed", (String)("pubPK = " + pubDetail.getPK().toString()), (Throwable)e);
            }
            try {
                this.getCommentService().indexAllCommentsOnPublication(pubDetail.getContributionType(), (WAPrimaryKey)pubDetail.getPK());
            }
            catch (Exception e) {
                SilverTrace.error((String)"kmelia", (String)"KmeliaBmEJB.indexExternalElementsOfPublication", (String)"Indexing comments failed", (String)("pubPK = " + pubDetail.getPK().toString()), (Throwable)e);
            }
        }
    }

    private void unIndexExternalElementsOfPublication(PublicationPK pubPK) {
        try {
            AttachmentServiceFactory.getAttachmentService().unindexAttachmentsOfExternalObject((WAPrimaryKey)pubPK);
        }
        catch (Exception e) {
            SilverTrace.error((String)"kmelia", (String)"KmeliaBmEJB.indexExternalElementsOfPublication", (String)"Indexing versioning documents failed", (String)("pubPK = " + pubPK.toString()), (Throwable)e);
        }
        try {
            this.getCommentService().unindexAllCommentsOnPublication(PublicationDetail.getResourceType(), (WAPrimaryKey)pubPK);
        }
        catch (Exception e) {
            SilverTrace.error((String)"kmelia", (String)"KmeliaBmEJB.indexExternalElementsOfPublication", (String)"Indexing comments failed", (String)("pubPK = " + pubPK.toString()), (Throwable)e);
        }
    }

    private void removeExternalElementsOfPublications(PublicationPK pubPK) {
        SimpleDocumentList documents = AttachmentServiceFactory.getAttachmentService().listAllDocumentsByForeignKey((WAPrimaryKey)pubPK, null);
        for (SimpleDocument doc : documents) {
            AttachmentServiceFactory.getAttachmentService().deleteAttachment(doc, false);
        }
        try {
            this.getCommentService().deleteAllCommentsOnPublication(PublicationDetail.getResourceType(), (WAPrimaryKey)pubPK);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.removeExternalElementsOfPublications()", 4, "kmelia.EX_IMPOSSIBLE_DE_SUPPRIMER_LES_COMMENTAIRES", e);
        }
        try {
            ThumbnailDetail thumbToDelete = new ThumbnailDetail(pubPK.getInstanceId(), Integer.parseInt(pubPK.getId()), 1);
            ThumbnailController.deleteThumbnail((ThumbnailDetail)thumbToDelete);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.removeExternalElementsOfPublications", 4, "root.EX_DELETE_THUMBNAIL_FAILED", e);
        }
        PublicationNoteReference publicationNoteReference = new PublicationNoteReference(pubPK.getId());
        this.getDateReminderService().remove((EntityReference)publicationNoteReference);
    }

    @Override
    public void removeContentOfPublication(PublicationPK pubPK) {
        PublicationDetail publication = this.getPublicationDetail(pubPK);
        if (!StringUtil.isInteger((String)publication.getInfoId())) {
            this.removeXMLContentOfPublication(pubPK);
        }
        publication.setInfoId("0");
        this.updatePublication(publication, 1, true);
    }

    private void removeXMLContentOfPublication(PublicationPK pubPK) {
        try {
            PublicationDetail pubDetail = this.getPublicationDetail(pubPK);
            String infoId = pubDetail.getInfoId();
            if (!StringUtil.isInteger((String)infoId)) {
                String xmlFormShortName = infoId;
                PublicationTemplate pubTemplate = PublicationTemplateManager.getInstance().getPublicationTemplate(pubDetail.getPK().getInstanceId() + ":" + xmlFormShortName);
                RecordSet set = pubTemplate.getRecordSet();
                DataRecord data = set.getRecord(pubDetail.getPK().getId());
                set.delete(data);
            }
        }
        catch (PublicationTemplateException e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.removeXMLContentOfPublication()", 4, "kmelia.EX_IMPOSSIBLE_DE_SUPPRIMER_LE_CONTENU_XML", (Exception)((Object)e));
        }
        catch (FormException e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.removeXMLContentOfPublication()", 4, "kmelia.EX_IMPOSSIBLE_DE_SUPPRIMER_LE_CONTENU_XML", (Exception)((Object)e));
        }
    }

    private Connection getConnection() {
        try {
            Connection con = DBUtil.makeConnection((String)JNDINames.SILVERPEAS_DATASOURCE);
            return con;
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.getConnection()", 4, "root.EX_CONNECTION_OPEN_FAILED", e);
        }
    }

    private void freeConnection(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (Exception e) {
                SilverTrace.error((String)"kmelia", (String)"KmeliaBmEJB.freeConnection()", (String)"root.EX_CONNECTION_CLOSE_FAILED", (String)"", (Throwable)e);
            }
        }
    }

    @Override
    public void setModelUsed(String[] models, String instanceId, String nodeId) {
        Connection con = this.getConnection();
        try {
            ModelDAO.deleteModel((Connection)con, (String)instanceId, (String)nodeId);
            if (models != null) {
                for (String modelId : models) {
                    ModelDAO.addModel((Connection)con, (String)instanceId, (String)modelId, (String)nodeId);
                }
            }
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.addModelUsed()", 4, "kmelia.IMPOSSIBLE_D_AJOUTER_LES_MODELES", e);
        }
        finally {
            this.freeConnection(con);
        }
    }

    @Override
    public Collection<String> getModelUsed(String instanceId, String nodeId) {
        Connection con = this.getConnection();
        try {
            Collection result = ModelDAO.getModelUsed((Connection)con, (String)instanceId, (String)nodeId);
            if (StringUtil.isDefined((String)nodeId) && result.isEmpty()) {
                Collection parents = this.nodeBm.getPath(new NodePK(nodeId, instanceId));
                Iterator iter = parents.iterator();
                while (iter.hasNext() && result.isEmpty()) {
                    NodeDetail parent = (NodeDetail)iter.next();
                    result = ModelDAO.getModelUsed((Connection)con, (String)instanceId, (String)parent.getNodePK().getId());
                }
            }
            Collection collection = result;
            return collection;
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.getModelUsed()", 4, "kmelia.IMPOSSIBLE_DE_RECUPERER_LES_MODELES", e);
        }
        finally {
            this.freeConnection(con);
        }
    }

    private void setModelUsed(NodePK from, NodePK to) {
        Connection con = this.getConnection();
        try {
            Collection modelIds = ModelDAO.getModelUsed((Connection)con, (String)from.getInstanceId(), (String)from.getId());
            for (String modelId : modelIds) {
                ModelDAO.addModel((Connection)con, (String)to.getInstanceId(), (String)modelId, (String)to.getId());
            }
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.setModelUsed()", 4, "kmelia.IMPOSSIBLE_DE_RECUPERER_LES_MODELES", e);
        }
        finally {
            this.freeConnection(con);
        }
    }

    @Override
    public List<NodeDetail> getAxis(String componentId) {
        ResourceLocator nodeSettings = new ResourceLocator("com.stratelia.webactiv.util.node.nodeSettings", "");
        String sortField = nodeSettings.getString("sortField", "nodepath");
        String sortOrder = nodeSettings.getString("sortOrder", "asc");
        SilverTrace.info((String)"kmax", (String)"KmeliaBmEjb.getAxis()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("componentId = " + componentId + " sortField=" + sortField + " sortOrder=" + sortOrder));
        ArrayList<NodeDetail> axis = new ArrayList<NodeDetail>();
        try {
            List<NodeDetail> headers = this.getAxisHeaders(componentId);
            for (NodeDetail header : headers) {
                if ("Invisible".equals(header.getStatus())) continue;
                axis.addAll(this.nodeBm.getSubTree(header.getNodePK(), sortField + " " + sortOrder));
            }
        }
        catch (Exception e) {
            throw new KmaxRuntimeException("KmeliaBmEJB.getAxis()", 4, "kmax.EX_IMPOSSIBLE_DOBTENIR_LES_AXES", e);
        }
        return axis;
    }

    @Override
    public List<NodeDetail> getAxisHeaders(String componentId) {
        List axisHeaders = null;
        try {
            axisHeaders = this.nodeBm.getHeadersByLevel(new NodePK("useless", componentId), 2);
        }
        catch (Exception e) {
            throw new KmaxRuntimeException("KmeliaBmEJB.getAxisHeaders()", 4, "kmax.EX_IMPOSSIBLE_DOBTENIR_LES_ENTETES_DES_AXES", e);
        }
        return axisHeaders;
    }

    @Override
    public NodePK addAxis(NodeDetail axis, String componentId) {
        NodePK axisPK = new NodePK("toDefine", componentId);
        NodeDetail rootDetail = new NodeDetail(new NodePK("0"), "Root", "desc", "unknown", "unknown", "/0", 1, new NodePK("-1"), null);
        rootDetail.setStatus("Visible");
        axis.setNodePK(axisPK);
        CoordinatePK coordinatePK = new CoordinatePK("useless", (WAPrimaryKey)axisPK);
        try {
            axisPK = this.nodeBm.createNode(axis, rootDetail);
            CoordinatePoint point = new CoordinatePoint(-1, Integer.parseInt(axisPK.getId()), true);
            this.coordinatesBm.addPointToAllCoordinates(coordinatePK, point);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.addAxis()", 4, "kmax.EX_IMPOSSIBLE_DE_CREER_L_AXE", e);
        }
        return axisPK;
    }

    @Override
    public void updateAxis(NodeDetail axis, String componentId) {
        axis.getNodePK().setComponentName(componentId);
        SilverTrace.info((String)"kmax", (String)"KmeliaBmEjb.updateAxis()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("componentId = " + componentId + " nodePk.getComponentId()=" + axis.getNodePK().getInstanceId()));
        try {
            this.nodeBm.setDetail(axis);
        }
        catch (Exception e) {
            throw new KmaxRuntimeException("KmeliaBmEJB.updateAxis()", 4, "kmax.EX_IMPOSSIBLE_DE_MODIFIER_L_AXE", e);
        }
    }

    @Override
    public void deleteAxis(String axisId, String componentId) {
        NodePK pkToDelete = new NodePK(axisId, componentId);
        PublicationPK pubPK = new PublicationPK("useless");
        CoordinatePK coordinatePK = new CoordinatePK("useless", (WAPrimaryKey)pkToDelete);
        ArrayList<String> fatherIds = new ArrayList<String>();
        try {
            if (this.getAxisHeaders(componentId).size() == 1) {
                Collection coordinateIds = this.coordinatesBm.getCoordinateIdsByNodeId(coordinatePK, axisId);
                for (String coordinateId : coordinateIds) {
                    fatherIds.add(coordinateId);
                }
                if (fatherIds.size() > 0) {
                    this.publicationBm.removeFathers(pubPK, fatherIds);
                }
            }
            List subComponents = this.nodeBm.getDescendantDetails(pkToDelete);
            Iterator it = subComponents.iterator();
            ArrayList<NodePK> points = new ArrayList<NodePK>();
            points.add(pkToDelete);
            while (it.hasNext()) {
                points.add(((NodeDetail)it.next()).getNodePK());
            }
            this.removeCoordinatesByPoints(points, componentId);
            this.nodeBm.removeNode(pkToDelete);
        }
        catch (Exception e) {
            throw new KmaxRuntimeException("KmeliaBmEJB.deleteAxis()", 4, "kmax.EX_IMPOSSIBLE_DE_SUPPRIMER_L_AXE", e);
        }
    }

    private void removeCoordinatesByPoints(List<NodePK> nodePKs, String componentId) {
        Iterator<NodePK> it = nodePKs.iterator();
        ArrayList<String> coordinatePoints = new ArrayList<String>();
        while (it.hasNext()) {
            String nodeId = it.next().getId();
            coordinatePoints.add(nodeId);
        }
        CoordinatePK coordinatePK = new CoordinatePK("useless", "useless", componentId);
        try {
            this.coordinatesBm.deleteCoordinatesByPoints(coordinatePK, coordinatePoints);
        }
        catch (Exception e) {
            throw new KmaxRuntimeException("KmeliaBmEJB.removeCoordinatesByPoints()", 4, "kmax.EX_IMPOSSIBLE_DE_SUPPRIMER_LES_COORDONNEES_PAR_UN_POINT", e);
        }
    }

    @Override
    public NodeDetail getNodeHeader(String id, String componentId) {
        NodePK pk = new NodePK(id, componentId);
        return this.getNodeHeader(pk);
    }

    private NodeDetail getNodeHeader(NodePK pk) {
        NodeDetail nodeDetail = null;
        try {
            nodeDetail = this.nodeBm.getHeader(pk);
        }
        catch (Exception e) {
            throw new KmaxRuntimeException("KmeliaBmEJB.getNodeHeader()", 4, "kmax.EX_IMPOSSIBLE_DOBTENIR_LE_NOEUD", e);
        }
        return nodeDetail;
    }

    @Override
    public NodePK addPosition(String fatherId, NodeDetail position, String componentId, String userId) {
        SilverTrace.info((String)"kmax", (String)"KmeliaBmEjb.addPosition()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("fatherId = " + fatherId + " And position = " + position.toString()));
        position.getNodePK().setComponentName(componentId);
        position.setCreationDate(DateUtil.today2SQLDate());
        position.setCreatorId(userId);
        NodePK componentPK = null;
        NodeDetail fatherDetail = this.getNodeHeader(fatherId, componentId);
        SilverTrace.info((String)"kmax", (String)"KmeliaBmEjb.addPosition()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("fatherDetail = " + fatherDetail.toString()));
        try {
            componentPK = this.nodeBm.createNode(position, fatherDetail);
        }
        catch (Exception e) {
            throw new KmaxRuntimeException("KmeliaBmEjb.addPosition()", 4, "kmax.EX_IMPOSSIBLE_DAJOUTER_UNE_COMPOSANTE_A_L_AXE", e);
        }
        return componentPK;
    }

    @Override
    public void updatePosition(NodeDetail position, String componentId) {
        position.getNodePK().setComponentName(componentId);
        try {
            this.nodeBm.setDetail(position);
        }
        catch (Exception e) {
            throw new KmaxRuntimeException("KmeliaBmEjb.updatePosition()", 4, "kmax.EX_IMPOSSIBLE_DE_MODIFIER_LA_COMPOSANTE_DE_L_AXE", e);
        }
    }

    @Override
    public void deletePosition(String positionId, String componentId) {
        NodePK pkToDelete = new NodePK(positionId, componentId);
        try {
            List subComponents = this.nodeBm.getDescendantDetails(pkToDelete);
            Iterator it = subComponents.iterator();
            ArrayList<NodePK> points = new ArrayList<NodePK>();
            points.add(pkToDelete);
            while (it.hasNext()) {
                points.add(((NodeDetail)it.next()).getNodePK());
            }
            this.removeCoordinatesByPoints(points, componentId);
            this.nodeBm.removeNode(pkToDelete);
        }
        catch (Exception e) {
            throw new KmaxRuntimeException("KmeliaBmEjb.deletePosition()", 4, "kmax.EX_IMPOSSIBLE_DE_SUPPRIMER_LA_COMPOSANTE_DE_L_AXE", e);
        }
    }

    @Override
    public Collection<NodeDetail> getPath(String id, String componentId) {
        ArrayList<NodeDetail> newPath = new ArrayList<NodeDetail>();
        NodePK nodePK = new NodePK(id, componentId);
        try {
            List pathInReverse = (List)this.nodeBm.getPath(nodePK);
            for (int i = pathInReverse.size() - 1; i >= 0; --i) {
                newPath.add((NodeDetail)pathInReverse.get(i));
            }
        }
        catch (Exception e) {
            throw new KmaxRuntimeException("KmeliaBmEjb.getPath()", 4, "kmax.EX_IMPOSSIBLE_DOBTENIR_LE_CHEMIN", e);
        }
        return newPath;
    }

    public Collection<Coordinate> getKmaxPathList(PublicationPK pubPK) {
        SilverTrace.info((String)"kmax", (String)"KmeliaBmEJB.getKmaxPathList()", (String)"root.MSG_GEN_ENTER_METHOD");
        Collection<Coordinate> coordinates = null;
        try {
            coordinates = this.getPublicationCoordinates(pubPK.getId(), pubPK.getInstanceId());
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.getKmaxPathList()", 4, "kmelia.EX_IMPOSSIBLE_DOBTENIR_LES_EMPLACEMENTS_DE_LA_PUBLICATION", e);
        }
        return coordinates;
    }

    @Override
    public List<KmeliaPublication> search(List<String> combination, String componentId) {
        Collection<PublicationDetail> publications = this.searchPublications(combination, componentId);
        if (publications == null) {
            return new ArrayList<KmeliaPublication>();
        }
        return this.pubDetails2userPubs(publications);
    }

    @Override
    public List<KmeliaPublication> search(List<String> combination, int nbDays, String componentId) {
        Collection<PublicationDetail> publications = this.searchPublications(combination, componentId);
        SilverTrace.info((String)"kmax", (String)"KmeliaBmEjb.search()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("publications = " + publications));
        return this.pubDetails2userPubs(this.filterPublicationsByBeginDate(publications, nbDays));
    }

    private Collection<PublicationDetail> searchPublications(List<String> combination, String componentId) {
        PublicationPK pk = new PublicationPK("useless", componentId);
        CoordinatePK coordinatePK = new CoordinatePK("unknown", (WAPrimaryKey)pk);
        Collection publications = null;
        Collection coordinates = null;
        try {
            for (int i = 0; i < combination.size(); ++i) {
                String axisValue = combination.get(i);
                StringTokenizer st = new StringTokenizer(axisValue, "/");
                int nodeLevel = st.countTokens();
                if (nodeLevel != 2) continue;
                combination.remove(i);
                --i;
            }
            if (combination.isEmpty()) {
                NodePK basketPK = new NodePK("1", componentId);
                publications = this.publicationBm.getDetailsNotInFatherPK(basketPK);
            } else {
                if (combination != null && combination.size() > 0) {
                    coordinates = this.coordinatesBm.getCoordinatesByFatherPaths((List)((ArrayList)combination), coordinatePK);
                }
                if (!coordinates.isEmpty()) {
                    publications = this.publicationBm.getDetailsByFatherIds((List)((ArrayList)coordinates), pk, false);
                }
            }
        }
        catch (Exception e) {
            throw new KmaxRuntimeException("KmeliaBmEJB.search()", 4, "kmax.EX_IMPOSSIBLE_DOBTENIR_LA_LISTE_DES_RESULTATS", e);
        }
        return publications;
    }

    @Override
    public Collection<KmeliaPublication> getUnbalancedPublications(String componentId) {
        PublicationPK pk = new PublicationPK("useless", componentId);
        Collection publications = null;
        try {
            publications = this.publicationBm.getOrphanPublications(pk);
        }
        catch (Exception e) {
            throw new KmaxRuntimeException("KmeliaBmEJB.getUnbalancedPublications()", 4, "kmax.EX_IMPOSSIBLE_DOBTENIR_LA_LISTE_DES_PUBLICATIONS_NON_CLASSEES", e);
        }
        return this.pubDetails2userPubs(publications);
    }

    private Collection<PublicationDetail> filterPublicationsByBeginDate(Collection<PublicationDetail> publications, int nbDays) {
        ArrayList<PublicationDetail> pubOK = new ArrayList<PublicationDetail>();
        if (publications != null) {
            Calendar rightNow = Calendar.getInstance();
            if (nbDays == 0) {
                nbDays = 1;
            }
            rightNow.add(5, 0 - nbDays);
            Date day = rightNow.getTime();
            for (PublicationDetail pub : publications) {
                Date dateToCompare = pub.getBeginDate() != null ? pub.getBeginDate() : pub.getCreationDate();
                if (dateToCompare.compareTo(day) < 0) continue;
                pubOK.add(pub);
            }
        }
        return pubOK;
    }

    @Override
    public void indexKmax(String componentId) {
        this.indexAxis(componentId);
        this.indexPublications(new PublicationPK("useless", componentId));
    }

    private void indexAxis(String componentId) {
        NodePK nodePK = new NodePK("useless", componentId);
        try {
            Collection nodes = this.nodeBm.getAllNodes(nodePK);
            if (nodes != null) {
                for (NodeDetail nodeDetail : nodes) {
                    if ("corbeille".equalsIgnoreCase(nodeDetail.getName()) && nodeDetail.getNodePK().isTrash()) continue;
                    this.nodeBm.createIndex(nodeDetail);
                }
            }
        }
        catch (Exception e) {
            throw new KmaxRuntimeException("KmeliaBmEjb.indexAxis()", 4, "kmax.EX_IMPOSSIBLE_DINDEXER_LES_AXES", e);
        }
    }

    @Override
    public KmeliaPublication getKmaxPublication(String pubId, String currentUserId) {
        SilverTrace.info((String)"kmax", (String)"KmeliaBmEjb.getKmaxCompletePublication()", (String)"root.MSG_GEN_ENTER_METHOD");
        CompletePublication completePublication = null;
        try {
            PublicationPK pubPK = new PublicationPK(pubId);
            completePublication = this.publicationBm.getCompletePublication(pubPK);
        }
        catch (Exception e) {
            throw new KmaxRuntimeException("KmeliaBmEjb.getKmaxCompletePublication()", 4, "kmax.EX_IMPOSSIBLE_DOBTENIR_LES_INFORMATIONS_DE_LA_PUBLICATION", e);
        }
        KmeliaPublication publication = KmeliaPublication.aKmeliaPublicationFromCompleteDetail(completePublication);
        SilverTrace.info((String)"kmax", (String)"KmeliaBmEjb.getKmaxCompletePublication()", (String)"root.MSG_GEN_EXIT_METHOD");
        return publication;
    }

    @Override
    public Collection<Coordinate> getPublicationCoordinates(String pubId, String componentId) {
        SilverTrace.info((String)"kmax", (String)"KmeliaBmEjb.getPublicationCoordinates()", (String)"root.MSG_GEN_ENTER_METHOD");
        try {
            return this.publicationBm.getCoordinates(pubId, componentId);
        }
        catch (Exception e) {
            throw new KmaxRuntimeException("KmeliaBmEjb.getPublicationCoordinates()", 4, "root.MSG_GEN_PARAM_VALUE", e);
        }
    }

    @Override
    public void addPublicationToCombination(String pubId, List<String> combination, String componentId) {
        SilverTrace.info((String)"kmax", (String)"KmeliaBmEJB.addPublicationToCombination()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("combination =" + combination.toString()));
        PublicationPK pubPK = new PublicationPK(pubId, componentId);
        CoordinatePK coordinatePK = new CoordinatePK("unknown", (WAPrimaryKey)pubPK);
        try {
            Collection<Coordinate> coordinates = this.getPublicationCoordinates(pubId, componentId);
            if (!this.checkCombination(coordinates, combination)) {
                return;
            }
            Iterator<String> it = combination.iterator();
            ArrayList<CoordinatePoint> allnodes = new ArrayList<CoordinatePoint>();
            int i = 1;
            while (it.hasNext()) {
                String nodeId = it.next();
                NodePK nodePK = new NodePK(nodeId, componentId);
                SilverTrace.info((String)"kmax", (String)"KmeliaBmEjb.addPublicationToCombination()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("avant nodeBm.getPath() ! i = " + i));
                Collection path = this.nodeBm.getPath(nodePK);
                SilverTrace.info((String)"kmax", (String)"KmeliaBmEjb.addPublicationToCombination()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("path for nodeId " + nodeId + " = " + path.toString()));
                Iterator i$ = path.iterator();
                while (i$.hasNext()) {
                    NodeDetail aPath;
                    NodeDetail nodeDetail = aPath = (NodeDetail)i$.next();
                    String anscestorId = nodeDetail.getNodePK().getId();
                    int nodeLevel = nodeDetail.getLevel();
                    if (nodeDetail.getNodePK().isRoot()) continue;
                    CoordinatePoint point = anscestorId.equals(nodeId) ? new CoordinatePoint(-1, Integer.parseInt(anscestorId), true, nodeLevel, i) : new CoordinatePoint(-1, Integer.parseInt(anscestorId), false, nodeLevel, i);
                    allnodes.add(point);
                }
                ++i;
            }
            int coordinateId = this.coordinatesBm.addCoordinate(coordinatePK, allnodes);
            this.publicationBm.addFather(pubPK, new NodePK(String.valueOf(coordinateId), (WAPrimaryKey)pubPK));
        }
        catch (Exception e) {
            throw new KmaxRuntimeException("KmeliaBmEjb.addPublicationToCombination()", 4, "kmax.EX_IMPOSSIBLE_DAJOUTER_LA_PUBLICATION_A_CETTE_COMBINAISON", e);
        }
    }

    protected boolean checkCombination(Collection<Coordinate> coordinates, List<String> combination) {
        for (Coordinate coordinate : coordinates) {
            Collection points = coordinate.getCoordinatePoints();
            if (points.isEmpty()) continue;
            boolean matchFound = false;
            for (CoordinatePoint point : points) {
                if (!this.checkPoint(point, combination)) {
                    matchFound = false;
                    break;
                }
                matchFound = true;
            }
            if (!matchFound) continue;
            return false;
        }
        return true;
    }

    protected boolean checkPoint(CoordinatePoint point, List<String> combination) {
        for (String intVal : combination) {
            if (Integer.parseInt(intVal) != point.getNodeId()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void deleteCoordinates(CoordinatePK coordinatePK, List<String> coordinates) {
        this.coordinatesBm.deleteCoordinates(coordinatePK, coordinates);
    }

    @Override
    public void deletePublicationFromCombination(String pubId, String combinationId, String componentId) {
        SilverTrace.info((String)"kmax", (String)"KmeliaBmEjb.deletePublicationFromCombination()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("combinationId = " + combinationId));
        PublicationPK pubPK = new PublicationPK(pubId, componentId);
        NodePK fatherPK = new NodePK(combinationId, componentId);
        CoordinatePK coordinatePK = new CoordinatePK(combinationId, (WAPrimaryKey)pubPK);
        try {
            this.publicationBm.removeFather(pubPK, fatherPK);
            ArrayList<String> coordinateIds = new ArrayList<String>(1);
            coordinateIds.add(combinationId);
            this.coordinatesBm.deleteCoordinates(coordinatePK, coordinateIds);
        }
        catch (Exception e) {
            throw new KmaxRuntimeException("KmeliaBmEjb.deletePublicationFromCombination()", 4, "kmax.EX_IMPOSSIBLE_DE_SUPPRIMER_LA_COMBINAISON_DE_LA_PUBLICATION", e);
        }
    }

    @Override
    public String createKmaxPublication(PublicationDetail pubDetail) {
        SilverTrace.info((String)"kmax", (String)"KmeliaBmEJB.createKmaxPublication()", (String)"root.MSG_GEN_ENTER_METHOD");
        PublicationPK pubPK = null;
        Connection con = this.getConnection();
        try {
            pubDetail = this.changePublicationStatusOnCreation(pubDetail, new NodePK("useless", (WAPrimaryKey)pubDetail.getPK()));
            pubPK = this.publicationBm.createPublication(pubDetail);
            pubDetail.getPK().setId(pubPK.getId());
            this.createTodosForPublication(pubDetail, true);
            this.createSilverContent(pubDetail, pubDetail.getCreatorId());
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.createKmaxPublication()", 4, "kmelia.EX_IMPOSSIBLE_DE_CREER_LA_PUBLICATION", e);
        }
        finally {
            this.freeConnection(con);
        }
        SilverTrace.info((String)"kmax", (String)"KmeliaBmEJB.createKmaxPublication()", (String)"root.MSG_GEN_EXIT_METHOD");
        return pubPK.getId();
    }

    @Override
    public Collection<Alias> getAlias(PublicationPK pubPK) {
        try {
            return this.publicationBm.getAlias(pubPK);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.getAlias()", 4, "kmelia.EX_IMPOSSIBLE_DAVOIR_LES_ALIAS_DE_PUBLICATION", e);
        }
    }

    @Override
    public void setAlias(PublicationPK pubPK, List<Alias> alias) {
        this.publicationBm.setAlias(pubPK, alias);
        PublicationDetail pubDetail = this.getPublicationDetail(pubPK);
        this.sendSubscriptionsNotification(pubDetail, NotifAction.PUBLISHED, true);
    }

    @Override
    public void addUploadedFilesToPublication(PublicationDetail pubDetail, Collection<UploadedFile> uploadedFiles) {
        if (CollectionUtil.isNotEmpty(uploadedFiles)) {
            for (UploadedFile uploadedFile : uploadedFiles) {
                uploadedFile.registerAttachment((WAPrimaryKey)pubDetail.getPK(), pubDetail.getLanguage(), pubDetail.isIndexable());
            }
        }
    }

    @Override
    public void addAttachmentToPublication(PublicationPK pubPK, String userId, String filename, String description, byte[] contents) {
        try {
            HistorisedDocument document;
            Date creationDate = new Date();
            SimpleAttachment file = new SimpleAttachment(FileUtil.getFilename((String)filename), I18NHelper.defaultLanguage, filename, "", (long)contents.length, FileUtil.getMimeType((String)filename), userId, creationDate, null);
            boolean versioningActive = StringUtil.getBooleanValue((String)OrganisationControllerFactory.getOrganisationController().getComponentParameterValue(pubPK.getComponentName(), "versionControl"));
            if (versioningActive) {
                document = new HistorisedDocument(new SimpleDocumentPK(null, pubPK.getComponentName()), pubPK.getId(), 0, file);
                document.setPublicDocument(true);
            } else {
                document = new SimpleDocument(new SimpleDocumentPK(null, pubPK.getComponentName()), pubPK.getId(), 0, false, file);
            }
            AttachmentServiceFactory.getAttachmentService().createAttachment((SimpleDocument)document, (InputStream)new ByteArrayInputStream(contents));
        }
        catch (AttachmentException fnfe) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.addAttachmentToPublication()", 4, "kmelia.EX_IMPOSSIBLE_DAJOUTER_ATTACHEMENT", (Exception)((Object)fnfe));
        }
    }

    @Override
    public boolean importPublication(String componentId, String topicId, String spaceId, String userId, Map<String, String> publiParams, Map<String, String> formParams, String language, String xmlFormName, String discrimatingParameterName, String userProfile) {
        PublicationImport publicationImport = new PublicationImport(this, componentId, topicId, spaceId, userId);
        return publicationImport.importPublication(publiParams, formParams, language, xmlFormName, discrimatingParameterName, userProfile);
    }

    @Override
    public boolean importPublication(String componentId, String topicId, String userId, Map<String, String> publiParams, Map<String, String> formParams, String language, String xmlFormName, String discriminantParameterName, String userProfile, boolean ignoreMissingFormFields) {
        PublicationImport publicationImport = new PublicationImport(this, componentId, topicId, null, userId);
        publicationImport.setIgnoreMissingFormFields(ignoreMissingFormFields);
        return publicationImport.importPublication(publiParams, formParams, language, xmlFormName, discriminantParameterName, userProfile);
    }

    @Override
    public boolean importPublication(String publicationId, String componentId, String topicId, String spaceId, String userId, Map<String, String> publiParams, Map<String, String> formParams, String language, String xmlFormName, String userProfile) {
        PublicationImport publicationImport = new PublicationImport(this, componentId, topicId, spaceId, userId);
        return publicationImport.importPublication(publicationId, publiParams, formParams, language, xmlFormName, userProfile);
    }

    @Override
    public void importPublications(String componentId, String topicId, String spaceId, String userId, List<Map<String, String>> publiParamsList, List<Map<String, String>> formParamsList, String language, String xmlFormName, String discrimatingParameterName, String userProfile) {
        PublicationImport publicationImport = new PublicationImport(this, componentId, topicId, spaceId, userId);
        publicationImport.importPublications(publiParamsList, formParamsList, language, xmlFormName, discrimatingParameterName, userProfile);
    }

    @Override
    public List<XMLField> getPublicationXmlFields(String publicationId, String componentId, String spaceId, String userId) {
        PublicationImport publicationImport = new PublicationImport(this, componentId, null, spaceId, userId);
        return publicationImport.getPublicationXmlFields(publicationId);
    }

    @Override
    public List<XMLField> getPublicationXmlFields(String publicationId, String componentId, String spaceId, String userId, String language) {
        PublicationImport publicationImport = new PublicationImport(this, componentId, null, spaceId, userId);
        return publicationImport.getPublicationXmlFields(publicationId, language);
    }

    @Override
    public String createTopic(String componentId, String topicId, String spaceId, String userId, String name, String description) {
        PublicationImport publicationImport = new PublicationImport(this, componentId, topicId, spaceId, userId);
        return publicationImport.createTopic(name, description);
    }

    @Override
    public Collection<String> getPublicationsSpecificValues(String componentId, String xmlFormName, String fieldName) {
        PublicationImport publicationImport = new PublicationImport(this, componentId);
        return publicationImport.getPublicationsSpecificValues(componentId, xmlFormName, fieldName);
    }

    @Override
    public void draftInPublication(String componentId, String xmlFormName, String fieldName, String fieldValue) {
        PublicationImport publicationImport = new PublicationImport(this, componentId);
        publicationImport.draftInPublication(xmlFormName, fieldName, fieldValue);
    }

    @Override
    public void updatePublicationEndDate(String componentId, String spaceId, String userId, String xmlFormName, String fieldName, String fieldValue, Date endDate) {
        PublicationImport publicationImport = new PublicationImport(this, componentId, null, spaceId, userId);
        publicationImport.updatePublicationEndDate(xmlFormName, fieldName, fieldValue, endDate);
    }

    @Override
    public String findPublicationIdBySpecificValue(String componentId, String xmlFormName, String fieldName, String fieldValue, String topicId, String spaceId, String userId) {
        PublicationImport publicationImport = new PublicationImport(this, componentId, topicId, spaceId, userId);
        return publicationImport.getPublicationId(xmlFormName, fieldName, fieldValue);
    }

    @Override
    public void doAutomaticDraftOut() {
        Collection pubs = this.publicationBm.getPublicationsToDraftOut(true);
        for (PublicationDetail pub : pubs) {
            this.draftOutPublication(pub.getClonePK(), null, "admin", true);
        }
    }

    @Override
    public String clonePublication(CompletePublication refPubComplete, PublicationDetail pubDetail, String nextStatus) {
        String cloneId;
        try {
            PublicationDetail refPub = refPubComplete.getPublicationDetail();
            String fromId = refPub.getPK().getId();
            String fromComponentId = refPub.getPK().getInstanceId();
            PublicationDetail clone = this.getClone(refPub);
            ResourceLocator publicationSettings = new ResourceLocator("org.silverpeas.util.publication.publicationSettings", "");
            String absolutePath = FileRepositoryManager.getAbsolutePath((String)fromComponentId);
            if (pubDetail != null) {
                clone.setAuthor(pubDetail.getAuthor());
                clone.setBeginDate(pubDetail.getBeginDate());
                clone.setBeginHour(pubDetail.getBeginHour());
                clone.setDescription(pubDetail.getDescription());
                clone.setEndDate(pubDetail.getEndDate());
                clone.setEndHour(pubDetail.getEndHour());
                clone.setImportance(pubDetail.getImportance());
                clone.setKeywords(pubDetail.getKeywords());
                clone.setName(pubDetail.getName());
                clone.setTargetValidatorId(pubDetail.getTargetValidatorId());
            }
            if (StringUtil.isInteger((String)refPub.getInfoId())) {
                clone.setInfoId(null);
            }
            clone.setStatus(nextStatus);
            clone.setCloneId(fromId);
            clone.setIndexOperation(-1);
            PublicationPK clonePK = this.publicationBm.createPublication(clone);
            clonePK.setComponentName(fromComponentId);
            cloneId = clonePK.getId();
            SimpleDocumentList documents = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKey((WAPrimaryKey)new ForeignPK(fromId, fromComponentId), null);
            HashMap attachmentIds = new HashMap(documents.size());
            for (SimpleDocument document : documents) {
                AttachmentServiceFactory.getAttachmentService().cloneDocument(document, cloneId);
            }
            String xmlFormShortName = refPub.getInfoId();
            if (xmlFormShortName != null && !"0".equals(xmlFormShortName) && !StringUtil.isInteger((String)xmlFormShortName)) {
                PublicationTemplateManager templateManager = PublicationTemplateManager.getInstance();
                templateManager.addDynamicPublicationTemplate(fromComponentId + ":" + xmlFormShortName, xmlFormShortName + ".xml");
                PublicationTemplate pubTemplate = templateManager.getPublicationTemplate(fromComponentId + ":" + xmlFormShortName);
                RecordSet set = pubTemplate.getRecordSet();
                set.clone(fromId, fromComponentId, cloneId, fromComponentId, attachmentIds);
            }
            if (refPubComplete.getLinkList() != null && refPubComplete.getLinkList().size() > 0) {
                this.addInfoLinks(clonePK, refPubComplete.getLinkList());
            }
            WysiwygController.copy((String)fromComponentId, (String)fromId, (String)fromComponentId, (String)cloneId, (String)clone.getCreatorId());
            refPub.setCloneId(cloneId);
            refPub.setCloneStatus(nextStatus);
            refPub.setStatusMustBeChecked(false);
            refPub.setUpdateDateMustBeSet(false);
            this.updatePublication(refPub);
            String vignette = refPub.getImage();
            if (vignette != null) {
                ThumbnailDetail thumbDetail = new ThumbnailDetail(clone.getPK().getInstanceId(), Integer.valueOf(clone.getPK().getId()).intValue(), 1);
                thumbDetail.setMimeType(refPub.getImageMimeType());
                if (vignette.startsWith("/")) {
                    thumbDetail.setOriginalFileName(vignette);
                } else {
                    String thumbnailsSubDirectory = publicationSettings.getString("imagesSubDirectory");
                    String from = absolutePath + thumbnailsSubDirectory + File.separator + vignette;
                    String type = FilenameUtils.getExtension((String)vignette);
                    String newVignette = Long.toString(System.currentTimeMillis()) + "." + type;
                    String to = absolutePath + thumbnailsSubDirectory + File.separator + newVignette;
                    FileRepositoryManager.copyFile((String)from, (String)to);
                    thumbDetail.setOriginalFileName(newVignette);
                }
                ThumbnailServiceFactory.getThumbnailService().createThumbnail(thumbDetail);
            }
        }
        catch (IOException e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.clonePublication", 4, "kmelia.CANT_CLONE_PUBLICATION", e);
        }
        catch (FormException fe) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.clonePublication", 4, "kmelia.CANT_CLONE_PUBLICATION_XMLCONTENT", (Exception)((Object)fe));
        }
        catch (PublicationTemplateException pe) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.clonePublication", 4, "kmelia.CANT_CLONE_PUBLICATION_XMLCONTENT", (Exception)((Object)pe));
        }
        catch (ThumbnailException e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.clonePublication", 4, "kmelia.CANT_CLONE_PUBLICATION", (Exception)((Object)e));
        }
        return cloneId;
    }

    private CommentService getCommentService() {
        if (this.commentService == null) {
            this.commentService = CommentServiceFactory.getFactory().getCommentService();
        }
        return this.commentService;
    }

    private ResourceLocator getMultilang() {
        return new ResourceLocator(MESSAGES_PATH, "fr");
    }

    @Override
    public NodeDetail getRoot(String componentId, String userId) {
        return this.getRoot(componentId, userId, null);
    }

    private NodeDetail getRoot(String componentId, String userId, List<NodeDetail> treeview) {
        NodePK rootPK = new NodePK("0", componentId);
        NodeDetail root = this.nodeBm.getDetail(rootPK);
        this.setRole(root, userId);
        root.setChildrenDetails(this.getRootChildren(root, userId, treeview));
        return root;
    }

    private List<NodeDetail> getRootChildren(NodeDetail root, String userId, List<NodeDetail> treeview) {
        String instanceId = root.getNodePK().getInstanceId();
        ArrayList<NodeDetail> children = new ArrayList<NodeDetail>();
        try {
            this.setAllowedSubfolders(root, userId);
            List nodes = (List)root.getChildrenDetails();
            this.setNbItemsOfSubfolders(root, treeview, userId);
            NodeDetail trash = null;
            for (NodeDetail node : nodes) {
                if (node.getNodePK().isTrash()) {
                    trash = node;
                    continue;
                }
                if (node.getNodePK().isUnclassed()) continue;
                children.add(node);
            }
            if (this.isUserCanValidate(instanceId, userId)) {
                NodeDetail temp = new NodeDetail();
                temp.getNodePK().setId("tovalidate");
                temp.setName(this.getMultilang().getString("ToValidateShort"));
                if (this.isNbItemsDisplayed(instanceId)) {
                    int nbPublisToValidate = this.getPublicationsToValidate(instanceId, userId).size();
                    temp.setNbObjects(nbPublisToValidate);
                }
                children.add(temp);
            }
            if (this.isUserCanWrite(instanceId, userId) && trash != null) {
                children.add(trash);
            }
            root.setChildrenDetails(children);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        return children;
    }

    @Override
    public Collection<NodeDetail> getFolderChildren(NodePK nodePK, String userId) {
        NodeDetail node = this.nodeBm.getDetail(nodePK);
        if (node.getNodePK().isRoot()) {
            node.setChildrenDetails(this.getRootChildren(node, userId, null));
        } else {
            this.setAllowedSubfolders(node, userId);
        }
        this.setNbItemsOfSubfolders(node, null, userId);
        return node.getChildrenDetails();
    }

    private void setNbItemsOfSubfolders(NodeDetail node, List<NodeDetail> treeview, String userId) {
        String instanceId = node.getNodePK().getInstanceId();
        if (this.isNbItemsDisplayed(instanceId)) {
            if (treeview == null) {
                treeview = this.getTreeview(node.getNodePK(), userId);
            }
            this.setNbItemsOfFolders(instanceId, node.getChildrenDetails(), treeview);
        }
    }

    private List<NodeDetail> getTreeview(NodePK pk, String userId) {
        String instanceId = pk.getInstanceId();
        if (this.isUserComponentAdmin(instanceId, userId)) {
            return this.getTreeview(pk, "admin", this.isCoWritingEnable(instanceId), this.isDraftVisibleWithCoWriting(), userId, this.isNbItemsDisplayed(instanceId), false);
        }
        return this.getTreeview(pk, this.getUserTopicProfile(pk, userId), this.isCoWritingEnable(instanceId), this.isDraftVisibleWithCoWriting(), userId, this.isNbItemsDisplayed(instanceId), this.isRightsOnTopicsEnabled(instanceId));
    }

    private void setNbItemsOfFolders(String componentId, Collection<NodeDetail> nodes, List<NodeDetail> treeview) {
        if (this.isNbItemsDisplayed(componentId)) {
            for (NodeDetail child : nodes) {
                int index = treeview.indexOf(child);
                if (index == -1) continue;
                child.setNbObjects(treeview.get(index).getNbObjects());
            }
        }
    }

    private void setAllowedSubfolders(NodeDetail node, String userId) {
        String instanceId = node.getNodePK().getInstanceId();
        if (this.isRightsOnTopicsEnabled(instanceId)) {
            if (this.isUserComponentAdmin(instanceId, userId)) {
                this.setRole(node.getChildrenDetails(), userId);
            } else {
                List<NodeDetail> allowedChildren = this.getAllowedSubfolders(node, userId);
                this.setRole(allowedChildren, userId);
                node.setChildrenDetails(allowedChildren);
            }
        }
    }

    private boolean isUserComponentAdmin(String componentId, String userId) {
        return "admin".equalsIgnoreCase(KmeliaHelper.getProfile(this.getUserRoles(componentId, userId)));
    }

    private void setRole(NodeDetail node, String userId) {
        if (this.isRightsOnTopicsEnabled(node.getNodePK().getInstanceId())) {
            node.setUserRole(this.getUserTopicProfile(node.getNodePK(), userId));
        }
    }

    private void setRole(Collection<NodeDetail> nodes, String userId) {
        for (NodeDetail node : nodes) {
            this.setRole(node, userId);
        }
    }

    private boolean isRightsOnTopicsEnabled(String componentId) {
        return StringUtil.getBooleanValue((String)OrganisationControllerFactory.getOrganisationController().getComponentParameterValue(componentId, "rightsOnTopics"));
    }

    private boolean isNbItemsDisplayed(String componentId) {
        return StringUtil.getBooleanValue((String)OrganisationControllerFactory.getOrganisationController().getComponentParameterValue(componentId, "displayNB"));
    }

    private boolean isCoWritingEnable(String componentId) {
        return StringUtil.getBooleanValue((String)OrganisationControllerFactory.getOrganisationController().getComponentParameterValue(componentId, "coWriting"));
    }

    private boolean isDraftVisibleWithCoWriting() {
        return this.getComponentSettings().getBoolean("draftVisibleWithCoWriting", false);
    }

    @Override
    public String getUserTopicProfile(NodePK pk, String userId) {
        if (!this.isRightsOnTopicsEnabled(pk.getInstanceId()) || KmeliaHelper.isToValidateFolder(pk.getId())) {
            return KmeliaHelper.getProfile(this.getUserRoles(pk.getInstanceId(), userId));
        }
        NodeDetail node = this.getNodeHeader(pk.getId(), pk.getInstanceId());
        if (node != null && node.haveRights()) {
            int rightsDependsOn = node.getRightsDependsOn();
            return KmeliaHelper.getProfile(OrganisationControllerFactory.getOrganisationController().getUserProfiles(userId, pk.getInstanceId(), rightsDependsOn, ObjectType.NODE));
        }
        return KmeliaHelper.getProfile(this.getUserRoles(pk.getInstanceId(), userId));
    }

    private String[] getUserRoles(String componentId, String userId) {
        return OrganisationControllerFactory.getOrganisationController().getUserProfiles(userId, componentId);
    }

    private NodePK getRootPK(String componentId) {
        return new NodePK("0", componentId);
    }

    @Override
    public boolean isUserCanValidatePublication(PublicationPK pubPK, String userId) {
        PublicationDetail publi = this.getPublicationDetail(pubPK);
        if (!publi.isValidationRequired()) {
            return false;
        }
        List<String> validatorIds = this.getAllValidators(pubPK);
        if (!validatorIds.contains(userId)) {
            return false;
        }
        if (this.getValidationType(pubPK.getInstanceId()) == 2) {
            ValidationStep validationStep = this.publicationBm.getValidationStepByUser(pubPK, userId);
            return validationStep == null;
        }
        return true;
    }

    @Override
    public boolean isUserCanValidate(String componentId, String userId) {
        if (KmeliaHelper.isToolbox(componentId)) {
            return false;
        }
        return this.isUserCanPublish(componentId, userId);
    }

    @Override
    public boolean isUserCanWrite(String componentId, String userId) {
        String[] grantedRoles = new String[]{SilverpeasRole.admin.name(), SilverpeasRole.publisher.name(), SilverpeasRole.writer.name()};
        return this.checkUserRoles(componentId, userId, grantedRoles);
    }

    @Override
    public boolean isUserCanPublish(String componentId, String userId) {
        String[] grantedRoles = new String[]{SilverpeasRole.admin.name(), SilverpeasRole.publisher.name()};
        return this.checkUserRoles(componentId, userId, grantedRoles);
    }

    private boolean checkUserRoles(String componentId, String userId, String ... roles) {
        SilverpeasRole userProfile = SilverpeasRole.from((String)KmeliaHelper.getProfile(this.getUserRoles(componentId, userId)));
        boolean checked = userProfile.isInRole(roles);
        if (!checked && this.isRightsOnTopicsEnabled(componentId)) {
            Iterator descendants = this.nodeBm.getDescendantDetails(this.getRootPK(componentId)).iterator();
            while (!checked && descendants.hasNext()) {
                String[] profiles;
                NodeDetail descendant = (NodeDetail)descendants.next();
                AdminController admin = null;
                if (!descendant.haveLocalRights() || (profiles = (admin = new AdminController(userId)).getProfilesByObjectAndUserId(descendant.getId(), ObjectType.NODE.getCode(), componentId, userId)) == null || profiles.length <= 0) continue;
                userProfile = SilverpeasRole.from((String)KmeliaHelper.getProfile(profiles));
                checked = userProfile.isInRole(roles);
            }
        }
        return checked;
    }

    @Override
    public NodeDetail getExpandedPathToNode(NodePK pk, String userId) {
        String instanceId = pk.getInstanceId();
        ArrayList<NodeDetail> nodes = new ArrayList<NodeDetail>(this.nodeBm.getPath(pk));
        Collections.reverse(nodes);
        nodes.remove(0);
        List<NodeDetail> treeview = null;
        if (this.isNbItemsDisplayed(instanceId)) {
            treeview = this.getTreeview(this.getRootPK(instanceId), userId);
        }
        NodeDetail root = this.getRoot(instanceId, userId, treeview);
        if (treeview != null) {
            root.setNbObjects(treeview.get(0).getNbObjects());
            this.setNbItemsOfFolders(instanceId, nodes, treeview);
        }
        NodeDetail currentNode = root;
        for (NodeDetail node : nodes) {
            currentNode = this.find(currentNode.getChildrenDetails(), node);
            Collection children = this.nodeBm.getChildrenDetails(node.getNodePK());
            node.setChildrenDetails(children);
            this.setAllowedSubfolders(node, userId);
            if (treeview != null) {
                this.setNbItemsOfSubfolders(node, treeview, userId);
            }
            currentNode.setChildrenDetails(node.getChildrenDetails());
        }
        return root;
    }

    private NodeDetail find(Collection<NodeDetail> nodes, NodeDetail toFind) {
        for (NodeDetail node : nodes) {
            if (!node.getNodePK().getId().equals(toFind.getNodePK().getId())) continue;
            return node;
        }
        return null;
    }

    @Override
    public List<String> deletePublications(List<String> ids, NodePK nodePK, String userId) {
        ArrayList<String> removedIds = new ArrayList<String>();
        String profile = this.getProfile(userId, nodePK);
        for (String id : ids) {
            PublicationPK pk = new PublicationPK(id, (WAPrimaryKey)nodePK);
            if (!this.isUserCanDeletePublication(new PublicationPK(id, (WAPrimaryKey)nodePK), profile, userId)) continue;
            try {
                if (nodePK.isTrash()) {
                    this.deletePublication(pk);
                } else {
                    this.sendPublicationToBasket(pk);
                }
                SilverTrace.spy((String)"kmelia", (String)"KmeliaBmEJB.deletePublications", null, (String)nodePK.getInstanceId(), (String)id, (String)userId, (String)"2");
                removedIds.add(id);
            }
            catch (Exception e) {
                SilverTrace.error((String)"kmelia", (String)"KmeliaBmEJB.deletePublications()", (String)"kmelia.EX_IMPOSSIBLE_DE_SUPPRIMER_LA_PUBLICATION", (String)("pk = " + pk.toString()), (Throwable)e);
            }
        }
        return removedIds;
    }

    private boolean isUserCanDeletePublication(PublicationPK pubPK, String profile, String userId) {
        UserDetail owner = this.getPublication(pubPK).getCreator();
        return KmeliaPublicationHelper.isRemovable(pubPK.getInstanceId(), userId, profile, owner);
    }

    @Override
    public String getWysiwyg(PublicationPK pubPK, String language) {
        try {
            return WysiwygController.load((String)pubPK.getInstanceId(), (String)pubPK.getId(), (String)I18NHelper.checkLanguage((String)language));
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.getAttachments()", 4, "kmelia.EX_IMPOSSIBLE_DOBTENIR_LE_WYSIWYG", e);
        }
    }

    public KmeliaPublication getContentById(String contentId) {
        return this.getPublication(new PublicationPK(contentId));
    }

    public ResourceLocator getComponentSettings() {
        return settings;
    }

    public ResourceLocator getComponentMessages(String language) {
        return new ResourceLocator(MESSAGES_PATH, language);
    }

    @Override
    @Interceptors(value={SimulationActionProcessAnnotationEJBInterceptor.class})
    @SimulationActionProcess(elementLister=KmeliaNodeSimulationElementLister.class)
    @Action(value=ActionType.MOVE)
    public NodeDetail moveNode(@SourcePK NodePK nodePK, @TargetPK NodePK to, String userId) {
        ArrayList treeToPaste = this.nodeBm.getSubTree(nodePK);
        this.nodeBm.moveNode(nodePK, to);
        AdminController admin = new AdminController(userId);
        for (NodeDetail fromNode : treeToPaste) {
            List profiles;
            if (fromNode == null) continue;
            NodePK toNodePK = new NodePK(fromNode.getNodePK().getId(), (WAPrimaryKey)to);
            if (fromNode.haveLocalRights() && (profiles = admin.getProfilesByObject(fromNode.getNodePK().getId(), ObjectType.NODE.getCode(), fromNode.getNodePK().getInstanceId())) != null) {
                for (ProfileInst profile : profiles) {
                    if (profile == null || !StringUtil.isDefined((String)profile.getId())) continue;
                    admin.deleteProfileInst(profile.getId());
                }
            }
            if (!nodePK.getInstanceId().equals(to.getInstanceId())) {
                WysiwygController.move((String)fromNode.getNodePK().getInstanceId(), (String)("Node_" + fromNode.getId()), (String)to.getInstanceId(), (String)("Node_" + toNodePK.getId()));
            }
            this.movePublicationsOfTopic(fromNode.getNodePK(), toNodePK, userId);
        }
        nodePK.setComponentName(to.getInstanceId());
        return this.getNodeHeader(nodePK);
    }

    private void movePublicationsOfTopic(NodePK fromPK, NodePK toPK, String userId) {
        Collection publications = this.publicationBm.getDetailsByFatherPK(fromPK);
        for (PublicationDetail publi : publications) {
            this.movePublication(publi.getPK(), toPK, userId);
        }
    }

    @Override
    @Interceptors(value={SimulationActionProcessAnnotationEJBInterceptor.class})
    @SimulationActionProcess(elementLister=KmeliaNodeSimulationElementLister.class)
    @Action(value=ActionType.COPY)
    public NodeDetail copyNode(@SourcePK @TargetPK KmeliaCopyDetail copyDetail) {
        HashMap<Integer, Integer> oldAndNewIds = new HashMap<Integer, Integer>();
        return this.copyNode(copyDetail, oldAndNewIds);
    }

    private NodeDetail copyNode(KmeliaCopyDetail copyDetail, HashMap<Integer, Integer> oldAndNewIds) {
        NodePK nodePKToCopy = copyDetail.getFromNodePK();
        NodePK targetPK = copyDetail.getToNodePK();
        String userId = copyDetail.getUserId();
        SilverTrace.debug((String)"kmelia", (String)"KmeliaBmEJB.copyNode()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("from = " + nodePKToCopy.toString() + ", to = " + targetPK.toString()));
        NodeDetail nodeToCopy = this.nodeBm.getDetail(nodePKToCopy);
        NodeDetail father = this.getNodeHeader(targetPK);
        NodePK nodePK = new NodePK("unknown", (WAPrimaryKey)targetPK);
        NodeDetail node = nodeToCopy.clone();
        node.setNodePK(nodePK);
        node.setCreatorId(userId);
        node.setRightsDependsOn(father.getRightsDependsOn());
        node.setCreationDate(DateUtil.today2SQLDate());
        nodePK = this.nodeBm.createNode(node, father);
        if (copyDetail.isNodeRightsMustBeCopied()) {
            oldAndNewIds.put(Integer.parseInt(nodePKToCopy.getId()), Integer.parseInt(nodePK.getId()));
            if (nodeToCopy.haveRights()) {
                if (nodeToCopy.haveLocalRights()) {
                    node.setRightsDependsOn(Integer.parseInt(nodePK.getId()));
                } else {
                    int oldRightsDependsOn = nodeToCopy.getRightsDependsOn();
                    Integer newRightsDependsOn = oldAndNewIds.get(oldRightsDependsOn);
                    node.setRightsDependsOn(newRightsDependsOn.intValue());
                }
                this.nodeBm.updateRightsDependency(node);
            }
            if (nodeToCopy.haveLocalRights()) {
                AdminController admin = new AdminController(userId);
                List topicProfiles = admin.getProfilesByObject(nodeToCopy.getNodePK().getId(), ObjectType.NODE.getCode(), nodeToCopy.getNodePK().getInstanceId());
                for (ProfileInst nodeToPasteProfile : topicProfiles) {
                    if (nodeToPasteProfile == null) continue;
                    ProfileInst nodeProfileInst = (ProfileInst)nodeToPasteProfile.clone();
                    nodeProfileInst.setId("-1");
                    nodeProfileInst.setComponentFatherId(nodePK.getInstanceId());
                    nodeProfileInst.setObjectId(Integer.parseInt(nodePK.getId()));
                    nodeProfileInst.setObjectFatherId(father.getId());
                    admin.addProfileInst(nodeProfileInst, userId);
                }
            }
        }
        WysiwygController.copy((String)nodePKToCopy.getInstanceId(), (String)("Node_" + nodePKToCopy.getId()), (String)nodePK.getInstanceId(), (String)("Node_" + nodePK.getId()), (String)userId);
        this.setModelUsed(nodePKToCopy, nodePK);
        KmeliaCopyDetail folderContentCopy = new KmeliaCopyDetail((PasteDetail)copyDetail);
        folderContentCopy.setFromNodePK(nodePKToCopy);
        folderContentCopy.setToNodePK(nodePK);
        if (copyDetail.isPublicationHeaderMustBeCopied()) {
            this.copyPublications(folderContentCopy);
        }
        Collection subtopics = nodeToCopy.getChildrenDetails();
        for (NodeDetail subTopic : subtopics) {
            if (subTopic == null) continue;
            folderContentCopy.setFromNodePK(subTopic.getNodePK());
            this.copyNode(folderContentCopy, oldAndNewIds);
        }
        return node;
    }

    @Override
    @Interceptors(value={SimulationActionProcessAnnotationEJBInterceptor.class})
    @SimulationActionProcess(elementLister=KmeliaPublicationSimulationElementLister.class)
    @Action(value=ActionType.COPY)
    public void copyPublications(@SourcePK @TargetPK KmeliaCopyDetail copyDetail) {
        Collection publications = this.publicationBm.getDetailsByFatherPK(copyDetail.getFromNodePK());
        for (PublicationDetail publi : publications) {
            this.copyPublication(publi, copyDetail);
        }
    }

    @Override
    @Interceptors(value={SimulationActionProcessAnnotationEJBInterceptor.class})
    @SimulationActionProcess(elementLister=KmeliaPublicationSimulationElementLister.class)
    @Action(value=ActionType.COPY)
    public PublicationPK copyPublication(@SourcePK PublicationDetail publiToCopy, @TargetPK KmeliaCopyDetail copyDetail) {
        NodePK nodePK = copyDetail.getToNodePK();
        String userId = copyDetail.getUserId();
        try {
            ForeignPK toForeignPK = new ForeignPK("unknown", (WAPrimaryKey)nodePK);
            PublicationPK toPubPK = new PublicationPK("unknown", (WAPrimaryKey)nodePK);
            String toComponentId = nodePK.getInstanceId();
            PublicationDetail newPubli = new PublicationDetail();
            newPubli.setPk(toPubPK);
            newPubli.setLanguage(publiToCopy.getLanguage());
            newPubli.setName(publiToCopy.getName());
            newPubli.setDescription(publiToCopy.getDescription());
            newPubli.setKeywords(publiToCopy.getKeywords());
            newPubli.setTranslations(publiToCopy.getClonedTranslations());
            newPubli.setAuthor(publiToCopy.getAuthor());
            newPubli.setCreatorId(userId);
            newPubli.setBeginDate(publiToCopy.getBeginDate());
            newPubli.setBeginHour(publiToCopy.getBeginHour());
            newPubli.setEndDate(publiToCopy.getEndDate());
            newPubli.setEndHour(publiToCopy.getEndHour());
            newPubli.setImportance(publiToCopy.getImportance());
            if (copyDetail.isPublicationContentMustBeCopied()) {
                newPubli.setInfoId(publiToCopy.getInfoId());
            }
            newPubli.setTargetValidatorId(copyDetail.getPublicationValidatorIds());
            if (StringUtil.isDefined((String)copyDetail.getPublicationStatus())) {
                String profile = this.getProfile(userId, nodePK);
                if (!copyDetail.getPublicationStatus().equals("Draft")) {
                    if (SilverpeasRole.from((String)profile).isGreaterThanOrEquals(SilverpeasRole.publisher)) {
                        newPubli.setStatus("Valid");
                    } else {
                        newPubli.setStatus("ToValidate");
                    }
                }
            }
            String fromId = publiToCopy.getPK().getId();
            String fromComponentId = publiToCopy.getPK().getInstanceId();
            ForeignPK fromForeignPK = new ForeignPK(publiToCopy.getPK().getId(), fromComponentId);
            PublicationPK fromPubPK = new PublicationPK(publiToCopy.getPK().getId(), fromComponentId);
            if (copyDetail.isAdministrativeOperation()) {
                newPubli.setCreatorId(publiToCopy.getCreatorId());
                newPubli.setCreationDate(publiToCopy.getCreationDate());
                newPubli.setUpdaterId(publiToCopy.getUpdaterId());
                newPubli.setUpdateDate(publiToCopy.getUpdateDate());
                newPubli.setStatus(publiToCopy.getStatus());
            }
            String id = this.createPublicationIntoTopic(newPubli, nodePK);
            toPubPK.setId(id);
            toForeignPK.setId(id);
            SilverTrace.spy((String)"kmelia", (String)"KmeliaBmEJB.copyPublication", (String)"unknown", (String)nodePK.getInstanceId(), (String)id, (String)userId, (String)"1");
            ThumbnailController.copyThumbnail((ForeignPK)fromForeignPK, (ForeignPK)toForeignPK);
            if (copyDetail.isPublicationPositionsMustBeCopied()) {
                this.copyPdcPositions(fromPubPK, toPubPK);
            }
            HashMap<String, String> fileIds = new HashMap<String, String>();
            if (copyDetail.isPublicationFilesMustBeCopied()) {
                fileIds.putAll(this.copyFiles(fromPubPK, toPubPK));
            }
            if (copyDetail.isPublicationContentMustBeCopied()) {
                String xmlFormShortName = newPubli.getInfoId();
                if (xmlFormShortName != null && !"0".equals(xmlFormShortName)) {
                    PublicationTemplateManager publicationTemplateManager = PublicationTemplateManager.getInstance();
                    GenericRecordSet toRecordset = publicationTemplateManager.addDynamicPublicationTemplate(toComponentId + ":" + xmlFormShortName, xmlFormShortName + ".xml");
                    PublicationTemplate pubTemplate = publicationTemplateManager.getPublicationTemplate(fromComponentId + ":" + xmlFormShortName);
                    RecordSet set = pubTemplate.getRecordSet();
                    set.copy(fromForeignPK, toForeignPK, toRecordset.getRecordTemplate(), fileIds);
                } else {
                    WysiwygController.copy((String)fromComponentId, (String)fromId, (String)toPubPK.getInstanceId(), (String)id, (String)userId);
                }
            }
            this.publicationBm.createIndex(toPubPK);
            return newPubli.getPK();
        }
        catch (Exception ex) {
            SilverTrace.error((String)"kmelia", (String)(this.getClass().getSimpleName() + ".pastePublication()"), (String)"root.EX_NO_MESSAGE", (Throwable)ex);
            return null;
        }
    }

    private Map<String, String> copyFiles(PublicationPK fromPK, PublicationPK toPK) throws IOException {
        HashMap<String, String> fileIds = new HashMap<String, String>();
        SimpleDocumentList origins = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKeyAndType((WAPrimaryKey)fromPK, DocumentType.attachment, null);
        for (SimpleDocument origin : origins) {
            SimpleDocumentPK copyPk = AttachmentServiceFactory.getAttachmentService().copyDocument(origin, new ForeignPK((WAPrimaryKey)toPK));
            fileIds.put(origin.getId(), copyPk.getId());
        }
        return fileIds;
    }

    private void copyPdcPositions(PublicationPK fromPK, PublicationPK toPK) throws RemoteException, PdcException {
        int fromSilverObjectId = this.getSilverObjectId(fromPK);
        int toSilverObjectId = this.getSilverObjectId(toPK);
        new PdcBmImpl().copyPositions(fromSilverObjectId, fromPK.getInstanceId(), toSilverObjectId, toPK.getInstanceId());
    }

    @Override
    public List<KmeliaPublication> filterPublications(List<KmeliaPublication> publications, String instanceId, SilverpeasRole profile, String userId) {
        boolean coWriting = this.isCoWritingEnable(instanceId);
        ArrayList<KmeliaPublication> filteredPublications = new ArrayList<KmeliaPublication>();
        for (KmeliaPublication userPub : publications) {
            if (!this.isPublicationVisible(userPub.getDetail(), profile, userId, coWriting)) continue;
            filteredPublications.add(userPub);
        }
        return filteredPublications;
    }

    @Override
    public boolean isPublicationVisible(PublicationDetail detail, SilverpeasRole profile, String userId) {
        boolean coWriting = this.isCoWritingEnable(detail.getInstanceId());
        return this.isPublicationVisible(detail, profile, userId, coWriting);
    }

    private boolean isPublicationVisible(PublicationDetail detail, SilverpeasRole profile, String userId, boolean coWriting) {
        if (detail.getStatus() != null) {
            if (detail.isValid()) {
                if (detail.isVisible()) {
                    return true;
                }
                if (profile == SilverpeasRole.admin || userId.equals(detail.getUpdaterId()) || profile != SilverpeasRole.user && coWriting) {
                    return true;
                }
            } else if (detail.isDraft() ? userId.equals(detail.getCreatorId()) || userId.equals(detail.getUpdaterId()) || coWriting && this.isDraftVisibleWithCoWriting() && profile != SilverpeasRole.user : profile == SilverpeasRole.admin || profile == SilverpeasRole.publisher || userId.equals(detail.getCreatorId()) || userId.equals(detail.getUpdaterId()) || profile != SilverpeasRole.user && coWriting) {
                return true;
            }
        }
        return false;
    }

    protected PersistentDateReminderService getDateReminderService() {
        if (this.dateReminderService == null) {
            this.dateReminderService = DateReminderServiceFactory.getDateReminderService();
        }
        return this.dateReminderService;
    }

    @Override
    public void userHaveBeenDeleted(String userId) {
        List publications = this.publicationBm.removeUserFromTargetValidators(userId);
        SilverTrace.info((String)"kmelia", (String)(this.getClass().getSimpleName() + ".userHaveBeenDeleted()"), (String)"root.EX_NO_MESSAGE", (String)("User #" + userId + " have been removed from " + publications.size() + " publications as target validator"));
        KmeliaValidation.by(userId).validatorHasNoMoreRight().validate(publications);
    }
}

