/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.kmelia.control.ejb;

import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.webactiv.SilverpeasRole;
import com.stratelia.webactiv.util.node.model.NodeDetail;
import com.stratelia.webactiv.util.node.model.NodePK;
import com.stratelia.webactiv.util.publication.model.PublicationDetail;
import java.io.Serializable;
import org.silverpeas.attachment.model.SimpleDocument;

public class KmeliaHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int PUBLICATION_HEADER = 0;
    public static final int PUBLICATION_CONTENT = 1;
    public static final int VALIDATION_CLASSIC = 0;
    public static final int VALIDATION_TARGET_1 = 1;
    public static final int VALIDATION_TARGET_N = 2;
    public static final int VALIDATION_COLLEGIATE = 3;
    public static final String ROLE_ADMIN = "admin";
    public static final String ROLE_PUBLISHER = "publisher";
    public static final String ROLE_WRITER = "writer";
    public static final String ROLE_READER = "user";
    public static final String SPECIALFOLDER_TOVALIDATE = "tovalidate";

    public static String getProfile(String[] profiles) {
        SilverpeasRole flag = SilverpeasRole.user;
        block6: for (String profile : profiles) {
            SilverpeasRole role = SilverpeasRole.valueOf((String)profile);
            switch (role) {
                case admin: {
                    return SilverpeasRole.admin.toString();
                }
                case publisher: {
                    flag = SilverpeasRole.publisher;
                    continue block6;
                }
                case writer: {
                    if (flag == SilverpeasRole.publisher) continue block6;
                    flag = SilverpeasRole.writer;
                    continue block6;
                }
                case supervisor: {
                    flag = SilverpeasRole.supervisor;
                }
            }
        }
        return flag.toString();
    }

    public static void checkIndex(PublicationDetail pubDetail) {
        if (KmeliaHelper.isIndexable(pubDetail)) {
            pubDetail.setIndexOperation(0);
        } else {
            pubDetail.setIndexOperation(1);
        }
    }

    public static boolean isIndexable(PublicationDetail pubDetail) {
        return pubDetail.isIndexable();
    }

    public static String extractObjectIdFromURL(String url) {
        return url.substring(url.indexOf("Id=") + 3, url.length());
    }

    public static String extractObjectTypeFromURL(String url) {
        return url.substring(url.indexOf("Type=") + 5, url.lastIndexOf("&"));
    }

    public static String getPublicationUrl(PublicationDetail pubDetail, NodePK nodePK) {
        if (pubDetail.isAlias() && nodePK != null) {
            return URLManager.getSimpleURL((int)2, (String)pubDetail.getPK().getId(), (String)nodePK.getInstanceId(), (boolean)false);
        }
        return URLManager.getSimpleURL((int)2, (String)pubDetail.getPK().getId(), (boolean)false);
    }

    public static String getNodeUrl(NodeDetail nodeDetail) {
        return URLManager.getSimpleURL((int)3, (String)nodeDetail.getNodePK().getId(), (String)nodeDetail.getNodePK().getInstanceId(), (boolean)false);
    }

    public static String getDocumentUrl(PublicationDetail pubDetail, SimpleDocument document) {
        return "/Rkmelia/" + document.getPk().getInstanceId() + "/searchResult?Type=Document&Id=" + pubDetail.getPK().getId() + "&DocumentId=" + document.getId() + "&FileOpened=0";
    }

    public static boolean isToolbox(String componentId) {
        return componentId.startsWith("toolbox");
    }

    public static boolean isKmax(String componentId) {
        return componentId.startsWith("kmax");
    }

    public static boolean isKmelia(String componentId) {
        return componentId.startsWith("kmelia");
    }

    public static boolean isToValidateFolder(String id) {
        return SPECIALFOLDER_TOVALIDATE.equalsIgnoreCase(id);
    }
}

