/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.kmelia.notification;

import com.silverpeas.kmelia.notification.AbstractKmeliaUserNotification;
import com.silverpeas.notification.model.NotificationResourceData;
import com.silverpeas.util.template.SilverpeasTemplate;
import com.stratelia.silverpeas.notificationManager.constant.NotifAction;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.kmelia.control.ejb.KmeliaHelper;
import com.stratelia.webactiv.util.node.model.NodePK;
import com.stratelia.webactiv.util.publication.model.PublicationDetail;

public abstract class AbstractKmeliaPublicationUserNotification
extends AbstractKmeliaUserNotification<PublicationDetail> {
    private final NodePK nodePK;
    private final NotifAction action;
    private final String senderName;

    protected AbstractKmeliaPublicationUserNotification(NodePK nodePK, PublicationDetail resource, NotifAction action) {
        this(nodePK, resource, action, null);
    }

    protected AbstractKmeliaPublicationUserNotification(NodePK nodePK, PublicationDetail resource, NotifAction action, String senderName) {
        super(resource, null, null);
        this.nodePK = nodePK;
        this.action = action;
        this.senderName = senderName;
    }

    protected void performTemplateData(String language, PublicationDetail resource, SilverpeasTemplate template) {
        this.getNotificationMetaData().addLanguage(language, this.getBundle(language).getString(this.getBundleSubjectKey(), this.getTitle()), "");
        template.setAttribute("path", (Object)this.getPath(language));
        template.setAttribute("publication", (Object)resource);
        template.setAttribute("publicationName", (Object)resource.getName(language));
        template.setAttribute("publicationDesc", (Object)resource.getDescription(language));
        template.setAttribute("publicationKeywords", (Object)resource.getKeywords(language));
        template.setAttribute("senderName", (Object)this.getSenderName());
    }

    protected void performNotificationResource(String language, PublicationDetail resource, NotificationResourceData notificationResourceData) {
        notificationResourceData.setResourceName(resource.getName(language));
        notificationResourceData.setResourceDescription(resource.getDescription(language));
    }

    protected boolean stopWhenNoUserToNotify() {
        return !NotifAction.REPORT.equals((Object)this.action);
    }

    protected String getResourceURL(PublicationDetail resource) {
        return KmeliaHelper.getPublicationUrl(resource, this.getNodePK());
    }

    protected NodePK getNodePK() {
        return this.nodePK;
    }

    protected final String getPath(String language) {
        if (this.nodePK == null) {
            return "";
        }
        return this.getHTMLNodePath(this.nodePK, language);
    }

    protected String getSenderName() {
        return this.senderName;
    }

    protected NotifAction getAction() {
        return this.action;
    }

    protected String getComponentInstanceId() {
        return ((PublicationDetail)this.getResource()).getInstanceId();
    }

    protected String getSender() {
        if (NotifAction.REPORT.equals((Object)this.action)) {
            return null;
        }
        if (NotifAction.CREATE.equals((Object)this.action)) {
            String userId = ((PublicationDetail)this.getResource()).getCreatorId();
            UserDetail creator = UserDetail.getById((String)userId);
            if (!creator.isActivatedState()) {
                return ((PublicationDetail)this.getResource()).getUpdaterId();
            }
            return userId;
        }
        return ((PublicationDetail)this.getResource()).getUpdaterId();
    }

    protected String getContributionAccessLinkLabelBundleKey() {
        return "kmelia.notifPublicationLinkLabel";
    }
}

