/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.kmelia.workflowextensions;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import com.silverpeas.form.DataRecord;
import com.silverpeas.form.DataRecordUtil;
import com.silverpeas.form.Field;
import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.Form;
import com.silverpeas.form.FormException;
import com.silverpeas.form.displayers.WysiwygFCKFieldDisplayer;
import com.silverpeas.form.fieldType.ExplorerField;
import com.silverpeas.form.fieldType.FileField;
import com.silverpeas.form.form.HtmlForm;
import com.silverpeas.form.form.XmlForm;
import com.silverpeas.form.record.GenericFieldTemplate;
import com.silverpeas.publicationTemplate.PublicationTemplateException;
import com.silverpeas.publicationTemplate.PublicationTemplateImpl;
import com.silverpeas.publicationTemplate.PublicationTemplateManager;
import com.silverpeas.util.ForeignPK;
import com.silverpeas.util.StringUtil;
import com.silverpeas.workflow.api.WorkflowException;
import com.silverpeas.workflow.api.instance.HistoryStep;
import com.silverpeas.workflow.api.instance.ProcessInstance;
import com.silverpeas.workflow.api.instance.UpdatableProcessInstance;
import com.silverpeas.workflow.api.model.Action;
import com.silverpeas.workflow.api.model.Parameter;
import com.silverpeas.workflow.api.model.State;
import com.silverpeas.workflow.external.impl.ExternalActionImpl;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.OrganizationController;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.kmelia.control.ejb.KmeliaBm;
import com.stratelia.webactiv.kmelia.model.KmeliaRuntimeException;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.EJBUtilitaire;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.WAPrimaryKey;
import com.stratelia.webactiv.util.node.control.NodeBm;
import com.stratelia.webactiv.util.node.model.NodeDetail;
import com.stratelia.webactiv.util.node.model.NodePK;
import com.stratelia.webactiv.util.publication.model.PublicationDetail;
import com.stratelia.webactiv.util.publication.model.PublicationPK;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.htmlparser.jericho.Source;
import org.silverpeas.attachment.AttachmentException;
import org.silverpeas.attachment.AttachmentService;
import org.silverpeas.attachment.AttachmentServiceFactory;
import org.silverpeas.attachment.model.DocumentType;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.model.SimpleDocumentPK;
import org.silverpeas.attachment.util.SimpleDocumentList;

public class SendInKmelia
extends ExternalActionImpl {
    private String targetId = "unknown";
    private String topicId = "unknown";
    private String pubTitle = "unknown";
    private String pubDesc = null;
    private String role = "unknown";
    private String xmlFormName = null;
    private boolean addPDFHistory = true;
    private boolean addPDFHistoryFirst = true;
    private String pdfHistoryName = null;
    private OrganizationController orga = null;
    private String userId = null;
    private final String ADMIN_ID = "0";

    public void execute() {
        this.setRole(this.getEvent().getUserRoleName());
        Parameter parameter = this.getTriggerParameter("explorerFieldName");
        if (parameter != null && StringUtil.isDefined((String)parameter.getValue())) {
            String explorerFieldName = parameter.getValue();
            ExplorerField explorer = null;
            try {
                explorer = (ExplorerField)this.getProcessInstance().getField(explorerFieldName);
            }
            catch (WorkflowException e1) {
                SilverTrace.error((String)"processManager", (String)"SendInKmelia.execute", (String)"err.CANT_GET_TOPIC", (Throwable)e1);
            }
            ForeignPK pk = (ForeignPK)explorer.getObjectValue();
            this.targetId = pk.getInstanceId();
            this.topicId = pk.getId();
        } else {
            this.targetId = this.getTriggerParameter("targetComponentId").getValue();
            Parameter paramTopicPath = this.getTriggerParameter("targetFolderPath");
            if (paramTopicPath != null && StringUtil.isDefined((String)paramTopicPath.getValue())) {
                try {
                    String path = DataRecordUtil.applySubstitution((String)paramTopicPath.getValue(), (DataRecord)this.getProcessInstance().getAllDataRecord(this.role, "fr"), (String)"fr");
                    this.topicId = this.getNodeId(path);
                }
                catch (WorkflowException e) {
                    SilverTrace.error((String)"workflowEngine", (String)"SendInKmelia.execute()", (String)"root.MSG_GEN_ERROR", (Throwable)e);
                    this.topicId = "0";
                }
            } else {
                this.topicId = this.getTriggerParameter("targetTopicId").getValue();
            }
        }
        this.pubTitle = this.getTriggerParameter("pubTitle").getValue();
        Parameter paramDescription = this.getTriggerParameter("pubDescription");
        if (paramDescription != null && StringUtil.isDefined((String)paramDescription.getValue())) {
            this.pubDesc = paramDescription.getValue();
        }
        if (this.getTriggerParameter("xmlFormName") != null) {
            this.xmlFormName = this.getTriggerParameter("xmlFormName").getValue();
            if (StringUtil.isDefined((String)this.xmlFormName) && this.xmlFormName.lastIndexOf(".xml") != -1) {
                this.xmlFormName = this.xmlFormName.substring(0, this.xmlFormName.lastIndexOf(".xml"));
            }
        }
        boolean formIsUsed = StringUtil.isDefined((String)this.xmlFormName);
        if (this.getTriggerParameter("addPDFHistory") != null) {
            Parameter paramPDFName;
            this.addPDFHistory = StringUtil.getBooleanValue((String)this.getTriggerParameter("addPDFHistory").getValue());
            if (this.getTriggerParameter("addPDFHistoryFirst") != null) {
                this.addPDFHistoryFirst = StringUtil.getBooleanValue((String)this.getTriggerParameter("addPDFHistoryFirst").getValue());
            }
            if ((paramPDFName = this.getTriggerParameter("pdfHistoryName")) != null) {
                this.pdfHistoryName = this.getTriggerParameter("pdfHistoryName").getValue();
            }
        }
        PublicationPK pubPK = new PublicationPK("0", this.getTargetId());
        Date now = new Date();
        String pubName = this.getProcessInstance().getTitle(this.getRole(), this.getLanguage());
        if (StringUtil.isDefined((String)this.pubTitle)) {
            try {
                pubName = DataRecordUtil.applySubstitution((String)this.pubTitle, (DataRecord)this.getProcessInstance().getAllDataRecord(this.role, "fr"), (String)"fr");
            }
            catch (WorkflowException e) {
                SilverTrace.error((String)"workflowEngine", (String)"SendInKmelia.execute()", (String)"root.MSG_GEN_ERROR", (Throwable)e);
            }
        }
        String desc = "";
        if (StringUtil.isDefined((String)this.pubDesc)) {
            try {
                desc = DataRecordUtil.applySubstitution((String)this.pubDesc, (DataRecord)this.getProcessInstance().getAllDataRecord(this.role, "fr"), (String)"fr");
            }
            catch (WorkflowException e) {
                SilverTrace.error((String)"workflowEngine", (String)"SendInKmelia.execute()", (String)"root.MSG_GEN_ERROR", (Throwable)e);
            }
        }
        this.userId = this.getBestUserDetail().getId();
        PublicationDetail pubDetail = new PublicationDetail(pubPK, pubName, desc, now, now, null, this.userId, 1, null, null, null);
        if (formIsUsed) {
            pubDetail.setInfoId(this.xmlFormName);
        }
        KmeliaBm kmelia = this.getKmeliaBm();
        String pubId = kmelia.createPublicationIntoTopic(pubDetail, new NodePK(this.getTopicId(), this.getTargetId()));
        pubPK.setId(pubId);
        if (this.addPDFHistory && this.addPDFHistoryFirst) {
            this.addPdfHistory(pubPK, this.userId);
        }
        ForeignPK fromPK = new ForeignPK(this.getProcessInstance().getInstanceId(), this.getProcessInstance().getModelId());
        ForeignPK toPK = new ForeignPK((WAPrimaryKey)pubPK);
        this.copyFiles(fromPK, toPK, DocumentType.attachment, DocumentType.attachment);
        if (this.addPDFHistory && !this.addPDFHistoryFirst) {
            this.addPdfHistory(pubPK, this.userId);
        }
        PublicationDetail newPubli = this.getKmeliaBm().getPublicationDetail(pubPK);
        newPubli.setStatusMustBeChecked(false);
        this.getKmeliaBm().updatePublication(newPubli);
        if (formIsUsed) {
            this.populateFields(pubId, fromPK, toPK);
        } else {
            this.copyFiles(fromPK, toPK, DocumentType.form, DocumentType.attachment);
        }
        this.orga = null;
    }

    public void populateFields(String pubId, ForeignPK fromPK, ForeignPK toPK) {
        UpdatableProcessInstance currentProcessInstance = (UpdatableProcessInstance)this.getProcessInstance();
        try {
            PublicationTemplateManager.getInstance().addDynamicPublicationTemplate(this.targetId + ":" + this.xmlFormName, this.xmlFormName + ".xml");
            PublicationTemplateImpl pubTemplate = (PublicationTemplateImpl)PublicationTemplateManager.getInstance().getPublicationTemplate(this.targetId + ":" + this.xmlFormName);
            DataRecord record = pubTemplate.getRecordSet().getEmptyRecord();
            record.setId(pubId);
            for (String fieldName : record.getFieldNames()) {
                SilverTrace.debug((String)"workflowEngine", (String)"SendInKmelia.populateFields", (String)("Process fieldName =" + fieldName));
                Object fieldValue = null;
                try {
                    Field fieldOfFolder = currentProcessInstance.getField(fieldName);
                    fieldValue = fieldOfFolder.getObjectValue();
                    if (fieldOfFolder instanceof FileField) {
                        SilverTrace.info((String)"workflowEngine", (String)"SendInKmelia.populateFields", (String)"Process file copy");
                        fieldValue = this.copyFormFile(fromPK, toPK, ((FileField)fieldOfFolder).getAttachmentId());
                    }
                }
                catch (WorkflowException e) {
                    SilverTrace.debug((String)"workflowEngine", (String)"SendInKmelia.populateFields", (String)("fill fieldname=" + fieldName + " with value " + fieldValue), (Throwable)e);
                }
                SilverTrace.debug((String)"workflowEngine", (String)"SendInKmelia.populateFields", (String)("fill fieldname=" + fieldName + " with value " + fieldValue));
                record.getField(fieldName).setObjectValue(fieldValue);
            }
            pubTemplate.getRecordSet().save(record);
        }
        catch (PublicationTemplateException e) {
            SilverTrace.error((String)"workflowEngine", (String)"SendInKmelia.populateFields()", (String)"workflowEngine.CANNOT_UPDATE_PUBLICATION", (Throwable)e);
        }
        catch (FormException e) {
            SilverTrace.error((String)"workflowEngine", (String)"SendInKmelia.populateFields()", (String)"workflowEngine.CANNOT_UPDATE_PUBLICATION", (Throwable)e);
        }
    }

    private String copyFormFile(ForeignPK fromPK, ForeignPK toPK, String attachmentId) {
        AttachmentService service;
        SimpleDocument attachment = null;
        if (StringUtil.isDefined((String)attachmentId) && (attachment = (service = AttachmentServiceFactory.getAttachmentService()).searchDocumentById(new SimpleDocumentPK(attachmentId, fromPK.getInstanceId()), null)) != null) {
            SimpleDocumentPK copyPK = this.copyFile(attachment, toPK);
            return copyPK.getId();
        }
        return null;
    }

    private Map<String, String> copyFiles(ForeignPK fromPK, ForeignPK toPK, DocumentType fromType, DocumentType toType) {
        HashMap<String, String> fileIds = new HashMap<String, String>();
        try {
            SimpleDocumentList origins = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKeyAndType((WAPrimaryKey)fromPK, fromType, this.getLanguage());
            for (SimpleDocument origin : origins) {
                SimpleDocumentPK copyPk = this.copyFile(origin, toPK, toType);
                fileIds.put(origin.getId(), copyPk.getId());
            }
        }
        catch (AttachmentException e) {
            SilverTrace.error((String)"workflowEngine", (String)"SendInKmelia.copyFiles", (String)"CANNOT_PASTE_FILES", (Throwable)e);
        }
        return fileIds;
    }

    private SimpleDocumentPK copyFile(SimpleDocument file, ForeignPK toPK) {
        return this.copyFile(file, toPK);
    }

    private SimpleDocumentPK copyFile(SimpleDocument file, ForeignPK toPK, DocumentType type) {
        if (type != null) {
            file.setDocumentType(type);
        }
        return AttachmentServiceFactory.getAttachmentService().copyDocument(file, toPK);
    }

    private byte[] generatePDF(ProcessInstance instance) {
        Document document = new Document();
        try {
            HistoryStep[] steps;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PdfWriter.getInstance((Document)document, (OutputStream)baos);
            document.open();
            for (HistoryStep historyStep : steps = instance.getHistorySteps()) {
                this.generatePDFStep(historyStep, document);
            }
            document.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            SilverTrace.error((String)"workflowEngine", (String)"SendInKmelia.generatePDF()", (String)"root.MSG_GEN_ERROR", (Throwable)e);
            return null;
        }
    }

    private void generatePDFStep(HistoryStep step, Document document) {
        if (step != null) {
            this.generatePDFStepHeader(step, document);
            this.generatePDFStepContent(step, document);
        }
    }

    private void generatePDFStepHeader(HistoryStep step, Document document) {
        try {
            String activity = "";
            if (step.getResolvedState() != null) {
                State resolvedState = step.getProcessInstance().getProcessModel().getState(step.getResolvedState());
                activity = resolvedState.getLabel(this.getRole(), this.getLanguage());
            }
            String sAction = null;
            try {
                if ("#question#".equals(step.getAction())) {
                    sAction = this.getString("processManager.question");
                } else if ("#response#".equals(step.getAction())) {
                    sAction = this.getString("processManager.response");
                } else if ("#reAssign#".equals(step.getAction())) {
                    sAction = this.getString("processManager.reAffectation");
                } else {
                    Action action = step.getProcessInstance().getProcessModel().getAction(step.getAction());
                    sAction = action.getLabel(this.getRole(), this.getLanguage());
                }
            }
            catch (WorkflowException we) {
                sAction = "##";
            }
            String actor = step.getUser().getFullName();
            String date = DateUtil.getOutputDateAndHour((Date)step.getActionDate(), (String)this.getLanguage());
            String header = "";
            if (StringUtil.isDefined((String)activity)) {
                header = header + activity + " - ";
            }
            header = header + sAction + " (" + actor + " - " + date + ")";
            Font fontHeader = new Font(1, 12.0f, 0);
            PdfPCell pCell = new PdfPCell(new Phrase(header, fontHeader));
            pCell.setFixedHeight(28.0f);
            pCell.setBackgroundColor(new Color(239, 239, 239));
            pCell.setVerticalAlignment(5);
            PdfPTable pTable = new PdfPTable(1);
            pTable.setWidthPercentage(100.0f);
            pTable.addCell(pCell);
            document.add((Element)pTable);
        }
        catch (Exception e) {
            SilverTrace.error((String)"workflowEngine", (String)"SendInKmelia.generatePDFStep()", (String)"root.MSG_GEN_ERROR", (Throwable)e);
        }
    }

    private void generatePDFStepContent(HistoryStep step, Document document) {
        try {
            Form form = "#question#".equals(step.getAction()) || "#response#".equals(step.getAction()) ? null : this.getProcessInstance().getProcessModel().getPresentationForm(step.getAction(), this.getRole(), this.getLanguage());
            if (form != null && step.getActionRecord() != null) {
                XmlForm xmlForm = null;
                HtmlForm htmlForm = null;
                if (form instanceof XmlForm) {
                    xmlForm = (XmlForm)form;
                }
                if (form instanceof HtmlForm) {
                    htmlForm = (HtmlForm)form;
                }
                DataRecord data = step.getActionRecord();
                float[] colsWidth = new float[]{25.0f, 75.0f};
                PdfPTable tableContent = new PdfPTable(colsWidth);
                tableContent.setWidthPercentage(100.0f);
                String fieldValue = "";
                Font fontLabel = new Font(1, 10.0f, 1);
                Font fontValue = new Font(1, 10.0f, 0);
                List fieldTemplates = null;
                if (xmlForm != null) {
                    fieldTemplates = xmlForm.getFieldTemplates();
                }
                if (htmlForm != null) {
                    fieldTemplates = htmlForm.getFieldTemplates();
                }
                for (FieldTemplate fieldTemplate1 : fieldTemplates) {
                    try {
                        GenericFieldTemplate fieldTemplate = (GenericFieldTemplate)fieldTemplate1;
                        String fieldLabel = fieldTemplate.getLabel("fr");
                        Field field = data.getField(fieldTemplate.getFieldName());
                        String componentId = step.getProcessInstance().getProcessModel().getModelId();
                        if ("wysiwyg".equals(fieldTemplate.getDisplayerName())) {
                            String file = WysiwygFCKFieldDisplayer.getFile((String)componentId, (String)this.getProcessInstance().getInstanceId(), (String)fieldTemplate.getFieldName(), (String)this.getLanguage());
                            Source source = new Source((InputStream)new FileInputStream(file));
                            if (source != null) {
                                fieldValue = source.getTextExtractor().toString();
                            }
                        } else if ("file".equals(fieldTemplate.getDisplayerName()) && StringUtil.isDefined((String)field.getValue())) {
                            SimpleDocument doc = AttachmentServiceFactory.getAttachmentService().searchDocumentById(new SimpleDocumentPK(field.getValue(), componentId), null);
                            if (doc != null) {
                                fieldValue = doc.getFilename();
                            }
                        } else if ("date".equals(fieldTemplate.getTypeName())) {
                            fieldValue = DateUtil.getOutputDate((String)field.getValue(), (String)"fr");
                        } else {
                            fieldTemplate.setDisplayerName("simpletext");
                            fieldValue = field.getValue(this.getLanguage());
                        }
                        PdfPCell cell = new PdfPCell(new Phrase(fieldLabel, fontLabel));
                        cell.setBorderWidth(0.0f);
                        cell.setPaddingBottom(5.0f);
                        tableContent.addCell(cell);
                        cell = new PdfPCell(new Phrase(fieldValue, fontValue));
                        cell.setBorderWidth(0.0f);
                        cell.setPaddingBottom(5.0f);
                        tableContent.addCell(cell);
                    }
                    catch (Exception e) {
                        SilverTrace.warn((String)"workflowEngine", (String)"SendInKmelia.generatePDFStep()", (String)"CANT_DISPLAY_DATA_OF_STEP", (Throwable)e);
                    }
                }
                document.add((Element)tableContent);
            }
        }
        catch (Exception e) {
            SilverTrace.error((String)"workflowEngine", (String)"SendInKmelia.generatePDFStep()", (String)"root.MSG_GEN_ERROR", (Throwable)e);
        }
    }

    private OrganizationController getOrganizationController() {
        if (this.orga == null) {
            this.orga = new OrganizationController();
        }
        return this.orga;
    }

    private String getString(String key) {
        return key;
    }

    private String getTargetId() {
        return this.targetId;
    }

    private String getTopicId() {
        return this.topicId;
    }

    private String getLanguage() {
        return "fr";
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    private KmeliaBm getKmeliaBm() {
        try {
            return (KmeliaBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.KMELIABM_EJBHOME, KmeliaBm.class);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("SendInKmelia.getKmeliaBm()", 4, "root.EX_CANT_GET_REMOTE_OBJECT", e);
        }
    }

    private UserDetail getBestUserDetail() {
        String currentUserId = "0";
        if (this.getEvent().getUser() != null) {
            currentUserId = this.getEvent().getUser().getUserId();
        }
        return this.getOrganizationController().getUserDetail(currentUserId);
    }

    private void addPdfHistory(PublicationPK pubPK, String userId) {
        String fileName = "processHistory_" + this.getProcessInstance().getInstanceId() + ".pdf";
        if (StringUtil.isDefined((String)this.pdfHistoryName) && !(fileName = this.pdfHistoryName).endsWith(".pdf")) {
            fileName = fileName + ".pdf";
        }
        byte[] pdf = this.generatePDF(this.getProcessInstance());
        this.getKmeliaBm().addAttachmentToPublication(pubPK, userId, fileName, "", pdf);
    }

    private String getNodeId(String explicitPath) {
        String[] path = explicitPath.substring(1).split("/");
        NodePK nodePK = new NodePK("unknown", this.targetId);
        String parentId = "0";
        for (String name : path) {
            NodeDetail existingNode = null;
            try {
                existingNode = this.getNodeBm().getDetailByNameAndFatherId(nodePK, name, Integer.parseInt(parentId));
            }
            catch (Exception e) {
                SilverTrace.info((String)"workflowEngine", (String)"SendInKmelia.getNodeId()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("node named '" + name + "' in path '" + explicitPath + "' does not exist"));
            }
            if (existingNode != null) {
                parentId = existingNode.getNodePK().getId();
                continue;
            }
            NodeDetail newNode = new NodeDetail();
            newNode.setName(name);
            newNode.setNodePK(new NodePK("unknown", this.targetId));
            newNode.setFatherPK(new NodePK(parentId, this.targetId));
            newNode.setCreatorId(this.userId);
            NodePK newNodePK = null;
            try {
                newNodePK = this.getNodeBm().createNode(newNode);
            }
            catch (Exception e) {
                SilverTrace.error((String)"workflowEngine", (String)"SendInKmelia.getNodeId()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("Can't create node named '" + name + "' in path '" + explicitPath + "'"), (Throwable)e);
                return "-1";
            }
            parentId = newNodePK.getId();
        }
        return parentId;
    }

    protected NodeBm getNodeBm() {
        return (NodeBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.NODEBM_EJBHOME, NodeBm.class);
    }
}

