/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.kmelia;

import com.stratelia.silverpeas.classifyEngine.ClassifyEngine;
import com.stratelia.silverpeas.contentManager.ContentInterface;
import com.stratelia.silverpeas.contentManager.ContentManager;
import com.stratelia.silverpeas.contentManager.ContentManagerException;
import com.stratelia.silverpeas.contentManager.SilverContentVisibility;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.kmelia.KmeliaSecurity;
import com.stratelia.webactiv.kmelia.model.KmeliaRuntimeException;
import com.stratelia.webactiv.util.EJBUtilitaire;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.publication.control.PublicationBm;
import com.stratelia.webactiv.util.publication.model.PublicationDetail;
import com.stratelia.webactiv.util.publication.model.PublicationPK;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class KmeliaContentManager
implements ContentInterface,
Serializable {
    private static final long serialVersionUID = 3525407153404515235L;
    private ContentManager contentManager = null;
    private PublicationBm currentPublicationBm = null;

    public List getSilverContentById(List ids, String peasId, String userId, List userRoles) {
        if (this.getContentManager() == null) {
            return new ArrayList();
        }
        return this.getHeaders(this.makePKArray(ids, peasId), peasId, userId);
    }

    public int getSilverObjectId(String pubId, String peasId) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaContentManager.getSilverObjectId()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("pubId = " + pubId));
        try {
            return this.getContentManager().getSilverContentId(pubId, peasId);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaContentManager.getSilverObjectId()", 4, "kmelia.EX_IMPOSSIBLE_DOBTENIR_LE_SILVEROBJECTID", e);
        }
    }

    public int createSilverContent(Connection con, PublicationDetail pubDetail, String userId) throws ContentManagerException {
        SilverContentVisibility scv = new SilverContentVisibility(pubDetail.getBeginDate(), pubDetail.getEndDate(), this.isVisible(pubDetail));
        SilverTrace.info((String)"kmelia", (String)"KmeliaContentManager.createSilverContent()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("SilverContentVisibility = " + scv.toString()));
        return this.getContentManager().addSilverContent(con, pubDetail.getPK().getId(), pubDetail.getPK().getComponentName(), userId, scv);
    }

    public void updateSilverContentVisibility(PublicationDetail pubDetail) throws ContentManagerException {
        this.updateSilverContentVisibility(pubDetail, this.isVisible(pubDetail));
    }

    private void updateSilverContentVisibility(SilverContentVisibility scv, PublicationDetail pubDetail, int silverContentId) throws ContentManagerException {
        if (silverContentId == -1) {
            this.createSilverContent(null, pubDetail, pubDetail.getUpdaterId());
        } else {
            this.getContentManager().updateSilverContentVisibilityAttributes(scv, pubDetail.getPK().getComponentName(), silverContentId);
        }
        ClassifyEngine.clearCache();
    }

    public void updateSilverContentVisibility(PublicationDetail pubDetail, boolean isVisible) throws ContentManagerException {
        int silverContentId = this.getContentManager().getSilverContentId(pubDetail.getPK().getId(), pubDetail.getPK().getComponentName());
        SilverContentVisibility scv = new SilverContentVisibility(pubDetail.getBeginDate(), pubDetail.getEndDate(), isVisible);
        SilverTrace.info((String)"kmelia", (String)"KmeliaContentManager.updateSilverContentVisibility()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("SilverContentVisibility = " + scv.toString()));
        this.updateSilverContentVisibility(scv, pubDetail, silverContentId);
    }

    public void deleteSilverContent(Connection con, PublicationPK pubPK) throws ContentManagerException {
        int contentId = this.getContentManager().getSilverContentId(pubPK.getId(), pubPK.getComponentName());
        if (contentId != -1) {
            SilverTrace.info((String)"kmelia", (String)"KmeliaContentManager.deleteSilverContent()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("pubId = " + pubPK.getId() + ", contentId = " + contentId));
            this.getContentManager().removeSilverContent(con, contentId, pubPK.getComponentName());
        }
    }

    private boolean isVisible(PublicationDetail pubDetail) {
        return "Valid".equals(pubDetail.getStatus());
    }

    private ArrayList<PublicationPK> makePKArray(List<Integer> idList, String peasId) {
        ArrayList<PublicationPK> pks = new ArrayList<PublicationPK>();
        for (int contentId : idList) {
            try {
                String id = this.getContentManager().getInternalContentId(contentId);
                PublicationPK pubPK = new PublicationPK(id, peasId);
                pks.add(pubPK);
            }
            catch (ClassCastException ignored) {
            }
            catch (ContentManagerException ignored) {}
        }
        return pks;
    }

    private List<PublicationDetail> getHeaders(List<PublicationPK> ids, String componentId, String userId) {
        ArrayList<PublicationDetail> headers = new ArrayList<PublicationDetail>();
        KmeliaSecurity security = new KmeliaSecurity();
        boolean checkRights = security.isRightsOnTopicsEnabled(componentId);
        Collection publicationDetails = this.getPublicationBm().getPublications(ids);
        for (PublicationDetail pubDetail : publicationDetails) {
            if (checkRights && !security.isPublicationAvailable(pubDetail.getPK(), userId)) continue;
            pubDetail.setIconUrl("kmeliaSmall.gif");
            headers.add(pubDetail);
        }
        return headers;
    }

    private ContentManager getContentManager() {
        if (this.contentManager == null) {
            try {
                this.contentManager = new ContentManager();
            }
            catch (Exception e) {
                SilverTrace.fatal((String)"kmelia", (String)"KmeliaContentManager", (String)"root.EX_UNKNOWN_CONTENT_MANAGER", (Throwable)e);
            }
        }
        return this.contentManager;
    }

    private PublicationBm getPublicationBm() {
        if (this.currentPublicationBm == null) {
            try {
                this.currentPublicationBm = (PublicationBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.PUBLICATIONBM_EJBHOME, PublicationBm.class);
            }
            catch (Exception e) {
                throw new KmeliaRuntimeException("KmeliaContentManager.getPublicationBm()", 4, "kmelia.EX_IMPOSSIBLE_DE_FABRIQUER_PUBLICATIONBM_HOME", e);
            }
        }
        return this.currentPublicationBm;
    }
}

