/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.component.kmelia;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.SilverpeasRole;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.kmelia.control.ejb.KmeliaHelper;
import com.stratelia.webactiv.util.node.model.NodePK;
import org.silverpeas.core.admin.OrganisationControllerFactory;

public class KmeliaPublicationHelper {
    public static boolean isUserConsideredAsOwner(String instanceId, String currentUserId, String profile, UserDetail ownerDetail) {
        if ("admin".equals(profile) || "publisher".equals(profile) || "supervisor".equals(profile) || ownerDetail != null && currentUserId.equals(ownerDetail.getId()) && "writer".equals(profile)) {
            return true;
        }
        if ("writer".equals(profile)) {
            return StringUtil.getBooleanValue((String)KmeliaPublicationHelper.getParameterValue(instanceId, "coWriting"));
        }
        return false;
    }

    public static boolean isRemovable(String instanceId, String currentUserId, String profile, UserDetail ownerDetail) {
        boolean removeOnlyForAdmin;
        return ("admin".equals(profile) || "publisher".equals(profile) || "supervisor".equals(profile) || ownerDetail != null && currentUserId.equals(ownerDetail.getId()) && "writer".equals(profile)) && (!(removeOnlyForAdmin = StringUtil.getBooleanValue((String)KmeliaPublicationHelper.getParameterValue(instanceId, "suppressionOnlyForAdmin"))) || "admin".equals(profile) && removeOnlyForAdmin);
    }

    public static boolean isCanBeCut(String instanceId, String currentUserId, String profile, UserDetail ownerDetail) {
        return !KmeliaHelper.isKmax(instanceId) && KmeliaPublicationHelper.isUserConsideredAsOwner(instanceId, currentUserId, profile, ownerDetail);
    }

    public static boolean isCreationAllowed(NodePK pk, String profile) {
        boolean publicationsInTopic = !pk.isRoot() || pk.isRoot() && (KmeliaPublicationHelper.isPublicationsOnRootAllowed(pk.getInstanceId()) || !KmeliaPublicationHelper.isTreeEnabled(pk.getInstanceId()));
        return !SilverpeasRole.user.isInRole(new String[]{profile}) && publicationsInTopic;
    }

    public static boolean isPublicationsOnRootAllowed(String instanceId) {
        String parameterValue = KmeliaPublicationHelper.getParameterValue(instanceId, "nbPubliOnRoot");
        if (StringUtil.isDefined((String)parameterValue)) {
            return Integer.parseInt(parameterValue) == 0;
        }
        return true;
    }

    public static boolean isTreeEnabled(String instanceId) {
        String param = KmeliaPublicationHelper.getParameterValue(instanceId, "istree");
        if (!StringUtil.isDefined((String)param)) {
            return true;
        }
        return "0".equals(param) || "1".equals(param);
    }

    private static String getParameterValue(String instanceId, String name) {
        return OrganisationControllerFactory.getOrganisationController().getComponentParameterValue(instanceId, name);
    }
}

