/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.kmelia.notification;

import com.silverpeas.notification.builder.AbstractTemplateUserNotificationBuilder;
import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import com.stratelia.webactiv.beans.admin.OrganizationController;
import com.stratelia.webactiv.beans.admin.SpaceInst;
import com.stratelia.webactiv.kmelia.model.KmaxRuntimeException;
import com.stratelia.webactiv.kmelia.model.KmeliaRuntimeException;
import com.stratelia.webactiv.util.EJBUtilitaire;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.node.control.NodeBm;
import com.stratelia.webactiv.util.node.model.NodeDetail;
import com.stratelia.webactiv.util.node.model.NodePK;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.silverpeas.core.admin.OrganisationController;

public abstract class AbstractKmeliaUserNotification<T>
extends AbstractTemplateUserNotificationBuilder<T> {
    public AbstractKmeliaUserNotification(T resource) {
        super(resource);
    }

    public AbstractKmeliaUserNotification(T resource, String title, String fileName) {
        super(resource, title, fileName);
    }

    protected String getMultilangPropertyFile() {
        return "org.silverpeas.kmelia.multilang.kmeliaBundle";
    }

    protected String getTemplatePath() {
        return "kmelia";
    }

    protected OrganisationController getOrganisationController() {
        return new OrganizationController();
    }

    protected NodeBm getNodeBm() {
        try {
            return (NodeBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.NODEBM_EJBHOME, NodeBm.class);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("AbstractKmeliaNotificationBuilder.getNodeBm()", 4, "kmelia.EX_IMPOSSIBLE_DE_FABRIQUER_NODEBM_HOME", e);
        }
    }

    protected NodeDetail getNodeHeader(NodePK pk) {
        NodeDetail nodeDetail = null;
        try {
            nodeDetail = this.getNodeBm().getHeader(pk);
        }
        catch (Exception e) {
            throw new KmaxRuntimeException("AbstractKmeliaNotificationBuilder.getNodeHeader()", 4, "kmax.EX_IMPOSSIBLE_DOBTENIR_LE_NOEUD", e);
        }
        return nodeDetail;
    }

    protected String getHTMLNodePath(NodePK nodePK, String language) {
        String htmlPath = "";
        if (nodePK != null) {
            List path = (List)this.getNodeBm().getPath(nodePK);
            if (path.size() > 0) {
                path.remove(path.size() - 1);
            }
            htmlPath = this.getSpacesPath(nodePK.getInstanceId(), language) + this.getComponentLabel(nodePK.getInstanceId(), language);
            if (!path.isEmpty()) {
                htmlPath = htmlPath + " > " + this.displayPath(path, 10, language);
            }
        }
        return htmlPath;
    }

    private String getSpacesPath(String componentId, String language) {
        String spacesPath = "";
        List spaces = this.getOrganisationController().getSpacePathToComponent(componentId);
        Iterator iSpaces = spaces.iterator();
        SpaceInst spaceInst = null;
        while (iSpaces.hasNext()) {
            spaceInst = (SpaceInst)iSpaces.next();
            spacesPath = spacesPath + spaceInst.getName(language);
            spacesPath = spacesPath + " > ";
        }
        return spacesPath;
    }

    private String getComponentLabel(String componentId, String language) {
        ComponentInstLight component = this.getOrganisationController().getComponentInstLight(componentId);
        String componentLabel = "";
        if (component != null) {
            componentLabel = component.getLabel(language);
        }
        return componentLabel;
    }

    private String displayPath(Collection<NodeDetail> path, int beforeAfter, String language) {
        StringBuilder pathString = new StringBuilder();
        boolean first = true;
        ArrayList<NodeDetail> pathAsList = new ArrayList<NodeDetail>(path);
        Collections.reverse(pathAsList);
        for (NodeDetail nodeInPath : pathAsList) {
            if (!first) {
                pathString.append(" > ");
            }
            first = false;
            pathString.append(nodeInPath.getName(language));
        }
        return pathString.toString();
    }
}

