/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.kmelia.notification;

import com.silverpeas.kmelia.notification.AbstractKmeliaUserNotification;
import com.silverpeas.notification.model.NotificationResourceData;
import com.silverpeas.util.template.SilverpeasTemplate;
import com.stratelia.silverpeas.notificationManager.constant.NotifAction;
import com.stratelia.webactiv.beans.admin.ObjectType;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.kmelia.control.ejb.KmeliaHelper;
import com.stratelia.webactiv.kmelia.model.KmeliaRuntimeException;
import com.stratelia.webactiv.util.node.model.NodeDetail;
import com.stratelia.webactiv.util.node.model.NodePK;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class KmeliaTopicUserNotification
extends AbstractKmeliaUserNotification<NodeDetail> {
    private final NodePK nodePK;
    private final NodeDetail fatherDetail;
    private final String alertType;
    private final NotifAction action;

    public KmeliaTopicUserNotification(NodePK nodePK, NodePK fatherPK, String alertType) {
        super(null, null, "notificationCreateTopic");
        this.nodePK = nodePK;
        this.alertType = alertType;
        try {
            this.setResource(this.getNodeBm().getHeader(nodePK));
            if (fatherPK != null) {
                this.action = NotifAction.CREATE;
                this.fatherDetail = this.getNodeBm().getHeader(fatherPK);
            } else {
                this.action = NotifAction.UPDATE;
                this.fatherDetail = null;
            }
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaBmEJB.topicCreationAlert()", 4, "kmelia.EX_IMPOSSIBLE_DALERTER_POUR_MANIPULATION_THEME", e);
        }
    }

    protected String getBundleSubjectKey() {
        return "kmelia.NewTopic";
    }

    protected Collection<String> getUserIdsToNotify() {
        Object users;
        boolean haveRights = ((NodeDetail)this.getResource()).haveRights();
        int rightsDependOn = ((NodeDetail)this.getResource()).getRightsDependsOn();
        if (this.fatherDetail != null) {
            haveRights = this.fatherDetail.haveRights();
            rightsDependOn = this.fatherDetail.getRightsDependsOn();
        }
        if (!haveRights) {
            if ("All".equals(this.alertType)) {
                UserDetail[] userDetails = this.getOrganisationController().getAllUsers(this.getComponentInstanceId());
                if (userDetails != null) {
                    users = new String[userDetails.length];
                    int i = 0;
                    for (UserDetail userDetail : userDetails) {
                        users[i++] = userDetail.getId();
                    }
                } else {
                    users = null;
                }
            } else if ("Publisher".equals(this.alertType)) {
                ArrayList<String> profileNames = new ArrayList<String>();
                profileNames.add("admin");
                profileNames.add("publisher");
                profileNames.add("writer");
                users = this.getOrganisationController().getUsersIdsByRoleNames(this.getComponentInstanceId(), profileNames);
            } else {
                users = null;
            }
        } else {
            ArrayList<String> profileNames = new ArrayList<String>();
            profileNames.add("admin");
            profileNames.add("publisher");
            profileNames.add("writer");
            if (this.alertType.equals("All")) {
                profileNames.add("user");
                users = this.getOrganisationController().getUsersIdsByRoleNames(this.getComponentInstanceId(), String.valueOf(rightsDependOn), ObjectType.NODE, profileNames);
            } else {
                users = this.alertType.equals("Publisher") ? this.getOrganisationController().getUsersIdsByRoleNames(this.getComponentInstanceId(), String.valueOf(rightsDependOn), ObjectType.NODE, profileNames) : null;
            }
        }
        if (users == null) {
            return null;
        }
        return Arrays.asList(users);
    }

    protected void perform(NodeDetail resource) {
        super.perform((Object)resource);
        this.getNotificationMetaData().displayReceiversInFooter();
    }

    protected void performTemplateData(String language, NodeDetail resource, SilverpeasTemplate template) {
        this.getNotificationMetaData().addLanguage(language, this.getBundle(language).getString(this.getBundleSubjectKey(), this.getTitle()), "");
        template.setAttribute("path", (Object)this.getHTMLNodePath(resource.getFatherPK(), language));
        template.setAttribute("topic", (Object)resource);
        template.setAttribute("topicName", (Object)resource.getName(language));
        template.setAttribute("topicDescription", (Object)resource.getDescription(language));
        template.setAttribute("senderName", (Object)"");
    }

    protected void performNotificationResource(String language, NodeDetail resource, NotificationResourceData notificationResourceData) {
        notificationResourceData.setResourceId((Number)resource.getId());
        notificationResourceData.setResourceType(resource.getType());
        notificationResourceData.setResourceName(resource.getName(language));
        notificationResourceData.setResourceDescription(resource.getDescription(language));
    }

    protected String getResourceURL(NodeDetail resource) {
        return KmeliaHelper.getNodeUrl(resource);
    }

    protected NotifAction getAction() {
        return this.action;
    }

    protected String getComponentInstanceId() {
        return this.nodePK.getInstanceId();
    }

    protected String getSender() {
        return ((NodeDetail)this.getResource()).getCreatorId();
    }

    protected String getContributionAccessLinkLabelBundleKey() {
        return "kmelia.notifTopicLinkLabel";
    }
}

