/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.kmelia;

import com.silverpeas.admin.components.ComponentsInstanciatorIntf;
import com.silverpeas.admin.components.InstanciationException;
import com.silverpeas.comment.service.CommentServiceFactory;
import com.silverpeas.thumbnail.ThumbnailInstanciator;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.SQLRequest;
import com.stratelia.webactiv.calendar.backbone.TodoBackboneAccess;
import com.stratelia.webactiv.node.NodeInstanciator;
import com.stratelia.webactiv.publication.PublicationInstanciator;
import com.stratelia.webactiv.util.DateUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class KmeliaInstanciator
extends SQLRequest
implements ComponentsInstanciatorIntf {
    public KmeliaInstanciator() {
        super("com.stratelia.webactiv.kmelia");
    }

    public void create(Connection con, String spaceId, String componentId, String userId) throws InstanciationException {
        SilverTrace.info((String)"kmelia", (String)"KmeliaInstanciator.create()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("Space = " + spaceId));
        PublicationInstanciator pub = new PublicationInstanciator("com.stratelia.webactiv.kmelia");
        pub.create(con, spaceId, componentId, userId);
        NodeInstanciator node = new NodeInstanciator("com.stratelia.webactiv.kmelia");
        node.create(con, spaceId, componentId, userId);
        this.setInsertQueries();
        this.insertSpecialNode(con, componentId, userId);
    }

    public void delete(Connection con, String spaceId, String componentId, String userId) throws InstanciationException {
        SilverTrace.info((String)"kmelia", (String)"KmeliaInstanciator.delete()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("Space = " + spaceId));
        PublicationInstanciator pub = new PublicationInstanciator("com.stratelia.webactiv.kmelia");
        pub.delete(con, spaceId, componentId, userId);
        TodoBackboneAccess todoBBA = new TodoBackboneAccess();
        todoBBA.removeEntriesByInstanceId(componentId);
        NodeInstanciator node = new NodeInstanciator("com.stratelia.webactiv.kmelia");
        node.delete(con, spaceId, componentId, userId);
        ThumbnailInstanciator thumbnail = new ThumbnailInstanciator();
        thumbnail.delete(con, spaceId, componentId, userId);
        CommentServiceFactory.getFactory().getCommentService().deleteAllCommentsByComponentInstanceId(componentId);
    }

    private void insertSpecialNode(Connection con, String componentId, String userId) throws InstanciationException {
        String insertStatement = this.getInsertQuery(componentId, "Root");
        String creationDate = DateUtil.today2SQLDate();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(insertStatement);
            prepStmt.setString(1, creationDate);
            prepStmt.setString(2, userId);
            prepStmt.setString(3, componentId);
            prepStmt.executeUpdate();
            prepStmt.close();
        }
        catch (SQLException se) {
            throw new InstanciationException("KmeliaInstanciator.insertSpecialNode()", 4, "root.EX_RECORD_INSERTION_FAILED", "Query = " + insertStatement, (Exception)se);
        }
        insertStatement = this.getInsertQuery(componentId, "Basket");
        try {
            prepStmt = con.prepareStatement(insertStatement);
            prepStmt.setString(1, creationDate);
            prepStmt.setString(2, userId);
            prepStmt.setString(3, componentId);
            prepStmt.executeUpdate();
            prepStmt.close();
        }
        catch (SQLException se) {
            throw new InstanciationException("KmeliaInstanciator.insertSpecialNode()", 4, "root.EX_RECORD_INSERTION_FAILED", "INSERT BASKET with query = " + insertStatement, (Exception)se);
        }
        insertStatement = this.getInsertQuery(componentId, "DZ");
        try {
            prepStmt = con.prepareStatement(insertStatement);
            prepStmt.setString(1, creationDate);
            prepStmt.setString(2, userId);
            prepStmt.setString(3, componentId);
            prepStmt.executeUpdate();
            prepStmt.close();
        }
        catch (SQLException se) {
            throw new InstanciationException("KmeliaInstanciator.insertSpecialNode()", 4, "root.EX_RECORD_INSERTION_FAILED", "INSERT DZ with query = " + insertStatement, (Exception)se);
        }
    }
}

