/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.kmelia.control;

import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silverpeasinitialize.CallBack;
import com.stratelia.silverpeas.silverpeasinitialize.CallBackManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.kmelia.control.ejb.KmeliaBm;
import com.stratelia.webactiv.kmelia.model.KmeliaRuntimeException;
import com.stratelia.webactiv.util.EJBUtilitaire;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.node.model.NodePK;
import com.stratelia.webactiv.util.publication.model.PublicationPK;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.importExport.attachment.AttachmentDetail;
import org.silverpeas.importExport.versioning.Document;

public class KmeliaCallBack
implements CallBack {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doInvoke(int action, int iParam, String componentId, Object extraParam) {
        SilverTrace.info((String)"kmelia", (String)"KmeliaCallback.doInvoke()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("action = " + action + ", iParam = " + iParam + ", componentId = " + componentId));
        if (extraParam != null) {
            SilverTrace.info((String)"kmelia", (String)"KmeliaCallback.doInvoke()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("extraParam = " + extraParam.toString()));
        }
        if (iParam == -1) {
            SilverTrace.info((String)"kmelia", (String)"KmeliaCallback.doInvoke()", (String)"root.MSG_GEN_PARAM_VALUE", (String)"userId is null. Callback stopped !");
            return;
        }
        String sUserId = Integer.toString(iParam);
        if (componentId != null && (componentId.startsWith("kmelia") || componentId.startsWith("toolbox") || componentId.startsWith("kmax"))) {
            try {
                if (action == 17) {
                    if (extraParam instanceof PublicationPK) {
                        PublicationPK pubPK = (PublicationPK)extraParam;
                        this.getKmeliaBm().deletePublication(pubPK);
                        return;
                    }
                    if (!(extraParam instanceof NodePK)) return;
                    NodePK nodePK = (NodePK)extraParam;
                    this.getKmeliaBm().deleteTopic(nodePK);
                    return;
                }
                if (!(extraParam instanceof String) && !(extraParam instanceof AttachmentDetail) && !(extraParam instanceof Document) && !(extraParam instanceof SimpleDocument)) return;
                String pubId = null;
                if (extraParam instanceof String) {
                    pubId = (String)extraParam;
                } else if (extraParam instanceof AttachmentDetail) {
                    AttachmentDetail attachment = (AttachmentDetail)extraParam;
                    if (attachment.getContext().equalsIgnoreCase("images")) {
                        pubId = attachment.getForeignKey().getId();
                    }
                } else if (extraParam instanceof Document) {
                    Document document = (Document)extraParam;
                    pubId = document.getForeignKey().getId();
                } else if (extraParam instanceof SimpleDocument) {
                    SimpleDocument document = (SimpleDocument)extraParam;
                    pubId = document.getForeignId();
                }
                if (!this.isPublicationModified(pubId, action)) return;
                this.getKmeliaBm().externalElementsOfPublicationHaveChanged(new PublicationPK(pubId, componentId), sUserId, action);
                return;
            }
            catch (Exception e) {
                throw new KmeliaRuntimeException("KmeliaCallback.doInvoke()", 4, "root.EX_CANT_GET_REMOTE_OBJECT", e);
            }
        } else {
            if (action != 1) return;
            this.getKmeliaBm().userHaveBeenDeleted(sUserId);
        }
    }

    public void subscribe() {
        CallBackManager callBackManager = CallBackManager.get();
        callBackManager.subscribeAction(8, (CallBack)this);
        callBackManager.subscribeAction(9, (CallBack)this);
        callBackManager.subscribeAction(10, (CallBack)this);
        callBackManager.subscribeAction(12, (CallBack)this);
        callBackManager.subscribeAction(13, (CallBack)this);
        callBackManager.subscribeAction(17, (CallBack)this);
        callBackManager.subscribeAction(1, (CallBack)this);
    }

    private boolean isPublicationModified(String pubId, int action) {
        return StringUtil.isDefined((String)pubId) && !pubId.startsWith("Node") && (action == 8 || action == 9 || action == 10 || action == 12 || action == 13);
    }

    private KmeliaBm getKmeliaBm() {
        KmeliaBm kmeliaBm = null;
        try {
            kmeliaBm = (KmeliaBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.KMELIABM_EJBHOME, KmeliaBm.class);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaSessionController.setKmeliaBm()", 4, "root.EX_CANT_GET_REMOTE_OBJECT", e);
        }
        return kmeliaBm;
    }
}

