/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.kmelia.model;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.kmelia.model.FileDetail;
import com.stratelia.webactiv.kmelia.model.KmeliaRuntimeException;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

public class FileFolder
implements Serializable {
    private static final long serialVersionUID = 5071147110169726697L;
    private ArrayList children;
    private ArrayList files;
    private ArrayList folders;
    private String name;
    private String path;

    public FileFolder(String path) {
        this.path = path;
        this.files = new ArrayList(0);
        this.folders = new ArrayList(0);
        this.children = new ArrayList(0);
        try {
            SilverTrace.debug((String)"kmelia", (String)"FileFolder.FileFolder()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("Starting constructor for FileFolder. Path = " + path));
            File f = new File(path);
            SilverTrace.debug((String)"kmelia", (String)"FileFolder.FileFolder()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("isExists " + f.exists() + " isFile=" + f.isFile()));
            if (f.exists()) {
                this.name = f.getName();
                String[] children_name = f.list();
                for (int i = 0; children_name != null && i < children_name.length; ++i) {
                    SilverTrace.debug((String)"kmelia", (String)"FileFolder.FileFolder()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("Name = " + children_name[i]));
                    File fChild = new File(path + File.separator + children_name[i]);
                    this.children.add(new FileDetail(fChild.getName(), fChild.getPath(), fChild.length(), fChild.isDirectory()));
                    if (fChild.isDirectory()) {
                        this.folders.add(new FileDetail(fChild.getName(), fChild.getPath(), fChild.length(), fChild.isDirectory()));
                        continue;
                    }
                    this.files.add(new FileDetail(fChild.getName(), fChild.getPath(), fChild.length(), fChild.isDirectory()));
                }
            }
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("FileFolder.FileFolder()", 4, "kmelia.IMPOSSIBLE_DACCEDER_AU_REPERTOIRE", e);
        }
    }

    public Collection getFiles() {
        return this.files;
    }

    public Collection getFolders() {
        return this.folders;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public ArrayList getChildren() {
        return this.children;
    }
}

