/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.kmelia.model;

import com.silverpeas.SilverpeasContent;
import com.silverpeas.comment.model.Comment;
import com.silverpeas.comment.service.CommentService;
import com.silverpeas.comment.service.CommentServiceFactory;
import com.silverpeas.pdc.ejb.PdcBm;
import com.silverpeas.util.ForeignPK;
import com.stratelia.silverpeas.pdc.model.ClassifyPosition;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.OrganizationController;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.kmelia.control.ejb.KmeliaBm;
import com.stratelia.webactiv.kmelia.model.KmeliaRuntimeException;
import com.stratelia.webactiv.util.EJBUtilitaire;
import com.stratelia.webactiv.util.GeneralPropertiesManager;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.WAPrimaryKey;
import com.stratelia.webactiv.util.publication.model.CompletePublication;
import com.stratelia.webactiv.util.publication.model.PublicationDetail;
import com.stratelia.webactiv.util.publication.model.PublicationPK;
import com.stratelia.webactiv.util.statistic.control.StatisticBm;
import com.stratelia.webactiv.util.statistic.model.StatisticRuntimeException;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class KmeliaPublication
implements SilverpeasContent {
    private static final long serialVersionUID = 4861635754389280165L;
    private static final OrganizationController organisationService = new OrganizationController();
    private PublicationDetail detail;
    private CompletePublication completeDetail;
    private boolean alias = false;
    private final PublicationPK pk;
    private int rank;
    public boolean read = false;

    public static KmeliaPublication aKmeliaPublicationWithPk(PublicationPK pk) {
        KmeliaPublication publication = new KmeliaPublication(pk);
        publication.getDetail();
        return publication;
    }

    public static KmeliaPublication aKmeliaPublicationFromDetail(PublicationDetail detail) {
        return KmeliaPublication.aKmeliaPublicationFromDetail(detail, 0);
    }

    public static KmeliaPublication aKmeliaPublicationFromDetail(PublicationDetail detail, int rank) {
        KmeliaPublication publication = new KmeliaPublication(detail.getPK(), rank);
        publication.setPublicationDetail(detail);
        return publication;
    }

    public static KmeliaPublication aKmeliaPublicationFromCompleteDetail(CompletePublication detail) {
        KmeliaPublication publication = new KmeliaPublication(detail.getPublicationDetail().getPK());
        publication.setPublicationCompleteDetail(detail);
        return publication;
    }

    public KmeliaPublication asAlias() {
        this.alias = true;
        return this;
    }

    public boolean isAlias() {
        return this.alias;
    }

    public PublicationPK getPk() {
        return this.pk;
    }

    public String getId() {
        return this.pk.getId();
    }

    public String getURL() {
        String defaultURL = this.getOrganizationController().getDomain(this.getCreator().getDomainId()).getSilverpeasServerURL();
        String serverURL = GeneralPropertiesManager.getString((String)"httpServerBase", (String)defaultURL);
        return serverURL + URLManager.getSimpleURL((int)2, (String)this.getPk().getId());
    }

    public PublicationDetail getDetail() {
        if (this.detail == null) {
            this.setPublicationDetail(this.getKmeliaService().getPublicationDetail(this.pk));
        }
        return this.detail;
    }

    public CompletePublication getCompleteDetail() {
        if (this.completeDetail == null) {
            this.setPublicationCompleteDetail(this.getKmeliaService().getCompletePublication(this.pk));
        }
        return this.completeDetail;
    }

    public UserDetail getCreator() {
        String creatorId = this.getDetail().getCreatorId();
        return this.getOrganizationController().getUserDetail(creatorId);
    }

    public UserDetail getLastModifier() {
        UserDetail lastModifier = null;
        String modifierId = this.getDetail().getUpdaterId();
        lastModifier = modifierId == null ? this.getCreator() : this.getOrganizationController().getUserDetail(modifierId);
        return lastModifier;
    }

    public List<Comment> getComments() {
        return Collections.unmodifiableList(this.getCommentService().getAllCommentsOnPublication(PublicationDetail.getResourceType(), (WAPrimaryKey)this.pk));
    }

    public List<ClassifyPosition> getPDCPositions() {
        int silverObjectId = this.getKmeliaService().getSilverObjectId(this.pk);
        return this.getPdcBm().getPositions(silverObjectId, this.pk.getInstanceId());
    }

    public int getNbAccess() {
        try {
            return this.getStatisticService().getCount(new ForeignPK((WAPrimaryKey)this.pk), 1, "Publication");
        }
        catch (Exception e) {
            SilverTrace.error((String)"kmelia", (String)"KmeliaPublication.getNbAccess", (String)"kmelia.CANT_GET_NB_ACCESS", (String)("pubId = " + this.pk.getId()), (Throwable)e);
            return -1;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KmeliaPublication other = (KmeliaPublication)obj;
        return this.pk == other.pk || this.pk != null && this.pk.equals((Object)other.pk);
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + (this.pk != null ? this.pk.hashCode() : 0);
        return hash;
    }

    private KmeliaPublication(PublicationPK id) {
        this.pk = id;
    }

    private KmeliaPublication(PublicationPK id, int rank) {
        this.pk = id;
        this.rank = rank;
    }

    private void setPublicationDetail(PublicationDetail detail) {
        this.detail = detail;
    }

    private void setPublicationCompleteDetail(CompletePublication detail) {
        this.setPublicationDetail(detail.getPublicationDetail());
        this.completeDetail = detail;
    }

    private KmeliaBm getKmeliaService() {
        try {
            return (KmeliaBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.KMELIABM_EJBHOME, KmeliaBm.class);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaPublication.getKmeliaService()", 4, "kmelia.EX_IMPOSSIBLE_DE_FABRIQUER_KmeliaBm_HOME", e);
        }
    }

    private StatisticBm getStatisticService() {
        try {
            return (StatisticBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.STATISTICBM_EJBHOME, StatisticBm.class);
        }
        catch (Exception e) {
            throw new StatisticRuntimeException("KmeliaPublication.getStatisticService()", 4, "root.EX_CANT_GET_REMOTE_OBJECT", e);
        }
    }

    private CommentService getCommentService() {
        return CommentServiceFactory.getFactory().getCommentService();
    }

    private OrganizationController getOrganizationController() {
        return organisationService;
    }

    public String getComponentInstanceId() {
        return this.getDetail().getComponentInstanceId();
    }

    public String getSilverpeasContentId() {
        return this.getDetail().getSilverpeasContentId();
    }

    public Date getCreationDate() {
        return this.getDetail().getCreationDate();
    }

    public String getTitle() {
        return this.getDetail().getTitle();
    }

    public String getDescription() {
        return this.getDetail().getDescription();
    }

    public String getContributionType() {
        return this.getDetail().getContributionType();
    }

    public boolean canBeAccessedBy(UserDetail user) {
        return this.getDetail().canBeAccessedBy(user);
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public int getRank() {
        return this.rank;
    }

    private PdcBm getPdcBm() {
        try {
            return (PdcBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.PDCBM_EJBHOME, PdcBm.class);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException("KmeliaPublication.getPdcBm()", 4, "kmelia.EX_IMPOSSIBLE_DE_FABRIQUER_KmeliaBm_HOME", e);
        }
    }

    public int getNumberOfComments() {
        return this.getCommentService().getCommentsCountOnPublication(PublicationDetail.getResourceType(), (WAPrimaryKey)this.getPk());
    }
}

