/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.kmelia.model.updatechain;

import com.silverpeas.form.FormException;
import com.silverpeas.form.Util;
import com.silverpeas.util.EncodeHelper;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.kmelia.model.updatechain.FieldParameter;
import com.stratelia.webactiv.kmelia.model.updatechain.FieldUpdateChainDescriptor;
import com.stratelia.webactiv.kmelia.model.updatechain.FieldsContext;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.GeneralPropertiesManager;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JdbcFieldDisplayer {
    private static final String VARIABLE_REGEX_USER_ID = "\\$\\$userId";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display(PrintWriter out, FieldUpdateChainDescriptor field, FieldsContext fieldsContext, boolean mandatory) throws FormException {
        String value = "";
        String html = "";
        String mandatoryImg = Util.getIcon((String)"mandatoryField");
        String fieldName = field.getName();
        List<FieldParameter> parameters = field.getParams();
        Collection<String> listRes = null;
        String driverName = null;
        String url = null;
        String login = null;
        String password = null;
        String query = null;
        String valueFieldType = "1";
        int size = 30;
        for (FieldParameter param : parameters) {
            if ("url".equals(param.getName())) {
                url = param.getValue();
            }
            if ("valueFieldType".equals(param.getName())) {
                valueFieldType = param.getValue();
            }
            if ("query".equals(param.getName())) {
                query = param.getValue();
            }
            if ("login".equals(param.getName())) {
                login = param.getValue();
            }
            if ("password".equals(param.getName())) {
                password = param.getValue();
            }
            if ("driverName".equals(param.getName())) {
                driverName = param.getValue();
            }
            if (!"size".equals(param.getName())) continue;
            size = Integer.parseInt(param.getValue());
        }
        if (field != null) {
            Connection jdbcConnection = null;
            try {
                jdbcConnection = this.connectJdbc(driverName, url, login, password);
                listRes = this.selectSql(jdbcConnection, query);
            }
            finally {
                try {
                    if (jdbcConnection != null) {
                        jdbcConnection.close();
                    }
                }
                catch (SQLException e) {
                    SilverTrace.error((String)"formTemplate", (String)"JdbcFieldDisplayer.selectSql", (String)"root.EX_CONNECTION_CLOSE_FAILED", (Throwable)e);
                }
            }
        }
        if (listRes != null && listRes.size() > 0) {
            String m_context = GeneralPropertiesManager.getGeneralResourceLocator().getString("ApplicationURL");
            int zindex = (fieldsContext.getLastFieldIndex() - Integer.parseInt(fieldsContext.getCurrentFieldIndex())) * 9000;
            html = html + "<script type=\"text/javascript\">\n";
            html = html + "listArray" + fieldName + " = [\n";
            for (String val : listRes) {
                html = html + "\"" + EncodeHelper.javaStringToJsString((String)val) + "\",\n";
            }
            html = html.substring(0, html.length() - 1);
            html = html + "];\n";
            html = html + "</script>\n";
            html = html + "<script type=\"text/javascript\" src=\"" + m_context + "/util/yui/yuiloader/yuiloader-min.js\"></script>";
            html = html + "<script type=\"text/javascript\">\n";
            html = html + "var loader = new YAHOO.util.YUILoader({require: ['fonts', 'autocomplete', 'animation'], base: '" + m_context + "/util/yui/', Optional: false, \n";
            html = html + "onSuccess: function(displayList) {\n";
            html = html + " this.oACDS" + fieldName + " = new YAHOO.widget.DS_JSArray(listArray" + fieldName + ");\n";
            html = html + " this.oAutoComp" + fieldName + " = new YAHOO.widget.AutoComplete('" + fieldName + "','container" + fieldName + "', this.oACDS" + fieldName + ");\n";
            html = html + " this.oAutoComp" + fieldName + ".prehighlightClassName = \"yui-ac-prehighlight\";\n";
            html = html + " this.oAutoComp" + fieldName + ".typeAhead = true;\n";
            html = html + " this.oAutoComp" + fieldName + ".useIFrame = true;\n";
            html = html + " this.oAutoComp" + fieldName + ".useShadow = true;\n";
            html = html + " this.oAutoComp" + fieldName + ".minQueryLength = 0;\n";
            if ("1".equals(valueFieldType)) {
                html = html + " this.oAutoComp" + fieldName + ".forceSelection = true;\n";
            }
            html = html + " this.oAutoComp" + fieldName + ".textboxFocusEvent.subscribe(function(){\n";
            html = html + "   var sInputValue = YAHOO.util.Dom.get('" + fieldName + "').value;\n";
            html = html + "   if(sInputValue.length == 0) {\n";
            html = html + "     var oSelf = this;\n";
            html = html + "     setTimeout(function(){oSelf.sendQuery(sInputValue);},0);\n";
            html = html + "   }\n";
            html = html + " });\n";
            html = html + "}\n";
            html = html + ",\n";
            html = html + "onFailure: function(o)      {\n";
            html = html + "alert(\"Error\");\n";
            html = html + "}\n";
            html = html + "});\n";
            html = html + "loader.insert();\n";
            html = html + "</script>\n";
            html = html + "<style type=\"text/css\">\n";
            html = html + "\t#listAutocomplete" + fieldName + " {\n";
            html = html + "\t\twidth:" + size / 2 + "em;\n";
            html = html + "\t\tpadding-bottom:2em;\n";
            html = html + "\t}\n";
            html = html + "\t#listAutocomplete" + fieldName + " {\n";
            html = html + "\t\tz-index:" + zindex + "; /* z-index needed on top instance for ie & sf absolute inside relative issue */\n";
            html = html + "\t}\n";
            html = html + "\t#" + fieldName + " {\n";
            html = html + "\t\t_position:absolute; /* abs pos needed for ie quirks */\n";
            html = html + "\t}\n";
            html = html + "</style>\n";
            html = html + "<div id=\"listAutocomplete" + fieldName + "\">\n";
            html = html + "<input id=\"" + fieldName + "\" size=\"" + size + "\" name=\"" + fieldName + "\" type=\"text\"";
            if (value != null) {
                html = html + " value=\"" + value + "\"";
            }
            html = html + "/>\n";
            html = html + "<div id=\"container" + fieldName + "\"/>\n";
            html = html + "</div>\n";
            if (mandatory) {
                String sizeMandatory = Integer.toString(size / 2 + 1);
                html = html + "<img src=\"" + mandatoryImg + "\" width=\"5\" height=\"5\" border=\"0\" style=\"position:absolute;left:" + sizeMandatory + "em;top:5px\">\n";
            }
        } else {
            if ("1".equals(valueFieldType)) {
                html = html + "<SELECT name=\"" + EncodeHelper.javaStringToHtmlString((String)fieldName) + "\"";
                html = html + " >\n";
                html = html + "</SELECT>\n";
            } else {
                html = html + "<input type=\"text\" size=\"" + size + "\" name=\"" + EncodeHelper.javaStringToHtmlString((String)fieldName) + "\"";
                html = html + " >\n";
            }
            if (mandatory) {
                html = html + "&nbsp;<img src=\"" + mandatoryImg + "\" width=\"5\" height=\"5\" border=\"0\">&nbsp;\n";
            }
        }
        out.println(html);
    }

    public Connection connectJdbc(String driverName, String url, String login, String password) throws FormException {
        Connection result = null;
        try {
            Class.forName(driverName);
        }
        catch (ClassNotFoundException e) {
            throw new FormException("JdbcField.connectJdbc", "form.EX_CANT_FIND_DRIVER_JDBC", (Exception)e);
        }
        try {
            result = DriverManager.getConnection(url, login, password);
        }
        catch (SQLException e) {
            throw new FormException("JdbcField.connectJdbc", "form.EX_CANT_CONNECT_JDBC", (Exception)e);
        }
        return result;
    }

    public Collection<String> selectSql(Connection jdbcConnection, String query) throws FormException {
        ArrayList<String> result = new ArrayList<String>();
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        if (jdbcConnection != null) {
            try {
                prepStmt = jdbcConnection.prepareStatement(query);
            }
            catch (SQLException e) {
                throw new FormException("JdbcField.selectSql", "form.EX_CANT_PREPARE_STATEMENT_JDBC", (Exception)e);
            }
            try {
                rs = prepStmt.executeQuery();
            }
            catch (SQLException e) {
                throw new FormException("JdbcField.selectSql", "form.EX_CANT_EXECUTE_QUERY_JDBC", (Exception)e);
            }
            try {
                while (rs.next()) {
                    ResultSetMetaData metadata = rs.getMetaData();
                    int nbColumns = metadata.getColumnCount();
                    String value = "";
                    for (int i = 1; i <= nbColumns; ++i) {
                        value = value + rs.getString(i) + " ";
                    }
                    result.add(value.trim());
                }
            }
            catch (SQLException e) {
                throw new FormException("JdbcField.selectSql", "form.EX_CANT_BROWSE_RESULT_JDBC", (Exception)e);
            }
            finally {
                DBUtil.close((ResultSet)rs, (Statement)prepStmt);
            }
        }
        return result;
    }
}

