/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.accesscontrol;

import com.silverpeas.util.CollectionUtil;
import java.util.Collection;
import java.util.EnumSet;
import org.apache.commons.collections.CollectionUtils;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonValue;

public enum AccessControlOperation {
    unknown,
    creation,
    modification,
    deletion,
    download,
    sharing;

    public static EnumSet<AccessControlOperation> PERSIST_ACTIONS;

    @JsonValue
    public String getName() {
        return this.name();
    }

    @JsonCreator
    public static AccessControlOperation from(String name) {
        try {
            return AccessControlOperation.valueOf(name);
        }
        catch (Exception e) {
            return unknown;
        }
    }

    public static boolean isPersistActionFrom(Collection<AccessControlOperation> accessControlOperations) {
        return CollectionUtil.isNotEmpty(accessControlOperations) && !CollectionUtils.intersection(PERSIST_ACTIONS, accessControlOperations).isEmpty();
    }

    public static boolean isSharingActionFrom(Collection<AccessControlOperation> accessControlOperations) {
        return CollectionUtil.isNotEmpty(accessControlOperations) && accessControlOperations.contains((Object)sharing);
    }

    public static boolean isDownloadActionFrom(Collection<AccessControlOperation> accessControlOperations) {
        return CollectionUtil.isNotEmpty(accessControlOperations) && accessControlOperations.contains((Object)download);
    }

    static {
        PERSIST_ACTIONS = EnumSet.of(creation, modification, deletion);
    }
}

