/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.comment.model;

import com.silverpeas.SilverpeasContent;
import com.silverpeas.accesscontrol.AccessController;
import com.silverpeas.accesscontrol.AccessControllerProvider;
import com.silverpeas.comment.model.CommentPK;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.WAPrimaryKey;
import java.util.Date;

public class Comment
implements SilverpeasContent {
    private static final long serialVersionUID = 3738544756345055840L;
    public static final String CONTRIBUTION_TYPE = "Comment";
    public static final String PUBLICATION_RESOURCETYPE = "Publication";
    public static final String NEWS_RESOURCETYPE = "News";
    public static final String CLASSIFIED_RESOURCETYPE = "Classified";
    public static final String SCHEDULEEVENT_RESOURCETYPE = "ScheduleEvent";
    public static final String SUGGESTION_RESOURCETYPE = "Suggestion";
    public static final String PHOTO_RESOURCETYPE = "Photo";
    public static final String VIDEO_RESOURCETYPE = "Video";
    public static final String SOUND_RESOURCETYPE = "Sound";
    public static final String STREAMING_RESOURCETYPE = "Streaming";
    private CommentPK pk;
    private String resourceType;
    private WAPrimaryKey foreign_key;
    private int owner_id;
    private String message;
    private Date creation_date;
    private Date modification_date;
    private UserDetail ownerDetail;

    private void init(CommentPK pk, String resourceType, WAPrimaryKey foreign_key, int owner_id, String message, Date creation_date, Date modification_date) {
        this.pk = pk;
        this.resourceType = resourceType;
        this.foreign_key = foreign_key;
        this.owner_id = owner_id;
        this.message = message;
        this.creation_date = new Date(creation_date.getTime());
        if (modification_date != null) {
            this.modification_date = new Date(modification_date.getTime());
        }
    }

    public Comment(CommentPK pk, String resourceType, WAPrimaryKey foreign_key, int owner_id, String owner, String message, Date creation_date, Date modification_date) {
        this.init(pk, resourceType, foreign_key, owner_id, message, creation_date, modification_date);
    }

    public Comment(CommentPK pk, String resourceType, WAPrimaryKey contentPk, String authorId, String message, Date creationDate, Date modificationDate) {
        this.init(pk, resourceType, contentPk, Integer.valueOf(authorId), message, creationDate, modificationDate);
    }

    public void setCommentPK(CommentPK pk) {
        this.pk = pk;
    }

    public CommentPK getCommentPK() {
        return this.pk;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setForeignKey(WAPrimaryKey foreign_key) {
        this.foreign_key = foreign_key;
    }

    public WAPrimaryKey getForeignKey() {
        return this.foreign_key;
    }

    public int getOwnerId() {
        return this.owner_id;
    }

    public String getOwner() {
        if (this.getOwnerDetail() != null) {
            return this.getOwnerDetail().getDisplayedName();
        }
        return "";
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setCreationDate(Date creation_date) {
        this.creation_date = new Date(creation_date.getTime());
    }

    @Override
    public Date getCreationDate() {
        return new Date(this.creation_date.getTime());
    }

    public void setModificationDate(Date modification_date) {
        this.modification_date = new Date(modification_date.getTime());
    }

    public Date getModificationDate() {
        Date date = null;
        if (this.modification_date != null) {
            date = new Date(this.modification_date.getTime());
        }
        return date;
    }

    public UserDetail getOwnerDetail() {
        return this.getCreator();
    }

    public void setOwnerDetail(UserDetail ownerDetail) {
        this.ownerDetail = ownerDetail;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("getCommentPK() = ").append(this.getCommentPK().toString()).append(", \n");
        str.append("getResourceType() = ").append(this.getResourceType()).append(", \n");
        str.append("getForeignKey() = ").append(this.getForeignKey().toString()).append(", \n");
        str.append("getOwnerId() = ").append(this.getOwnerId()).append(", \n");
        str.append("getMessage() = ").append(this.getMessage()).append(", \n");
        str.append("getCreationDate() = ").append(this.getCreationDate()).append(", \n");
        str.append("getModificationDate() = ").append(this.getModificationDate());
        return str.toString();
    }

    @Override
    public UserDetail getCreator() {
        if (this.ownerDetail == null || !this.ownerDetail.isFullyDefined()) {
            this.ownerDetail = UserDetail.getById(String.valueOf(this.owner_id));
        }
        return this.ownerDetail;
    }

    @Override
    public String getTitle() {
        return "";
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public String getId() {
        return this.pk.getId();
    }

    @Override
    public String getComponentInstanceId() {
        return this.pk.getInstanceId();
    }

    @Override
    public String getContributionType() {
        return CONTRIBUTION_TYPE;
    }

    @Override
    public boolean canBeAccessedBy(UserDetail user) {
        AccessController<String> accessController = AccessControllerProvider.getAccessController("componentAccessController");
        return accessController.isUserAuthorized(user.getId(), this.getComponentInstanceId());
    }

    @Override
    public String getSilverpeasContentId() {
        return "";
    }
}

