/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.displayers;

import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.displayers.AbstractFieldDisplayer;
import com.silverpeas.form.fieldType.SequenceField;
import com.silverpeas.util.EncodeHelper;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ecs.html.Input;

public class SequenceFieldDisplayer
extends AbstractFieldDisplayer<SequenceField> {
    @Override
    public void display(PrintWriter out, SequenceField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        if (!template.getTypeName().equals("sequence")) {
            SilverTrace.info("form", "SequenceFieldDisplayer.display", "form.INFO_NOT_CORRECT_TYPE", "sequence");
        }
        SequenceField sequenceField = null;
        if (!"sequence".equals(field.getTypeName())) {
            SilverTrace.info("form", "SequenceFieldDisplayer.display", "form.INFO_NOT_CORRECT_TYPE", "sequence");
        } else {
            sequenceField = field;
        }
        String language = pagesContext.getLanguage();
        String fieldName = template.getFieldName();
        String value = "";
        if (field.isNull()) {
            if (sequenceField != null) {
                Map<String, String> parameters = template.getParameters(language);
                int minLength = 1;
                if (parameters.containsKey("minLength")) {
                    minLength = Integer.parseInt(parameters.get("minLength"));
                }
                int startValue = 1;
                if (parameters.containsKey("startValue")) {
                    startValue = Integer.parseInt(parameters.get("startValue"));
                }
                boolean reuseAvailableValues = StringUtil.getBooleanValue(parameters.get("reuseAvailableValues"));
                boolean global = StringUtil.getBooleanValue(parameters.get("global"));
                value = sequenceField.getNextValue(fieldName, template.getTemplateName(), pagesContext.getComponentId(), minLength, startValue, reuseAvailableValues, global);
            }
        } else {
            value = field.getValue(language);
        }
        Input input2 = new Input();
        input2.setID(fieldName);
        input2.setName(fieldName);
        input2.setValue(EncodeHelper.javaStringToHtmlString(value));
        input2.setType("text");
        input2.setSize(value.length() + 2);
        input2.setReadOnly(true);
        out.println(input2.toString());
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pagesContext) throws IOException {
        if (!template.getTypeName().equals("sequence")) {
            SilverTrace.info("form", "SequenceFieldDisplayer.displayScripts", "form.INFO_NOT_CORRECT_TYPE", "sequence");
        }
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 1;
    }

    @Override
    public boolean isDisplayedMandatory() {
        return false;
    }

    @Override
    public List<String> update(String value, SequenceField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        if (!"sequence".equals(field.getTypeName())) {
            throw new FormException("SequenceFieldDisplayer.update", "form.EX_NOT_CORRECT_TYPE", "sequence");
        }
        if (!field.acceptValue(value, pagesContext.getLanguage())) {
            throw new FormException("SequenceFieldDisplayer.update", "form.EX_NOT_CORRECT_VALUE", "sequence");
        }
        field.setValue(value, pagesContext.getLanguage());
        return new ArrayList<String>();
    }
}

