/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.fieldType;

import com.silverpeas.form.fieldType.TextField;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.JNDINames;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SequenceField
extends TextField {
    private static final long serialVersionUID = -6526406111012877271L;
    public static final String TYPE = "sequence";
    private static final String VALUES_QUERY = "select distinct(f.fieldValue) from sb_formtemplate_template t, sb_formtemplate_record r, sb_formtemplate_textfield f where t.templateId = r.templateId and r.recordId = f.recordId and f.fieldName = ? and t.externalId = ?";
    private static final String GLOBAL_VALUES_QUERY = "select distinct(f.fieldValue) from sb_formtemplate_template t, sb_formtemplate_record r, sb_formtemplate_textfield f where t.templateId = r.templateId and r.recordId = f.recordId and f.fieldName = ? and t.externalId like ?";
    private static final int NUMBER_ERROR = -1;
    private String value = "";

    @Override
    public String getTypeName() {
        return TYPE;
    }

    @Override
    public void setStringValue(String value) {
        this.value = value;
    }

    @Override
    public String getStringValue() {
        return this.value;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public String getNextValue(String fieldName, String templateName, String componentId, int minLength, int startValue, boolean reuseAvailableValues, boolean global) {
        int newValue;
        List<Integer> values = this.getValues(fieldName, templateName, componentId, global);
        if (values.isEmpty()) {
            newValue = startValue;
        } else if (reuseAvailableValues) {
            newValue = startValue;
            while (values.contains(newValue)) {
                ++newValue;
            }
        } else {
            newValue = values.get(values.size() - 1) + 1;
        }
        return SequenceField.numberToString(newValue, minLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List<Integer> getValues(String fieldName, String templateName, String componentId, boolean global) {
        ArrayList<Integer> values;
        block16: {
            values = new ArrayList<Integer>();
            Connection connection = null;
            PreparedStatement statement = null;
            ResultSet rs = null;
            connection = DBUtil.makeConnection(JNDINames.FORMTEMPLATE_DATASOURCE);
            statement = global ? connection.prepareStatement(GLOBAL_VALUES_QUERY) : connection.prepareStatement(VALUES_QUERY);
            statement.setString(1, fieldName);
            if (global) {
                statement.setString(2, "%:" + templateName);
            } else {
                statement.setString(2, componentId + ":" + templateName);
            }
            SilverTrace.debug("form", "SequenceField.getValues", "root.MSG_GEN_PARAM_VALUE", "fieldName = " + fieldName + ", componentId = " + componentId + ", templateName = " + templateName + " ,global=" + global);
            rs = statement.executeQuery();
            while (rs.next()) {
                int currentValue = SequenceField.numberToInt(rs.getString(1));
                if (currentValue == -1) continue;
                values.add(currentValue);
            }
            DBUtil.close(rs, statement);
            try {
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
                break block16;
            }
            catch (SQLException e) {
                SilverTrace.error("form", "SequenceField.getValues", "root.EX_CONNECTION_CLOSE_FAILED", e);
            }
            break block16;
            catch (Exception e) {
                try {
                    SilverTrace.error("form", "SequenceField.getValues", "root.EX_SQL_QUERY_FAILED", e);
                }
                catch (Throwable throwable) {
                    DBUtil.close(rs, statement);
                    try {
                        if (connection != null && !connection.isClosed()) {
                            connection.close();
                        }
                    }
                    catch (SQLException e2) {
                        SilverTrace.error("form", "SequenceField.getValues", "root.EX_CONNECTION_CLOSE_FAILED", e2);
                    }
                    throw throwable;
                }
                DBUtil.close(rs, statement);
                try {
                    if (connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                }
                catch (SQLException e3) {
                    SilverTrace.error("form", "SequenceField.getValues", "root.EX_CONNECTION_CLOSE_FAILED", e3);
                }
            }
        }
        Collections.sort(values);
        return values;
    }

    private static String numberToString(int number, int minLength) {
        String result = String.valueOf(number);
        while (result.length() < minLength) {
            result = "0" + result;
        }
        return result;
    }

    private static int numberToInt(String number) {
        String currentNumber = number;
        if (currentNumber != null && currentNumber.length() > 0) {
            while (currentNumber.startsWith("0")) {
                currentNumber = currentNumber.substring(1);
            }
            try {
                return Integer.parseInt(currentNumber);
            }
            catch (NumberFormatException e) {
                SilverTrace.error("form", "SequenceField.numberToInt", "form.EX_CANT_PARSE_NUMBER", "number=" + number, e);
            }
        }
        return -1;
    }
}

