/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.record;

import com.silverpeas.form.DataRecord;
import com.silverpeas.form.Field;
import com.silverpeas.form.FieldDisplayer;
import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.RecordSet;
import com.silverpeas.form.RecordTemplate;
import com.silverpeas.form.TypeManager;
import com.silverpeas.form.displayers.WysiwygFCKFieldDisplayer;
import com.silverpeas.form.record.GenericDataRecord;
import com.silverpeas.form.record.GenericRecordSetManager;
import com.silverpeas.form.record.IdentifiedRecordTemplate;
import com.silverpeas.util.ForeignPK;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.silverpeas.attachment.AttachmentException;
import org.silverpeas.attachment.AttachmentServiceFactory;
import org.silverpeas.attachment.model.DocumentType;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.model.SimpleDocumentPK;
import org.silverpeas.attachment.util.SimpleDocumentList;
import org.silverpeas.search.indexEngine.model.FullIndexEntry;

public class GenericRecordSet
implements RecordSet,
Serializable {
    private static final long serialVersionUID = 1L;
    private IdentifiedRecordTemplate recordTemplate = null;

    public GenericRecordSet(IdentifiedRecordTemplate recordTemplate) {
        this.recordTemplate = recordTemplate;
    }

    @Override
    public RecordTemplate getRecordTemplate() {
        return this.recordTemplate;
    }

    @Override
    public DataRecord getEmptyRecord() throws FormException {
        return this.recordTemplate.getEmptyRecord();
    }

    @Override
    public DataRecord getRecord(String objectId) throws FormException {
        return this.getGenericRecordSetManager().getRecord(this.recordTemplate, objectId);
    }

    @Override
    public DataRecord getRecord(String objectId, String language) throws FormException {
        return this.getGenericRecordSetManager().getRecord(this.recordTemplate, objectId, language);
    }

    private void insert(DataRecord record) throws FormException {
        this.recordTemplate.checkDataRecord(record);
        this.getGenericRecordSetManager().insertRecord(this.recordTemplate, record);
    }

    private void update(DataRecord record) throws FormException {
        this.recordTemplate.checkDataRecord(record);
        this.getGenericRecordSetManager().updateRecord(this.recordTemplate, record);
    }

    @Override
    public void save(DataRecord record) throws FormException {
        if (record.isNew()) {
            this.insert(record);
        } else {
            this.update(record);
        }
    }

    private void indexRecord(String recordId, String formName, FullIndexEntry indexEntry, String language) throws FormException {
        SilverTrace.info("form", "GenericRecordSet.index()", "root.MSG_GEN_ENTER_METHOD", "recordId = " + recordId + ", language = " + language);
        DataRecord data = this.getRecord(recordId, language);
        if (data != null) {
            String[] fieldNames = data.getFieldNames();
            Field field = null;
            for (String fieldName : fieldNames) {
                FieldTemplate fieldTemplate;
                field = data.getField(fieldName);
                if (field == null || (fieldTemplate = this.recordTemplate.getFieldTemplate(fieldName)) == null) continue;
                String fieldType = fieldTemplate.getTypeName();
                String fieldDisplayerName = fieldTemplate.getDisplayerName();
                try {
                    FieldDisplayer fieldDisplayer;
                    if (!StringUtil.isDefined(fieldDisplayerName)) {
                        fieldDisplayerName = TypeManager.getInstance().getDisplayerName(fieldType);
                    }
                    if ((fieldDisplayer = TypeManager.getInstance().getDisplayer(fieldType, fieldDisplayerName)) == null) continue;
                    String key = formName + "$$" + fieldName;
                    fieldDisplayer.index(indexEntry, key, fieldName, field, language, fieldTemplate.isUsedAsFacet());
                }
                catch (FormException fe) {
                    SilverTrace.error("form", "AbstractForm.update", "form.EXP_UNKNOWN_FIELD", null, fe);
                }
                catch (Exception e) {
                    SilverTrace.error("form", "AbstractForm.update", "form.EXP_UNKNOWN_FIELD", null, e);
                }
            }
        }
    }

    @Override
    public void indexRecord(String recordId, String formName, FullIndexEntry indexEntry) throws FormException {
        if (!I18NHelper.isI18nContentActivated) {
            this.indexRecord(recordId, formName, indexEntry, null);
        } else {
            List<String> languages = this.getGenericRecordSetManager().getLanguagesOfRecord(this.recordTemplate, recordId);
            for (String language : languages) {
                this.indexRecord(recordId, formName, indexEntry, language);
            }
        }
    }

    @Override
    public void delete(DataRecord record) throws FormException {
        if (record != null) {
            this.delete(record.getId());
        }
    }

    private void delete(DataRecord record, String language) throws FormException {
        if (record != null) {
            ForeignPK foreignPK = new ForeignPK(record.getId(), this.recordTemplate.getInstanceId());
            WysiwygFCKFieldDisplayer.removeContents(foreignPK, this.getWYSIWYGFieldNames(record), language);
            SimpleDocumentList<SimpleDocument> docs = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKeyAndType(foreignPK, DocumentType.form, language);
            for (SimpleDocument doc : docs) {
                AttachmentServiceFactory.getAttachmentService().deleteAttachment(doc, false);
            }
            this.getGenericRecordSetManager().deleteRecord(this.recordTemplate, record);
        }
    }

    @Override
    public void delete(String objectId) throws FormException {
        List<String> languages = this.getGenericRecordSetManager().getLanguagesOfRecord(this.recordTemplate, objectId);
        for (String lang : languages) {
            this.delete(objectId, lang);
        }
    }

    @Override
    public void delete(String objectId, String language) throws FormException {
        DataRecord data = this.getRecord(objectId, language);
        if (data != null && data.getLanguage().equals(language)) {
            this.delete(data, language);
        }
    }

    private List<String> getWYSIWYGFieldNames(DataRecord data) {
        ArrayList<String> wysiwygFieldNames = new ArrayList<String>();
        if (data != null) {
            String[] fieldNames;
            for (String fieldName : fieldNames = data.getFieldNames()) {
                try {
                    String fieldDisplayerName;
                    FieldTemplate fieldTemplate;
                    Field field = data.getField(fieldName);
                    if (field == null || (fieldTemplate = this.recordTemplate.getFieldTemplate(fieldName)) == null || !"wysiwyg".equals(fieldDisplayerName = fieldTemplate.getDisplayerName())) continue;
                    wysiwygFieldNames.add(fieldName);
                }
                catch (FormException fe) {
                    SilverTrace.error("form", "GenericRecordSet.getWYSIWYGFieldNames", "form.EXP_UNKNOWN_FIELD", fe);
                }
            }
        }
        return wysiwygFieldNames;
    }

    @Override
    public void move(ForeignPK fromPK, ForeignPK toPK, RecordTemplate toRecordTemplate) throws FormException {
        WysiwygFCKFieldDisplayer wysiwygDisplayer = new WysiwygFCKFieldDisplayer();
        try {
            wysiwygDisplayer.move(fromPK, toPK);
        }
        catch (IOException e) {
            SilverTrace.error("form", "GenericRecordSet.move", "form.CANT_MOVE_WYSIWYG_FIELD_CONTENT", null, e);
        }
        SimpleDocumentList<SimpleDocument> documents = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKeyAndType(fromPK, DocumentType.form, null);
        for (SimpleDocument doc : documents) {
            AttachmentServiceFactory.getAttachmentService().moveDocument(doc, toPK);
        }
        List<String> languages = this.getGenericRecordSetManager().getLanguagesOfRecord(this.recordTemplate, fromPK.getId());
        for (String lang : languages) {
            GenericDataRecord record = (GenericDataRecord)this.getRecord(fromPK.getId(), lang);
            if (record == null) continue;
            this.getGenericRecordSetManager().moveRecord(record.getInternalId(), (IdentifiedRecordTemplate)toRecordTemplate);
        }
    }

    @Override
    public void copy(ForeignPK fromPK, ForeignPK toPK, RecordTemplate toRecordTemplate, Map<String, String> oldAndNewFileIds) throws FormException {
        WysiwygFCKFieldDisplayer wysiwygDisplayer = new WysiwygFCKFieldDisplayer();
        try {
            wysiwygDisplayer.cloneContents(fromPK, toPK, oldAndNewFileIds);
        }
        catch (Exception e) {
            SilverTrace.error("form", "GenericRecordSet.copy", "form.EX_CLONE_FAILURE", null, e);
        }
        HashMap<String, String> ids = new HashMap<String, String>();
        try {
            SimpleDocumentList<SimpleDocument> originals = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKeyAndType(fromPK, DocumentType.form, null);
            for (SimpleDocument original : originals) {
                SimpleDocumentPK clonePk = AttachmentServiceFactory.getAttachmentService().copyDocument(original, toPK);
                ids.put(original.getId(), clonePk.getId());
            }
        }
        catch (AttachmentException e) {
            throw new FormException("form", "", e);
        }
        List<String> languages = this.getGenericRecordSetManager().getLanguagesOfRecord(this.recordTemplate, fromPK.getId());
        for (String lang : languages) {
            GenericDataRecord record = (GenericDataRecord)this.getRecord(fromPK.getId(), lang);
            if (record == null) continue;
            record.setInternalId(-1);
            record.setId(toPK.getId());
            this.replaceIds(ids, record, toPK.getId());
            this.getGenericRecordSetManager().insertRecord((IdentifiedRecordTemplate)toRecordTemplate, record);
        }
    }

    @Override
    public void clone(String originalExternalId, String originalComponentId, String cloneExternalId, String cloneComponentId, Map<String, String> attachmentIds) throws FormException {
        GenericDataRecord record = (GenericDataRecord)this.getRecord(originalExternalId);
        record.setInternalId(-1);
        record.setId(cloneExternalId);
        ForeignPK fromPK = new ForeignPK(originalExternalId, originalComponentId);
        ForeignPK toPK = new ForeignPK(cloneExternalId, cloneComponentId);
        WysiwygFCKFieldDisplayer wysiwygDisplayer = new WysiwygFCKFieldDisplayer();
        try {
            wysiwygDisplayer.cloneContents(fromPK, toPK, attachmentIds);
        }
        catch (Exception e) {
            SilverTrace.error("form", "AbstractForm.clone", "form.EX_CLONE_FAILURE", null, e);
        }
        try {
            SimpleDocumentList<SimpleDocument> originals = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKeyAndType(fromPK, DocumentType.form, null);
            originals.addAll(AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKeyAndType(fromPK, DocumentType.video, null));
            HashMap<String, String> ids = new HashMap<String, String>(originals.size());
            for (SimpleDocument original : originals) {
                SimpleDocumentPK clonePk = AttachmentServiceFactory.getAttachmentService().cloneDocument(original, cloneExternalId);
                ids.put(original.getId(), clonePk.getId());
            }
            this.replaceIds(ids, record, originalExternalId);
        }
        catch (AttachmentException e) {
            throw new FormException("form", "", e);
        }
        this.insert(record);
    }

    @Override
    public void merge(String fromExternalId, String fromComponentId, String toExternalId, String toComponentId, Map<String, String> attachmentIds) throws FormException {
        GenericDataRecord fromRecord = (GenericDataRecord)this.getRecord(fromExternalId);
        GenericDataRecord toRecord = (GenericDataRecord)this.getRecord(toExternalId);
        fromRecord.setInternalId(toRecord.getInternalId());
        fromRecord.setId(toExternalId);
        WysiwygFCKFieldDisplayer wysiwygDisplayer = new WysiwygFCKFieldDisplayer();
        try {
            wysiwygDisplayer.mergeContents(fromComponentId, fromExternalId, toComponentId, toExternalId);
        }
        catch (Exception e) {
            SilverTrace.error("form", "AbstractForm.clone", "form.EX_MERGE_FAILURE", null, e);
        }
        ForeignPK fromPK = new ForeignPK(fromExternalId, fromComponentId);
        ForeignPK toPK = new ForeignPK(toExternalId, toComponentId);
        try {
            Map<String, String> ids = AttachmentServiceFactory.getAttachmentService().mergeDocuments(toPK, fromPK, DocumentType.form);
            Map<String, String> videoIds = AttachmentServiceFactory.getAttachmentService().mergeDocuments(toPK, fromPK, DocumentType.video);
            ids.putAll(videoIds);
            this.replaceIds(ids, fromRecord, toExternalId);
        }
        catch (AttachmentException e) {
            throw new FormException("form", "", e);
        }
        this.update(fromRecord);
    }

    private void replaceIds(Map<String, String> ids, GenericDataRecord record, String recordIdFrom) throws FormException {
        String[] fieldNames;
        for (String fieldName : fieldNames = record.getFieldNames()) {
            FieldTemplate fieldTemplate;
            Field field = record.getField(fieldName);
            if (field == null || (fieldTemplate = this.recordTemplate.getFieldTemplate(fieldName)) == null) continue;
            String fieldType = fieldTemplate.getTypeName();
            String fieldDisplayerName = fieldTemplate.getDisplayerName();
            try {
                if (!StringUtil.isDefined(fieldDisplayerName)) {
                    fieldDisplayerName = TypeManager.getInstance().getDisplayerName(fieldType);
                }
                if ("file".equals(fieldType)) {
                    if (!ids.containsKey(field.getStringValue())) continue;
                    field.setStringValue(ids.get(field.getStringValue()));
                    continue;
                }
                String oldValue = field.getStringValue();
                if (oldValue == null || !oldValue.startsWith("xmlWysiwygField_")) continue;
                String newValue = oldValue.replaceAll(recordIdFrom, record.getId());
                field.setStringValue(newValue);
            }
            catch (Exception e) {
                SilverTrace.error("form", "AbstractForm.update", "form.EXP_UNKNOWN_FIELD", null, e);
            }
        }
    }

    protected GenericRecordSetManager getGenericRecordSetManager() {
        return GenericRecordSetManager.getInstance();
    }
}

