/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.notification.builder;

import com.silverpeas.SilverpeasContent;
import com.silverpeas.SilverpeasToolContent;
import com.silverpeas.notification.builder.AbstractUserNotificationBuilder;
import com.silverpeas.notification.model.NotificationResourceData;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractResourceUserNotificationBuilder<T>
extends AbstractUserNotificationBuilder {
    private T resource;

    public AbstractResourceUserNotificationBuilder(T resource, String title, String content) {
        super(title, content);
        this.setResource(resource);
    }

    public AbstractResourceUserNotificationBuilder(T resource) {
        this(resource, null, null);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.getNotificationMetaData().setLink(this.getResourceURL(this.resource));
    }

    @Override
    protected final void performBuild() {
        this.performBuild(this.resource);
        this.performNotificationResource(this.resource);
    }

    protected abstract void performBuild(T var1);

    protected void performNotificationResource(T resource) {
        NotificationResourceData notificationResourceData = this.initializeNotificationResourceData();
        this.performNotificationResource(resource, notificationResourceData);
        this.getNotificationMetaData().setNotificationResourceData(notificationResourceData);
    }

    protected NotificationResourceData initializeNotificationResourceData() {
        NotificationResourceData notificationResourceData = new NotificationResourceData();
        notificationResourceData.setComponentInstanceId(this.getNotificationMetaData().getComponentId());
        notificationResourceData.setResourceUrl(this.getNotificationMetaData().getLink());
        if (this.resource instanceof SilverpeasContent) {
            this.fill(notificationResourceData, (SilverpeasContent)this.resource);
        }
        return notificationResourceData;
    }

    protected abstract void performNotificationResource(T var1, NotificationResourceData var2);

    protected String getResourceURL(T resource) {
        String resourceUrl = null;
        if (resource instanceof SilverpeasContent) {
            resourceUrl = URLManager.getSearchResultURL((SilverpeasContent)resource);
        }
        if (StringUtils.isBlank(resourceUrl)) {
            resourceUrl = "";
            SilverTrace.warn("NotificationBuider", "AbstractResourceNotificationBuilder.getResourceURL(T resource)", "notificationBuider.RESOURCE_URL_IS_EMPTY");
        }
        return resourceUrl;
    }

    @Override
    protected boolean isSendImmediatly() {
        return this.getResource() instanceof SilverpeasToolContent;
    }

    protected final T getResource() {
        return this.resource;
    }

    protected final void setResource(T resource) {
        this.resource = resource;
    }

    private void fill(NotificationResourceData notificationResourceData, SilverpeasContent silverpeasContent) {
        notificationResourceData.setResourceId(silverpeasContent.getId());
        notificationResourceData.setResourceType(silverpeasContent.getContributionType());
    }
}

