/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.notification.delayed.repository;

import com.silverpeas.notification.delayed.constant.DelayedNotificationFrequency;
import com.silverpeas.notification.delayed.model.DelayedNotificationData;
import com.silverpeas.notification.delayed.repository.DelayedNotificationRepositoryCustom;
import com.silverpeas.util.persistence.TypedParameterUtil;
import com.stratelia.silverpeas.notificationManager.constant.NotifChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class DelayedNotificationRepositoryImpl
implements DelayedNotificationRepositoryCustom {
    @PersistenceContext
    private EntityManager em;

    @Override
    public List<Integer> findUsersToBeNotified(Set<NotifChannel> aimedChannels, Set<DelayedNotificationFrequency> aimedFrequencies, boolean isThatUsersWithNoSettingHaveToBeNotified) {
        ArrayList parameters = new ArrayList();
        StringBuilder query = new StringBuilder();
        query.append("select distinct d.userId from DelayedNotificationData d ");
        query.append("  left outer join d.delayedNotificationUserSetting p ");
        query.append("where d.channel in (:");
        query.append(TypedParameterUtil.addNamedParameter(parameters, "channels", NotifChannel.toIds(aimedChannels)));
        query.append(") and ( ");
        query.append("  (p.id is not null and p.frequency in (:");
        query.append(TypedParameterUtil.addNamedParameter(parameters, "frequencies", DelayedNotificationFrequency.toCodes(aimedFrequencies))).append(")) ");
        if (isThatUsersWithNoSettingHaveToBeNotified) {
            query.append("  or p.id is null ");
        }
        query.append(") ");
        TypedQuery typedQuery = this.em.createQuery(query.toString(), Integer.class);
        TypedParameterUtil.computeNamedParameters(typedQuery, parameters);
        return typedQuery.getResultList();
    }

    @Override
    public List<DelayedNotificationData> findDelayedNotification(DelayedNotificationData delayedNotification) {
        ArrayList parameters = new ArrayList();
        StringBuilder query = new StringBuilder("from DelayedNotificationData where");
        query.append(" userId = :");
        query.append(TypedParameterUtil.addNamedParameter(parameters, "userId", delayedNotification.getUserId()));
        query.append(" and fromUserId = :");
        query.append(TypedParameterUtil.addNamedParameter(parameters, "fromUserId", delayedNotification.getFromUserId()));
        query.append(" and channel = :");
        query.append(TypedParameterUtil.addNamedParameter(parameters, "channel", delayedNotification.getChannel().getId()));
        query.append(" and action = :");
        query.append(TypedParameterUtil.addNamedParameter(parameters, "action", delayedNotification.getAction().getId()));
        query.append(" and language = :");
        query.append(TypedParameterUtil.addNamedParameter(parameters, "language", delayedNotification.getLanguage()));
        Date date = delayedNotification.getCreationDate();
        if (date == null) {
            date = new Date();
        }
        query.append(" and creationDate between :");
        query.append(TypedParameterUtil.addNamedParameter(parameters, "creationDateMin", DateUtils.setSeconds((Date)DateUtils.setMilliseconds((Date)date, (int)0), (int)0), TemporalType.TIMESTAMP));
        query.append(" and :");
        query.append(TypedParameterUtil.addNamedParameter(parameters, "creationDateMax", DateUtils.setSeconds((Date)DateUtils.setMilliseconds((Date)date, (int)999), (int)59), TemporalType.TIMESTAMP));
        query.append(" and notificationResourceId = :");
        query.append(TypedParameterUtil.addNamedParameter(parameters, "resourceId", delayedNotification.getResource()));
        if (StringUtils.isNotBlank((String)delayedNotification.getMessage())) {
            query.append(" and message = :");
            query.append(TypedParameterUtil.addNamedParameter(parameters, "message", delayedNotification.getMessage()));
        } else {
            query.append(" and message is null");
        }
        TypedQuery typedQuery = this.em.createQuery(query.toString(), DelayedNotificationData.class);
        TypedParameterUtil.computeNamedParameters(typedQuery, parameters);
        return typedQuery.getResultList();
    }
}

