/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.thumbnail.control;

import com.silverpeas.thumbnail.control.ThumbnailController;
import com.silverpeas.thumbnail.control.ThumbnailDummyHandledFile;
import com.silverpeas.thumbnail.control.ThumbnailSimulationElement;
import com.silverpeas.thumbnail.model.ThumbnailDetail;
import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.util.ActionType;
import com.stratelia.webactiv.util.WAPrimaryKey;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Named;
import org.apache.commons.io.FileUtils;
import org.silverpeas.process.annotation.AbstractDummyHandledFileConverter;
import org.silverpeas.process.io.file.DummyHandledFile;

@Named
public class ThumbnailDummyHandledFileConverter
extends AbstractDummyHandledFileConverter<ThumbnailSimulationElement> {
    @Override
    public Class<ThumbnailSimulationElement> getSourceElementType() {
        return ThumbnailSimulationElement.class;
    }

    @Override
    public List<DummyHandledFile> convert(List<ThumbnailSimulationElement> elements, WAPrimaryKey targetPK, ActionType actionType) {
        LinkedList<DummyHandledFile> dummyHandledFiles = new LinkedList<DummyHandledFile>();
        if (actionType.isCreate() || actionType.isUpdate() || actionType.isCopy() || actionType.isMove()) {
            for (ThumbnailSimulationElement thumbnail : elements) {
                String thumbnailRootPath = ThumbnailController.getImageDirectory(((ThumbnailDetail)thumbnail.getElement()).getInstanceId());
                for (String thumbnailName : new String[]{((ThumbnailDetail)thumbnail.getElement()).getCropFileName(), ((ThumbnailDetail)thumbnail.getElement()).getOriginalFileName()}) {
                    File thumbnailFile;
                    if (StringUtil.isNotDefined(thumbnailName) || !(thumbnailFile = FileUtils.getFile((String[])new String[]{thumbnailRootPath, thumbnailName})).exists() || !thumbnailFile.isFile()) continue;
                    if (actionType.isUpdate() && thumbnail.isOld() || actionType.isMove() && !thumbnail.isOld()) {
                        dummyHandledFiles.add(new ThumbnailDummyHandledFile((ThumbnailDetail)thumbnail.getElement(), thumbnailFile, true));
                    }
                    if (thumbnail.isOld()) continue;
                    dummyHandledFiles.add(new ThumbnailDummyHandledFile((ThumbnailDetail)thumbnail.getElement(), thumbnailFile, targetPK));
                }
            }
        }
        return dummyHandledFiles;
    }
}

