/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.util;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.MovieHeaderBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.TrackHeaderBox;
import com.silverpeas.util.CollectionUtil;
import com.silverpeas.util.MapUtil;
import com.silverpeas.util.MetaData;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.tika.Tika;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.XMPDM;

public class MetadataExtractor {
    private static final MetadataExtractor instance = new MetadataExtractor();
    private Tika tika = new Tika();
    private static final Pattern VIDEO_ADDITIONAL_METADATA_PATTERN = Pattern.compile("(?i)/[x\\-ms]*(m4v|mp4|quicktime)$");

    private MetadataExtractor() {
    }

    public static MetadataExtractor getInstance() {
        return instance;
    }

    public MetaData extractMetadata(String fileName) {
        return this.extractMetadata(new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaData extractMetadata(File file) {
        MetaData metaData;
        TikaInputStream inputStream = null;
        try {
            Metadata metadata = new Metadata();
            inputStream = TikaInputStream.get((File)file, (Metadata)metadata);
            this.getTikaService().parse((InputStream)inputStream, metadata).close();
            this.additionalExtractions(file, metadata);
            metaData = new MetaData(file, metadata);
        }
        catch (IOException ex) {
            MetaData metaData2;
            try {
                SilverTrace.warn("MetadataExtractor.getMetadata()", "SilverpeasException.WARNING", "util.EXE_CANT_GET_SUMMARY_INFORMATION" + ex.getMessage(), ex);
                metaData2 = new MetaData(file, new Metadata());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            return metaData2;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void additionalExtractions(File file, Metadata metadata) throws IOException {
        String contentType = metadata.get("Content-Type");
        Matcher videoMatcher = VIDEO_ADDITIONAL_METADATA_PATTERN.matcher(contentType);
        if (videoMatcher.find()) {
            MovieHeaderBox movieHeaderBox;
            IsoFile isoFile;
            TikaInputStream tstream = null;
            try {
                tstream = TikaInputStream.get((File)file, (Metadata)metadata);
                isoFile = new IsoFile((ReadableByteChannel)tstream.getFileChannel());
            }
            finally {
                IOUtils.closeQuietly((InputStream)tstream);
            }
            MovieBox movieBox = isoFile.getMovieBox();
            if (movieBox != null && (movieHeaderBox = movieBox.getMovieHeaderBox()) != null) {
                this.computeMp4Duration(metadata, movieHeaderBox);
                this.computeMp4Dimension(metadata, movieBox);
            }
        }
    }

    private void computeMp4Duration(Metadata metadata, MovieHeaderBox movieHeaderBox) {
        BigDecimal duration = BigDecimal.valueOf(movieHeaderBox.getDuration());
        if (duration.intValue() > 0) {
            BigDecimal divisor = BigDecimal.valueOf(movieHeaderBox.getTimescale());
            duration = duration.divide(divisor, 10, 5);
            duration = duration.multiply(BigDecimal.valueOf(1000L));
            metadata.add(XMPDM.DURATION, duration.toString());
        }
    }

    private void computeMp4Dimension(Metadata metadata, MovieBox movieBox) {
        List trackBoxes = movieBox.getBoxes(TrackBox.class);
        if (trackBoxes.size() > 0) {
            TrackHeaderBox trackHeader = null;
            for (TrackBox trackBox : trackBoxes) {
                boolean isWidthExisting;
                boolean bl = isWidthExisting = trackBox.getTrackHeaderBox().getWidth() > 0.0;
                if (!isWidthExisting && trackHeader != null) continue;
                trackHeader = trackBox.getTrackHeaderBox();
                if (!isWidthExisting) continue;
                break;
            }
            if (trackHeader != null) {
                metadata.set(Metadata.IMAGE_WIDTH, (int)trackHeader.getWidth());
                metadata.set(Metadata.IMAGE_LENGTH, (int)trackHeader.getHeight());
            }
        }
    }

    private Map<String, List<Box>> getFilledBoxes(List<Box> boxes, Map<String, List<Box>> filledBoxes) {
        HashMap<String, List<Box>> result;
        HashMap<String, List<Box>> hashMap = result = filledBoxes != null ? filledBoxes : new HashMap<String, List<Box>>();
        if (CollectionUtil.isNotEmpty(boxes)) {
            for (Box box : boxes) {
                if (box instanceof ContainerBox) {
                    this.getFilledBoxes(((ContainerBox)box).getBoxes(), result);
                    continue;
                }
                MapUtil.putAddList(result, box.getType(), box);
            }
        }
        return result;
    }

    public String detectMimeType(File file) throws IOException {
        return this.getTikaService().detect(file);
    }

    private Tika getTikaService() {
        return this.tika;
    }
}

