/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.wysiwyg.dynamicvalue.pool;

import com.silverpeas.util.StringUtil;
import com.silverpeas.wysiwyg.dynamicvalue.pool.ConnectionPool;
import com.silverpeas.wysiwyg.dynamicvalue.pool.ConnectionPoolInformation;
import com.silverpeas.wysiwyg.dynamicvalue.pool.TechnicalException;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.ResourceLocator;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Unmarshaller;
import org.xml.sax.InputSource;

public class ConnectionPoolFactory {
    private static final String CONFIG_MAPPING_FILE_NAME = "org/silverpeas/wysiwyg/dynamicvalue/pool/mapping-config";
    private static final String CONFIG_POOL_FILE_NAME = "org/silverpeas/wysiwyg/dynamicvalue/pool/ConnectionSettings";
    private static ConnectionPoolInformation poolInfo = null;
    private static ConnectionPool pool = null;

    private ConnectionPoolFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection() throws SQLException {
        Connection conn = null;
        Class<ConnectionPoolFactory> clazz = ConnectionPoolFactory.class;
        synchronized (ConnectionPoolFactory.class) {
            if (poolInfo == null) {
                SilverTrace.debug("wysiwyg", ConnectionPoolFactory.class.toString(), " information about datasource : loading ...");
                try {
                    Mapping mapping = new Mapping();
                    InputStream inputStream = ResourceLocator.getResourceAsStream(ConnectionPoolFactory.class, null, CONFIG_MAPPING_FILE_NAME, ".xml");
                    InputSource inputSource = new InputSource(inputStream);
                    mapping.loadMapping(inputSource);
                    Unmarshaller unmar = new Unmarshaller(mapping);
                    inputStream = ResourceLocator.getResourceAsStream(ConnectionPoolFactory.class, null, CONFIG_POOL_FILE_NAME, ".xml");
                    inputSource = new InputSource(inputStream);
                    poolInfo = (ConnectionPoolInformation)unmar.unmarshal(inputSource);
                    SilverTrace.debug("wysiwyg", ConnectionPoolFactory.class.toString(), " information about datasource : poolInformation detail :" + poolInfo.toString());
                }
                catch (Exception exception) {
                    SilverTrace.error("wysiwig", ConnectionPoolFactory.class.toString(), "wysiwig.CONNECTION_INIALIZATION_FAILED");
                    throw new TechnicalException("The pool  has not been initialized. Error when parsing org/silverpeas/wysiwyg/dynamicvalue/pool/mapping-config", exception);
                }
                SilverTrace.debug("wysiwyg", ConnectionPoolFactory.class.toString(), " information about datasource : end of loading ...");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            clazz = ConnectionPoolFactory.class;
            synchronized (ConnectionPoolFactory.class) {
                if (pool == null) {
                    if (StringUtil.isDefined(poolInfo.getConnectionType())) {
                        String className = "com.silverpeas.wysiwyg.dynamicvalue.pool.ConnectionPoolWithJDBC";
                        if ("JNDI".equalsIgnoreCase(poolInfo.getConnectionType())) {
                            className = "com.silverpeas.wysiwyg.dynamicvalue.pool.ConnectionPoolWithJNDI";
                        }
                        try {
                            pool = (ConnectionPool)Class.forName(className).newInstance();
                        }
                        catch (Exception e) {
                            SilverTrace.error("wysiwig", ConnectionPoolFactory.class.toString(), "root.EX_CANT_INSTANCIATE_DB_DRIVER");
                            throw new TechnicalException("The pool  has not been initialized. Error during object instantiation", e);
                        }
                        pool.setPoolInformation(poolInfo);
                    } else {
                        SilverTrace.error("wysiwig", ConnectionPoolFactory.class.toString(), "wysiwig.CONNECTION_INIALIZATION_FAILED");
                        throw new TechnicalException("The pool  has not been initialized. Error when reading ConnectionPoolInformation object");
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                conn = pool.getConnection();
                return conn;
            }
        }
    }
}

