/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.domains.ldapdriver;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPConstraints;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPJSSESecureSocketFactory;
import com.novell.ldap.LDAPReferralException;
import com.novell.ldap.LDAPSearchConstraints;
import com.novell.ldap.LDAPSearchResults;
import com.novell.ldap.LDAPSocketFactory;
import com.novell.ldap.controls.LDAPSortControl;
import com.novell.ldap.controls.LDAPSortKey;
import com.silverpeas.util.ArrayUtil;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.domains.ldapdriver.AbstractLDAPTimeStamp;
import com.stratelia.silverpeas.domains.ldapdriver.LDAPConnectInfos;
import com.stratelia.silverpeas.domains.ldapdriver.LDAPSettings;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.SynchroReport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class LDAPUtility {
    public static final int MAX_NB_RETRY_CONNECT = 10;
    public static final int MAX_NB_RETRY_TIMELIMIT = 5;
    public static final String BASEDN_SEPARATOR = ";;";
    static final Map<String, LDAPConnectInfos> connectInfos = new HashMap<String, LDAPConnectInfos>();
    static int connexionsLastId = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String openConnection(LDAPSettings driverSettings) throws AdminException {
        String newId;
        Map<String, LDAPConnectInfos> map = connectInfos;
        synchronized (map) {
            newId = Integer.toString(connexionsLastId);
            if (++connexionsLastId > 1000000) {
                connexionsLastId = 0;
            }
        }
        connectInfos.put(newId, new LDAPConnectInfos(driverSettings));
        LDAPUtility.InternalOpenConnection(newId);
        return newId;
    }

    public static LDAPConnection getConnection(String connectionId) {
        return LDAPUtility.connectInfos.get((Object)connectionId).connection;
    }

    public static boolean recoverConnection(String connectionId, LDAPException ex) {
        int nbRetry = 0;
        boolean reOpened = false;
        if (ex.getResultCode() == 91 && connectInfos.get(connectionId).incErrorCpt()) {
            SilverTrace.warn("admin", "LDAPUtility.recoverConnection", "admin.EX_ERR_LDAP_CONNECTION_LOST", "ConnectionId=" + connectionId, ex);
            try {
                LDAPUtility.InternalCloseConnection(connectionId);
            }
            catch (AdminException e) {
                SilverTrace.warn("admin", "LDAPUtility.recoverConnection", "admin.EX_ERR_LDAP_GENERAL", e);
            }
            while (!reOpened && nbRetry < 10) {
                try {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    LDAPUtility.InternalOpenConnection(connectionId);
                    reOpened = true;
                }
                catch (AdminException e) {
                    SilverTrace.warn("admin", "LDAPUtility.recoverConnection", "admin.EX_ERR_LDAP_GENERAL", "Retry#=" + Integer.toString(++nbRetry), e);
                }
            }
        }
        return reOpened;
    }

    public static void closeConnection(String connectionId) throws AdminException {
        LDAPUtility.InternalCloseConnection(connectionId);
        connectInfos.remove(connectionId);
    }

    private static void InternalOpenConnection(String connectionId) throws AdminException {
        LDAPSettings driverSettings = LDAPUtility.connectInfos.get((Object)connectionId).driverSettings;
        LDAPConnection valret = driverSettings.isLDAPSecured() ? new LDAPConnection((LDAPSocketFactory)new LDAPJSSESecureSocketFactory()) : new LDAPConnection();
        try {
            valret.connect(driverSettings.getLDAPHost(), driverSettings.getLDAPPort());
            byte[] passwd = driverSettings.getLDAPAccessPasswd();
            valret.bind(driverSettings.getLDAPProtocolVer(), driverSettings.getLDAPAccessLoginDN(), passwd);
            valret.setConstraints((LDAPConstraints)driverSettings.getSearchConstraints(false));
            LDAPUtility.connectInfos.get((Object)connectionId).connection = valret;
        }
        catch (LDAPException e) {
            try {
                if (valret != null) {
                    valret.disconnect();
                }
            }
            catch (LDAPException ee) {
                SilverTrace.error("admin", "LDAPUtility.openConnection", "admin.EX_ERR_LDAP_GENERAL", "ERROR CLOSING CONNECTION : ConnectionId=" + connectionId + " Error LDAP #" + e.getResultCode() + " " + e.getLDAPErrorMessage(), ee);
            }
            throw new AdminException("LDAPUtility.openConnection", 4, "admin.EX_ERR_LDAP_GENERAL", "Host : " + driverSettings.getLDAPHost() + " Port : " + driverSettings.getLDAPPort() + " LDAPLogin : " + driverSettings.getLDAPAccessLoginDN() + " ProtocolVer : " + driverSettings.getLDAPProtocolVer(), (Exception)((Object)e));
        }
    }

    private static void InternalCloseConnection(String connectionId) throws AdminException {
        LDAPConnection toClose = LDAPUtility.getConnection(connectionId);
        if (toClose != null && toClose.isConnected()) {
            try {
                toClose.disconnect();
            }
            catch (LDAPException e) {
                throw new AdminException("LDAPUtility.closeConnection", 4, "admin.EX_ERR_LDAP_GENERAL", "ConnectionId=" + connectionId + " Error LDAP #" + Integer.toString(e.getResultCode()) + " " + e.getLDAPErrorMessage(), (Exception)((Object)e));
            }
        }
    }

    public static String getFirstAttributeValue(LDAPEntry theEntry, String attributeName) {
        String[] stringVals = LDAPUtility.getAttributeValues(theEntry, attributeName);
        if (stringVals != null && stringVals.length > 0) {
            return stringVals[0];
        }
        return "";
    }

    public static LDAPEntry getFirstEntryFromSearch(String lds, String baseDN, int scope, String filter, String[] attrs) throws AdminException {
        LDAPConnection connection = LDAPUtility.getConnection(lds);
        String sureFilter = !StringUtil.isDefined(filter) ? "(objectClass=*)" : filter;
        LDAPSearchConstraints sc = connection.getSearchConstraints();
        sc.setBatchSize(1);
        sc.setMaxResults(1);
        SilverTrace.debug("admin", "LDAPUtility.getFirstEntryFromSearch()", "LDAP query", "BaseDN=" + baseDN + " scope=" + Integer.toString(scope) + " Filter=" + sureFilter);
        String[] baseDNs = LDAPUtility.extractBaseDNs(baseDN);
        LDAPEntry theEntry = null;
        for (String baseDN1 : baseDNs) {
            try {
                LDAPSearchResults res = connection.search(baseDN1, scope, sureFilter, attrs, false, sc);
                if (!res.hasMore()) continue;
                theEntry = res.next();
                SilverTrace.debug("admin", "LDAPUtility.getFirstEntryFromSearch()", "Entry Founded : ", theEntry.getDN());
                break;
            }
            catch (LDAPReferralException re) {
                throw new AdminException("LDAPUtility.getFirstEntryFromSearch", 4, "admin.EX_ERR_LDAP_REFERRAL", "#" + Integer.toString(re.getResultCode()) + " " + re.getLDAPErrorMessage(), (Exception)((Object)re));
            }
            catch (LDAPException e) {
                if (LDAPUtility.recoverConnection(lds, e)) {
                    return LDAPUtility.getFirstEntryFromSearch(lds, baseDN, scope, filter, attrs);
                }
                SilverTrace.error("admin", "LDAPUtility.getFirstEntryFromSearch()", "admin.EX_ERR_LDAP_GENERAL", "#" + Integer.toString(e.getResultCode()) + " " + e.getLDAPErrorMessage(), e);
            }
        }
        return theEntry;
    }

    public static boolean isAGuid(String attName) {
        return "objectGUID".equalsIgnoreCase(attName) || "GUID".equalsIgnoreCase(attName);
    }

    public static String[] getAttributeValues(LDAPEntry theEntry, String theAttributeName) {
        SilverTrace.debug("admin", "LDAPUtility.getAttributeValues()", "root.MSG_GEN_ENTER_METHOD", "theAttributeName = " + theAttributeName);
        if (theEntry == null || !StringUtil.isDefined(theAttributeName)) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        LDAPAttribute theAttr = theEntry.getAttribute(theAttributeName);
        if (theAttr == null) {
            SilverTrace.debug("admin", "LDAPUtility.getAttributeValues()", "root.MSG_GEN_PARAM_VALUE", "Attribute : " + theAttributeName + " is null !!!");
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        SilverTrace.debug("admin", "LDAPUtility.getAttributeValues()", "root.MSG_GEN_PARAM_VALUE", "Attribute : " + theAttributeName + " size = " + Integer.toString(theAttr.size()));
        if (LDAPUtility.isAGuid(theAttributeName)) {
            byte[][] allBytes = theAttr.getByteValueArray();
            String[] valret = new String[theAttr.size()];
            for (int j = 0; j < theAttr.size(); ++j) {
                byte[] asBytes;
                StringBuffer theStr = new StringBuffer(50);
                for (byte asByte : asBytes = allBytes[j]) {
                    String asString = Integer.toHexString(asByte);
                    if (asString.length() > 3) {
                        theStr.append("\\\\").append(asString.substring(6));
                        continue;
                    }
                    if (asString.length() == 0) {
                        theStr.append("\\\\").append("00");
                        continue;
                    }
                    if (asString.length() == 1) {
                        theStr.append("\\\\0").append(asString);
                        continue;
                    }
                    theStr.append("\\\\").append(asString);
                }
                valret[j] = theStr.toString();
                SilverTrace.info("admin", "LDAPUtility.getAttributeValues()", "root.MSG_GEN_PARAM_VALUE", "Attribute : " + theAttributeName + " PARSED VALUE = " + theStr);
            }
            return valret;
        }
        return theAttr.getStringValueArray();
    }

    public static String dblBackSlashesForDNInFilters(String theDN) {
        return LDAPUtility.escapeDN(theDN);
    }

    public static String normalizeFilterValue(String theFilter) {
        return LDAPUtility.escapeLDAPSearchFilter(theFilter);
    }

    public static String escapeDN(String name) {
        StringBuilder sb = new StringBuilder();
        if (name.length() > 0 && (name.charAt(0) == ' ' || name.charAt(0) == '#')) {
            sb.append('\\');
        }
        block9: for (int i = 0; i < name.length(); ++i) {
            char curChar = name.charAt(i);
            switch (curChar) {
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case ',': {
                    sb.append("\\,");
                    continue block9;
                }
                case '+': {
                    sb.append("\\+");
                    continue block9;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '<': {
                    sb.append("\\<");
                    continue block9;
                }
                case '>': {
                    sb.append("\\>");
                    continue block9;
                }
                case ';': {
                    sb.append("\\;");
                    continue block9;
                }
                default: {
                    sb.append(curChar);
                }
            }
        }
        if (name.length() > 1 && name.charAt(name.length() - 1) == ' ') {
            sb.insert(sb.length() - 1, '\\');
        }
        return sb.toString();
    }

    static String escapeLDAPSearchFilter(String filter) {
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < filter.length(); ++i) {
            char curChar = filter.charAt(i);
            switch (curChar) {
                case '\\': {
                    sb.append("\\5c");
                    continue block7;
                }
                case '*': {
                    sb.append("\\2a");
                    continue block7;
                }
                case '(': {
                    sb.append("\\28");
                    continue block7;
                }
                case ')': {
                    sb.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    sb.append("\\00");
                    continue block7;
                }
                default: {
                    sb.append(curChar);
                }
            }
        }
        return sb.toString();
    }

    static String unescapeLDAPSearchFilter(String filter) {
        String unescapedFilter = filter;
        unescapedFilter = unescapedFilter.replace("\\5c", "\\");
        unescapedFilter = unescapedFilter.replace("\\2a", "*");
        unescapedFilter = unescapedFilter.replace("\\28", "(");
        unescapedFilter = unescapedFilter.replace("\\29", ")");
        unescapedFilter = unescapedFilter.replace("\\00", "\u0000");
        return unescapedFilter;
    }

    public static LDAPEntry[] search1000Plus(String lds, String baseDN, int scope, String filter, String varToSort, String[] args) throws AdminException {
        SilverTrace.info("admin", "LDAPUtility.search1000Plus()", "root.MSG_GEN_ENTER_METHOD");
        LDAPConnection ld = LDAPUtility.getConnection(lds);
        ArrayList<LDAPEntry> entriesVector = new ArrayList<LDAPEntry>();
        int nbReaded = 0;
        LDAPSearchConstraints cons = null;
        LDAPSortKey[] keys = new LDAPSortKey[1];
        String theFullFilter = filter;
        boolean notTheFirst = false;
        LDAPException lastException = null;
        try {
            LDAPSettings driverSettings = LDAPUtility.connectInfos.get((Object)lds).driverSettings;
            SilverTrace.info("admin", "LDAPUtility.search1000Plus()", "root.MSG_GEN_PARAM_VALUE", "LDAPImpl = " + driverSettings.getLDAPImpl());
            if (args != null) {
                SilverTrace.info("admin", "LDAPUtility.search1000Plus()", "root.MSG_GEN_PARAM_VALUE", "args = " + Arrays.toString(args));
            }
            if (!driverSettings.isSortControlSupported()) {
                cons = null;
            } else {
                keys[0] = new LDAPSortKey(varToSort);
                LDAPSortControl sort = new LDAPSortControl(keys, true);
                cons = ld.getSearchConstraints();
                cons.setControls((LDAPControl)sort);
            }
            boolean sizeLimitReached = false;
            boolean timeLimitReached = false;
            int nbRetryTimeLimit = 0;
            String[] baseDNs = LDAPUtility.extractBaseDNs(baseDN);
            LDAPEntry entry = null;
            for (String baseDN1 : baseDNs) {
                theFullFilter = filter;
                while (theFullFilter != null) {
                    SilverTrace.debug("admin", "LDAPUtility.search1000Plus()", "LDAP query", "BaseDN=" + baseDN1 + " scope=" + Integer.toString(scope) + " Filter=" + theFullFilter);
                    SynchroReport.debug("LDAPUtility.search1000Plus()", "Requ\u00eate sur le domaine LDAP distant (protocole v" + ld.getProtocolVersion() + "), BaseDN=" + baseDN1 + " scope=" + Integer.toString(scope) + " Filter=" + theFullFilter, null);
                    try {
                        LDAPSearchResults res = ld.search(baseDN1, scope, theFullFilter, args, false, cons);
                        while (res.hasMore()) {
                            entry = res.next();
                            if (notTheFirst) {
                                notTheFirst = false;
                                continue;
                            }
                            SynchroReport.debug("LDAPUtility.search1000Plus()", "\u00e9l\u00e9ment #" + nbReaded + " : " + entry.getDN(), null);
                            SilverTrace.debug("admin", "LDAPUtility.search1000Plus()", "root.MSG_GEN_PARAM_VALUE", "\u00e9l\u00e9ment #" + nbReaded + " : " + entry.getDN());
                            entriesVector.add(entry);
                            ++nbReaded;
                        }
                    }
                    catch (LDAPException le) {
                        if (le.getResultCode() == 4) {
                            sizeLimitReached = true;
                            SynchroReport.debug("LDAPUtility.search1000Plus()", "Size Limit Reached...", null);
                            SilverTrace.debug("admin", "LDAPUtility.search1000Plus()", "root.MSG_GEN_PARAM_VALUE", "Size Limit Reached...");
                        }
                        if (le.getResultCode() == 3) {
                            timeLimitReached = true;
                            lastException = le;
                            SynchroReport.debug("LDAPUtility.search1000Plus()", "Time Limit Reached (#" + ++nbRetryTimeLimit + ")", null);
                            SilverTrace.debug("admin", "LDAPUtility.search1000Plus()", "root.MSG_GEN_PARAM_VALUE", "Time Limit Reached (#" + nbRetryTimeLimit + ")");
                        }
                        SilverTrace.error("admin", "LDAPUtility.search1000Plus", "admin.EX_ERR_LDAP_REFERRAL", "#" + Integer.toString(le.getResultCode()) + " " + le.getLDAPErrorMessage(), le);
                        throw le;
                    }
                    if (sizeLimitReached || timeLimitReached && nbRetryTimeLimit <= 5) {
                        notTheFirst = true;
                        sizeLimitReached = false;
                        timeLimitReached = false;
                        theFullFilter = "(&" + filter + "(" + varToSort + ">=" + LDAPUtility.getFirstAttributeValue(entry, varToSort) + "))";
                        SilverTrace.info("admin", "LDAPUtility.search1000Plus()", "root.MSG_GEN_PARAM_VALUE", "SIZE LIMIT REACHED : " + theFullFilter);
                        continue;
                    }
                    if (timeLimitReached && nbRetryTimeLimit > 5) {
                        throw lastException;
                    }
                    theFullFilter = null;
                }
            }
        }
        catch (LDAPReferralException re) {
            SynchroReport.error("LDAPUtility.search1000Plus()", "R\u00e9f\u00e9rence (referral) retourn\u00e9e mais pas suivie !", re);
            throw new AdminException("LDAPUtility.search1000Plus", 4, "admin.EX_ERR_LDAP_REFERRAL", "#" + Integer.toString(re.getResultCode()) + " " + re.getLDAPErrorMessage(), (Exception)((Object)re));
        }
        catch (LDAPException e) {
            SynchroReport.debug("LDAPUtility.search1000Plus()", "Une exception g\u00e9n\u00e9rale est survenue : #" + e.getResultCode() + " " + e.getLDAPErrorMessage(), null);
            SilverTrace.debug("admin", "LDAPUtility.search1000Plus()", "Une exception g\u00e9n\u00e9rale est survenue : #" + e.getResultCode() + " " + e.getLDAPErrorMessage());
            if (LDAPUtility.recoverConnection(lds, e)) {
                return LDAPUtility.search1000Plus(lds, baseDN, scope, filter, varToSort, args);
            }
            throw new AdminException("LDAPUtility.search1000Plus", 4, "admin.EX_ERR_LDAP_GENERAL", "#" + Integer.toString(e.getResultCode()) + " " + e.getLDAPErrorMessage(), (Exception)((Object)e));
        }
        return entriesVector.toArray(new LDAPEntry[entriesVector.size()]);
    }

    public static AbstractLDAPTimeStamp getTimeStamp(String lds, String baseDN, int scope, String filter, String timeStampVar, String minTimeStamp) throws AdminException {
        SilverTrace.info("admin", "LDAPUtility.getTimeStamp()", "root.MSG_GEN_ENTER_METHOD");
        LDAPSettings driverSettings = LDAPUtility.connectInfos.get((Object)lds).driverSettings;
        LDAPEntry[] theEntries = LDAPUtility.search1000Plus(lds, baseDN, scope, "(&(" + timeStampVar + ">=" + minTimeStamp + ")" + filter + ")", timeStampVar, null);
        if (theEntries.length > 0) {
            AbstractLDAPTimeStamp lastVal;
            AbstractLDAPTimeStamp firstVal = driverSettings.newLDAPTimeStamp(LDAPUtility.getFirstAttributeValue(theEntries[0], timeStampVar));
            if (firstVal.compareTo(lastVal = driverSettings.newLDAPTimeStamp(LDAPUtility.getFirstAttributeValue(theEntries[theEntries.length - 1], timeStampVar))) >= 0) {
                return firstVal;
            }
            return lastVal;
        }
        return driverSettings.newLDAPTimeStamp(minTimeStamp);
    }

    static String[] extractBaseDNs(String baseDN) {
        if (!StringUtil.isDefined(baseDN) || !baseDN.contains(BASEDN_SEPARATOR)) {
            String[] baseDNs = new String[1];
            if (baseDN == null) {
                baseDN = "";
            }
            baseDNs[0] = baseDN;
            return baseDNs;
        }
        StringTokenizer st = new StringTokenizer(baseDN, BASEDN_SEPARATOR);
        ArrayList<String> baseDNs = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            baseDNs.add(st.nextToken());
        }
        return baseDNs.toArray(new String[baseDNs.size()]);
    }
}

