/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.genericPanel;

import com.stratelia.silverpeas.genericPanel.PanelLine;
import com.stratelia.silverpeas.genericPanel.PanelProvider;
import com.stratelia.silverpeas.genericPanel.PanelSearchEdit;
import com.stratelia.silverpeas.genericPanel.PanelSearchToken;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.GeneralPropertiesManager;
import com.stratelia.webactiv.util.ResourceLocator;
import java.util.Hashtable;
import org.silverpeas.core.admin.OrganisationController;
import org.silverpeas.core.admin.OrganisationControllerFactory;

public class AllUserPanel
extends PanelProvider {
    protected static final int FILTER_LASTNAME = 0;
    protected static final int FILTER_FIRSTNAME = 1;
    protected static final int COL_LASTNAME = 0;
    protected static final int COL_FIRSTNAME = 1;
    protected static final int COL_EMAIL = 2;
    protected OrganisationController m_oc = OrganisationControllerFactory.getOrganisationController();
    protected Hashtable<String, UserDetail> m_AllUserDetail = new Hashtable();

    public AllUserPanel(String language, String title) {
        this.initAll(language, title);
    }

    public void initAll(String language, String title) {
        String[] filters = new String[2];
        this.language = language;
        ResourceLocator message = GeneralPropertiesManager.getGeneralMultilang(this.language);
        this.resourceLocator = new ResourceLocator("com.stratelia.silverpeas.genericPanel.multilang.genericPanelBundle", this.language);
        this.pageName = title;
        this.pageSubTitle = this.resourceLocator.getString("genericPanel.usersList");
        this.columnHeaders = new String[3];
        this.columnHeaders[0] = message.getString("GML.lastName");
        this.columnHeaders[1] = message.getString("GML.firstName");
        this.columnHeaders[2] = message.getString("GML.email");
        this.searchTokens = new PanelSearchToken[2];
        this.searchTokens[0] = new PanelSearchEdit(0, message.getString("GML.lastName"), "");
        this.searchTokens[1] = new PanelSearchEdit(1, message.getString("GML.firstName"), "");
        filters[1] = "";
        filters[0] = "";
        this.refresh(filters);
    }

    @Override
    public void refresh(String[] filters) {
        UserDetail modelUser = new UserDetail();
        UserDetail[] result = null;
        if (filters[1] != null && filters[1].length() > 0) {
            modelUser.setFirstName(filters[1] + "%");
        } else {
            modelUser.setFirstName("");
        }
        if (filters[0] != null && filters[0].length() > 0) {
            modelUser.setLastName(filters[0] + "%");
        } else {
            modelUser.setLastName("");
        }
        result = this.m_oc.searchUsers(modelUser, true);
        this.m_AllUserDetail.clear();
        this.ids = new String[result.length];
        for (int i = 0; i < result.length; ++i) {
            this.ids[i] = result[i].getId();
            this.m_AllUserDetail.put(this.ids[i], result[i]);
        }
        ((PanelSearchEdit)this.searchTokens[1]).m_Text = this.getSureString(filters[1]);
        ((PanelSearchEdit)this.searchTokens[0]).m_Text = this.getSureString(filters[0]);
        this.verifIndexes();
    }

    @Override
    public PanelLine getElementInfos(String id) {
        UserDetail theUser = this.m_AllUserDetail.get(id);
        PanelLine valret = null;
        SilverTrace.info("genericPanel", "AllUserPanel.getElementInfos()", "root.GEN_MSG_PARAM_VALUE", "id=" + id);
        String[] theValues = new String[]{theUser.getLastName(), theUser.getFirstName(), theUser.geteMail()};
        valret = new PanelLine(theUser.getId(), theValues, false);
        return valret;
    }
}

