/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.genericPanel;

import com.silverpeas.ui.DisplayI18NHelper;
import com.stratelia.silverpeas.genericPanel.GenericPanelSettings;
import com.stratelia.silverpeas.genericPanel.PanelLine;
import com.stratelia.silverpeas.genericPanel.PanelMiniFilterSelect;
import com.stratelia.silverpeas.genericPanel.PanelMiniFilterToken;
import com.stratelia.silverpeas.genericPanel.PanelSearchToken;
import com.stratelia.webactiv.util.ResourceLocator;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class PanelProvider {
    protected String pageName = "";
    protected String pageSubTitle = "";
    protected String[] columnHeaders = new String[0];
    protected PanelSearchToken[] searchTokens = null;
    protected ResourceLocator resourceLocator = null;
    protected String language = DisplayI18NHelper.getDefaultLanguage();
    protected String[] ids = new String[0];
    protected int m_FirstDisplayed = 0;
    protected int nbDisplayed = GenericPanelSettings.m_ElementsByPage;
    protected Map<String, PanelLine> elementsCache = new HashMap<String, PanelLine>();
    protected Set<String> selectedElements = new HashSet<String>();
    protected boolean m_FilterValid = true;
    protected PanelMiniFilterToken[] miniFilters = new PanelMiniFilterToken[0];
    protected PanelMiniFilterSelect selectMiniFilter = null;

    public abstract PanelLine getElementInfos(String var1);

    public abstract void refresh(String[] var1);

    public void setMiniFilter(int filterIndex, String filterValue) {
    }

    public PanelMiniFilterSelect getSelectMiniFilter() {
        return this.selectMiniFilter;
    }

    public void setSelectMiniFilter(PanelMiniFilterSelect selectMiniFilter) {
        this.selectMiniFilter = selectMiniFilter;
    }

    public void initAll(String[] selectedIds) {
        this.resetAllCache();
        this.selectedElements.clear();
        if (selectedIds != null) {
            Collections.addAll(this.selectedElements, selectedIds);
        }
        this.m_FirstDisplayed = 0;
    }

    public void resetAllSelected() {
        this.selectedElements.clear();
    }

    public void resetAllCache() {
        this.elementsCache.clear();
    }

    public void resetOneCache(String id) {
        this.elementsCache.remove(id);
    }

    public PanelLine getCachedElement(String id) {
        PanelLine result;
        if (this.elementsCache.get(id) == null) {
            this.elementsCache.put(id, this.getElementInfos(id));
            result = this.elementsCache.get(id);
            if (result != null) {
                result.m_Selected = this.selectedElements.contains(result.m_Id);
            }
        } else {
            result = this.elementsCache.get(id);
        }
        return result;
    }

    public void setSelectedElement(String id, boolean isSelected) {
        PanelLine theElement = this.getCachedElement(id);
        theElement.m_Selected = isSelected;
        if (isSelected) {
            this.selectedElements.add(id);
        } else {
            this.selectedElements.remove(id);
        }
    }

    public void setSelectedElements(Set<String> elements) {
        for (String element : elements) {
            this.setSelectedElement(element, true);
        }
    }

    public void unsetSelectedElements(Set<String> elements) {
        for (String element : elements) {
            this.setSelectedElement(element, false);
        }
    }

    public String[] getSelectedElements() {
        return this.selectedElements.toArray(new String[this.selectedElements.size()]);
    }

    public int getSelectedNumber() {
        return this.selectedElements.size();
    }

    public boolean isFilterValid() {
        return this.m_FilterValid;
    }

    public PanelSearchToken[] getSearchTokens() {
        return this.searchTokens;
    }

    public String[] getColumnsHeader() {
        return this.columnHeaders;
    }

    public String getPageName() {
        return this.pageName;
    }

    public String getPageSubTitle() {
        return this.pageSubTitle;
    }

    public int getElementNumber() {
        return this.ids.length;
    }

    public int getNbMaxDisplayed() {
        if (this.nbDisplayed == -1) {
            return this.getElementNumber();
        }
        return this.nbDisplayed;
    }

    public void nextPage() {
        if (this.nbDisplayed != -1 && this.ids.length > this.m_FirstDisplayed + this.nbDisplayed) {
            this.m_FirstDisplayed += this.nbDisplayed;
        }
    }

    public void previousPage() {
        if (this.nbDisplayed != -1 && this.m_FirstDisplayed > 0) {
            this.m_FirstDisplayed = this.m_FirstDisplayed >= this.nbDisplayed ? (this.m_FirstDisplayed -= this.nbDisplayed) : 0;
        }
    }

    public boolean isFirstPage() {
        if (this.nbDisplayed == -1) {
            return true;
        }
        return this.m_FirstDisplayed == 0;
    }

    public boolean isLastPage() {
        if (this.nbDisplayed == -1) {
            return true;
        }
        return this.ids.length <= this.m_FirstDisplayed + this.nbDisplayed;
    }

    public PanelLine[] getPage() {
        PanelLine[] valret = new PanelLine[this.ids.length];
        for (int i = 0; i < valret.length; ++i) {
            valret[i] = this.getCachedElement(this.ids[i]);
        }
        return valret;
    }

    protected void verifIndexes() {
        this.m_FirstDisplayed = 0;
    }

    protected String getSureString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

