/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.notificationManager;

import com.silverpeas.notification.delayed.constant.DelayedNotificationFrequency;
import com.stratelia.webactiv.util.ResourceLocator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class NotificationManagerSettings {
    private static ResourceLocator settings = new ResourceLocator("org.silverpeas.notificationManager.settings.notificationManagerSettings", "");

    public static DelayedNotificationFrequency getDefaultDelayedNotificationFrequency() {
        DelayedNotificationFrequency defaultFrequency = DelayedNotificationFrequency.decode(settings.getString("DEFAULT_DELAYED_NOTIFICATION_FREQUENCY"));
        if (defaultFrequency == null) {
            defaultFrequency = DelayedNotificationFrequency.NONE;
        }
        return defaultFrequency;
    }

    public static Set<DelayedNotificationFrequency> getDelayedNotificationFrequencyChoiceList() {
        HashSet<DelayedNotificationFrequency> possibleFrequencies = new HashSet<DelayedNotificationFrequency>();
        String frequencyChoiceList = settings.getString("DELAYED_NOTIFICATION_FREQUENCY_CHOICE_LIST", "").replaceAll("[ ]+", ",");
        if (StringUtils.isNotBlank((CharSequence)frequencyChoiceList)) {
            for (String frequencyCode : frequencyChoiceList.split("[,;|]")) {
                if ("*".equals(frequencyCode)) {
                    possibleFrequencies.clear();
                    possibleFrequencies.addAll(Arrays.asList(DelayedNotificationFrequency.values()));
                    break;
                }
                possibleFrequencies.add(DelayedNotificationFrequency.decode(frequencyCode));
            }
        }
        possibleFrequencies.remove(null);
        return new TreeSet<DelayedNotificationFrequency>(possibleFrequencies);
    }

    public static boolean isUserManualNotificationRecipientLimitEnabled() {
        return NotificationManagerSettings.getUserManualNotificationRecipientLimit() > 0;
    }

    public static int getUserManualNotificationRecipientLimit() {
        return settings.getInteger("notif.manual.receiver.limit", 0);
    }

    public static int getReceiverThresholdAfterThatReplaceUserNameListByGroupName() {
        return settings.getInteger("notif.receiver.displayUser.threshold", 0);
    }

    public static boolean isDisplayingUserNameListInsteadOfGroupEnabled() {
        return settings.getBoolean("notif.receiver.displayGroup", false);
    }

    public static boolean isDisplayingReceiversInNotificationMessageEnabled() {
        return settings.getBoolean("addReceiversInBody", false);
    }

    public static String getCronOfDelayedNotificationSending() {
        return settings.getString("cronDelayedNotificationSending", "");
    }

    public static boolean isMultiChannelNotificationEnabled() {
        return settings.getBoolean("multiChannelNotification", false);
    }

    public static List<Integer> getDefaultChannels() {
        String defaultChannels = settings.getString("notif.defaultChannels", "");
        boolean isMultiChannelSupported = NotificationManagerSettings.isMultiChannelNotificationEnabled();
        StringTokenizer channelTokenizer = new StringTokenizer(defaultChannels.replaceAll("[ ]{2,}", " "), " ");
        ArrayList<Integer> mediaIds = new ArrayList<Integer>(channelTokenizer.countTokens() + 1);
        while (channelTokenizer.hasMoreTokens()) {
            String channel = channelTokenizer.nextToken();
            if ("BASIC_POPUP".equalsIgnoreCase(channel) && !mediaIds.contains(-10)) {
                mediaIds.add(-10);
            } else if ("BASIC_REMOVE".equalsIgnoreCase(channel) && !mediaIds.contains(-11)) {
                mediaIds.add(-11);
            } else if ("BASIC_SILVERMAIL".equalsIgnoreCase(channel) && !mediaIds.contains(-12)) {
                mediaIds.add(-12);
            } else if ("BASIC_SMTP_MAIL".equalsIgnoreCase(channel) && !mediaIds.contains(-13)) {
                mediaIds.add(-13);
            } else if ("BASIC_SERVER".equalsIgnoreCase(channel) && !mediaIds.contains(-14)) {
                mediaIds.add(-14);
            } else if ("BASIC_COMMUNICATION_USER".equalsIgnoreCase(channel) && !mediaIds.contains(-15)) {
                mediaIds.add(-15);
            }
            if (isMultiChannelSupported || mediaIds.isEmpty()) continue;
            break;
        }
        if (mediaIds.isEmpty()) {
            mediaIds.add(-13);
        }
        return mediaIds;
    }

    public static boolean isRemoveSenderFromSubscriptionNotificationReceiversEnabled() {
        return settings.getBoolean("notification.subscription.removeSenderFromReceivers.enabled", true);
    }

    public static boolean isSubscriptionNotificationConfirmationEnabled() {
        return settings.getBoolean("notification.subscription.confirmation.enabled", true);
    }
}

