/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.notificationManager.model;

import com.stratelia.silverpeas.notificationManager.model.NotifChannelRow;
import com.stratelia.silverpeas.notificationManager.model.NotifSchema;
import com.stratelia.webactiv.util.AbstractTable;
import com.stratelia.webactiv.util.Schema;
import com.stratelia.webactiv.util.exception.UtilException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class NotifChannelTable
extends AbstractTable<NotifChannelRow> {
    protected static final String NOTIFCHANNEL_COLUMNS = "id,name,description,couldBeAdded,fromAvailable,subjectAvailable";
    private static final String SELECT_NOTIFCHANNEL_BY_ID = "select id,name,description,couldBeAdded,fromAvailable,subjectAvailable from ST_NotifChannel Where id = ?";
    private static final String SELECT_ALL_NOTIFCHANNEL = "select id,name,description,couldBeAdded,fromAvailable,subjectAvailable from ST_NotifChannel";
    private static final String INSERT_NOTIFCHANNEL = "insert into ST_NotifChannel (id, name, description, couldBeAdded, fromAvailable, subjectAvailable) values  (?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_NOTIFCHANNEL = "Update ST_NotifChannel set name = ?, description = ?, couldBeAdded = ?, fromAvailable = ?, subjectAvailable = ? Where id = ?";
    private static final String DELETE_NOTIFCHANNEL = "delete from ST_NotifChannel where id=?";

    public NotifChannelTable(Schema schema) {
        super(schema, "ST_NotifChannel");
    }

    public NotifChannelRow getNotifChannel(int id) throws UtilException {
        return (NotifChannelRow)this.getUniqueRow(SELECT_NOTIFCHANNEL_BY_ID, id);
    }

    public NotifChannelRow[] getAllRows() throws UtilException {
        List<NotifChannelRow> rows = this.getRows(SELECT_ALL_NOTIFCHANNEL);
        return rows.toArray(new NotifChannelRow[rows.size()]);
    }

    public NotifChannelRow getNotifChannel(String query) throws UtilException {
        return (NotifChannelRow)this.getUniqueRow(query);
    }

    public NotifChannelRow[] getNotifChannels(String query) throws UtilException {
        List<NotifChannelRow> rows = this.getRows(query);
        return rows.toArray(new NotifChannelRow[rows.size()]);
    }

    public int create(NotifChannelRow notifChannel) throws UtilException {
        this.insertRow(INSERT_NOTIFCHANNEL, notifChannel);
        return notifChannel.getId();
    }

    public void update(NotifChannelRow notifChannel) throws UtilException {
        this.updateRow(UPDATE_NOTIFCHANNEL, notifChannel);
    }

    public void save(NotifChannelRow notifChannel) throws UtilException {
        if (notifChannel.getId() == -1) {
            this.create(notifChannel);
        } else {
            this.update(notifChannel);
        }
    }

    public void delete(int id) throws UtilException {
        ((NotifSchema)this.schema).notifAddress.dereferenceNotifChannelId(id);
        this.updateRelation(DELETE_NOTIFCHANNEL, id);
    }

    @Override
    protected NotifChannelRow fetchRow(ResultSet rs) throws SQLException {
        return new NotifChannelRow(rs.getInt("id"), rs.getString("name"), rs.getString("description"), rs.getString("couldBeAdded"), rs.getString("fromAvailable"), rs.getString("subjectAvailable"));
    }

    @Override
    protected void prepareUpdate(String updateQuery, PreparedStatement update, NotifChannelRow r) throws SQLException {
        update.setString(1, NotifChannelTable.truncate(r.getName(), 20));
        update.setString(2, NotifChannelTable.truncate(r.getDescription(), 200));
        update.setString(3, NotifChannelTable.truncate(r.getCouldBeAdded(), 1));
        update.setString(4, NotifChannelTable.truncate(r.getFromAvailable(), 1));
        update.setString(5, NotifChannelTable.truncate(r.getSubjectAvailable(), 1));
        update.setInt(6, r.getId());
    }

    @Override
    protected void prepareInsert(String insertQuery, PreparedStatement insert, NotifChannelRow r) throws SQLException {
        if (r.getId() == -1) {
            r.setId(this.getNextId());
        }
        insert.setInt(1, r.getId());
        insert.setString(2, NotifChannelTable.truncate(r.getName(), 20));
        insert.setString(3, NotifChannelTable.truncate(r.getDescription(), 200));
        insert.setString(4, NotifChannelTable.truncate(r.getCouldBeAdded(), 1));
        insert.setString(5, NotifChannelTable.truncate(r.getFromAvailable(), 1));
        insert.setString(6, NotifChannelTable.truncate(r.getSubjectAvailable(), 1));
    }
}

