/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.silvertrace;

import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.io.IOUtils;

public final class MsgTrace {
    private Properties allMessages = new Properties();
    private String languageMessages = "";
    private String pathMessages = "";
    private String defaultLanguage = "fr";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initFromProperties(String filePath, String language) {
        this.allMessages.clear();
        this.pathMessages = filePath + "/messages";
        this.languageMessages = this.isDefaultLanguage(language) ? this.defaultLanguage : language;
        List<File> theFiles = this.getPropertyFiles(this.pathMessages, '_' + this.languageMessages.toUpperCase());
        for (File currentFile : theFiles) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(currentFile);
                this.allMessages.load(is);
            }
            catch (IOException e) {
                try {
                    SilverTrace.error("silvertrace", "MsgTrace.initFromProperties()", "silvertrace.ERR_TRACE_MESSAGES_FILE_ERROR", "File:[" + currentFile.getAbsolutePath() + ']', e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
                continue;
            }
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public String getMsgString(String messageID) {
        return this.allMessages.getProperty(messageID, "!!! Message " + messageID + " NOT INITIALIZED !!!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMsgString(String messageID, String language) {
        if (!StringUtil.isDefined(language) || language.equalsIgnoreCase(this.languageMessages)) {
            return this.getMsgString(messageID);
        }
        Properties theMessages = new Properties();
        String valret = "!!! Messages " + messageID + " NOT INITIALIZED !!!";
        FileInputStream is = null;
        if (messageID.indexOf(46) > 0) {
            String fileName = this.pathMessages + '/' + messageID.substring(0, messageID.indexOf(46)) + "Messages_" + language + ".properties";
            try {
                File thePropFile = new File(fileName);
                is = new FileInputStream(thePropFile);
                theMessages.load(is);
                valret = theMessages.getProperty(messageID, valret);
            }
            catch (IOException e) {
                try {
                    SilverTrace.error("silvertrace", "MsgTrace.getMsgString()", "silvertrace.ERR_TRACE_MESSAGES_FILE_ERROR", "File:[" + fileName + ']', e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        return valret;
    }

    public static boolean getBooleanProperty(Properties theProps, String propertyName, boolean defaultValue) {
        boolean valret = defaultValue;
        String value = theProps.getProperty(propertyName);
        if (value != null) {
            valret = "true".equalsIgnoreCase(value);
        }
        return valret;
    }

    public static boolean getBooleanProperty(ResourceBundle resource, String propertyName, boolean defaultValue) {
        boolean valret = defaultValue;
        String value = resource.getString(propertyName);
        if (value != null) {
            valret = StringUtil.getBooleanValue(value);
        }
        return valret;
    }

    public List<File> getPropertyFiles(String pathFiles, String suffix) {
        File pathMessagesFile = new File(pathFiles);
        if (pathMessagesFile.exists() && pathMessagesFile.isDirectory()) {
            File[] messageFiles = pathMessagesFile.listFiles();
            ArrayList<File> valret = new ArrayList<File>(messageFiles.length);
            for (File currentFile : messageFiles) {
                if (!currentFile.getName().toUpperCase().endsWith(suffix + ".PROPERTIES")) continue;
                valret.add(currentFile);
            }
            return valret;
        }
        return new ArrayList<File>();
    }

    protected boolean isDefaultLanguage(String language) {
        return !StringUtil.isDefined(language) || this.defaultLanguage.equalsIgnoreCase(language);
    }
}

