/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.silvertrace;

import com.silverpeas.util.FileUtil;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.MsgTrace;
import com.stratelia.silverpeas.silvertrace.SilverTraceLayout;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.net.SMTPAppender;

public class SilverTrace {
    public static final int TRACE_LEVEL_UNKNOWN = 0;
    public static final int TRACE_LEVEL_DEBUG = 1;
    public static final int TRACE_LEVEL_INFO = 2;
    public static final int TRACE_LEVEL_WARN = 3;
    public static final int TRACE_LEVEL_ERROR = 4;
    public static final int TRACE_LEVEL_FATAL = 5;
    public static final int APPENDER_CONSOLE = 1;
    public static final int APPENDER_FILE = 2;
    public static final int APPENDER_ROLLING_FILE = 4;
    public static final int APPENDER_MAIL = 8;
    public static final int APPENDER_ALL = -1;
    public static final String ROLLING_MODE_MONTH = "'.'yyyy-MM";
    public static final String ROLLING_MODE_WEEK = "'.'yyyy-WW";
    public static final String ROLLING_MODE_DAILY = "'.'yyyy-MM-dd";
    public static final String ROLLING_MODE_HOUR = "'.'yyyy-MM-dd-HH";
    public static final String MODULE_ROOT = "root";
    public static final String MODULE_ERROR_AND_FATAL = "outErrorAndFatal";
    public static final String MODULE_SPY = "outSpy";
    public static final String SPY_ACTION_CREATE = "1";
    public static final String SPY_ACTION_DELETE = "2";
    public static final String SPY_ACTION_UPDATE = "3";
    public static final String MODULE_BUS = "bus";
    public static final String MODULE_ADMIN = "admin";
    public static final String MODULE_COMPONENTS = "components";
    public static final String MODULE_LIBRARIES = "libraries";
    protected static final Properties availableModules = new Properties();
    protected static final MsgTrace traceMessages = new MsgTrace();
    protected static String errorDir = null;
    protected static boolean initFinished = false;

    public static void debug(String module, String classe, String message) {
        SilverTrace.debug(module, classe, message, null, null);
    }

    public static void debug(String module, String classe, String message, String extraInfos) {
        SilverTrace.debug(module, classe, message, extraInfos, null);
    }

    public static void debug(String module, String classe, String message, Throwable ex) {
        SilverTrace.debug(module, classe, message, null, ex);
    }

    public static void debug(String module, String classe, String message, String extraInfos, Throwable ex) {
        if (initFinished) {
            try {
                Logger logger = SilverTrace.getModuleLogger(module);
                if (logger != null && logger.isDebugEnabled()) {
                    logger.debug((Object)SilverTrace.formatTraceMessage(module, classe, null, message, extraInfos), ex);
                }
            }
            catch (RuntimeException e) {
                SilverTrace.error("silvertrace", "SilverTrace.debug()", "silvertrace.ERR_RUNTIME_ERROR_OCCUR", "Msg=" + message, e);
                SilverTrace.emergencyTrace(module, classe, message, extraInfos, ex);
            }
        } else {
            SilverTrace.emergencyTrace(module, classe, message, extraInfos, ex);
        }
    }

    public static void info(String module, String classe, String messageID) {
        SilverTrace.info(module, classe, messageID, null, null);
    }

    public static void info(String module, String classe, String messageID, String extraInfos) {
        SilverTrace.info(module, classe, messageID, extraInfos, null);
    }

    public static void info(String module, String classe, String messageID, Throwable ex) {
        SilverTrace.info(module, classe, messageID, null, ex);
    }

    public static void info(String module, String classe, String messageID, String extraInfos, Throwable ex) {
        if (initFinished) {
            try {
                Logger cat = SilverTrace.getModuleLogger(module);
                if (cat != null && cat.isInfoEnabled()) {
                    cat.info((Object)SilverTrace.formatTraceMessage(module, classe, messageID, traceMessages.getMsgString(messageID), extraInfos), ex);
                }
            }
            catch (RuntimeException e) {
                SilverTrace.error("silvertrace", "SilverTrace.info()", "silvertrace.ERR_RUNTIME_ERROR_OCCUR", "MsgId=" + messageID, e);
                SilverTrace.emergencyTrace(module, classe, messageID, extraInfos, ex);
            }
        } else {
            SilverTrace.emergencyTrace(module, classe, messageID, extraInfos, ex);
        }
    }

    public static void warn(String module, String classe, String messageID) {
        SilverTrace.warn(module, classe, messageID, null, null);
    }

    public static void warn(String module, String classe, String messageID, String extraInfos) {
        SilverTrace.warn(module, classe, messageID, extraInfos, null);
    }

    public static void warn(String module, String classe, String messageID, Throwable ex) {
        SilverTrace.warn(module, classe, messageID, null, ex);
    }

    public static void warn(String module, String classe, String messageID, String extraInfos, Throwable ex) {
        if (initFinished) {
            try {
                Logger cat = SilverTrace.getModuleLogger(module);
                if (cat != null && cat.isEnabledFor((Priority)Level.WARN)) {
                    cat.warn((Object)SilverTrace.formatTraceMessage(module, classe, messageID, traceMessages.getMsgString(messageID), extraInfos), ex);
                }
            }
            catch (RuntimeException e) {
                SilverTrace.error("silvertrace", "SilverTrace.warn()", "silvertrace.ERR_RUNTIME_ERROR_OCCUR", "MsgId=" + messageID, e);
                SilverTrace.emergencyTrace(module, classe, messageID, extraInfos, ex);
            }
        } else {
            SilverTrace.emergencyTrace(module, classe, messageID, extraInfos, ex);
        }
    }

    public static void error(String module, String classe, String messageID) {
        SilverTrace.error(module, classe, messageID, null, null);
    }

    public static void error(String module, String classe, String messageID, String extraInfos) {
        SilverTrace.error(module, classe, messageID, extraInfos, null);
    }

    public static void error(String module, String classe, String messageID, Throwable ex) {
        SilverTrace.error(module, classe, messageID, null, ex);
    }

    public static void error(String module, String classe, String messageID, String extraInfos, Throwable ex) {
        if (initFinished) {
            try {
                Logger logger = SilverTrace.getModuleLogger(module);
                if (logger != null && logger.isEnabledFor((Priority)Level.ERROR)) {
                    logger.error((Object)SilverTrace.formatTraceMessage(module, classe, messageID, traceMessages.getMsgString(messageID), extraInfos), ex);
                }
                if ((logger = SilverTrace.getModuleLogger(MODULE_ERROR_AND_FATAL)) != null && logger.isEnabledFor((Priority)Level.ERROR)) {
                    logger.error((Object)SilverTrace.formatErrorAndFatalMessage(module, classe, messageID, extraInfos, ex));
                }
            }
            catch (RuntimeException e) {
                if (!module.equals("silvertrace")) {
                    SilverTrace.error("silvertrace", "SilverTrace.error()", "silvertrace.ERR_RUNTIME_ERROR_OCCUR", "MsgId=" + messageID, e);
                }
                SilverTrace.emergencyTrace(module, classe, messageID, extraInfos, ex);
            }
        } else {
            SilverTrace.emergencyTrace(module, classe, messageID, extraInfos, ex);
        }
    }

    public static void fatal(String module, String classe, String messageID) {
        SilverTrace.fatal(module, classe, messageID, null, null);
    }

    public static void fatal(String module, String classe, String messageID, String extraInfos) {
        SilverTrace.fatal(module, classe, messageID, extraInfos, null);
    }

    public static void fatal(String module, String classe, String messageID, Throwable ex) {
        SilverTrace.fatal(module, classe, messageID, null, ex);
    }

    public static void fatal(String module, String classe, String messageID, String extraInfos, Throwable ex) {
        if (initFinished) {
            try {
                Logger cat = SilverTrace.getModuleLogger(module);
                if (cat != null && cat.isEnabledFor((Priority)Level.FATAL)) {
                    cat.fatal((Object)SilverTrace.formatTraceMessage(module, classe, messageID, traceMessages.getMsgString(messageID), extraInfos), ex);
                }
                if ((cat = SilverTrace.getModuleLogger(MODULE_ERROR_AND_FATAL)) != null && cat.isEnabledFor((Priority)Level.FATAL)) {
                    cat.fatal((Object)SilverTrace.formatErrorAndFatalMessage(module, classe, messageID, extraInfos, ex));
                }
            }
            catch (RuntimeException e) {
                SilverTrace.error("silvertrace", "SilverTrace.fatal()", "silvertrace.ERR_RUNTIME_ERROR_OCCUR", "MsgId=" + messageID, e);
                SilverTrace.emergencyTrace(module, classe, messageID, extraInfos, ex);
            }
        } else {
            SilverTrace.emergencyTrace(module, classe, messageID, extraInfos, ex);
        }
    }

    public static void spy(String module, String classe, String spaceId, String instanceId, String objectId, String userId, String actionId) {
        if (initFinished) {
            try {
                Logger cat = SilverTrace.getModuleLogger(MODULE_SPY);
                if (cat != null && cat.isEnabledFor((Priority)Level.FATAL)) {
                    cat.fatal((Object)SilverTrace.formatSpyMessage(spaceId, instanceId, objectId, userId, actionId));
                }
            }
            catch (RuntimeException e) {
                SilverTrace.error("silvertrace", "SilverTrace.spy()", "silvertrace.ERR_RUNTIME_ERROR_OCCUR", e);
                SilverTrace.emergencyTrace(module, classe, null, null, null);
            }
        } else {
            SilverTrace.emergencyTrace(module, classe, null, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetAll() {
        availableModules.clear();
        Logger.getRootLogger().getLoggerRepository().resetConfiguration();
        Logger.getRootLogger().setAdditivity(true);
        Logger.getRootLogger().setLevel(Level.ERROR);
        ResourceBundle resources = FileUtil.loadBundle("org.silverpeas.silvertrace.settings.silverTrace", Locale.ROOT);
        String pathFiles = resources.getString("pathSilverTrace");
        String languageMessage = resources.getString("language");
        errorDir = resources.getString("ErrorDir");
        traceMessages.initFromProperties(pathFiles, languageMessage);
        List<File> theFiles = traceMessages.getPropertyFiles(pathFiles, "");
        for (File theFile : theFiles) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(theFile);
                Properties currentFileProperties = new Properties();
                currentFileProperties.load(is);
                SilverTrace.initFromProperties(currentFileProperties);
            }
            catch (IOException e) {
                block6: {
                    try {
                        if (initFinished) {
                            SilverTrace.error("silvertrace", "SilverTrace.resetAll()", "silvertrace.ERR_INIT_TRACE_FROM_PROP", "File:[" + theFile.getAbsolutePath() + "]", e);
                            break block6;
                        }
                        SilverTrace.emergencyTrace("Error in SilverTrace initialization : Cant load property file : '" + theFile.getAbsolutePath() + "'", e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)is);
                continue;
            }
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyProperties(String filePath) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(filePath);
            Properties currentFileProperties = new Properties();
            currentFileProperties.load(is);
            SilverTrace.initFromProperties(currentFileProperties);
        }
        catch (IOException e) {
            block5: {
                try {
                    if (initFinished) {
                        SilverTrace.error("silvertrace", "SilverTrace.resetAll()", "silvertrace.ERR_INIT_TRACE_FROM_PROP", "File:[" + filePath + "]", e);
                        break block5;
                    }
                    SilverTrace.emergencyTrace("Error in SilverTrace applyProperties(" + filePath + ")", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    public static void initFromProperties(Properties fileProperties) {
        try {
            int i;
            String enumModulesName = fileProperties.getProperty("module.name");
            String enumModulesPath = fileProperties.getProperty("module.path");
            if (StringUtil.isDefined(enumModulesName) && StringUtil.isDefined(enumModulesPath)) {
                i = enumModulesPath.lastIndexOf(46);
                if (i > 0 && i + 1 < enumModulesPath.length()) {
                    StringBuilder ws = new StringBuilder(enumModulesPath);
                    ws.setCharAt(i + 1, enumModulesPath.toUpperCase().charAt(i + 1));
                    enumModulesPath = ws.toString();
                }
                availableModules.setProperty(enumModulesName, enumModulesPath);
            }
            i = 0;
            String appenderTypeStr = fileProperties.getProperty("appender" + i + ".type");
            while (appenderTypeStr != null) {
                int appenderTypeInt = "APPENDER_CONSOLE".equalsIgnoreCase(appenderTypeStr) ? 1 : ("APPENDER_FILE".equalsIgnoreCase(appenderTypeStr) ? 2 : ("APPENDER_ROLLING_FILE".equalsIgnoreCase(appenderTypeStr) ? 4 : ("APPENDER_MAIL".equalsIgnoreCase(appenderTypeStr) ? 8 : -1)));
                boolean appenderEnabled = MsgTrace.getBooleanProperty(fileProperties, "appender" + i + ".enabled", true);
                if (appenderTypeInt != -1 && appenderEnabled) {
                    SilverTrace.addAppenderFromProperties(fileProperties, i, appenderTypeInt);
                }
                appenderTypeStr = fileProperties.getProperty("appender" + ++i + ".type");
            }
            Enumeration<?> enumModulesNames = availableModules.propertyNames();
            while (enumModulesNames.hasMoreElements()) {
                enumModulesName = (String)enumModulesNames.nextElement();
                String traceLevel = fileProperties.getProperty("traceLevel." + enumModulesName);
                if (traceLevel == null) continue;
                int traceLevelInt = "TRACE_LEVEL_DEBUG".equalsIgnoreCase(traceLevel) ? 1 : ("TRACE_LEVEL_INFO".equalsIgnoreCase(traceLevel) ? 2 : ("TRACE_LEVEL_WARN".equalsIgnoreCase(traceLevel) ? 3 : ("TRACE_LEVEL_ERROR".equalsIgnoreCase(traceLevel) ? 4 : (traceLevel.equalsIgnoreCase("TRACE_LEVEL_FATAL") ? 5 : 0))));
                SilverTrace.setTraceLevel(enumModulesName, traceLevelInt);
            }
        }
        catch (Exception e) {
            if (initFinished) {
                SilverTrace.error("silvertrace", "SilverTrace.resetAll()", "silvertrace.ERR_INIT_APPENDER_FROM_PROP", e);
            }
            SilverTrace.emergencyTrace("Error in SilverTrace initFromProperties", e);
        }
    }

    public static void setTraceLevel(String module, int val) {
        Logger logger = SilverTrace.getModuleLogger(module);
        if (logger != null) {
            switch (val) {
                case 0: {
                    logger.setLevel(null);
                    break;
                }
                case 1: {
                    logger.setLevel(Level.DEBUG);
                    break;
                }
                case 2: {
                    logger.setLevel(Level.INFO);
                    break;
                }
                case 3: {
                    logger.setLevel(Level.WARN);
                    break;
                }
                case 4: {
                    logger.setLevel(Level.ERROR);
                    break;
                }
                case 5: {
                    logger.setLevel(Level.FATAL);
                }
            }
        }
    }

    public static int getTraceLevel(String module, boolean chained) {
        Logger cat = SilverTrace.getModuleLogger(module);
        if (cat == null) {
            return 0;
        }
        Level log4jLevel = chained ? cat.getEffectiveLevel() : cat.getLevel();
        if (log4jLevel == null) {
            return 0;
        }
        int log4jLevelInt = log4jLevel.toInt();
        switch (log4jLevelInt) {
            case 10000: {
                return 1;
            }
            case 20000: {
                return 2;
            }
            case 30000: {
                return 3;
            }
            case 40000: {
                return 4;
            }
            case 50000: {
                return 5;
            }
        }
        return 0;
    }

    public static void addAppenderConsole(String module, String patternLayout, String consoleName) {
        Logger cat = SilverTrace.getModuleLogger(module);
        ConsoleAppender a1 = new ConsoleAppender();
        if (cat != null) {
            try {
                cat.removeAppender(SilverTrace.getAppenderName(module, 1));
                a1.setName(SilverTrace.getAppenderName(module, 1));
                a1.setLayout(SilverTraceLayout.getLayout(patternLayout));
                if (StringUtil.isDefined(consoleName)) {
                    a1.setTarget(consoleName);
                }
                a1.activateOptions();
                cat.addAppender((Appender)a1);
            }
            catch (Exception e) {
                if (initFinished) {
                    SilverTrace.error("silvertrace", "SilverTrace.addAppenderConsole()", "silvertrace.ERR_CANT_ADD_APPENDER", "Console " + module + "," + patternLayout + "," + consoleName, e);
                }
                SilverTrace.emergencyTrace("Error in SilverTrace addAppenderConsole", e);
            }
        }
    }

    public static void addAppenderFile(String module, String patternLayout, String fileName, boolean appendOnFile) {
        Logger cat = SilverTrace.getModuleLogger(module);
        FileAppender a1 = new FileAppender();
        if (cat != null) {
            try {
                cat.removeAppender(SilverTrace.getAppenderName(module, 2));
                a1.setName(SilverTrace.getAppenderName(module, 2));
                a1.setLayout(SilverTraceLayout.getLayout(patternLayout));
                a1.setAppend(appendOnFile);
                a1.setFile(fileName);
                a1.activateOptions();
                cat.addAppender((Appender)a1);
            }
            catch (Exception e) {
                if (initFinished) {
                    SilverTrace.error("silvertrace", "SilverTrace.addAppenderFile()", "silvertrace.ERR_CANT_ADD_APPENDER", "File " + module + "," + patternLayout + "," + fileName, e);
                }
                SilverTrace.emergencyTrace("Error in SilverTrace addAppenderFile", e);
            }
        }
    }

    public static void addAppenderRollingFile(String module, String patternLayout, String fileName, String rollingMode) {
        Logger logger = SilverTrace.getModuleLogger(module);
        if (logger != null) {
            try {
                DailyRollingFileAppender a1 = new DailyRollingFileAppender(SilverTraceLayout.getLayout(patternLayout), fileName, rollingMode);
                if (MODULE_ROOT.equals(module)) {
                    logger = Logger.getRootLogger();
                }
                logger.removeAppender(SilverTrace.getAppenderName(module, 4));
                a1.setName(SilverTrace.getAppenderName(module, 4));
                logger.addAppender((Appender)a1);
            }
            catch (Exception e) {
                if (initFinished) {
                    SilverTrace.error("silvertrace", "SilverTrace.addAppenderRollingFile()", "silvertrace.ERR_CANT_ADD_APPENDER", "RollingFile " + module + "," + patternLayout + "," + fileName, e);
                }
                SilverTrace.emergencyTrace("Error in SilverTrace addAppenderRollingFile", e);
            }
        }
    }

    public static void addAppenderMail(String module, String patternLayout, String mailHost, String mailFrom, String mailTo, String mailSubject) {
        Logger cat = SilverTrace.getModuleLogger(module);
        SMTPAppender a1 = new SMTPAppender();
        if (cat != null) {
            try {
                cat.removeAppender(SilverTrace.getAppenderName(module, 8));
                a1.setName(SilverTrace.getAppenderName(module, 8));
                a1.setLayout(SilverTraceLayout.getLayout(patternLayout));
                a1.setSMTPHost(mailHost);
                a1.setFrom(mailFrom);
                a1.setTo(mailTo);
                a1.setSubject(mailSubject);
                a1.activateOptions();
                cat.addAppender((Appender)a1);
            }
            catch (Exception e) {
                if (initFinished) {
                    SilverTrace.error("silvertrace", "SilverTrace.addAppenderMail()", "silvertrace.ERR_CANT_ADD_APPENDER", "SMTP " + module + "," + patternLayout + "," + mailHost, e);
                }
                SilverTrace.emergencyTrace("Error in SilverTrace addAppenderMail", e);
            }
        }
    }

    public static void removeAppender(String module, int typeOfAppender) {
        Logger cat = SilverTrace.getModuleLogger(module);
        if (cat != null) {
            if ((typeOfAppender & 1) == 1) {
                cat.removeAppender(SilverTrace.getAppenderName(module, 1));
            }
            if ((typeOfAppender & 2) == 2) {
                cat.removeAppender(SilverTrace.getAppenderName(module, 2));
            }
            if ((typeOfAppender & 4) == 4) {
                cat.removeAppender(SilverTrace.getAppenderName(module, 4));
            }
            if ((typeOfAppender & 8) == 8) {
                cat.removeAppender(SilverTrace.getAppenderName(module, 8));
            }
        }
    }

    public static Properties getModuleList() {
        return availableModules;
    }

    public static int getAvailableAppenders(String module) {
        Logger cat = SilverTrace.getModuleLogger(module);
        int valret = 0;
        if (cat != null) {
            if (cat.getAppender(SilverTrace.getAppenderName(module, 1)) != null) {
                valret |= 1;
            }
            if (cat.getAppender(SilverTrace.getAppenderName(module, 2)) != null) {
                valret |= 2;
            }
            if (cat.getAppender(SilverTrace.getAppenderName(module, 4)) != null) {
                valret |= 4;
            }
            if (cat.getAppender(SilverTrace.getAppenderName(module, 8)) != null) {
                valret |= 8;
            }
        }
        return valret;
    }

    public static Properties getAppender(String module, int typeOfAppender) {
        Logger cat = SilverTrace.getModuleLogger(module);
        if (cat == null) {
            return null;
        }
        Appender app = cat.getAppender(SilverTrace.getAppenderName(module, typeOfAppender));
        if (app == null) {
            return null;
        }
        Layout lay = app.getLayout();
        Properties valret = new Properties();
        valret.setProperty("Name", app.getName());
        valret.setProperty("Type", Integer.toString(typeOfAppender));
        if (lay != null) {
            if ("org.apache.log4j.HTMLLayout".equals(lay.getClass().getName())) {
                valret.setProperty("Layout", SilverTraceLayout.LAYOUT_HTML.name());
            }
            if ("org.apache.log4j.PatternLayout".equals(lay.getClass().getName())) {
                PatternLayout layPattern = (PatternLayout)lay;
                valret.setProperty("Layout", SilverTraceLayout.findByPattern(layPattern.getConversionPattern()).name());
            }
        }
        if ((typeOfAppender & 1) == 1) {
            ConsoleAppender capp = (ConsoleAppender)app;
            valret.setProperty("consoleName", capp.getTarget());
        }
        if ((typeOfAppender & 2) == 2) {
            FileAppender fapp = (FileAppender)app;
            valret.setProperty("fileName", fapp.getFile());
            if (fapp.getAppend()) {
                valret.setProperty("append", "true");
            } else {
                valret.setProperty("append", "false");
            }
        }
        if ((typeOfAppender & 4) == 4) {
            DailyRollingFileAppender rapp = (DailyRollingFileAppender)app;
            valret.setProperty("fileName", rapp.getFile());
            valret.setProperty("rollingMode", rapp.getDatePattern());
        }
        if ((typeOfAppender & 8) == 8) {
            SMTPAppender sapp = (SMTPAppender)app;
            valret.setProperty("mailHost", sapp.getSMTPHost());
            valret.setProperty("mailFrom", sapp.getFrom());
            valret.setProperty("mailTo", sapp.getTo());
            valret.setProperty("mailSubject", sapp.getSubject());
        }
        return valret;
    }

    public static String getTraceMessage(String messageId) {
        try {
            return traceMessages.getMsgString(messageId);
        }
        catch (RuntimeException ex) {
            SilverTrace.error("silvertrace", "SilverTrace.getTraceMessage()", "silvertrace.ERR_RUNTIME_ERROR_OCCUR", "MsgId=" + messageId, ex);
            return "!!! Messages " + messageId + " NOT FOUND !!!";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getEndFileTrace(String nbLines) {
        String[] stringArray;
        long fileLength;
        ArrayList<String> ar;
        File theFile;
        LineNumberReader lnr;
        block7: {
            lnr = null;
            theFile = new File(errorDir + "/traces.txt");
            ar = new ArrayList<String>();
            fileLength = theFile.length();
            if (fileLength != 0L) break block7;
            String[] stringArray2 = ArrayUtils.EMPTY_STRING_ARRAY;
            IOUtils.closeQuietly(lnr);
            return stringArray2;
        }
        try {
            int nbl = Integer.parseInt(nbLines);
            lnr = new LineNumberReader(new FileReader(theFile));
            if (nbl > 0 && (long)((nbl + 1) * 100) < fileLength) {
                lnr.skip(fileLength - (long)((nbl + 1) * 100));
            }
            String line = lnr.readLine();
            while (line != null) {
                line = lnr.readLine();
                if (line == null) continue;
                ar.add(line);
            }
            stringArray = ar.toArray(new String[ar.size()]);
        }
        catch (Exception e) {
            String[] stringArray3;
            try {
                SilverTrace.error("silvertrace", "SilverTrace.getEndFileTrace()", "silvertrace.ERR_RUNTIME_ERROR_OCCUR", "File NOT FOUND :" + errorDir + "/traces.txt", e);
                stringArray3 = ArrayUtils.EMPTY_STRING_ARRAY;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(lnr);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)lnr);
            return stringArray3;
        }
        IOUtils.closeQuietly((Reader)lnr);
        return stringArray;
    }

    public static String getTraceMessage(String messageId, String language) {
        try {
            return traceMessages.getMsgString(messageId, language);
        }
        catch (RuntimeException ex) {
            SilverTrace.error("silvertrace", "SilverTrace.getTraceMessage()", "silvertrace.ERR_RUNTIME_ERROR_OCCUR", "MsgId=" + messageId + " Lang=" + language, ex);
            return "!!! Messages " + messageId + " FOR " + language + " NOT FOUND !!!";
        }
    }

    protected static String formatSpyMessage(String spaceId, String instanceId, String objectId, String userId, String actionId) {
        StringBuilder valret = new StringBuilder("");
        if (StringUtil.isDefined(spaceId)) {
            valret.append(spaceId);
            valret.append(",");
        }
        if (StringUtil.isDefined(instanceId)) {
            valret.append(instanceId);
            valret.append(",");
        }
        if (StringUtil.isDefined(objectId)) {
            valret.append(objectId);
            valret.append(",");
        }
        if (StringUtil.isDefined(userId)) {
            valret.append(userId);
            valret.append(",");
        }
        if (StringUtil.isDefined(actionId)) {
            valret.append(actionId);
        }
        return valret.toString();
    }

    protected static String formatErrorAndFatalMessage(String module, String classe, String messageID, String extraInfos, Throwable ex) {
        String extraParams;
        if (ex != null) {
            CharArrayWriter buffer = new CharArrayWriter();
            ex.printStackTrace(new PrintWriter(buffer));
            extraParams = StringUtil.isDefined(extraInfos) ? extraInfos + ", EXCEPTION : " + buffer.toString() : "EXCEPTION : " + buffer.toString();
        } else {
            extraParams = extraInfos;
        }
        return SilverTrace.formatTraceMessage(module, classe, messageID, traceMessages.getMsgString(messageID), extraParams);
    }

    protected static String formatTraceMessage(String module, String classe, String messageID, String message, String extraInfos) {
        StringBuilder valret = new StringBuilder("");
        if (StringUtil.isDefined(messageID)) {
            valret.append(messageID).append(" | ");
        }
        if (StringUtil.isDefined(classe)) {
            valret.append("MODULE : ").append(module).append(".").append(classe).append(" | ");
        } else {
            valret.append("MODULE : ").append(module).append(" | ");
        }
        if (StringUtil.isDefined(message)) {
            valret.append(message);
        }
        if (StringUtil.isDefined(extraInfos)) {
            valret.append(" (").append(extraInfos).append(")");
        }
        return valret.toString();
    }

    protected static String translateFileName(String fileName) {
        String valret = fileName;
        if (StringUtil.isDefined(fileName)) {
            int index = fileName.indexOf("@ErrorDir@");
            if (index == 0) {
                valret = errorDir + fileName.substring(index + 10, fileName.length());
            } else if (index > 0) {
                valret = fileName.substring(0, index) + errorDir + fileName.substring(index + 10, fileName.length());
            }
        }
        return valret;
    }

    protected static void addAppenderFromProperties(Properties fileProperties, int appenderNumber, int appenderType) {
        String layoutName;
        String module = fileProperties.getProperty("appender" + Integer.toString(appenderNumber) + ".module");
        if (module == null) {
            module = MODULE_ROOT;
        }
        SilverTraceLayout layout = (layoutName = fileProperties.getProperty("appender" + Integer.toString(appenderNumber) + ".layout")) == null ? SilverTraceLayout.LAYOUT_SHORT : SilverTraceLayout.getSilverTraceLayout(layoutName);
        switch (appenderType) {
            case 1: {
                String consoleName = fileProperties.getProperty("appender" + Integer.toString(appenderNumber) + ".consoleName");
                SilverTrace.addAppenderConsole(module, layout.name(), consoleName);
                break;
            }
            case 2: {
                String fileName = SilverTrace.translateFileName(fileProperties.getProperty("appender" + Integer.toString(appenderNumber) + ".fileName"));
                boolean append = MsgTrace.getBooleanProperty(fileProperties, "appender" + Integer.toString(appenderNumber) + ".append", true);
                SilverTrace.addAppenderFile(module, layout.name(), fileName, append);
                break;
            }
            case 4: {
                String fileName = SilverTrace.translateFileName(fileProperties.getProperty("appender" + Integer.toString(appenderNumber) + ".fileName"));
                String rollingModeName = fileProperties.getProperty("appender" + Integer.toString(appenderNumber) + ".rollingMode");
                String rollingMode = !StringUtil.isDefined(rollingModeName) ? ROLLING_MODE_DAILY : ("ROLLING_MODE_MOUNTH".equalsIgnoreCase(rollingModeName) ? ROLLING_MODE_MONTH : ("ROLLING_MODE_WEEK".equalsIgnoreCase(rollingModeName) ? ROLLING_MODE_WEEK : ("ROLLING_MODE_DAILY".equalsIgnoreCase(rollingModeName) ? ROLLING_MODE_DAILY : ("ROLLING_MODE_HOUR".equalsIgnoreCase(rollingModeName) ? ROLLING_MODE_HOUR : rollingModeName))));
                SilverTrace.addAppenderRollingFile(module, layout.name(), fileName, rollingMode);
                break;
            }
            case 8: {
                String mailHost = fileProperties.getProperty("appender" + Integer.toString(appenderNumber) + ".mailHost");
                String mailFrom = fileProperties.getProperty("appender" + Integer.toString(appenderNumber) + ".mailFrom");
                String mailTo = fileProperties.getProperty("appender" + Integer.toString(appenderNumber) + ".mailTo");
                String mailSubject = fileProperties.getProperty("appender" + Integer.toString(appenderNumber) + ".mailSubject");
                SilverTrace.addAppenderMail(module, layout.name(), mailHost, mailFrom, mailTo, mailSubject);
            }
        }
    }

    protected static Logger getModuleLogger(String module) {
        if (MODULE_ROOT.equalsIgnoreCase(module)) {
            return Logger.getRootLogger();
        }
        String modulePath = availableModules.getProperty(module);
        if (modulePath == null) {
            return null;
        }
        return Logger.getLogger((String)modulePath);
    }

    protected static String getAppenderName(String module, int typeOfAppender) {
        if ((typeOfAppender & 1) == 1) {
            return module + ".ConsoleAppender";
        }
        if ((typeOfAppender & 2) == 2) {
            return module + ".FileAppender";
        }
        if ((typeOfAppender & 4) == 4) {
            return module + ".DailyRollingFileAppender";
        }
        if ((typeOfAppender & 8) == 8) {
            return module + ".SMTPAppender";
        }
        return null;
    }

    protected static void emergencyTrace(String msgToTrace, Throwable ex) {
        StringBuilder sb = new StringBuilder(msgToTrace);
        if (ex != null) {
            sb.append("| Ex : ").append(ex.getMessage());
        }
        System.err.println(sb.toString());
        if (ex != null) {
            System.err.println(ex);
        }
    }

    protected static void emergencyTrace(String module, String classe, String msgToTrace, String extraInfos, Throwable ex) {
        StringBuilder sb = new StringBuilder("SilverTrace can't display normaly the message : ");
        if (module != null) {
            sb.append(" Module : ").append(module);
        }
        if (classe != null) {
            sb.append("| Classe : ").append(classe);
        }
        if (msgToTrace != null) {
            sb.append("| Msg : ").append(msgToTrace);
        }
        if (extraInfos != null) {
            sb.append(" (").append(extraInfos).append(")");
        }
        SilverTrace.emergencyTrace(sb.toString(), ex);
    }

    static {
        SilverTrace.resetAll();
        initFinished = true;
        SilverTrace.info("silvertrace", "SilverTrace.static", "silvertrace.MSG_END_OF_INIT");
    }
}

