/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.util;

import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.GeneralPropertiesManager;
import com.stratelia.webactiv.util.ResourceLocator;
import java.text.ParseException;
import java.util.Date;
import java.util.ResourceBundle;

public class ResourcesWrapper {
    private ResourceLocator specificMultilang = null;
    private ResourceLocator specificIcons = null;
    private ResourceLocator specificSettings = null;
    private ResourceLocator genericMultilang = null;
    private String language = null;

    public ResourcesWrapper(ResourceLocator specificMultilang, ResourceLocator specificIcons, String language) {
        this.specificMultilang = specificMultilang;
        this.specificIcons = specificIcons;
        this.genericMultilang = GeneralPropertiesManager.getGeneralMultilang(language);
        this.language = language;
    }

    public ResourcesWrapper(ResourceLocator specificMultilang, ResourceLocator specificIcons, ResourceLocator specificSettings, String language) {
        this.specificMultilang = specificMultilang;
        this.specificIcons = specificIcons;
        this.genericMultilang = GeneralPropertiesManager.getGeneralMultilang(language);
        this.language = language;
        this.specificSettings = specificSettings;
    }

    public ResourcesWrapper(ResourceLocator specificMultilang, String language) {
        this.specificMultilang = specificMultilang;
        this.genericMultilang = GeneralPropertiesManager.getGeneralMultilang(language);
        this.language = language;
    }

    public ResourceBundle getMultilangBundle() {
        return this.specificMultilang.getResourceBundle();
    }

    public ResourceBundle getIconsBundle() {
        return this.specificIcons.getResourceBundle();
    }

    public String getString(String key) {
        String valret = null;
        if (key != null) {
            valret = key;
            if (key.startsWith("GML.")) {
                if (this.genericMultilang != null) {
                    valret = this.genericMultilang.getString(key);
                }
            } else if (this.specificMultilang != null) {
                valret = this.specificMultilang.getString(key);
            }
        }
        if (valret == null) {
            valret = "";
        }
        return valret;
    }

    public String getStringWithParam(String key, String param) {
        String[] params = new String[]{param};
        return this.getStringWithParams(key, params);
    }

    public String getStringWithParams(String key, String[] params) {
        String valret = null;
        if (key != null) {
            valret = key;
            if (key.startsWith("GML.")) {
                if (this.genericMultilang != null) {
                    valret = this.genericMultilang.getStringWithParams(key, params);
                }
            } else if (this.specificMultilang != null) {
                valret = this.specificMultilang.getStringWithParams(key, params);
            }
        }
        if (valret == null) {
            valret = "";
        }
        return valret;
    }

    public String getIcon(String key) {
        return URLManager.getApplicationURL() + this.getValue(key, this.specificIcons);
    }

    public String getLanguage() {
        return this.language;
    }

    public String getSetting(String key) {
        return this.getSetting(key, null);
    }

    public String getSetting(String key, String defaultValue) {
        return this.specificSettings.getString(key, defaultValue);
    }

    public boolean getSetting(String key, boolean defaultValue) {
        return this.specificSettings.getBoolean(key, defaultValue);
    }

    public int getSetting(String key, int defaultValue) {
        return this.specificSettings.getInteger(key, defaultValue);
    }

    public String getOutputDate(Date date) {
        return DateUtil.getOutputDate(date, this.language);
    }

    public String getOutputDate(String dateDB) throws ParseException {
        return DateUtil.getOutputDate(dateDB, this.language);
    }

    public String getOutputDateAndHour(Date date) {
        return DateUtil.getOutputDateAndHour(date, this.language);
    }

    public String getOutputDateAndHour(Date date, Date defaultDate) {
        String formatedDate = DateUtil.getOutputDateAndHour(date, this.language);
        if (!StringUtil.isDefined(formatedDate)) {
            formatedDate = DateUtil.getOutputDateAndHour(defaultDate, this.language);
        }
        return formatedDate;
    }

    public String getInputDate(Date date) {
        return DateUtil.getInputDate(date, this.language);
    }

    public String getInputDate(String dateDB) throws ParseException {
        return DateUtil.getInputDate(dateDB, this.language);
    }

    public String getDBDate(String date) throws ParseException {
        return DateUtil.date2SQLDate(date, this.language);
    }

    public String getDBDate(Date date) {
        return DateUtil.date2SQLDate(date);
    }

    public Date getDate(String date) throws ParseException {
        return DateUtil.stringToDate(date, this.language);
    }

    private String getValue(String key, ResourceLocator resourceLocator) {
        String valret = null;
        if (key != null) {
            valret = key;
            if (resourceLocator != null) {
                valret = resourceLocator.getString(key);
            }
        }
        if (valret == null) {
            valret = "";
        }
        return valret;
    }
}

