/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin;

import com.silverpeas.util.ArrayUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.ComponentInst;
import com.stratelia.webactiv.beans.admin.ComponentInstManager;
import com.stratelia.webactiv.beans.admin.DomainDriverManager;
import com.stratelia.webactiv.beans.admin.SpaceI18N;
import com.stratelia.webactiv.beans.admin.SpaceInst;
import com.stratelia.webactiv.beans.admin.SpaceInstLight;
import com.stratelia.webactiv.beans.admin.SpaceProfileInst;
import com.stratelia.webactiv.beans.admin.SpaceProfileInstManager;
import com.stratelia.webactiv.beans.admin.cache.TreeCache;
import com.stratelia.webactiv.beans.admin.dao.SpaceDAO;
import com.stratelia.webactiv.organization.AdminPersistenceException;
import com.stratelia.webactiv.organization.SpaceI18NRow;
import com.stratelia.webactiv.organization.SpaceRow;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.JNDINames;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class SpaceInstManager {
    static ComponentInstManager componentInstManager = new ComponentInstManager();
    static SpaceProfileInstManager spaceProfileInstManager = new SpaceProfileInstManager();

    public SpaceInst copy(SpaceInst spaceInstToCopy) {
        int nI;
        if (spaceInstToCopy == null) {
            return null;
        }
        SpaceInst spaceInst = new SpaceInst();
        spaceInst.setLevel(spaceInstToCopy.getLevel());
        spaceInst.setId(spaceInstToCopy.getId());
        spaceInst.setDomainFatherId(spaceInstToCopy.getDomainFatherId());
        spaceInst.setName(spaceInstToCopy.getName());
        spaceInst.setDescription(spaceInstToCopy.getDescription());
        spaceInst.setCreatorUserId(spaceInstToCopy.getCreatorUserId());
        spaceInst.setFirstPageType(spaceInstToCopy.getFirstPageType());
        spaceInst.setFirstPageExtraParam(spaceInstToCopy.getFirstPageExtraParam());
        spaceInst.setOrderNum(spaceInstToCopy.getOrderNum());
        spaceInst.setCreateDate(spaceInstToCopy.getCreateDate());
        spaceInst.setUpdateDate(spaceInstToCopy.getUpdateDate());
        spaceInst.setRemoveDate(spaceInstToCopy.getRemoveDate());
        spaceInst.setStatus(spaceInstToCopy.getStatus());
        spaceInst.setUpdaterUserId(spaceInstToCopy.getUpdaterUserId());
        spaceInst.setRemoverUserId(spaceInstToCopy.getRemoverUserId());
        spaceInst.setInheritanceBlocked(spaceInstToCopy.isInheritanceBlocked());
        spaceInst.setLook(spaceInstToCopy.getLook());
        String[] asSubSpaceIdsToCopy = spaceInstToCopy.getSubSpaceIds();
        String[] asSubSpaceIds = new String[asSubSpaceIdsToCopy.length];
        System.arraycopy(asSubSpaceIdsToCopy, 0, asSubSpaceIds, 0, asSubSpaceIdsToCopy.length);
        spaceInst.setSubSpaceIds(asSubSpaceIds);
        for (nI = 0; nI < spaceInstToCopy.getNumComponentInst(); ++nI) {
            spaceInst.addComponentInst(componentInstManager.copy(spaceInstToCopy.getComponentInst(nI)));
        }
        for (nI = 0; nI < spaceInstToCopy.getNumSpaceProfileInst(); ++nI) {
            spaceInst.addSpaceProfileInst(spaceInstToCopy.getSpaceProfileInst(nI));
        }
        spaceInst.setLanguage(spaceInstToCopy.getLanguage());
        for (SpaceI18N translation : spaceInstToCopy.getTranslations().values()) {
            spaceInst.addTranslation(translation);
        }
        spaceInst.setDisplaySpaceFirst(spaceInstToCopy.isDisplaySpaceFirst());
        spaceInst.setPersonalSpace(spaceInstToCopy.isPersonalSpace());
        return spaceInst;
    }

    public String createSpaceInst(SpaceInst spaceInst, DomainDriverManager ddManager) throws AdminException {
        try {
            this.isValidSpace(spaceInst);
            SpaceRow newSpaceRow = this.makeSpaceRow(spaceInst);
            String sSpaceNodeId = "";
            ddManager.getOrganization().space.createSpace(newSpaceRow);
            sSpaceNodeId = SpaceInstManager.idAsString(newSpaceRow.id);
            Map translations = spaceInst.getTranslations();
            for (String lang : translations.keySet()) {
                if (lang.equals(newSpaceRow.lang)) continue;
                SpaceI18N translation = (SpaceI18N)translations.get(lang);
                SpaceI18NRow row = new SpaceI18NRow(newSpaceRow.id, lang, translation.getName(), translation.getDescription());
                ddManager.getOrganization().spaceI18N.createTranslation(row);
            }
            for (int nI = 0; nI < spaceInst.getNumSpaceProfileInst(); ++nI) {
                spaceProfileInstManager.createSpaceProfileInst(spaceInst.getSpaceProfileInst(nI), ddManager, sSpaceNodeId);
            }
            return sSpaceNodeId;
        }
        catch (Exception e) {
            throw new AdminException("SpaceInstManager.createSpaceInst", 4, "admin.EX_ERR_ADD_SPACE", "space name : '" + spaceInst.getName() + "'", e);
        }
    }

    public SpaceInst getSpaceInstById(DomainDriverManager ddManager, String spaceInstId) throws AdminException {
        try {
            String[] asProfIds;
            ddManager.getOrganizationSchema();
            SpaceRow space = ddManager.getOrganization().space.getSpace(this.idAsInt(spaceInstId));
            if (space == null) {
                SilverTrace.error("admin", "SpaceInstManager.getSpaceInstById", "admin.EX_ERR_SPACE_NOT_FOUND", "spaceId = " + spaceInstId);
                SpaceInst spaceInst = null;
                return spaceInst;
            }
            SpaceInst spaceInst = this.spaceRow2SpaceInst(space);
            String[] asSubSpaceIds = ddManager.getOrganization().space.getDirectSubSpaceIds(this.idAsInt(spaceInstId));
            spaceInst.setSubSpaceIds(asSubSpaceIds);
            String[] asCompoIds = ddManager.getOrganization().instance.getAllComponentInstanceIdsInSpace(this.idAsInt(spaceInstId));
            if (asCompoIds != null) {
                for (String componentId : asCompoIds) {
                    ComponentInst componentInst = componentInstManager.getComponentInst(ddManager, componentId, spaceInstId);
                    spaceInst.addComponentInst(componentInst);
                }
            }
            if ((asProfIds = ddManager.getOrganization().spaceUserRole.getAllSpaceUserRoleIdsOfSpace(this.idAsInt(spaceInstId))) != null) {
                for (String profileId : asProfIds) {
                    SpaceProfileInst spaceProfileInst = spaceProfileInstManager.getSpaceProfileInst(ddManager, profileId, spaceInstId);
                    spaceInst.addSpaceProfileInst(spaceProfileInst);
                }
            }
            spaceInst.setLanguage(space.lang);
            SpaceI18N translation = new SpaceI18N(space.lang, space.name, space.description);
            spaceInst.addTranslation(translation);
            List<SpaceI18NRow> translations = ddManager.getOrganization().spaceI18N.getTranslations(this.idAsInt(spaceInstId));
            for (int t = 0; translations != null && t < translations.size(); ++t) {
                SpaceI18NRow row = translations.get(t);
                spaceInst.addTranslation(new SpaceI18N(row));
            }
            SpaceInst spaceInst2 = spaceInst;
            return spaceInst2;
        }
        catch (Exception e) {
            throw new AdminException("SpaceInstManager.getSpaceInstById", 4, "admin.EX_ERR_SET_SPACE", "spaceId : '" + spaceInstId + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public SpaceInst getPersonalSpace(DomainDriverManager ddManager, String userId) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            SpaceRow space = ddManager.getOrganization().space.getPersonalSpace(userId);
            if (space != null) {
                SpaceInst spaceInst = this.spaceRow2SpaceInst(space);
                String[] asCompoIds = ddManager.getOrganization().instance.getAllComponentInstanceIdsInSpace(this.idAsInt(spaceInst.getId()));
                for (int nI = 0; asCompoIds != null && nI < asCompoIds.length; ++nI) {
                    ComponentInst componentInst = componentInstManager.getComponentInst(ddManager, asCompoIds[nI], spaceInst.getId());
                    spaceInst.addComponentInst(componentInst);
                }
                spaceInst.setLanguage(space.lang);
                SpaceInst spaceInst2 = spaceInst;
                return spaceInst2;
            }
            SpaceInst spaceInst = null;
            return spaceInst;
        }
        catch (Exception e) {
            throw new AdminException("SpaceInstManager.getPersonalSpace", 4, "admin.EX_ERR_GET_PERSONAL_SPACE", "userId = " + userId, e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    private SpaceInst spaceRow2SpaceInst(SpaceRow space) {
        SpaceInst spaceInst = new SpaceInst();
        spaceInst.setId(SpaceInstManager.idAsString(space.id));
        spaceInst.setDomainFatherId(SpaceInstManager.idAsString(space.domainFatherId));
        int spaceLevel = -1;
        spaceLevel = spaceInst.isRoot() ? 0 : this.getSpaceLevel(space.domainFatherId) + 1;
        spaceInst.setLevel(spaceLevel);
        spaceInst.setName(space.name);
        spaceInst.setDescription(space.description);
        spaceInst.setCreatorUserId(SpaceInstManager.idAsString(space.createdBy));
        spaceInst.setFirstPageType(space.firstPageType);
        spaceInst.setFirstPageExtraParam(space.firstPageExtraParam);
        spaceInst.setOrderNum(space.orderNum);
        if (space.createTime != null) {
            spaceInst.setCreateDate(new Date(Long.parseLong(space.createTime)));
        }
        if (space.updateTime != null) {
            spaceInst.setUpdateDate(new Date(Long.parseLong(space.updateTime)));
        }
        if (space.removeTime != null) {
            spaceInst.setRemoveDate(new Date(Long.parseLong(space.removeTime)));
        }
        spaceInst.setUpdaterUserId(SpaceInstManager.idAsString(space.updatedBy));
        spaceInst.setRemoverUserId(SpaceInstManager.idAsString(space.removedBy));
        spaceInst.setStatus(space.status);
        spaceInst.setInheritanceBlocked(space.inheritanceBlocked == 1);
        spaceInst.setLook(space.look);
        spaceInst.setDisplaySpaceFirst(space.displaySpaceFirst == 1);
        spaceInst.setPersonalSpace(space.isPersonalSpace == 1);
        return spaceInst;
    }

    public SpaceInstLight getSpaceInstLightById(DomainDriverManager ddManager, String spaceId) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            SpaceRow spaceRow = ddManager.getOrganization().space.getSpace(this.idAsInt(spaceId));
            if (spaceRow == null) {
                SpaceInstLight spaceInstLight = null;
                return spaceInstLight;
            }
            SpaceInstLight spaceInstLight = new SpaceInstLight(spaceRow);
            spaceInstLight.setLevel(this.getSpaceLevel(spaceRow.id));
            this.setTranslations(ddManager, spaceInstLight, spaceRow);
            SpaceInstLight spaceInstLight2 = spaceInstLight;
            return spaceInstLight2;
        }
        catch (Exception e) {
            throw new AdminException("SpaceInstManager.getSpaceInstLightById", 4, "admin.EX_ERR_GET_SPACE", "space Id = " + spaceId, e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public void updateSpaceOrder(DomainDriverManager ddManager, String sSpaceId, int orderNum) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            ddManager.getOrganization().space.updateSpaceOrder(this.idAsInt(sSpaceId), orderNum);
        }
        catch (Exception e) {
            throw new AdminException("SpaceInstManager.updateSpaceOrder", 4, "admin.EX_ERR_UPDATE_SPACE", "space Id : '" + sSpaceId + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    private int getSpaceLevel(int spaceId) {
        return TreeCache.getSpaceLevel(Integer.toString(spaceId));
    }

    public String[] getAllRootSpaceIds(DomainDriverManager ddManager) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            String[] asSpaceIds = ddManager.getOrganization().space.getAllRootSpaceIds();
            if (asSpaceIds != null) {
                String[] stringArray = asSpaceIds;
                return stringArray;
            }
            String[] stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
            return stringArray;
        }
        catch (Exception e) {
            throw new AdminException("SpaceInstManager.getAllSpaceIds", 4, "admin.EX_ERR_GET_ALL_SPACE_IDS", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public String[] getAllSpaceIds(DomainDriverManager ddManager) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            String[] asSpaceIds = ddManager.getOrganization().space.getAllSpaceIds();
            if (asSpaceIds != null) {
                String[] stringArray = asSpaceIds;
                return stringArray;
            }
            String[] stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
            return stringArray;
        }
        catch (Exception e) {
            throw new AdminException("SpaceInstManager.getAllSpaceIds", 4, "admin.EX_ERR_GET_ALL_SPACE_IDS", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public List<SpaceInstLight> getRemovedSpaces(DomainDriverManager ddManager) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            SpaceRow[] spaceRows = ddManager.getOrganization().space.getRemovedSpaces();
            List<SpaceInstLight> list = this.spaceRows2SpaceInstLights(ddManager, spaceRows);
            return list;
        }
        catch (Exception e) {
            throw new AdminException("SpaceInstManager.getRemovedSpaces", 4, "admin.EX_ERR_GET_REMOVED_SPACES", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public List<SpaceInstLight> getSubSpaces(DomainDriverManager ddManager, String spaceId) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            List<SpaceRow> rows = ddManager.getOrganization().space.getDirectSubSpaces(Integer.parseInt(spaceId));
            List<SpaceInstLight> list = this.spaceRows2SpaceInstLights(ddManager, rows.toArray(new SpaceRow[0]));
            return list;
        }
        catch (Exception e) {
            throw new AdminException("SpaceInstManager.getSubSpaces", 4, "admin.EX_ERR_GET_SUBSPACES", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public List<String> getRootSpaceIds() throws AdminException {
        Connection con = null;
        try {
            con = DBUtil.makeConnection(JNDINames.ADMIN_DATASOURCE);
            List<String> list = SpaceDAO.getRootSpaceIds(con);
            return list;
        }
        catch (Exception e) {
            throw new AdminException("SpaceInstManager.getRootSpaceIds", 4, "admin.EX_ERR_GET_ROOTSPACEIDS", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    private void setTranslations(DomainDriverManager ddManager, SpaceInstLight space, SpaceRow row) {
        try {
            space.setLanguage(row.lang);
            SpaceI18N translation = new SpaceI18N(row.lang, row.name, row.description);
            space.addTranslation(translation);
            if (I18NHelper.isI18nContentActivated) {
                List<SpaceI18NRow> translations = ddManager.getOrganization().spaceI18N.getTranslations(row.id);
                for (int t = 0; translations != null && t < translations.size(); ++t) {
                    SpaceI18NRow i18nRow = translations.get(t);
                    space.addTranslation(new SpaceI18N(i18nRow));
                }
            }
        }
        catch (AdminPersistenceException e) {
            e.printStackTrace();
        }
    }

    private List<SpaceInstLight> spaceRows2SpaceInstLights(DomainDriverManager ddManager, SpaceRow[] spaceRows) {
        ArrayList<SpaceInstLight> spaces = new ArrayList<SpaceInstLight>();
        if (spaceRows == null) {
            return spaces;
        }
        for (SpaceRow row : spaceRows) {
            SpaceInstLight spaceLight = new SpaceInstLight(row);
            this.setTranslations(ddManager, spaceLight, row);
            spaces.add(spaceLight);
        }
        return spaces;
    }

    public String[] getAllSpaceProfileIds(DomainDriverManager ddManager, String sSpaceId) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            String[] asSpaceProfileIds = ddManager.getOrganization().spaceUserRole.getAllSpaceUserRoleIdsOfSpace(this.idAsInt(sSpaceId));
            if (asSpaceProfileIds != null) {
                String[] stringArray = asSpaceProfileIds;
                return stringArray;
            }
            String[] stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
            return stringArray;
        }
        catch (Exception e) {
            throw new AdminException("SpaceInstManager.getAllSpaceProfileIds", 4, "admin.EX_ERR_GET_ALL_SPACE_PROFILE_IDS", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public String[] getAllSubSpaceIds(DomainDriverManager ddManager, String sDomainFatherId) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            String[] asSpaceIds = ddManager.getOrganization().space.getDirectSubSpaceIds(this.idAsInt(sDomainFatherId));
            if (asSpaceIds != null) {
                String[] stringArray = asSpaceIds;
                return stringArray;
            }
            String[] stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
            return stringArray;
        }
        catch (Exception e) {
            throw new AdminException("SpaceInstManager.getAllSubSpaceIds", 4, "admin.EX_ERR_GET_ALL_SUBSPACE_IDS", " father space Id : '" + sDomainFatherId + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public void deleteSpaceInst(SpaceInst spaceInst, DomainDriverManager ddManager) throws AdminException {
        try {
            ddManager.getOrganization().spaceI18N.removeTranslations(this.idAsInt(spaceInst.getId()));
            ddManager.getOrganization().space.removeSpace(this.idAsInt(spaceInst.getId()));
        }
        catch (Exception e) {
            throw new AdminException("SpaceInstManager.deleteSpaceInst", 4, "admin.EX_ERR_DELETE_SPACE", "space Id : '" + spaceInst.getId() + "'", e);
        }
    }

    public void sendSpaceToBasket(DomainDriverManager ddManager, SpaceInst spaceInst, String userId) throws AdminException {
        boolean nameOK = false;
        int retry = 0;
        String deletedSpaceName = null;
        while (!nameOK) {
            boolean spaceAlreadyExists;
            deletedSpaceName = spaceInst.getName() + " (Restaur\u00e9)";
            if (retry > 0) {
                deletedSpaceName = deletedSpaceName + " " + retry;
            }
            nameOK = !(spaceAlreadyExists = ddManager.getOrganization().space.isSpaceIntoBasket(this.idAsInt(spaceInst.getDomainFatherId()), deletedSpaceName));
            ++retry;
        }
        try {
            ddManager.getOrganization().space.sendSpaceToBasket(this.idAsInt(spaceInst.getId()), deletedSpaceName, userId);
        }
        catch (Exception e) {
            throw new AdminException("SpaceInstManager.sendSpaceToBasket", 4, "admin.EX_ERR_SEND_SPACE_INTO_BASKET", "spaceId = " + spaceInst.getId(), e);
        }
    }

    public void removeSpaceFromBasket(DomainDriverManager ddManager, String spaceId) throws AdminException {
        try {
            ddManager.getOrganization().space.removeSpaceFromBasket(this.idAsInt(spaceId));
        }
        catch (Exception e) {
            throw new AdminException("SpaceInstManager.removeSpaceFromBasket", 4, "admin.EX_ERR_RESTORE_SPACE_FROM_BASKET", "spaceId = " + spaceId, e);
        }
    }

    public void moveSpace(DomainDriverManager ddManager, int spaceId, int fatherId) throws AdminException {
        try {
            ddManager.getOrganization().space.moveSpace(spaceId, fatherId);
        }
        catch (Exception e) {
            throw new AdminException("SpaceInstManager.moveSpace", 4, "admin.EX_ERR_MOVING_SPACE", "spaceId= " + spaceId + ", fatherId=" + fatherId, e);
        }
    }

    public void updateSpaceInst(DomainDriverManager ddManager, SpaceInst spaceInstNew) throws AdminException {
        try {
            this.isValidSpace(spaceInstNew);
            SpaceRow changedSpace = this.makeSpaceRow(spaceInstNew);
            changedSpace.id = this.idAsInt(spaceInstNew.getId());
            SpaceRow oldSpace = ddManager.getOrganization().space.getSpace(changedSpace.id);
            SilverTrace.debug("admin", this.getClass().getName() + ".updateSpaceInst", "root.MSG_GEN_PARAM_VALUE", "remove = " + spaceInstNew.isRemoveTranslation() + ", translationId = " + spaceInstNew.getTranslationId());
            if (spaceInstNew.isRemoveTranslation()) {
                if (oldSpace.lang.equalsIgnoreCase(spaceInstNew.getLanguage())) {
                    List<SpaceI18NRow> translations = ddManager.getOrganization().spaceI18N.getTranslations(changedSpace.id);
                    if (translations != null && translations.size() > 0) {
                        SpaceI18NRow translation = translations.get(0);
                        changedSpace.lang = translation.lang;
                        changedSpace.name = translation.name;
                        changedSpace.description = translation.description;
                        ddManager.getOrganization().space.updateSpace(changedSpace);
                        ddManager.getOrganization().spaceI18N.removeTranslation(translation.id);
                    }
                } else {
                    ddManager.getOrganization().spaceI18N.removeTranslation(Integer.parseInt(spaceInstNew.getTranslationId()));
                }
            } else {
                if (changedSpace.lang != null) {
                    if (oldSpace.lang == null) {
                        oldSpace.lang = I18NHelper.defaultLanguage;
                    }
                    if (!oldSpace.lang.equalsIgnoreCase(changedSpace.lang)) {
                        SpaceI18NRow row = new SpaceI18NRow(changedSpace);
                        String translationId = spaceInstNew.getTranslationId();
                        if (translationId != null && !translationId.equals("-1")) {
                            row.id = Integer.parseInt(spaceInstNew.getTranslationId());
                            ddManager.getOrganization().spaceI18N.updateTranslation(row);
                        } else {
                            ddManager.getOrganization().spaceI18N.createTranslation(row);
                        }
                        changedSpace.lang = oldSpace.lang;
                        changedSpace.name = oldSpace.name;
                        changedSpace.description = oldSpace.description;
                    }
                }
                ddManager.getOrganization().space.updateSpace(changedSpace);
            }
        }
        catch (Exception e) {
            throw new AdminException("SpaceInstManager.updateSpaceInst", 4, "admin.EX_ERR_UPDATE_SPACE", "space Id : '" + spaceInstNew.getId() + "'", e);
        }
    }

    private void isValidSpace(SpaceInst spaceInst) throws AdminException {
        String sError = "";
        if (spaceInst.getName().length() < 1) {
            sError = sError + "The space name is empty";
        }
        if (sError.length() != 0) {
            throw new AdminException("SpaceInstManager.isValidSpace", 4, "admin.EX_ERR_INVALID_SPACE", "space Id : '" + spaceInst.getId() + "'");
        }
    }

    public boolean isSpaceInstExist(DomainDriverManager ddManager, String sSpaceInstId) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            boolean bl = ddManager.getOrganization().space.isSpaceInstExist(this.idAsInt(sSpaceInstId));
            return bl;
        }
        catch (Exception e) {
            throw new AdminException("SpaceInstManager.isSpaceInstExist", 4, "admin.EX_ERR_IS_SPACE_EXIST", "space Id : '" + sSpaceInstId + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public List<SpaceInstLight> getAllSpaces(DomainDriverManager ddManager) throws AdminException {
        ArrayList<SpaceInstLight> spaces = new ArrayList<SpaceInstLight>();
        try {
            ddManager.getOrganizationSchema();
            SpaceRow[] spaceRows = ddManager.getOrganization().space.getAllSpaces();
            spaces.addAll(this.spaceRows2SpaceInstLights(ddManager, spaceRows));
        }
        catch (Exception e) {
            throw new AdminException("SpaceInstManager.getAllSpaces", 4, "admin.EX_GETTING_ALL_SPACES", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
        return spaces;
    }

    public List<String> getManageableSpaceIds(String userId, List<String> groupIds) throws AdminException {
        Connection con = null;
        try {
            con = DBUtil.makeConnection(JNDINames.ADMIN_DATASOURCE);
            List<String> list = SpaceDAO.getManageableSpaceIds(con, userId, groupIds);
            return list;
        }
        catch (Exception e) {
            throw new AdminException("SpaceInstManager.getManageableSpaceIds", 4, "admin.EX_GETTING_MANAGEABLE_SPACEIDS", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    private SpaceRow makeSpaceRow(SpaceInst spaceInst) {
        SpaceRow space = new SpaceRow();
        space.id = this.idAsInt(spaceInst.getId());
        space.domainFatherId = this.idAsInt(spaceInst.getDomainFatherId());
        space.name = spaceInst.getName();
        space.description = spaceInst.getDescription();
        space.createdBy = this.idAsInt(spaceInst.getCreatorUserId());
        space.firstPageType = spaceInst.getFirstPageType();
        space.firstPageExtraParam = spaceInst.getFirstPageExtraParam();
        space.orderNum = spaceInst.getOrderNum();
        space.updatedBy = this.idAsInt(spaceInst.getUpdaterUserId());
        space.lang = spaceInst.getLanguage();
        space.look = spaceInst.getLook();
        space.inheritanceBlocked = spaceInst.isInheritanceBlocked() ? 1 : 0;
        space.displaySpaceFirst = spaceInst.isDisplaySpaceFirst() ? 1 : 0;
        space.isPersonalSpace = 0;
        if (spaceInst.isPersonalSpace()) {
            space.isPersonalSpace = 1;
        }
        return space;
    }

    private int idAsInt(String id) {
        if (id == null || id.length() == 0) {
            return -1;
        }
        try {
            return Integer.parseInt(id);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static String idAsString(int id) {
        return String.valueOf(id);
    }
}

