/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.util.Vector;

public class SynchroGroupReport {
    public static final int TRACE_LEVEL_UNKNOWN = 0;
    public static final int TRACE_LEVEL_DEBUG = 1;
    public static final int TRACE_LEVEL_INFO = 2;
    public static final int TRACE_LEVEL_WARN = 3;
    public static final int TRACE_LEVEL_ERROR = 4;
    public static final int TRACE_LEVEL_FATAL = 5;
    public static final int STATE_NOSYNC = 0;
    public static final int STATE_WAITSTART = 1;
    public static final int STATE_STARTED = 2;
    public static final int STATE_ENDED = 3;
    private static final String moduleName = "synchroGroup";
    private static int iTraceLevel = 3;
    private static Vector<String> VMessage = new Vector();
    private static int iState = 0;

    public static String getModuleName() {
        return moduleName;
    }

    public static void setTraceLevel(int iTraceLevelFixed) {
        iTraceLevel = iTraceLevelFixed;
    }

    public static int getTraceLevel() {
        return iTraceLevel;
    }

    public static String getTraceLevelStr() {
        if (iTraceLevel == 3) {
            return "warning";
        }
        if (iTraceLevel == 1) {
            return "debug";
        }
        if (iTraceLevel == 2) {
            return "info";
        }
        if (iTraceLevel == 4) {
            return "error";
        }
        if (iTraceLevel == 5) {
            return "fatal";
        }
        return "unknown";
    }

    public static synchronized void setState(int iStateCours) {
        if (iState < 1 || iStateCours != 1) {
            iState = iStateCours;
        }
    }

    public static int getState() {
        return iState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMessage() {
        String Message2 = null;
        Vector<String> vector = VMessage;
        synchronized (vector) {
            if (VMessage.size() > 0) {
                Message2 = VMessage.remove(0);
            }
        }
        return Message2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startSynchro() {
        Vector<String> vector = VMessage;
        synchronized (vector) {
            VMessage.clear();
        }
        SynchroGroupReport.setState(2);
        SynchroGroupReport.warn("SynchroReport.startSynchro", "Debut de Synchronisation", null);
    }

    public static void stopSynchro() {
        SynchroGroupReport.warn("SynchroReport.stopSynchro", "Fin de Synchronisation", null);
        SynchroGroupReport.setState(3);
    }

    public static void debug(String classe, String message, Throwable ex) {
        if (SynchroGroupReport.isSynchroActive()) {
            SynchroGroupReport.addMessage(SynchroGroupReport.msgFormat(1, classe, message, ex), 1);
            SilverTrace.debug(SynchroGroupReport.getModuleName(), classe, message, ex);
        }
    }

    public static void info(String classe, String message, Throwable ex) {
        if (SynchroGroupReport.isSynchroActive()) {
            SynchroGroupReport.addMessage(SynchroGroupReport.msgFormat(2, classe, message, ex), 2);
            SilverTrace.info(SynchroGroupReport.getModuleName(), classe, "root.MSG_GEN_PARAM_VALUE", message, ex);
        }
    }

    public static void warn(String classe, String message, Throwable ex) {
        if (SynchroGroupReport.isSynchroActive()) {
            SynchroGroupReport.addMessage(SynchroGroupReport.msgFormat(3, classe, message, ex), 3);
            SilverTrace.warn(SynchroGroupReport.getModuleName(), classe, "root.MSG_GEN_PARAM_VALUE", message, ex);
        }
    }

    public static void error(String classe, String message, Throwable ex) {
        if (SynchroGroupReport.isSynchroActive()) {
            SynchroGroupReport.addMessage(SynchroGroupReport.msgFormat(4, classe, message, ex), 4);
            SilverTrace.error(SynchroGroupReport.getModuleName(), classe, "root.MSG_GEN_PARAM_VALUE", message, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addMessage(String msg, int priority) {
        if (priority >= iTraceLevel) {
            Vector<String> vector = VMessage;
            synchronized (vector) {
                VMessage.add(msg);
            }
        }
    }

    public static boolean isSynchroActive() {
        return iState == 2;
    }

    protected static String msgFormat(int traceLvl, String classe, String msgToTrace, Throwable ex) {
        StringBuffer sb = new StringBuffer();
        if (traceLvl == 1) {
            sb.append("D_");
        } else if (traceLvl == 2) {
            sb.append("I_");
        } else if (traceLvl == 3) {
            sb.append("W_");
        } else if (traceLvl == 4) {
            sb.append("E_");
        } else if (traceLvl == 5) {
            sb.append("F_");
        } else {
            sb.append("U_");
        }
        sb.append(msgToTrace);
        if (classe != null && classe.length() > 0) {
            sb.append(" | Classe : ").append(classe);
        }
        if (ex != null) {
            sb.append(" | !!! EXCEPTION !!! : ").append(ex.getMessage());
        }
        return sb.toString();
    }
}

