/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SynchroReport {
    public static final int TRACE_LEVEL_UNKNOWN = 0;
    public static final int TRACE_LEVEL_DEBUG = 1;
    public static final int TRACE_LEVEL_INFO = 2;
    public static final int TRACE_LEVEL_WARN = 3;
    public static final int TRACE_LEVEL_ERROR = 4;
    public static final int TRACE_LEVEL_FATAL = 5;
    public static final int STATE_NOSYNC = 0;
    public static final int STATE_WAITSTART = 1;
    public static final int STATE_STARTED = 2;
    public static final int STATE_ENDED = 3;
    private static final String moduleName = "synchro";
    private static int iTraceLevel;
    private static final List<String> VMessage;
    private static int iState;

    public static String getModuleName() {
        return moduleName;
    }

    public static void setTraceLevel(int iTraceLevelFixed) {
        SilverTrace.setTraceLevel(SynchroReport.getModuleName(), iTraceLevelFixed);
        iTraceLevel = iTraceLevelFixed;
    }

    public static int getTraceLevel() {
        return iTraceLevel;
    }

    public static String getTraceLevelStr() {
        switch (iTraceLevel) {
            case 3: {
                return "warning";
            }
            case 1: {
                return "debug";
            }
            case 2: {
                return "info";
            }
            case 4: {
                return "error";
            }
            case 5: {
                return "fatal";
            }
        }
        return "unknown";
    }

    public static synchronized void setState(int iStateCours) {
        if (iState < 1 || iStateCours != 1) {
            iState = iStateCours;
        }
    }

    public static int getState() {
        return iState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMessage() {
        String message = null;
        List<String> list = VMessage;
        synchronized (list) {
            if (!VMessage.isEmpty()) {
                message = VMessage.remove(0);
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startSynchro() {
        List<String> list = VMessage;
        synchronized (list) {
            VMessage.clear();
        }
        SynchroReport.setState(2);
        SynchroReport.warn("SynchroReport.startSynchro", "Debut de Synchronisation", null);
    }

    public static void stopSynchro() {
        SynchroReport.warn("SynchroReport.stopSynchro", "Fin de Synchronisation", null);
        SynchroReport.setState(3);
    }

    public static void debug(String classe, String message, Throwable ex) {
        if (SynchroReport.isSynchroActive()) {
            SynchroReport.addMessage(SynchroReport.msgFormat(1, classe, message, ex), 1);
            SilverTrace.debug(SynchroReport.getModuleName(), classe, message, ex);
        }
    }

    public static void info(String classe, String message, Throwable ex) {
        if (SynchroReport.isSynchroActive()) {
            SynchroReport.addMessage(SynchroReport.msgFormat(2, classe, message, ex), 2);
            SilverTrace.info(SynchroReport.getModuleName(), classe, "root.MSG_GEN_PARAM_VALUE", message, ex);
        }
    }

    public static void warn(String classe, String message, Throwable ex) {
        if (SynchroReport.isSynchroActive()) {
            SynchroReport.addMessage(SynchroReport.msgFormat(3, classe, message, ex), 3);
            SilverTrace.warn(SynchroReport.getModuleName(), classe, "root.MSG_GEN_PARAM_VALUE", message, ex);
        }
    }

    public static void error(String classe, String message, Throwable ex) {
        if (SynchroReport.isSynchroActive()) {
            SynchroReport.addMessage(SynchroReport.msgFormat(4, classe, message, ex), 4);
            SilverTrace.error(SynchroReport.getModuleName(), classe, "root.MSG_GEN_PARAM_VALUE", message, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addMessage(String msg, int priority) {
        if (priority >= iTraceLevel) {
            List<String> list = VMessage;
            synchronized (list) {
                VMessage.add(msg);
            }
        }
    }

    public static boolean isSynchroActive() {
        return iState == 2;
    }

    protected static String msgFormat(int traceLvl, String classe, String msgToTrace, Throwable ex) {
        StringBuilder sb = new StringBuilder();
        switch (traceLvl) {
            case 1: {
                sb.append("D_");
                break;
            }
            case 2: {
                sb.append("I_");
                break;
            }
            case 3: {
                sb.append("W_");
                break;
            }
            case 4: {
                sb.append("E_");
                break;
            }
            case 5: {
                sb.append("F_");
                break;
            }
            default: {
                sb.append("U_");
            }
        }
        sb.append(msgToTrace);
        if (classe != null && classe.length() > 0) {
            sb.append(" | Classe : ").append(classe);
        }
        if (ex != null) {
            sb.append(" | !!! EXCEPTION !!! : ").append(ex.getMessage());
        }
        return sb.toString();
    }

    static {
        VMessage = Collections.synchronizedList(new ArrayList());
        iTraceLevel = 3;
        iState = 0;
    }
}

