/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin;

import com.silverpeas.SilverpeasServiceProvider;
import com.silverpeas.personalization.UserPreferences;
import com.silverpeas.session.SessionManagement;
import com.silverpeas.session.SessionManagementFactory;
import com.silverpeas.socialnetwork.invitation.InvitationService;
import com.silverpeas.socialnetwork.relationShip.RelationShipService;
import com.silverpeas.socialnetwork.status.StatusService;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.silverpeas.notificationManager.NotificationManagerSettings;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.Domain;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.FileServerUtils;
import com.stratelia.webactiv.util.GeneralPropertiesManager;
import com.stratelia.webactiv.util.ResourceLocator;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.silverpeas.admin.user.constant.UserAccessLevel;
import org.silverpeas.admin.user.constant.UserState;
import org.silverpeas.cache.service.CacheServiceFactory;
import org.silverpeas.core.admin.OrganisationController;
import org.silverpeas.core.admin.OrganisationControllerFactory;

public class UserDetail
implements Serializable,
Comparable<UserDetail> {
    public static final String CURRENT_REQUESTER_KEY = UserDetail.class.getName() + "_CURRENT_REQUESTER";
    private static final long serialVersionUID = -109886153681824159L;
    private static final String ANONYMOUS_ID_PROPERTY = "anonymousId";
    private static final String AVATAR_PROPERTY = GeneralPropertiesManager.getString("avatar.property", "login");
    private static final String AVATAR_EXTENSION = GeneralPropertiesManager.getString("avatar.extension", "jpg");
    private static final String AVATAR_BASEURI = "/display/avatar/";
    private static final ResourceLocator generalSettings = new ResourceLocator("org.silverpeas.lookAndFeel.generalLook", "");
    private String id = null;
    private String specificId = null;
    private String domainId = null;
    private String login = null;
    private String firstName = "";
    private String lastName = "";
    private String eMail = "";
    private UserAccessLevel accessLevel = UserAccessLevel.from(null);
    private String loginQuestion = "";
    private String loginAnswer = "";
    private Date creationDate = null;
    private Date saveDate = null;
    private int version = 0;
    private Date tosAcceptanceDate = null;
    private Date lastLoginDate = null;
    private int nbSuccessfulLoginAttempts = 0;
    private Date lastLoginCredentialUpdateDate = null;
    private Date expirationDate = null;
    private UserState state = UserState.from(null);
    private Date stateSaveDate = null;
    private Integer notifManualReceiverLimit;

    public static UserDetail getById(String userId) {
        return UserDetail.getOrganisationController().getUserDetail(userId);
    }

    public static UserDetail getCurrentRequester() {
        return CacheServiceFactory.getSessionCacheService().get(CURRENT_REQUESTER_KEY, UserDetail.class);
    }

    public static boolean isActivatedStateFor(String userId) {
        UserDetail userDetail = UserDetail.getById(userId);
        return userDetail != null && userDetail.isActivatedState();
    }

    public static List<UserDetail> getAll() {
        return Arrays.asList(UserDetail.getOrganisationController().getAllUsers());
    }

    public static List<UserDetail> getAllInDomain(String domainId) {
        return Arrays.asList(UserDetail.getOrganisationController().getAllUsersInDomain(domainId));
    }

    public UserDetail() {
    }

    public UserDetail(UserDetail toClone) {
        this.id = toClone.getId();
        this.specificId = toClone.getSpecificId();
        this.domainId = toClone.getDomainId();
        this.login = toClone.getLogin();
        this.firstName = toClone.getFirstName();
        this.lastName = toClone.getLastName();
        this.eMail = toClone.geteMail();
        this.accessLevel = toClone.getAccessLevel();
        this.loginQuestion = toClone.getLoginQuestion();
        this.loginAnswer = toClone.getLoginAnswer();
        this.creationDate = toClone.getCreationDate();
        this.saveDate = toClone.getSaveDate();
        this.version = toClone.getVersion();
        this.tosAcceptanceDate = toClone.getTosAcceptanceDate();
        this.lastLoginDate = toClone.getLastLoginDate();
        this.nbSuccessfulLoginAttempts = toClone.getNbSuccessfulLoginAttempts();
        this.lastLoginCredentialUpdateDate = toClone.getLastLoginCredentialUpdateDate();
        this.expirationDate = toClone.getExpirationDate();
        this.state = toClone.getState();
        this.stateSaveDate = toClone.getStateSaveDate();
    }

    public String getLoginQuestion() {
        return this.loginQuestion;
    }

    public void setLoginQuestion(String loginQuestion) {
        this.loginQuestion = loginQuestion;
    }

    public String getLoginAnswer() {
        return this.loginAnswer;
    }

    public void setLoginAnswer(String loginAnswer) {
        this.loginAnswer = loginAnswer;
    }

    public Date getTosAcceptanceDate() {
        return this.tosAcceptanceDate;
    }

    public void setTosAcceptanceDate(Date tosAcceptanceDate) {
        this.tosAcceptanceDate = tosAcceptanceDate;
    }

    public Date getLastLoginDate() {
        return this.lastLoginDate;
    }

    public void setLastLoginDate(Date lastLoginDate) {
        this.lastLoginDate = lastLoginDate;
    }

    public int getNbSuccessfulLoginAttempts() {
        return this.nbSuccessfulLoginAttempts;
    }

    public void setNbSuccessfulLoginAttempts(int nbSuccessfulLoginAttempts) {
        this.nbSuccessfulLoginAttempts = nbSuccessfulLoginAttempts;
    }

    public Date getLastLoginCredentialUpdateDate() {
        return this.lastLoginCredentialUpdateDate;
    }

    public void setLastLoginCredentialUpdateDate(Date lastLoginCredentialUpdateDate) {
        this.lastLoginCredentialUpdateDate = lastLoginCredentialUpdateDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public UserState getState() {
        return this.state;
    }

    public void setState(UserState state) {
        this.state = state != null ? state : UserState.from(null);
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getSaveDate() {
        return this.saveDate;
    }

    public void setSaveDate(Date saveDate) {
        this.saveDate = saveDate;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Date getStateSaveDate() {
        return this.stateSaveDate;
    }

    public void setStateSaveDate(Date stateSaveDate) {
        this.stateSaveDate = stateSaveDate;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSpecificId() {
        return this.specificId;
    }

    public void setSpecificId(String specificId) {
        this.specificId = specificId;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login != null ? login : "";
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName != null ? firstName.trim() : "";
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String sLastName) {
        this.lastName = sLastName != null ? sLastName.trim() : "";
    }

    public void seteMail(String seMail) {
        this.eMail = seMail != null ? seMail : "";
    }

    public String geteMail() {
        return this.eMail;
    }

    public UserAccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public void setAccessLevel(UserAccessLevel accessLevel) {
        this.accessLevel = accessLevel != null ? accessLevel : UserAccessLevel.USER;
    }

    public Domain getDomain() {
        return UserDetail.getOrganisationController().getDomain(this.getDomainId());
    }

    public boolean isDomainRestricted() {
        return (GeneralPropertiesManager.getDomainVisibility() == 2 || GeneralPropertiesManager.getDomainVisibility() == 1 && !"0".equals(this.getDomainId())) && !this.isAccessAdmin();
    }

    public boolean isDomainAdminRestricted() {
        return GeneralPropertiesManager.getDomainVisibility() != 0 && !this.isAccessAdmin() && (GeneralPropertiesManager.getDomainVisibility() != 1 || !"0".equals(this.getDomainId()));
    }

    public boolean isBackOfficeVisible() {
        return this.isAccessPdcManager() || this.isAccessAdmin() || this.isAccessDomainManager();
    }

    public boolean isAccessAdmin() {
        return UserAccessLevel.ADMINISTRATOR.equals((Object)this.accessLevel);
    }

    public boolean isAccessDomainManager() {
        return UserAccessLevel.DOMAIN_ADMINISTRATOR.equals((Object)this.accessLevel);
    }

    public boolean isAccessSpaceManager() {
        return UserAccessLevel.SPACE_ADMINISTRATOR.equals((Object)this.accessLevel);
    }

    public boolean isAccessPdcManager() {
        return UserAccessLevel.PDC_MANAGER.equals((Object)this.accessLevel);
    }

    public boolean isAccessUser() {
        return UserAccessLevel.USER.equals((Object)this.accessLevel);
    }

    public boolean isAccessGuest() {
        return UserAccessLevel.GUEST.equals((Object)this.accessLevel);
    }

    public boolean isAccessUnknown() {
        return UserAccessLevel.UNKNOWN.equals((Object)this.accessLevel);
    }

    public boolean isActivatedState() {
        return !this.isAnonymous() && !this.isDeletedState() && !this.isDeactivatedState();
    }

    public boolean isValidState() {
        return this.isAnonymous() || !UserState.UNKNOWN.equals((Object)this.state) && !this.isDeletedState() && !this.isBlockedState() && !this.isDeactivatedState() && !this.isExpiredState();
    }

    public boolean isDeletedState() {
        return UserState.DELETED.equals((Object)this.state);
    }

    public boolean isBlockedState() {
        return UserState.BLOCKED.equals((Object)this.state);
    }

    public boolean isDeactivatedState() {
        return UserState.DEACTIVATED.equals((Object)this.state);
    }

    public boolean isExpiredState() {
        return UserState.EXPIRED.equals((Object)this.state) || this.getExpirationDate() != null && this.getExpirationDate().compareTo(DateUtil.getDate()) < 0;
    }

    public boolean isAnonymous() {
        return this.getId() != null && this.getId().equals(UserDetail.getAnonymousUserId());
    }

    public static UserDetail getAnonymousUser() {
        UserDetail anonymousUser = null;
        if (UserDetail.isAnonymousUserExist()) {
            anonymousUser = OrganisationControllerFactory.getOrganisationController().getUserDetail(UserDetail.getAnonymousUserId());
        }
        return anonymousUser;
    }

    public String getDisplayedName() {
        return (this.getFirstName() + " " + this.getLastName()).trim();
    }

    public boolean equals(Object other) {
        if (other instanceof UserDetail) {
            UserDetail cmpUser = (UserDetail)other;
            return StringUtil.areStringEquals(this.id, cmpUser.getId()) && StringUtil.areStringEquals(this.specificId, cmpUser.getSpecificId()) && StringUtil.areStringEquals(this.domainId, cmpUser.getDomainId()) && StringUtil.areStringEquals(this.login, cmpUser.getLogin()) && StringUtil.areStringEquals(this.firstName, cmpUser.getFirstName()) && StringUtil.areStringEquals(this.lastName, cmpUser.getLastName()) && StringUtil.areStringEquals(this.eMail, cmpUser.geteMail()) && this.accessLevel.equals((Object)cmpUser.getAccessLevel());
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 41 * hash + (this.id != null ? this.id.hashCode() : 0);
        hash = 41 * hash + (this.specificId != null ? this.specificId.hashCode() : 0);
        hash = 41 * hash + (this.domainId != null ? this.domainId.hashCode() : 0);
        hash = 41 * hash + (this.login != null ? this.login.hashCode() : 0);
        hash = 41 * hash + (this.firstName != null ? this.firstName.hashCode() : 0);
        hash = 41 * hash + (this.lastName != null ? this.lastName.hashCode() : 0);
        hash = 41 * hash + (this.eMail != null ? this.eMail.hashCode() : 0);
        hash = 41 * hash + (this.accessLevel != null ? this.accessLevel.hashCode() : 0);
        return hash;
    }

    public void traceUser() {
        SilverTrace.info("admin", "UserDetail.traceUser", "admin.MSG_DUMP_USER", "Id : " + this.id);
        SilverTrace.info("admin", "UserDetail.traceUser", "admin.MSG_DUMP_USER", "SpecificId : " + this.specificId);
        SilverTrace.info("admin", "UserDetail.traceUser", "admin.MSG_DUMP_USER", "DomainId : " + this.domainId);
        SilverTrace.info("admin", "UserDetail.traceUser", "admin.MSG_DUMP_USER", "Login : " + this.login);
        SilverTrace.info("admin", "UserDetail.traceUser", "admin.MSG_DUMP_USER", "FirstName : " + this.firstName);
        SilverTrace.info("admin", "UserDetail.traceUser", "admin.MSG_DUMP_USER", "LastName : " + this.lastName);
        SilverTrace.info("admin", "UserDetail.traceUser", "admin.MSG_DUMP_USER", "eMail : " + this.eMail);
        SilverTrace.info("admin", "UserDetail.traceUser", "admin.MSG_DUMP_USER", "AccessLevel : " + (Object)((Object)this.accessLevel));
    }

    @Override
    public int compareTo(UserDetail other) {
        String otherFirstName;
        String myFirstName;
        String otherLastName;
        String myLastName;
        Collator collator = Collator.getInstance();
        int result = collator.compare(myLastName = this.getLastName().toLowerCase(I18NHelper.defaultLocale), otherLastName = other.getLastName().toLowerCase(I18NHelper.defaultLocale));
        if (result == 0 && (result = collator.compare(myFirstName = this.getFirstName().toLowerCase(I18NHelper.defaultLocale), otherFirstName = other.getFirstName().toLowerCase(I18NHelper.defaultLocale))) == 0) {
            String myId = this.getId();
            String otherId = other.getId();
            result = myId.compareTo(otherId);
        }
        return result;
    }

    public String getAvatar() {
        String avatar = this.getAvatarFileName();
        if (this.isAvatarPersonnalized()) {
            return AVATAR_BASEURI + avatar;
        }
        return "/directory/jsp/icons/avatar.png";
    }

    public String getSmallAvatar() {
        String avatar = this.getAvatar();
        if (avatar.startsWith(AVATAR_BASEURI)) {
            return FileServerUtils.getImageURL(avatar, "image.size.avatar.profil");
        }
        return avatar;
    }

    public boolean isAvatarPersonnalized() {
        return new File(FileRepositoryManager.getAvatarPath(), this.getAvatarFileName()).exists();
    }

    public String getAvatarFileName() {
        String propertyValue = this.getLogin();
        try {
            propertyValue = BeanUtils.getSimpleProperty((Object)this, (String)AVATAR_PROPERTY);
        }
        catch (IllegalAccessException e) {
            SilverTrace.debug("admin", "UserDetail.getAvatarFileName", "admin.MSG_GET_PROPERTY", e);
        }
        catch (NoSuchMethodException e) {
            SilverTrace.debug("admin", "UserDetail.getAvatarFileName", "admin.MSG_GET_PROPERTY", e);
        }
        catch (InvocationTargetException e) {
            SilverTrace.debug("admin", "UserDetail.getAvatarFileName", "admin.MSG_GET_PROPERTY", e);
        }
        return propertyValue + "." + AVATAR_EXTENSION;
    }

    public String getStatus() {
        String status = new StatusService().getLastStatusService(Integer.parseInt(this.getId())).getDescription();
        if (StringUtil.isDefined(status)) {
            return status;
        }
        return "";
    }

    public final UserPreferences getUserPreferences() {
        return SilverpeasServiceProvider.getPersonalizationService().getUserSettings(this.getId());
    }

    public boolean isConnected() {
        SessionManagementFactory factory = SessionManagementFactory.getFactory();
        SessionManagement sessionManagement = factory.getSessionManagement();
        return sessionManagement.isUserConnected(this);
    }

    public static boolean isAnonymousUserExist() {
        return StringUtil.isDefined(UserDetail.getAnonymousUserId());
    }

    public static boolean isAnonymousUser(String userId) {
        return UserDetail.isAnonymousUserExist() && UserDetail.getAnonymousUserId().equals(userId);
    }

    public boolean isFullyDefined() {
        return StringUtil.isDefined(this.getId()) && StringUtil.isDefined(this.getLogin()) && StringUtil.isDefined(this.getLastName());
    }

    public String getDurationOfCurrentSession() {
        if (this.isConnected()) {
            return DateUtil.formatDuration(new Date().getTime() - this.getLastLoginDate().getTime());
        }
        return "";
    }

    public boolean isInRelationWithOrInvitedBy(String userId) {
        RelationShipService relation = new RelationShipService();
        InvitationService invitation = new InvitationService();
        try {
            return relation.isInRelationShip(Integer.parseInt(userId), Integer.parseInt(this.getId())) || invitation.getInvitation(Integer.parseInt(userId), Integer.parseInt(this.getId())) != null;
        }
        catch (Exception e) {
            SilverTrace.warn("admin", this.getClass().getSimpleName(), "root.EX_NO_MESSAGE", e);
            return false;
        }
    }

    public boolean isUserManualNotificationUserReceiverLimit() {
        return this.getUserManualNotificationUserReceiverLimitValue() > 0;
    }

    public int getUserManualNotificationUserReceiverLimitValue() {
        int limit = 0;
        if (NotificationManagerSettings.isUserManualNotificationRecipientLimitEnabled() && (this.isAccessUser() || this.isAccessGuest() || this.isAnonymous() || this.isAccessUnknown())) {
            limit = !this.isAnonymous() && !this.isAccessUnknown() && this.getNotifManualReceiverLimit() != null ? this.getNotifManualReceiverLimit() : NotificationManagerSettings.getUserManualNotificationRecipientLimit();
        }
        return limit;
    }

    public void setUserManualNotificationUserReceiverLimit(Integer limit) {
        if (NotificationManagerSettings.isUserManualNotificationRecipientLimitEnabled() && (this.isAccessUser() || this.isAccessGuest())) {
            if (limit != null && (limit <= -1 || limit == NotificationManagerSettings.getUserManualNotificationRecipientLimit())) {
                limit = null;
            }
            this.setNotifManualReceiverLimit(limit);
        }
    }

    public void setNotifManualReceiverLimit(Integer notifManualReceiverLimit) {
        this.notifManualReceiverLimit = notifManualReceiverLimit;
    }

    public Integer getNotifManualReceiverLimit() {
        return this.notifManualReceiverLimit;
    }

    protected static String getAnonymousUserId() {
        return generalSettings.getString(ANONYMOUS_ID_PROPERTY, null);
    }

    protected static OrganisationController getOrganisationController() {
        return OrganisationControllerFactory.getOrganisationController();
    }
}

