/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin.dao;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.Group;
import com.stratelia.webactiv.beans.admin.PaginationPage;
import com.stratelia.webactiv.beans.admin.dao.GroupSearchCriteriaForDAO;
import com.stratelia.webactiv.util.DBUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.silverpeas.util.ListSlice;

public class GroupDAO {
    private static final String GROUP_COLUMNS = "id,specificId,domainId,superGroupId,name,description,synchroRule";
    private static final String queryGetGroup = "select id,specificId,domainId,superGroupId,name,description,synchroRule from ST_Group where id = ?";
    private static final String queryGetSubGroups = "select id,specificId,domainId,superGroupId,name,description,synchroRule from ST_Group where superGroupId = ?";
    private static final String queryGetNBUsersDirectlyInGroup = "select count(userid) from st_group_user_rel where groupid = ?";
    private static final String queryGetUsersDirectlyInGroup = "select userid from st_group_user_rel where groupid = ?";
    private static final String queryGetManageableGroupIdsByUser = "select st_groupuserrole.groupid from st_groupuserrole_user_rel, st_groupuserrole  where st_groupuserrole_user_rel.groupuserroleid=st_groupuserrole.id and st_groupuserrole_user_rel.userid=?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Group> getAllGroups(Connection connection) throws SQLException {
        List<Group> list;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            String query = "select id,specificId,domainId,superGroupId,name,description,synchroRule from st_group order by name";
            statement = connection.prepareStatement(query);
            resultSet = statement.executeQuery();
            list = GroupDAO.theGroupsFrom(resultSet);
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet, statement);
            throw throwable;
        }
        DBUtil.close(resultSet, statement);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListSlice<Group> getGroupsByCriteria(Connection connection, GroupSearchCriteriaForDAO criteria) throws SQLException {
        ListSlice<Group> groups;
        ResultSet resultSet;
        PreparedStatement statement;
        block3: {
            statement = null;
            resultSet = null;
            try {
                String query = criteria.toSQLQuery(GROUP_COLUMNS);
                statement = connection.prepareStatement(query, 1004, 1007);
                resultSet = statement.executeQuery();
                if (criteria.isPaginationSet()) {
                    PaginationPage page = criteria.getPagination();
                    int start = (page.getPageNumber() - 1) * page.getPageSize();
                    int end = start + page.getPageSize();
                    groups = GroupDAO.theGroupsFrom(resultSet, start, end);
                    break block3;
                }
                groups = new ListSlice<Group>((Collection<Group>)GroupDAO.theGroupsFrom(resultSet));
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet, statement);
                throw throwable;
            }
        }
        DBUtil.close(resultSet, statement);
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group getGroup(Connection con, String groupId) throws SQLException {
        Group group;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(queryGetGroup);
            stmt.setInt(1, Integer.parseInt(groupId));
            rs = stmt.executeQuery();
            Group group2 = null;
            if (rs.next()) {
                group2 = GroupDAO.fetchGroup(rs);
            }
            group = group2;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close(rs, stmt);
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Group> getSubGroups(Connection con, String groupId) throws SQLException {
        ArrayList<Group> arrayList;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            ArrayList<Group> groups = new ArrayList<Group>();
            stmt = con.prepareStatement(queryGetSubGroups);
            stmt.setInt(1, Integer.parseInt(groupId));
            rs = stmt.executeQuery();
            while (rs.next()) {
                groups.add(GroupDAO.fetchGroup(rs));
            }
            arrayList = groups;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close(rs, stmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNBUsersDirectlyInGroup(Connection con, String groupId) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        block3: {
            int n;
            stmt = null;
            rs = null;
            try {
                stmt = con.prepareStatement(queryGetNBUsersDirectlyInGroup);
                stmt.setInt(1, Integer.parseInt(groupId));
                rs = stmt.executeQuery();
                if (!rs.next()) break block3;
                n = rs.getInt(1);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, stmt);
                throw throwable;
            }
            DBUtil.close(rs, stmt);
            return n;
        }
        int n = 0;
        DBUtil.close(rs, stmt);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getUsersDirectlyInGroup(Connection con, String groupId) throws SQLException {
        ArrayList<String> arrayList;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            ArrayList<String> userIds = new ArrayList<String>();
            stmt = con.prepareStatement(queryGetUsersDirectlyInGroup);
            stmt.setInt(1, Integer.parseInt(groupId));
            rs = stmt.executeQuery();
            while (rs.next()) {
                userIds.add(Integer.toString(rs.getInt(1)));
            }
            arrayList = userIds;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close(rs, stmt);
        return arrayList;
    }

    public List<String> getManageableGroupIds(Connection con, String userId, List<String> groupIds) throws SQLException {
        ArrayList<String> manageableGroupIds = new ArrayList<String>();
        if (StringUtil.isDefined(userId)) {
            manageableGroupIds.addAll(this.getManageableGroupIdsByUser(con, userId));
        }
        if (groupIds != null && groupIds.size() > 0) {
            manageableGroupIds.addAll(this.getManageableGroupIdsByGroups(con, groupIds));
        }
        return manageableGroupIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getManageableGroupIdsByUser(Connection con, String userId) throws SQLException {
        ArrayList<String> arrayList;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            ArrayList<String> groupIds = new ArrayList<String>();
            stmt = con.prepareStatement(queryGetManageableGroupIdsByUser);
            stmt.setInt(1, Integer.parseInt(userId));
            rs = stmt.executeQuery();
            while (rs.next()) {
                groupIds.add(Integer.toString(rs.getInt(1)));
            }
            arrayList = groupIds;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close(rs, stmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getManageableGroupIdsByGroups(Connection con, List<String> groupIds) throws SQLException {
        ArrayList<String> arrayList;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String aQueryGetManageableGroupIdsByUser = "select st_groupuserrole.groupid from st_groupuserrole_group_rel, st_groupuserrole  where st_groupuserrole_group_rel.groupuserroleid=st_groupuserrole.id and st_groupuserrole_group_rel.groupid IN (" + GroupDAO.list2String(groupIds) + ")";
            ArrayList<String> manageableGroupIds = new ArrayList<String>();
            stmt = con.createStatement();
            rs = stmt.executeQuery(aQueryGetManageableGroupIdsByUser);
            while (rs.next()) {
                manageableGroupIds.add(Integer.toString(rs.getInt(1)));
            }
            arrayList = manageableGroupIds;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close(rs, stmt);
        return arrayList;
    }

    private static String list2String(List<String> ids) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < ids.size(); ++i) {
            if (i != 0) {
                str.append(",");
            }
            str.append(ids.get(i));
        }
        return str.toString();
    }

    private static Group fetchGroup(ResultSet rs) throws SQLException {
        Group group = new Group();
        group.setId(Integer.toString(rs.getInt("id")));
        group.setSpecificId(rs.getString("specificId"));
        if (group.getSpecificId().equals("-1")) {
            group.setSpecificId(null);
        }
        group.setDomainId(Integer.toString(rs.getInt("domainId")));
        group.setSuperGroupId(Integer.toString(rs.getInt("superGroupId")));
        if (rs.wasNull()) {
            group.setSuperGroupId(null);
        }
        group.setName(rs.getString("name"));
        group.setDescription(rs.getString("description"));
        group.setRule(rs.getString("synchroRule"));
        return group;
    }

    private static List<Group> theGroupsFrom(ResultSet rs) throws SQLException {
        ArrayList<Group> groups = new ArrayList<Group>();
        while (rs.next()) {
            groups.add(GroupDAO.fetchGroup(rs));
        }
        return groups;
    }

    private static ListSlice<Group> theGroupsFrom(ResultSet rs, int start, int end) throws SQLException {
        ListSlice<Group> groups = new ListSlice<Group>(start, end);
        if (start > 0) {
            rs.next();
            rs.relative(start - 1);
        }
        int i = start;
        while (rs.next()) {
            if (i < end) {
                groups.add(GroupDAO.fetchGroup(rs));
            }
            ++i;
        }
        groups.setOriginalListSize(i);
        return groups;
    }
}

