/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.organization;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.SynchroReport;
import com.stratelia.webactiv.organization.AdminPersistenceException;
import com.stratelia.webactiv.organization.GroupRow;
import com.stratelia.webactiv.organization.GroupUserRoleRow;
import com.stratelia.webactiv.organization.OrganizationSchema;
import com.stratelia.webactiv.organization.Table;
import com.stratelia.webactiv.organization.UserRow;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class GroupUserRoleTable
extends Table<GroupUserRoleRow> {
    private static final String GROUPUSERROLE_COLUMNS = "id,groupId,roleName";
    private static final String SELECT_GROUPUSERROLE_BY_ID = "select id,groupId,roleName from ST_GroupUserRole where id = ?";
    private static final String SELECT_GROUPUSERROLE_BY_GROUPID = "select id,groupId,roleName from ST_GroupUserRole where groupId = ?";
    private static final String INSERT_GROUPUSERROLE = "insert into ST_GroupUserRole(id,groupId,roleName) values     (? \t,?       ,?)";
    private static final String DELETE_GROUPUSERROLE = "delete from ST_GroupUserRole where id = ?";
    private static final String SELECT_COUNT_GROUPUSERROLE_USER_REL = "select count(*) from ST_GroupUserRole_User_Rel where userId = ? and groupUserRoleId = ?";
    private static final String INSERT_A_GROUPUSERROLE_USER_REL = "insert into ST_GroupUserRole_User_Rel(groupUserRoleId, userId) values(?,?)";
    private static final String DELETE_GROUPUSERROLE_USER_REL = "delete from ST_GroupUserRole_User_Rel where groupUserRoleId = ? and userId = ?";
    private static final String SELECT_COUNT_GROUPUSERROLE_GROUP_REL = "select count(*) from ST_GroupUserRole_Group_Rel where groupId = ? and groupUserRoleId = ?";
    private static final String INSERT_A_GROUPUSERROLE_GROUP_REL = "insert into ST_GroupUserRole_Group_Rel(groupUserRoleId, groupId) values(?,?)";
    private static final String DELETE_GROUPUSERROLE_GROUP_REL = "delete from ST_GroupUserRole_Group_Rel where groupUserRoleId = ? and groupId = ?";
    private OrganizationSchema organization = null;

    public GroupUserRoleTable(OrganizationSchema organization) {
        super(organization, "ST_GroupUserRole");
        this.organization = organization;
    }

    protected GroupUserRoleRow fetchGroupUserRole(ResultSet rs) throws SQLException {
        GroupUserRoleRow sur = new GroupUserRoleRow();
        sur.id = rs.getInt(1);
        sur.groupId = rs.getInt(2);
        sur.roleName = rs.getString(3);
        return sur;
    }

    public GroupUserRoleRow getGroupUserRole(int id) throws AdminPersistenceException {
        return (GroupUserRoleRow)this.getUniqueRow(SELECT_GROUPUSERROLE_BY_ID, id);
    }

    public GroupUserRoleRow getGroupUserRoleByGroupId(int groupId) throws AdminPersistenceException {
        return (GroupUserRoleRow)this.getUniqueRow(SELECT_GROUPUSERROLE_BY_GROUPID, groupId);
    }

    public void createGroupUserRole(GroupUserRoleRow groupUserRole) throws AdminPersistenceException {
        GroupRow group = this.organization.group.getGroup(groupUserRole.groupId);
        if (group == null) {
            throw new AdminPersistenceException("GroupUserRoleTable.createGroupUserRole", 4, "admin.EX_ERR_GROUP_NOT_FOUND", "group id : '" + groupUserRole.groupId + "'");
        }
        this.insertRow(INSERT_GROUPUSERROLE, groupUserRole);
    }

    @Override
    protected void prepareInsert(String insertQuery, PreparedStatement insert, GroupUserRoleRow usr) throws SQLException {
        if (usr.id == -1) {
            usr.id = this.getNextId();
        }
        insert.setInt(1, usr.id);
        insert.setInt(2, usr.groupId);
        if (!StringUtil.isDefined(usr.roleName)) {
            usr.roleName = "useless";
        }
        insert.setString(3, usr.roleName);
    }

    @Override
    protected void prepareUpdate(String updateQuery, PreparedStatement update, GroupUserRoleRow row) throws SQLException {
    }

    public void removeGroupUserRole(int id) throws AdminPersistenceException {
        GroupRow[] groups;
        UserRow[] users;
        GroupUserRoleRow groupUserRole = this.getGroupUserRole(id);
        if (groupUserRole == null) {
            return;
        }
        for (UserRow user : users = this.organization.user.getDirectUsersOfGroupUserRole(id)) {
            this.removeUserFromGroupUserRole(user.id, id);
        }
        for (GroupRow group : groups = this.organization.group.getDirectGroupsInGroupUserRole(id)) {
            this.removeGroupFromGroupUserRole(group.id, id);
        }
        this.updateRelation(DELETE_GROUPUSERROLE, id);
    }

    private boolean isUserDirectlyInRole(int userId, int groupUserRoleId) throws AdminPersistenceException {
        int[] ids = new int[]{userId, groupUserRoleId};
        Integer result = this.getInteger(SELECT_COUNT_GROUPUSERROLE_USER_REL, ids);
        return result != null && result >= 1;
    }

    public void addUserInGroupUserRole(int userId, int groupUserRoleId) throws AdminPersistenceException {
        if (this.isUserDirectlyInRole(userId, groupUserRoleId)) {
            return;
        }
        UserRow user = this.organization.user.getUser(userId);
        if (user == null) {
            throw new AdminPersistenceException("GroupUserRoleTable.addUserInGroupUserRole", 4, "admin.EX_ERR_USER_NOT_FOUND", "user id : '" + userId + "'");
        }
        GroupUserRoleRow groupUserRole = this.getGroupUserRole(groupUserRoleId);
        if (groupUserRole == null) {
            throw new AdminPersistenceException("GroupUserRoleTable.addUserInGroupUserRole", 4, "admin.EX_ERR_GROUPUSERROLE_NOT_FOUND", "group user role id : '" + groupUserRoleId + "'");
        }
        int[] params = new int[]{groupUserRoleId, userId};
        this.updateRelation(INSERT_A_GROUPUSERROLE_USER_REL, params);
    }

    public void removeUserFromGroupUserRole(int userId, int groupUserRoleId) throws AdminPersistenceException {
        if (!this.isUserDirectlyInRole(userId, groupUserRoleId)) {
            throw new AdminPersistenceException("GroupUserRoleTable.removeUserFromGroupUserRole", 4, "admin.EX_ERR_USER_NOT_IN_GROUP_USERROLE", "group userrole id: '" + groupUserRoleId + "', user id: '" + userId + "'");
        }
        int[] params = new int[]{groupUserRoleId, userId};
        SynchroReport.debug("GroupUserRoleTable.removeUserFromGroupUserRole()", "Retrait de l'utilisateur d'ID " + userId + " de role d'egroup d'ID " + groupUserRoleId + ", requ\u00eate : " + DELETE_GROUPUSERROLE_USER_REL, null);
        this.updateRelation(DELETE_GROUPUSERROLE_USER_REL, params);
    }

    private boolean isGroupDirectlyInRole(int groupId, int groupUserRoleId) throws AdminPersistenceException {
        int[] ids = new int[]{groupId, groupUserRoleId};
        Integer result = this.getInteger(SELECT_COUNT_GROUPUSERROLE_GROUP_REL, ids);
        return result != null && result >= 1;
    }

    public void addGroupInGroupUserRole(int groupId, int groupUserRoleId) throws AdminPersistenceException {
        if (this.isGroupDirectlyInRole(groupId, groupUserRoleId)) {
            return;
        }
        GroupRow group = this.organization.group.getGroup(groupId);
        if (group == null) {
            throw new AdminPersistenceException("GroupUserRoleTable.addGroupInGroupUserRole", 4, "admin.EX_ERR_GROUP_NOT_FOUND", "group id : '" + groupId + "'");
        }
        GroupUserRoleRow groupUserRole = this.getGroupUserRole(groupUserRoleId);
        if (groupUserRole == null) {
            throw new AdminPersistenceException("GroupUserRoleTable.addGroupInGroupUserRole", 4, "admin.EX_ERR_GROUPUSERROLE_NOT_FOUND", "group userrole id : '" + groupUserRoleId + "'");
        }
        int[] params = new int[]{groupUserRoleId, groupId};
        this.updateRelation(INSERT_A_GROUPUSERROLE_GROUP_REL, params);
    }

    public void removeGroupFromGroupUserRole(int groupId, int groupUserRoleId) throws AdminPersistenceException {
        if (!this.isGroupDirectlyInRole(groupId, groupUserRoleId)) {
            throw new AdminPersistenceException("GroupUserRoleTable.removeGroupFromGroupUserRole", 4, "admin.EX_ERR_GROUP_NOT_IN_GROUP_USERROLE", "group userrole id: '" + groupUserRoleId + "', group id: '" + groupId + "'");
        }
        int[] params = new int[]{groupUserRoleId, groupId};
        SynchroReport.debug("GroupUserRoleTable.removeGroupFromGroupUserRole()", "Retrait du groupe d'ID " + groupId + " de l'espace d'ID " + groupUserRoleId + ", requ\u00eate : " + DELETE_GROUPUSERROLE_GROUP_REL, null);
        this.updateRelation(DELETE_GROUPUSERROLE_GROUP_REL, params);
    }

    @Override
    protected GroupUserRoleRow fetchRow(ResultSet rs) throws SQLException {
        return this.fetchGroupUserRole(rs);
    }
}

