/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.exception.UtilException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public abstract class Schema {
    private boolean isLocalConnection = true;
    private boolean haveToTestConnections = true;
    private boolean managed = false;
    private Connection connection = null;

    protected abstract String getJNDIName();

    public Schema(Connection co) throws UtilException {
        this.connection = co;
        this.isLocalConnection = false;
    }

    public Schema() throws UtilException {
        this.createConnection();
        ResourceLocator resources = new ResourceLocator("com.stratelia.webactiv.beans.admin.admin", "");
        String m_sHaveToTestConnections = resources.getString("HaveToTestConnections");
        if ("false".equalsIgnoreCase(m_sHaveToTestConnections)) {
            this.haveToTestConnections = false;
        }
    }

    protected final synchronized void createConnection() throws UtilException {
        SilverTrace.info("util", "Schema.createConnection()", "root.MSG_GEN_ENTER_METHOD");
        try {
            InitialContext ctx = new InitialContext();
            DataSource src = (DataSource)ctx.lookup(this.getJNDIName());
            if (this.connection != null) {
                DBUtil.close(this.connection);
            }
            this.connection = src.getConnection();
            if (!this.connection.getAutoCommit()) {
                this.managed = true;
            } else {
                this.managed = false;
                this.connection.setAutoCommit(false);
            }
            this.isLocalConnection = true;
            SilverTrace.info("util", "Schema.createConnection()", "root.MSG_GEN_PARAM_VALUE", "Connection Created !");
        }
        catch (NamingException e) {
            try {
                InitialContext ctx = new InitialContext();
                DataSource dataSource = (DataSource)ctx.lookup(JNDINames.DIRECT_DATASOURCE);
                this.connection = dataSource.getConnection();
                this.managed = false;
            }
            catch (NamingException ne) {
                throw new UtilException("Schema.createConnection", 4, "root.EX_DATASOURCE_NOT_FOUND", "Data source " + JNDINames.DIRECT_DATASOURCE + " not found", ne);
            }
            catch (SQLException se) {
                throw new UtilException("Schema.createConnection", 4, "can't get connection for dataSource " + JNDINames.DIRECT_DATASOURCE, (Exception)se);
            }
        }
        catch (SQLException e) {
            throw new UtilException("Schema.createConnection", 4, "root.EX_DATASOURCE_INVALID", (Exception)e);
        }
    }

    public synchronized void commit() throws UtilException {
        SilverTrace.info("util", "Schema.commit()", "root.MSG_GEN_ENTER_METHOD");
        if (!this.isManaged()) {
            try {
                this.connection.commit();
            }
            catch (SQLException e) {
                throw new UtilException("Schema.commit", 4, "root.EX_ERR_COMMIT", (Exception)e);
            }
        }
    }

    public synchronized void rollback() throws UtilException {
        SilverTrace.info("util", "Schema.rollback()", "root.MSG_GEN_ENTER_METHOD");
        if (!this.isManaged()) {
            try {
                this.connection.rollback();
            }
            catch (SQLException e) {
                throw new UtilException("Schema.rollback", 4, "root.EX_ERR_ROLLBACK", (Exception)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        SilverTrace.info("util", "Schema.close()", "root.MSG_GEN_ENTER_METHOD");
        try {
            DBUtil.close(this.connection);
        }
        finally {
            this.connection = null;
        }
    }

    public boolean isOk() {
        try {
            if (this.connection == null || this.connection.isClosed()) {
                return false;
            }
            if (this.haveToTestConnections) {
                SilverTrace.info("util", "Schema.isOk()", "root.MSG_GEN_ENTER_METHOD", "Connection Test");
                Statement st = this.connection.createStatement();
                st.close();
            }
            return true;
        }
        catch (SQLException e) {
            SilverTrace.info("util", "Schema.isOk()", "root.MSG_GEN_ENTER_METHOD", "Connection Test Problem !!!", e);
            this.close();
            return false;
        }
    }

    public boolean isManaged() {
        return this.managed;
    }

    public synchronized PreparedStatement getStatement(String query) throws SQLException {
        SilverTrace.info("util", "Schema.getStatement()", "root.MSG_GEN_ENTER_METHOD", query);
        PreparedStatement statement = this.getConnection().prepareStatement(query);
        SilverTrace.info("util", "Schema.getStatement()", "root.MSG_GEN_PARAM_VALUE", "statement=" + statement);
        return statement;
    }

    public synchronized Connection getConnection() {
        if (!this.isOk() && this.isLocalConnection) {
            SilverTrace.info("util", "Schema.getConnection", "root.MSG_GEN_ENTER_METHOD", "Connection WAS CLOSED !!!! -> Create new one");
            try {
                this.createConnection();
            }
            catch (UtilException e) {
                SilverTrace.error("util", "Schema.getConnection", "util.CAN_T_CLOSE_CONNECTION", e);
            }
        } else {
            SilverTrace.info("util", "Schema.getConnection", "root.MSG_GEN_ENTER_METHOD", "Connection Verified");
        }
        return this.connection;
    }
}

