/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.admin.domain;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.Domain;
import javax.inject.Named;
import org.silverpeas.admin.domain.AbstractDomainService;
import org.silverpeas.admin.domain.exception.DomainConflictException;
import org.silverpeas.admin.domain.exception.DomainCreationException;
import org.silverpeas.admin.domain.exception.DomainDeletionException;
import org.springframework.stereotype.Service;

@Service
@Named(value="externalDomainService")
public class ExternalDomainService
extends AbstractDomainService {
    @Override
    public String createDomain(Domain domainToCreate) throws DomainCreationException, DomainConflictException {
        try {
            this.checkDomainName(domainToCreate.getName());
        }
        catch (AdminException e) {
            throw new DomainCreationException("ExternalDomainService.createDomain", domainToCreate.toString(), e);
        }
        domainToCreate.setId("-1");
        String id = this.registerDomain(domainToCreate);
        if (!StringUtil.isDefined(id)) {
            throw new DomainCreationException("ExternalDomainService.createDomain()", domainToCreate.toString());
        }
        return id;
    }

    @Override
    public String deleteDomain(Domain domainToRemove) throws DomainDeletionException {
        String id = this.unRegisterDomain(domainToRemove);
        if (!StringUtil.isDefined(id)) {
            throw new DomainDeletionException("ExternalDomainService.deleteDomain()", domainToRemove.toString());
        }
        return id;
    }
}

