/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.authentication.verifier;

import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.AdminReference;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.ResourceLocator;
import java.util.HashMap;
import java.util.Map;
import org.silverpeas.authentication.AuthenticationCredential;

class AbstractAuthenticationVerifier {
    protected static final Map<String, ResourceLocator> multilang = new HashMap<String, ResourceLocator>();
    protected static final ResourceLocator settings = new ResourceLocator("com.silverpeas.authentication.settings.authenticationSettings", "");
    protected static final ResourceLocator otherSettings = new ResourceLocator("com.silverpeas.authentication.settings.passwordExpiration", "");
    private UserDetail user;

    protected AbstractAuthenticationVerifier(UserDetail user) {
        this.user = user;
    }

    public void setUser(UserDetail user) {
        this.user = user;
    }

    public UserDetail getUser() {
        return this.user;
    }

    protected static UserDetail getUserByCredential(AuthenticationCredential credential) {
        try {
            return UserDetail.getById(AdminReference.getAdminService().getUserIdByLoginAndDomain(credential.getLogin(), credential.getDomainId()));
        }
        catch (AdminException ignore) {
            return null;
        }
    }

    protected static UserDetail getUserById(String userId) {
        return UserDetail.getById(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getString(String key, String language, String ... params) {
        ResourceLocator messages = multilang.get(language);
        if (messages == null) {
            Map<String, ResourceLocator> map = multilang;
            synchronized (map) {
                messages = new ResourceLocator("org.silverpeas.authentication.multilang.authentication", language);
                multilang.put(language, messages);
            }
        }
        return params != null && params.length > 0 ? messages.getStringWithParams(key, params) : messages.getString(key, "");
    }
}

