/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.image.imagemagick;

import java.io.File;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.im4java.core.ConvertCmd;
import org.im4java.core.IMOperation;
import org.im4java.core.IdentifyCmd;
import org.im4java.core.Operation;
import org.im4java.process.ArrayListOutputConsumer;
import org.im4java.process.OutputConsumer;
import org.silverpeas.image.AbstractImageTool;
import org.silverpeas.image.ImageToolDirective;
import org.silverpeas.image.imagemagick.Im4javaManager;
import org.silverpeas.image.option.AbstractImageToolOption;
import org.silverpeas.image.option.AnchoringPosition;
import org.silverpeas.image.option.BackgroundOption;
import org.silverpeas.image.option.DimensionOption;
import org.silverpeas.image.option.TransparencyColorOption;
import org.silverpeas.image.option.WatermarkTextOption;

@Named(value="imageTool")
public class Im4javaImageTool
extends AbstractImageTool {
    private static final String FIRST_PAGE_ONLY = "[0]";
    private static final String GEOMETRY_SHRINK = ">";

    @Override
    public boolean isActivated() {
        return Im4javaManager.isActivated();
    }

    @Override
    public String[] getImageInfo(File source, String ... options) throws Exception {
        IMOperation op = new IMOperation();
        op.format(StringUtils.join((Object[])options, (String)"|"));
        op.addImage(new String[]{source.getPath()});
        IdentifyCmd identifyCmd = new IdentifyCmd();
        ArrayListOutputConsumer result = new ArrayListOutputConsumer();
        identifyCmd.setOutputConsumer((OutputConsumer)result);
        identifyCmd.run((Operation)op, new Object[0]);
        return ((String)result.getOutput().get(0)).split("[|]");
    }

    @Override
    protected void convert(File source, File destination, Map<Class<AbstractImageToolOption>, AbstractImageToolOption> options, Set<ImageToolDirective> directives) throws Exception {
        IMOperation op = new IMOperation();
        this.setSource(op, source, directives);
        this.transparencyColor(op, options);
        this.background(op, options);
        this.resize(op, options, directives);
        this.watermarkText(op, source, options);
        this.setDestination(op, destination, directives);
        new ConvertCmd().run((Operation)op, new Object[0]);
    }

    private void setSource(IMOperation op, File source, Set<ImageToolDirective> directives) {
        StringBuilder sb = new StringBuilder(source.getPath());
        if (directives.contains((Object)ImageToolDirective.FIRST_PAGE_ONLY)) {
            sb.append(FIRST_PAGE_ONLY);
        }
        op.addImage(new String[]{sb.toString()});
    }

    private void setDestination(IMOperation op, File destination, Set<ImageToolDirective> directives) {
        op.addImage(new String[]{destination.getPath()});
    }

    private void background(IMOperation op, Map<Class<AbstractImageToolOption>, AbstractImageToolOption> options) {
        BackgroundOption background = this.getOption(options, BackgroundOption.class);
        if (background != null) {
            op.background(background.getValue());
            op.flatten();
        }
    }

    private void transparencyColor(IMOperation op, Map<Class<AbstractImageToolOption>, AbstractImageToolOption> options) {
        TransparencyColorOption transparencyColor = this.getOption(options, TransparencyColorOption.class);
        if (transparencyColor != null) {
            op.transparentColor(transparencyColor.getColor());
        }
    }

    private void resize(IMOperation op, Map<Class<AbstractImageToolOption>, AbstractImageToolOption> options, Set<ImageToolDirective> directives) {
        DimensionOption dimension = this.getOption(options, DimensionOption.class);
        if (dimension != null) {
            StringBuilder specialDirective = new StringBuilder();
            if (directives.contains((Object)ImageToolDirective.GEOMETRY_SHRINK)) {
                specialDirective.append(GEOMETRY_SHRINK);
            }
            if (directives.contains((Object)ImageToolDirective.PREVIEW_WORK)) {
                op.thumbnail(dimension.getWidth(), dimension.getHeight(), specialDirective.toString());
            } else {
                op.resize(dimension.getWidth(), dimension.getHeight(), specialDirective.toString());
            }
        }
    }

    private void watermarkText(IMOperation op, File source, Map<Class<AbstractImageToolOption>, AbstractImageToolOption> options) throws Exception {
        WatermarkTextOption watermarkText = this.getOption(options, WatermarkTextOption.class);
        if (watermarkText != null) {
            DimensionOption dimension = this.getOption(options, DimensionOption.class);
            String[] imageInfo = dimension != null ? new String[]{dimension.getWidth() != null ? String.valueOf(dimension.getWidth()) : this.getImageInfo(source, "%w")[0], dimension.getHeight() != null ? String.valueOf(dimension.getHeight()) : this.getImageInfo(source, "%h")[0]} : this.getImageInfo(source, "%w", "%h");
            int width = Integer.valueOf(imageInfo[0]);
            int height = Integer.valueOf(imageInfo[1]);
            int pointSize = (int)Math.rint((double)width * 0.02 + Math.log(width));
            pointSize = Math.min((int)((double)height * 0.2), pointSize);
            int minX = (int)Math.max(1.0, (double)height * 0.015);
            int minY = (int)Math.max(1.0, (double)height * 0.025);
            int x = (int)((double)minX + Math.max(1.0, (double)pointSize / 2.5));
            int y = (int)((double)minY + Math.max(1.0, (double)pointSize / 1.75));
            String text = watermarkText.getText();
            AnchoringPosition anchoringPosition = watermarkText.getAnchoringPosition();
            op.font(watermarkText.getFont());
            op.pointsize(Integer.valueOf(pointSize));
            String black = "rgba(0, 0, 0, 0.5)";
            String white = "rgba(255, 255, 255, 0.5)";
            this.drawText(op, black, text, anchoringPosition, x, y);
            this.drawText(op, white, text, anchoringPosition, minX, minY);
        }
    }

    private void drawText(IMOperation op, String color, String text, AnchoringPosition anchoringPosition, int x, int y) {
        String drawSb = "gravity " + anchoringPosition.name() + " fill " + color + " text " + x + "," + y + " '" + text.replace("'", "\\'") + "'";
        op.draw(drawSb);
    }
}

