/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.importExport.attachment;

import com.silverpeas.form.importExport.FormTemplateImportExport;
import com.silverpeas.form.importExport.XMLModelContentType;
import com.silverpeas.util.FileUtil;
import com.silverpeas.util.ForeignPK;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.FileServerUtils;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.WAPrimaryKey;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.silverpeas.attachment.AttachmentServiceFactory;
import org.silverpeas.attachment.model.DocumentType;
import org.silverpeas.attachment.model.SimpleAttachment;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.model.SimpleDocumentPK;
import org.silverpeas.attachment.util.SimpleDocumentList;
import org.silverpeas.importExport.attachment.AttachmentDetail;
import org.silverpeas.importExport.attachment.AttachmentPK;
import org.silverpeas.util.error.SilverpeasTransverseErrorUtil;

public class AttachmentImportExport {
    private UserDetail user;
    private final ResourceLocator resources = new ResourceLocator("org.silverpeas.importExport.settings.importSettings", "");

    public AttachmentImportExport(UserDetail user) {
        this.user = user;
    }

    @Deprecated
    public AttachmentDetail importWysiwygAttachment(String pubId, String componentId, AttachmentDetail attachmentDetail, String context) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AttachmentDetail> importAttachments(String pubId, String componentId, List<AttachmentDetail> attachments, String userId, boolean indexIt) throws FileNotFoundException {
        FormTemplateImportExport xmlIE = null;
        for (AttachmentDetail attDetail : attachments) {
            boolean removed;
            attDetail.setAuthor(userId);
            attDetail.setInstanceId(componentId);
            XMLModelContentType xmlContent = attDetail.getXMLModelContentType();
            if (xmlContent != null) {
                attDetail.setXmlForm(xmlContent.getName());
            }
            InputStream input2 = null;
            try {
                input2 = this.getAttachmentContent(attDetail);
                this.addAttachmentToPublication(pubId, componentId, attDetail, input2, indexIt);
                if (xmlContent != null) {
                    if (xmlIE == null) {
                        xmlIE = new FormTemplateImportExport();
                    }
                    ForeignPK pk = new ForeignPK(attDetail.getPK().getId(), attDetail.getPK().getInstanceId());
                    xmlIE.importXMLModelContentType(pk, "Attachment", xmlContent, attDetail.getAuthor());
                }
            }
            catch (Exception e) {
                SilverTrace.error("attachment", "AttachmentImportExport.importAttachments()", "root.MSG_GEN_PARAM_VALUE", e);
                SilverpeasTransverseErrorUtil.throwTransverseErrorIfAny(e, attDetail.getLanguage());
            }
            finally {
                IOUtils.closeQuietly((InputStream)input2);
            }
            if (!attDetail.isRemoveAfterImport() || (removed = FileUtils.deleteQuietly((File)this.getAttachmentFile(attDetail)))) continue;
            SilverTrace.error("attachment", "AttachmentImportExport.importAttachments()", "root.MSG_GEN_PARAM_VALUE", "Can't remove file " + this.getAttachmentFile(attDetail));
        }
        return attachments;
    }

    private SimpleDocument addAttachmentToPublication(String pubId, String componentId, AttachmentDetail attachment, InputStream input2, boolean indexIt) {
        SimpleDocumentPK attachmentPk = new SimpleDocumentPK(null, componentId);
        ForeignPK foreignKey = new ForeignPK(pubId, componentId);
        SimpleDocumentList<SimpleDocument> existingAttachments = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKeyAndType(foreignKey, DocumentType.attachment, attachment.getLanguage());
        String logicalName = attachment.getLogicalName();
        if (!StringUtil.isDefined(logicalName)) {
            logicalName = FileUtil.getFilename(attachment.getPhysicalName());
        }
        String userId = attachment.getAuthor();
        String updateRule = attachment.getImportUpdateRule();
        if (!StringUtil.isDefined(updateRule) || "null".equalsIgnoreCase(updateRule)) {
            updateRule = "add";
        }
        SilverTrace.info("attachment", "AttachmentImportExport.addAttachmentToPublication()", "root.MSG_GEN_PARAM_VALUE", "updateRule=" + updateRule);
        logicalName = this.computeUniqueName(attachment, 0, existingAttachments, logicalName, updateRule);
        attachment.setLogicalName(logicalName);
        Date creationDate = attachment.getCreationDate();
        if (creationDate == null) {
            creationDate = new Date();
        }
        SimpleDocument ad_toCreate = new SimpleDocument(attachmentPk, pubId, -1, false, new SimpleAttachment(attachment.getLogicalName(), attachment.getLanguage(), attachment.getTitle(), attachment.getInfo(), attachment.getSize(), FileUtil.getMimeType(attachment.getPhysicalName()), userId, creationDate, attachment.getXmlForm()));
        return AttachmentServiceFactory.getAttachmentService().createAttachment(ad_toCreate, input2, indexIt);
    }

    private String computeUniqueName(AttachmentDetail attachment, int increment, List<SimpleDocument> existingAttachments, String logicalName, String updateRule) {
        String uniqueName = logicalName;
        int incrementSuffixe = increment;
        for (SimpleDocument ad_toCreate : existingAttachments) {
            if (!ad_toCreate.getFilename().equals(uniqueName)) continue;
            if (ad_toCreate.getSize() != attachment.getSize() && "add".equalsIgnoreCase(updateRule)) {
                uniqueName = attachment.getLogicalName();
                int extPosition = logicalName.lastIndexOf(46);
                uniqueName = extPosition != -1 ? uniqueName.substring(0, extPosition) + '_' + ++incrementSuffixe + uniqueName.substring(extPosition, uniqueName.length()) : uniqueName + (95 + ++incrementSuffixe);
                return this.computeUniqueName(attachment, incrementSuffixe, existingAttachments, uniqueName, updateRule);
            }
            AttachmentServiceFactory.getAttachmentService().deleteAttachment(ad_toCreate);
            return uniqueName;
        }
        return logicalName;
    }

    public List<AttachmentDetail> getAttachments(WAPrimaryKey pk, String exportPath, String relativeExportPath, String extensionFilter) {
        SimpleDocumentList<SimpleDocument> listAttachment = AttachmentServiceFactory.getAttachmentService().listDocumentsByForeignKey(pk, null);
        ArrayList<AttachmentDetail> listToReturn = new ArrayList<AttachmentDetail>(listAttachment.size());
        if (!listAttachment.isEmpty()) {
            for (SimpleDocument attachment : listAttachment) {
                if (attachment.getDocumentType() != DocumentType.attachment || !attachment.isDownloadAllowedForRolesFrom(this.user) || extensionFilter != null && !FileRepositoryManager.getFileExtension(attachment.getFilename()).equalsIgnoreCase(extensionFilter)) continue;
                this.copyAttachment(attachment, exportPath);
                String physicalName = relativeExportPath + File.separator + FileServerUtils.replaceAccentChars(attachment.getFilename());
                AttachmentDetail attachDetail = new AttachmentDetail(new AttachmentPK(attachment.getId(), attachment.getInstanceId()), physicalName, attachment.getFilename(), attachment.getDescription(), attachment.getContentType(), attachment.getSize(), attachment.getDocumentType().toString(), attachment.getCreated(), new ForeignPK(attachment.getForeignId(), attachment.getInstanceId()));
                listToReturn.add(attachDetail);
            }
        }
        return listToReturn;
    }

    private void copyAttachment(SimpleDocument attDetail, String exportPath) {
        String fichierJointExport = exportPath + File.separatorChar + FileServerUtils.replaceAccentChars(attDetail.getFilename());
        AttachmentServiceFactory.getAttachmentService().getBinaryContent(new File(fichierJointExport), attDetail.getPk(), null);
    }

    public InputStream getAttachmentContent(AttachmentDetail attachment) throws FileNotFoundException {
        return new FileInputStream(this.getAttachmentFile(attachment));
    }

    public File getAttachmentFile(AttachmentDetail attachment) throws FileNotFoundException {
        File file = new File(FileUtil.convertPathToServerOS(attachment.getAttachmentPath()));
        if (file == null || !file.exists() || !file.isFile()) {
            String baseDir = this.resources.getString("importRepository");
            file = new File(FileUtil.convertPathToServerOS(baseDir + File.separatorChar + attachment.getPhysicalName()));
        }
        attachment.setSize(file.length());
        attachment.setType(FileUtil.getMimeType(file.getName()));
        if (!StringUtil.isDefined(attachment.getLogicalName())) {
            attachment.setLogicalName(file.getName());
        }
        return file;
    }
}

