/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.jdbc;

import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.JNDINames;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.silverpeas.jdbc.JdbcSqlExecutor;
import org.silverpeas.jdbc.JdbcSqlQuery;
import org.silverpeas.jdbc.ResultSetWrapper;
import org.silverpeas.jdbc.SelectResultRowProcess;

class DefaultJdbcSqlExecutor
implements JdbcSqlExecutor {
    protected DefaultJdbcSqlExecutor() {
    }

    @Override
    public long selectCount(JdbcSqlQuery selectCountQueryBuilder) throws SQLException {
        Connection con = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            con = DBUtil.makeConnection(JNDINames.DATABASE_DATASOURCE);
            st = con.prepareStatement(selectCountQueryBuilder.getSqlQuery());
            DefaultJdbcSqlExecutor.setParameters(st, selectCountQueryBuilder.getParameters());
            rs = st.executeQuery();
            rs.next();
            long count = rs.getLong(1);
            if (rs.next()) {
                throw new IllegalArgumentException("select count execution error");
            }
            return count;
        }
        catch (SQLException e) {
            DBUtil.close(rs, st);
            DBUtil.close(con);
            throw e;
        }
    }

    @Override
    public <ROW_ENTITY> List<ROW_ENTITY> select(JdbcSqlQuery selectQueryBuilder, SelectResultRowProcess<ROW_ENTITY> process) throws SQLException {
        Connection con = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            int resultLimit;
            con = DBUtil.makeConnection(JNDINames.DATABASE_DATASOURCE);
            st = con.prepareStatement(selectQueryBuilder.getSqlQuery());
            DefaultJdbcSqlExecutor.setParameters(st, selectQueryBuilder.getParameters());
            rs = st.executeQuery();
            ArrayList<ROW_ENTITY> entities = new ArrayList<ROW_ENTITY>();
            int i = 0;
            while (rs.next() && ((resultLimit = selectQueryBuilder.getConfiguration().getResultLimit()) <= 0 || entities.size() < resultLimit)) {
                ROW_ENTITY entity = process.currentRow(new ResultSetWrapper(rs, i));
                if (entity != null) {
                    entities.add(entity);
                }
                ++i;
            }
            return entities;
        }
        catch (SQLException e) {
            DBUtil.close(rs, st);
            DBUtil.close(con);
            throw e;
        }
    }

    @Override
    public long executeModify(JdbcSqlQuery ... modifySqlQueries) throws SQLException {
        return this.executeModify(Arrays.asList(modifySqlQueries));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long executeModify(List<JdbcSqlQuery> modifySqlQueries) throws SQLException {
        long nbUpdate = 0L;
        Connection con = null;
        PreparedStatement prepStmt = null;
        try {
            con = DBUtil.makeConnection(JNDINames.DATABASE_DATASOURCE);
            for (JdbcSqlQuery modifyQuery : modifySqlQueries) {
                modifyQuery.finalizeBeforeExecution();
                try {
                    prepStmt = con.prepareStatement(modifyQuery.getSqlQuery());
                    DefaultJdbcSqlExecutor.setParameters(prepStmt, modifyQuery.getParameters());
                    nbUpdate += (long)prepStmt.executeUpdate();
                }
                catch (Throwable throwable) {
                    DBUtil.close(prepStmt);
                    throw throwable;
                    return nbUpdate;
                }
                DBUtil.close(prepStmt);
            }
        }
        catch (SQLException e) {
            DBUtil.close(prepStmt);
            DBUtil.close(con);
            throw e;
        }
    }

    private static void setParameters(PreparedStatement preparedStatement, Object statementParameters) throws SQLException {
        Collection<Object> parameters = statementParameters instanceof Object[] ? Arrays.asList((Object[])statementParameters) : (statementParameters instanceof Collection ? (Collection)statementParameters : (statementParameters != null ? Arrays.asList(statementParameters) : Collections.EMPTY_LIST));
        int paramIndex = 1;
        for (Object e : parameters) {
            if (e == null) {
                preparedStatement.setObject(paramIndex, null);
            } else if (e instanceof String) {
                preparedStatement.setString(paramIndex, (String)e);
            } else if (e instanceof Enum) {
                preparedStatement.setString(paramIndex, ((Enum)e).name());
            } else if (e instanceof Integer) {
                preparedStatement.setInt(paramIndex, (Integer)e);
            } else if (e instanceof Long) {
                preparedStatement.setLong(paramIndex, (Long)e);
            } else if (e instanceof Timestamp) {
                preparedStatement.setTimestamp(paramIndex, (Timestamp)e);
            } else if (e instanceof java.util.Date) {
                preparedStatement.setDate(paramIndex, new Date(((java.util.Date)e).getTime()));
            } else {
                try {
                    Method idGetter = e.getClass().getDeclaredMethod("getId", new Class[0]);
                    String id = (String)idGetter.invoke(e, new Object[0]);
                    preparedStatement.setString(paramIndex, id);
                }
                catch (Exception e2) {
                    throw new IllegalArgumentException("SQL parameter type not handled: " + e.getClass());
                }
            }
            ++paramIndex;
        }
    }
}

